/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.StackTraceSnapshotBuilder;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class SelfSamplerAction
extends AbstractAction
implements AWTEventListener {
    private static final String ACTION_NAME_START = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ActionNameStart");
    private static final String ACTION_NAME_STOP = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ActionNameStop");
    private static final String THREAD_NAME = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ThreadName");
    private StackTraceSnapshotBuilder builder;
    private ThreadFactory threadFactory;
    private ScheduledExecutorService executor;
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private long startTime;

    private SelfSamplerAction() {
        this.putValue("Name", ACTION_NAME_START);
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/actions/resources/openSnapshot.png", (boolean)false));
        if (System.getProperty(SelfSamplerAction.class.getName() + ".sniff") != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
    }

    public static final SelfSamplerAction getInstance() {
        return Singleton.INSTANCE;
    }

    private synchronized StackTraceSnapshotBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new StackTraceSnapshotBuilder();
            this.threadFactory = new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    return new Thread(runnable, THREAD_NAME);
                }
            };
            this.builder.setIgnoredThreads(Collections.singleton(THREAD_NAME));
        }
        return this.builder;
    }

    public boolean isEnabled() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isRunning.compareAndSet(false, true)) {
            this.putValue("Name", ACTION_NAME_STOP);
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/actions/resources/modifyProfiling.png", (boolean)false));
            final StackTraceSnapshotBuilder stackTraceSnapshotBuilder = this.getBuilder();
            this.executor = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
            this.startTime = System.currentTimeMillis();
            this.executor.scheduleAtFixedRate(new Runnable(){

                public void run() {
                    stackTraceSnapshotBuilder.addStacktrace(Thread.getAllStackTraces(), System.nanoTime());
                }
            }, 10L, 10L, TimeUnit.MILLISECONDS);
        } else if (this.isRunning.compareAndSet(true, false)) {
            this.putValue("Name", ACTION_NAME_START);
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/actions/resources/openSnapshot.png", (boolean)false));
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(100L, TimeUnit.MILLISECONDS);
                CPUResultsSnapshot cPUResultsSnapshot = this.getBuilder().createSnapshot(this.startTime, System.nanoTime());
                LoadedSnapshot loadedSnapshot = new LoadedSnapshot((ResultsSnapshot)cPUResultsSnapshot, ProfilingSettingsPresets.createCPUPreset(), null, null);
                loadedSnapshot.setSaved(true);
                ResultsManager.getDefault().openSnapshot(loadedSnapshot);
                this.getBuilder().reset();
            }
            catch (CPUResultsSnapshot.NoDataAvailableException noDataAvailableException) {
                noDataAvailableException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 65406) {
            this.actionPerformed(new ActionEvent(this, aWTEvent.getID(), "shortcut"));
            keyEvent.consume();
        }
    }

    private static final class Singleton {
        static final SelfSamplerAction INSTANCE = new SelfSamplerAction();

        private Singleton() {
        }
    }
}

