/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.modules.profiler.heapwalk.memorylint.FieldAccess;
import org.netbeans.modules.profiler.heapwalk.memorylint.IteratingRule;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.netbeans.modules.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public class WrongWeakHashMap
extends IteratingRule {
    private FieldAccess fldHMEKey;
    private FieldAccess fldHMENext;
    private FieldAccess fldHMEValue;
    private FieldAccess fldHMTable;
    private JavaClass clsHM;
    private JavaClass clsHME;
    private Set<WHMRecord> poorWHM = new HashSet<WHMRecord>();

    public WrongWeakHashMap() {
        super(NbBundle.getMessage(WrongWeakHashMap.class, (String)"LBL_WWMH_Name"), NbBundle.getMessage(WrongWeakHashMap.class, (String)"LBL_WWMH_Desc"), "java.util.WeakHashMap");
    }

    public String getHTMLDescription() {
        return NbBundle.getMessage(WrongWeakHashMap.class, (String)"LBL_WWMH_LongDesc");
    }

    protected void perform(Instance instance) {
        this.scanWeakHashmap(instance);
    }

    protected void prepareRule(MemoryLint memoryLint) {
        Heap heap = memoryLint.getHeap();
        this.clsHM = heap.getJavaClassByName("java.util.WeakHashMap");
        this.clsHME = heap.getJavaClassByName("java.util.WeakHashMap$Entry");
        this.fldHMTable = new FieldAccess(this.clsHM, "table");
        JavaClass javaClass = heap.getJavaClassByName("java.lang.ref.Reference");
        this.fldHMEKey = new FieldAccess(javaClass, "referent");
        this.fldHMEValue = new FieldAccess(this.clsHME, "value");
        this.fldHMENext = new FieldAccess(this.clsHME, "next");
    }

    protected void summary() {
        for (WHMRecord wHMRecord : this.poorWHM) {
            this.getContext().appendResults(wHMRecord.toString());
        }
    }

    private void scanWeakHashmap(Instance instance) {
        ObjectArrayInstance objectArrayInstance = (ObjectArrayInstance)this.fldHMTable.getRefValue(instance);
        if (objectArrayInstance == null) {
            return;
        }
        List list = objectArrayInstance.getValues();
        for (Instance instance2 : list) {
            while (instance2 != null) {
                Instance instance3;
                Instance instance4 = this.fldHMEKey.getRefValue(instance2);
                if (instance4 != null && Utils.isReachableFrom(instance3 = this.fldHMEValue.getRefValue(instance2), instance4)) {
                    this.poorWHM.add(new WHMRecord(instance, instance4, instance3));
                    return;
                }
                instance2 = this.fldHMENext.getRefValue(instance2);
            }
        }
    }

    private class WHMRecord {
        private Instance hm;
        private Instance key;
        private Instance value;

        WHMRecord(Instance instance, Instance instance2, Instance instance3) {
            this.hm = instance;
            this.key = instance2;
            this.value = instance3;
        }

        public String toString() {
            return NbBundle.getMessage(WrongWeakHashMap.class, (String)"FMT_WWMH_Entry", (Object[])new Object[]{Utils.printClass(WrongWeakHashMap.this.getContext(), WrongWeakHashMap.this.getContext().getRootIncommingString(this.hm)), Utils.printInstance(this.hm), Utils.printInstance(this.key), Utils.printInstance(this.value)});
        }
    }
}

