/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JExtendedSplitPane;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.modules.profiler.heapwalk.OQLController;
import org.netbeans.modules.profiler.heapwalk.oql.OQLEngine;
import org.netbeans.modules.profiler.heapwalk.oql.ui.OQLEditor;
import org.netbeans.modules.profiler.heapwalk.ui.OQLQueryCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class OQLControllerUI
extends JPanel
implements HelpCtx.Provider {
    private static final String CONTROLLER_NAME = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_ControllerName");
    private static final String CONTROLLER_DESCR = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_ControllerDescr");
    private static final String QUERY_RESULTS_CAPTION = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_QueryResultsCaption");
    private static final String QUERY_EDITOR_CAPTION = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_QueryEditorCaption");
    private static final String SAVED_QUERIES_CAPTION = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_SavedQueriesCaption");
    private static final String EXECUTING_QUERY_MSG = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_ExecutingQueryMsg");
    private static final String EXECUTE_BUTTON_TEXT = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_ExecuteButtonText");
    private static final String EXECUTE_BUTTON_ACCESS_DESCR = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_ExecuteButtonAccessDescr");
    private static final String CANCEL_BUTTON_TEXT = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_CancelButtonText");
    private static final String CANCEL_BUTTON_ACCESS_DESCR = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_CancelButtonAccessDescr");
    private static final String SAVE_BUTTON_TEXT = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_SaveButtonText");
    private static final String SAVE_BUTTON_ACCESS_DESCR = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_SaveButtonAccessDescr");
    private static final String PROPERTIES_BUTTON_TEXT = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_PropertiesButtonText");
    private static final String PROPERTIES_BUTTON_ACCESS_DESCR = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_PropertiesButtonAccessDescr");
    private static final String DELETE_BUTTON_TEXT = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_DeleteButtonText");
    private static final String DELETE_BUTTON_ACCESS_DESCR = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_DeleteButtonAccessDescr");
    private static final String OPEN_BUTTON_TEXT = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_OpenButtonText");
    private static final String OPEN_BUTTON_ACCESS_DESCR = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_OpenButtonAccessDescr");
    private static final String LOADING_QUERIES_MSG = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_LoadingQueriesMsg");
    private static final String NO_SAVED_QUERIES_MSG = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_NoSavedQueriesMsg");
    private static final String HELP_CTX_KEY = "OQLControllerUI.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("OQLControllerUI.HelpCtx");
    private AbstractButton presenter;
    private OQLController oqlController;

    public OQLControllerUI(OQLController oQLController) {
        this.oqlController = oQLController;
        this.initComponents();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public AbstractButton getPresenter() {
        if (this.presenter == null) {
            this.presenter = new Presenter((QueryUI)((Object)this.oqlController.getQueryController().getPanel()));
        }
        return this.presenter;
    }

    private void initComponents() {
        JExtendedSplitPane jExtendedSplitPane = new JExtendedSplitPane(1, (Component)this.oqlController.getQueryController().getPanel(), (Component)this.oqlController.getSavedController().getPanel());
        OQLControllerUI.tweakSplitPaneUI((JSplitPane)jExtendedSplitPane);
        jExtendedSplitPane.setResizeWeight(1.0);
        JExtendedSplitPane jExtendedSplitPane2 = new JExtendedSplitPane(0, (Component)this.oqlController.getResultsController().getPanel(), (Component)jExtendedSplitPane);
        OQLControllerUI.tweakSplitPaneUI((JSplitPane)jExtendedSplitPane2);
        jExtendedSplitPane2.setResizeWeight(1.0);
        this.setLayout(new BorderLayout());
        this.add((Component)jExtendedSplitPane2, "Center");
    }

    private static void tweakSplitPaneUI(JSplitPane jSplitPane) {
        jSplitPane.setBorder(null);
        jSplitPane.setDividerSize(3);
        if (!(jSplitPane.getUI() instanceof BasicSplitPaneUI)) {
            return;
        }
        BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)jSplitPane.getUI()).getDivider();
        if (basicSplitPaneDivider != null) {
            basicSplitPaneDivider.setBorder(null);
        }
    }

    public static class SavedUI
    extends JTitledPanel {
        private OQLController.SavedController savedController;
        private JList savedList;
        private JButton openButton;
        private JButton editButton;
        private JButton deleteButton;
        private JTextArea descriptionArea;
        private JPanel contentsPanel;
        private JPanel loadingMsgPanel;
        private JPanel noQueriesMsgPanel;
        private JScrollPane savedListScroll;
        private DefaultListModel listModel;
        private boolean queriesLoaded = false;
        private static ImageIcon ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/savedOQL.png", (boolean)false);

        public SavedUI(OQLController.SavedController savedController) {
            super(SAVED_QUERIES_CAPTION, (Icon)ICON, true);
            this.savedController = savedController;
            this.listModel = new DefaultListModel();
            this.initComponents();
            this.refreshQueries();
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    OQLController.SavedController.loadData(SavedUI.this.listModel);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SavedUI.this.queriesLoaded = true;
                            SavedUI.this.refreshQueries();
                        }
                    });
                }
            });
        }

        public void saveQuery(final String string) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (OQLQueryCustomizer.saveQuery(string, SavedUI.this.listModel)) {
                        SavedUI.this.setVisible(true);
                        SavedUI.this.refreshQueries();
                        RequestProcessor.getDefault().post(new Runnable(){

                            public void run() {
                                OQLController.SavedController.saveData(SavedUI.this.listModel);
                            }
                        });
                    }
                }
            });
        }

        private void openQuery() {
            OQLController.Query query = (OQLController.Query)this.savedList.getSelectedValue();
            if (query != null) {
                this.savedController.getOQLController().getQueryController().setQuery(query.getScript());
            }
        }

        private void editQuery() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OQLController.Query query = (OQLController.Query)SavedUI.this.savedList.getSelectedValue();
                    if (query != null) {
                        if (OQLQueryCustomizer.editQuery(query, SavedUI.this.listModel, SavedUI.this.savedList)) {
                            SavedUI.this.refreshDescription();
                            RequestProcessor.getDefault().post(new Runnable(){

                                public void run() {
                                    OQLController.SavedController.saveData(SavedUI.this.listModel);
                                }
                            });
                        }
                        SavedUI.this.editButton.requestFocus();
                    }
                }
            });
        }

        private void deleteQueries() {
            Object[] objectArray;
            for (Object object : objectArray = this.savedList.getSelectedValues()) {
                this.listModel.removeElement(object);
            }
            this.refreshQueries();
            this.savedList.requestFocus();
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    OQLController.SavedController.saveData(SavedUI.this.listModel);
                }
            });
        }

        private void refreshQueries() {
            Component component = ((BorderLayout)this.contentsPanel.getLayout()).getLayoutComponent("Center");
            if (this.queriesLoaded) {
                if (this.listModel.isEmpty()) {
                    if (component != this.noQueriesMsgPanel) {
                        if (component != null) {
                            this.contentsPanel.remove(component);
                        }
                        this.contentsPanel.add((Component)this.noQueriesMsgPanel, "Center");
                        this.noQueriesMsgPanel.invalidate();
                        this.contentsPanel.revalidate();
                        this.contentsPanel.repaint();
                    }
                } else if (component != this.savedListScroll) {
                    if (component != null) {
                        this.contentsPanel.remove(component);
                    }
                    this.contentsPanel.add((Component)this.savedListScroll, "Center");
                    this.savedListScroll.invalidate();
                    this.contentsPanel.revalidate();
                    this.contentsPanel.repaint();
                }
            } else {
                this.contentsPanel.add((Component)this.loadingMsgPanel, "Center");
                this.loadingMsgPanel.invalidate();
                this.contentsPanel.revalidate();
                this.contentsPanel.repaint();
            }
        }

        private void refreshButtons() {
            int n = this.savedList.getSelectedValues().length;
            this.openButton.setEnabled(n == 1);
            this.editButton.setEnabled(n == 1);
            this.deleteButton.setEnabled(n > 0);
        }

        private void refreshDescription() {
            OQLController.Query query = (OQLController.Query)this.savedList.getSelectedValue();
            if (query != null && query.getDescription() != null) {
                this.descriptionArea.setText(query.getDescription());
                this.descriptionArea.setVisible(true);
            } else {
                this.descriptionArea.setVisible(false);
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.savedList = new JList(this.listModel);
            this.savedList.setSelectionMode(2);
            this.savedList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    SavedUI.this.refreshButtons();
                    SavedUI.this.refreshDescription();
                }
            });
            this.savedListScroll = new JScrollPane(this.savedList, 20, 30);
            this.savedListScroll.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, UIUtils.getProfilerResultsBackground()));
            this.savedListScroll.setViewportBorder(BorderFactory.createEmptyBorder());
            this.loadingMsgPanel = new JPanel(new BorderLayout());
            this.loadingMsgPanel.setOpaque(false);
            JLabel jLabel = new JLabel(LOADING_QUERIES_MSG, 0);
            jLabel.setEnabled(false);
            this.loadingMsgPanel.add((Component)jLabel, "Center");
            this.noQueriesMsgPanel = new JPanel(new BorderLayout());
            this.noQueriesMsgPanel.setOpaque(false);
            JLabel jLabel2 = new JLabel(NO_SAVED_QUERIES_MSG, 0);
            jLabel2.setEnabled(false);
            this.noQueriesMsgPanel.add((Component)jLabel2, "Center");
            this.openButton = new JButton(){

                protected void fireActionPerformed(ActionEvent actionEvent) {
                    SavedUI.this.openQuery();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.openButton, (String)OPEN_BUTTON_TEXT);
            this.openButton.getAccessibleContext().setAccessibleDescription(OPEN_BUTTON_ACCESS_DESCR);
            this.editButton = new JButton(){

                protected void fireActionPerformed(ActionEvent actionEvent) {
                    SavedUI.this.editQuery();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)PROPERTIES_BUTTON_TEXT);
            this.editButton.getAccessibleContext().setAccessibleDescription(PROPERTIES_BUTTON_ACCESS_DESCR);
            this.deleteButton = new JButton(){

                protected void fireActionPerformed(ActionEvent actionEvent) {
                    SavedUI.this.deleteQueries();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)DELETE_BUTTON_TEXT);
            this.deleteButton.getAccessibleContext().setAccessibleDescription(DELETE_BUTTON_ACCESS_DESCR);
            JPanel jPanel = new JPanel(new FlowLayout(3, 5, 0));
            jPanel.setOpaque(false);
            jPanel.add(this.editButton);
            jPanel.add(this.deleteButton);
            JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
            jPanel2.setBorder(BorderFactory.createMatteBorder(5, 0, 5, 5, UIUtils.getProfilerResultsBackground()));
            jPanel2.setOpaque(false);
            jPanel2.add((Component)jPanel, "West");
            jPanel2.add((Component)this.openButton, "East");
            this.descriptionArea = new JTextArea();
            this.descriptionArea.setEnabled(false);
            this.descriptionArea.setLineWrap(true);
            this.descriptionArea.setWrapStyleWord(true);
            this.descriptionArea.setDisabledTextColor(UIManager.getColor("ToolTip.foreground"));
            this.descriptionArea.setBackground(UIManager.getColor("ToolTip.background"));
            this.descriptionArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 5, 0, 5, UIUtils.getProfilerResultsBackground()), BorderFactory.createMatteBorder(5, 5, 5, 5, UIManager.getColor("ToolTip.background"))));
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setOpaque(false);
            jPanel3.add((Component)this.descriptionArea, "Center");
            jPanel3.add((Component)jPanel2, "South");
            this.contentsPanel = new JPanel();
            this.contentsPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, this.getTitleBorderColor()));
            this.contentsPanel.setLayout(new BorderLayout());
            this.contentsPanel.setOpaque(true);
            this.contentsPanel.setBackground(UIUtils.getProfilerResultsBackground());
            this.contentsPanel.add((Component)jPanel3, "South");
            this.setLayout(new BorderLayout());
            this.add(this.contentsPanel, "Center");
            this.refreshButtons();
            this.refreshDescription();
            this.savedList.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "OPEN_QUERY_ACTION");
            this.savedList.getActionMap().put("OPEN_QUERY_ACTION", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SavedUI.this.openQuery();
                }
            });
            this.savedList.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "DELETE_QUERY_ACTION");
            this.savedList.getActionMap().put("DELETE_QUERY_ACTION", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SavedUI.this.deleteQueries();
                }
            });
            this.savedList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                        SavedUI.this.openQuery();
                    }
                }
            });
            this.savedListScroll.setPreferredSize(new Dimension(this.openButton.getPreferredSize().width + this.editButton.getPreferredSize().width + this.deleteButton.getPreferredSize().width + 75, 200));
        }
    }

    public static class QueryUI
    extends JTitledPanel {
        private OQLController.QueryController queryController;
        private OQLEditor editor;
        private JButton runButton;
        private JButton saveButton;
        private JButton cancelButton;
        private JLabel progressLabel;
        private JProgressBar progressBar;
        private JPanel controlPanel;
        private JPanel progressPanel;
        private JPanel contentsPanel;
        private boolean queryValid = true;
        private static ImageIcon ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/rules.png", (boolean)false);

        public QueryUI(OQLController.QueryController queryController, OQLEngine oQLEngine) {
            super(QUERY_EDITOR_CAPTION, (Icon)ICON, true);
            this.queryController = queryController;
            this.initComponents(oQLEngine);
            this.updateUIState();
        }

        public void setQuery(String string) {
            this.setVisible(true);
            this.editor.setScript(string);
            this.editor.requestFocus();
        }

        public void queryStarted(final BoundedRangeModel boundedRangeModel) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    QueryUI.this.progressLabel.setText(EXECUTING_QUERY_MSG);
                    QueryUI.this.progressBar.setModel(boundedRangeModel);
                    QueryUI.this.progressBar.setMaximumSize(new Dimension(((QueryUI)QueryUI.this).progressBar.getMaximumSize().width, ((QueryUI)QueryUI.this).progressBar.getPreferredSize().height));
                    QueryUI.this.contentsPanel.remove(QueryUI.this.controlPanel);
                    QueryUI.this.contentsPanel.add((Component)QueryUI.this.progressPanel, "South");
                    QueryUI.this.progressPanel.invalidate();
                    QueryUI.this.contentsPanel.revalidate();
                    QueryUI.this.contentsPanel.repaint();
                    QueryUI.this.updateUIState();
                }
            });
        }

        public void queryFinished() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    QueryUI.this.updateUIState();
                    QueryUI.this.contentsPanel.remove(QueryUI.this.progressPanel);
                    QueryUI.this.contentsPanel.add((Component)QueryUI.this.controlPanel, "South");
                    QueryUI.this.controlPanel.invalidate();
                    QueryUI.this.contentsPanel.revalidate();
                    QueryUI.this.contentsPanel.repaint();
                }
            });
        }

        private void addToQuery(char c) {
            this.setVisible(true);
            String string = new String(new char[]{c});
            this.editor.setScript(this.editor.getScript() + string);
        }

        public void requestFocus() {
            this.editor.requestFocus();
        }

        private void updateUIState() {
            if (this.queryController.getOQLController().isQueryRunning()) {
                this.runButton.setEnabled(false);
                this.editor.setEditable(false);
                this.editor.setEnabled(false);
            } else {
                this.runButton.setEnabled(this.editor.getScript().length() > 0 && this.queryValid);
                this.saveButton.setEnabled(this.editor.getScript().length() > 0 && this.queryValid);
                this.editor.setEditable(true);
                this.editor.setEnabled(true);
            }
        }

        private void executeQuery() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    QueryUI.this.requestFocus();
                    QueryUI.this.queryController.getOQLController().executeQuery(QueryUI.this.editor.getScript());
                }
            });
        }

        private void saveQuery() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    QueryUI.this.queryController.getOQLController().getSavedController().saveQuery(QueryUI.this.editor.getScript());
                    QueryUI.this.editor.requestFocus();
                }
            });
        }

        private void cancelQuery() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    QueryUI.this.queryController.getOQLController().cancelQuery();
                }
            });
        }

        private void initComponents(OQLEngine oQLEngine) {
            this.editor = new OQLEditor(oQLEngine);
            this.editor.addPropertyChangeListener("document#valid", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    QueryUI.this.queryValid = (Boolean)propertyChangeEvent.getNewValue();
                    QueryUI.this.updateUIState();
                }
            });
            this.editor.setBackground(UIUtils.getProfilerResultsBackground());
            JScrollPane jScrollPane = new JScrollPane(this.editor, 20, 30);
            jScrollPane.setBorder(BorderFactory.createMatteBorder(5, 5, 0, 5, UIUtils.getProfilerResultsBackground()));
            jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
            jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
            this.runButton = new JButton(){

                protected void fireActionPerformed(ActionEvent actionEvent) {
                    QueryUI.this.executeQuery();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.runButton, (String)EXECUTE_BUTTON_TEXT);
            this.runButton.getAccessibleContext().setAccessibleDescription(EXECUTE_BUTTON_ACCESS_DESCR);
            this.saveButton = new JButton(){

                protected void fireActionPerformed(ActionEvent actionEvent) {
                    QueryUI.this.saveQuery();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.saveButton, (String)SAVE_BUTTON_TEXT);
            this.saveButton.getAccessibleContext().setAccessibleDescription(SAVE_BUTTON_ACCESS_DESCR);
            this.controlPanel = new JPanel(new BorderLayout(5, 5));
            this.controlPanel.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, UIUtils.getProfilerResultsBackground()));
            this.controlPanel.setOpaque(false);
            this.controlPanel.add((Component)this.saveButton, "West");
            this.controlPanel.add((Component)this.runButton, "East");
            this.progressBar = new JProgressBar(0);
            this.progressLabel = new JLabel();
            this.progressLabel.setLabelFor(this.progressBar);
            this.cancelButton = new JButton(){

                protected void fireActionPerformed(ActionEvent actionEvent) {
                    QueryUI.this.cancelQuery();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)CANCEL_BUTTON_TEXT);
            this.cancelButton.getAccessibleContext().setAccessibleDescription(CANCEL_BUTTON_ACCESS_DESCR);
            this.progressPanel = new JPanel(new GridBagLayout());
            this.progressPanel.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, UIUtils.getProfilerResultsBackground()));
            this.progressPanel.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            this.progressPanel.add((Component)this.progressLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            this.progressPanel.add((Component)this.progressBar, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.progressPanel.add((Component)this.cancelButton, gridBagConstraints);
            this.contentsPanel = new JPanel(new BorderLayout());
            this.contentsPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.getTitleBorderColor()));
            this.contentsPanel.setBackground(UIUtils.getProfilerResultsBackground());
            this.contentsPanel.setOpaque(true);
            this.contentsPanel.add((Component)jScrollPane, "Center");
            this.contentsPanel.add((Component)this.controlPanel, "South");
            this.setLayout(new BorderLayout());
            this.add(this.contentsPanel, "Center");
            this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "CANCEL_ACTION");
            this.getActionMap().put("CANCEL_ACTION", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    QueryUI.this.cancelQuery();
                }
            });
            jScrollPane.setPreferredSize(new Dimension(1, 200));
        }
    }

    public static class ResultsUI
    extends JTitledPanel {
        private OQLController.ResultsController resultsController;
        private HTMLTextArea resultsArea;
        private static ImageIcon ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/properties.png", (boolean)false);

        public ResultsUI(OQLController.ResultsController resultsController) {
            super(QUERY_RESULTS_CAPTION, (Icon)ICON, true);
            this.resultsController = resultsController;
            this.initComponents();
        }

        public void setResult(String string) {
            this.resultsArea.setText(string);
            try {
                this.resultsArea.setCaretPosition(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setVisible(true);
        }

        private void initComponents() {
            this.resultsArea = new HTMLTextArea(){

                protected void showURL(URL uRL) {
                    ResultsUI.this.resultsController.showURL(uRL);
                }
            };
            JScrollPane jScrollPane = new JScrollPane((Component)this.resultsArea, 20, 30);
            jScrollPane.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, UIUtils.getProfilerResultsBackground()));
            jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
            jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.getTitleBorderColor()));
            jPanel.setLayout(new BorderLayout());
            jPanel.setOpaque(true);
            jPanel.setBackground(this.resultsArea.getBackground());
            jPanel.add((Component)jScrollPane, "Center");
            this.setLayout(new BorderLayout());
            this.add(jPanel, "Center");
        }
    }

    private static class Presenter
    extends JToggleButton
    implements HelpCtx.Provider {
        private static ImageIcon ICON_INFO = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/oql.png", (boolean)false);

        public Presenter(final QueryUI queryUI) {
            this.setText(CONTROLLER_NAME);
            this.setToolTipText(CONTROLLER_DESCR);
            this.setIcon(ICON_INFO);
            this.setMargin(new Insets(this.getMargin().top, this.getMargin().top, this.getMargin().bottom, this.getMargin().top));
            this.addKeyListener(new KeyAdapter(){

                public void keyTyped(final KeyEvent keyEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            queryUI.requestFocus();
                            queryUI.addToQuery(keyEvent.getKeyChar());
                        }
                    });
                }
            });
        }

        public HelpCtx getHelpCtx() {
            return HELP_CTX;
        }
    }
}

