/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.profiler.heapwalk.OQLController;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class OQLQueryCustomizer {
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(OQLQueryCustomizer.class, (String)"OQLQueryCustomizer_OkButtonText");
    private static final String SAVE_QUERY_CAPTION = NbBundle.getMessage(OQLQueryCustomizer.class, (String)"OQLQueryCustomizer_SaveQueryCaption");
    private static final String QUERY_PROPERTIES_CAPTION = NbBundle.getMessage(OQLQueryCustomizer.class, (String)"OQLQueryCustomizer_QueryPropertiesCaption");
    private static final String UP_BUTTON_TOOLTIP = NbBundle.getMessage(OQLQueryCustomizer.class, (String)"OQLQueryCustomizer_UpButtonToolTip");
    private static final String DOWN_BUTTON_TOOLTIP = NbBundle.getMessage(OQLQueryCustomizer.class, (String)"OQLQueryCustomizer_DownButtonToolTip");
    private static final String UP_BUTTON_ACCESS_NAME = NbBundle.getMessage(OQLQueryCustomizer.class, (String)"OQLQueryCustomizer_UpButtonAccessName");
    private static final String DOWN_BUTTON_ACCESS_NAME = NbBundle.getMessage(OQLQueryCustomizer.class, (String)"OQLQueryCustomizer_DownButtonAccessName");
    private static final String NEW_QUERY_RADIO_TEXT = NbBundle.getMessage(OQLQueryCustomizer.class, (String)"OQLQueryCustomizer_NewQueryRadioText");
    private static final String EXISTING_QUERY_RADIO_TEXT = NbBundle.getMessage(OQLQueryCustomizer.class, (String)"OQLQueryCustomizer_ExistingQueryRadioText");
    private static final String NAME_LABEL_TEXT = NbBundle.getMessage(OQLQueryCustomizer.class, (String)"OQLQueryCustomizer_NameLabelText");
    private static final String DEFAULT_QUERY_NAME = NbBundle.getMessage(OQLQueryCustomizer.class, (String)"OQLQueryCustomizer_DefaultQueryName");
    private static final String DESCRIPTION_LABEL_TEXT = NbBundle.getMessage(OQLQueryCustomizer.class, (String)"OQLQueryCustomizer_DescriptionLabelText");
    private static final String UPDATE_QUERY_LABEL_TEXT = NbBundle.getMessage(OQLQueryCustomizer.class, (String)"OQLQueryCustomizer_UpdateQueryLabelText");
    private static ImageIcon ICON_UP = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/up.png", (boolean)false);
    private static ImageIcon ICON_DOWN = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/down.png", (boolean)false);

    public static boolean saveQuery(String string, DefaultListModel defaultListModel) {
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)OK_BUTTON_TEXT);
        CustomizerPanel customizerPanel = new CustomizerPanel(jButton, defaultListModel);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)customizerPanel, SAVE_QUERY_CAPTION, true, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton, 0, null, null);
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == jButton) {
            if (customizerPanel.isNewQuery()) {
                defaultListModel.addElement(new OQLController.Query(string, customizerPanel.getQueryName(), customizerPanel.getQueryDescription()));
            } else {
                OQLController.Query query = (OQLController.Query)customizerPanel.getSelectedValue();
                query.setScript(string);
            }
            return true;
        }
        return false;
    }

    public static boolean editQuery(final OQLController.Query query, final DefaultListModel defaultListModel, final JList jList) {
        int n = defaultListModel.indexOf(query);
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)OK_BUTTON_TEXT);
        final JButton[] jButtonArray = new JButton[2];
        jButtonArray[0] = new JButton(ICON_UP){

            protected void fireActionPerformed(ActionEvent actionEvent) {
                int n = defaultListModel.indexOf(query);
                defaultListModel.remove(n);
                defaultListModel.add(n - 1, query);
                jList.setSelectedValue(query, true);
                OQLQueryCustomizer.updateButtons(jButtonArray, query, defaultListModel);
            }
        };
        jButtonArray[0].setToolTipText(UP_BUTTON_TOOLTIP);
        jButtonArray[0].getAccessibleContext().setAccessibleName(UP_BUTTON_ACCESS_NAME);
        jButtonArray[1] = new JButton(ICON_DOWN){

            protected void fireActionPerformed(ActionEvent actionEvent) {
                int n = defaultListModel.indexOf(query);
                defaultListModel.remove(n);
                defaultListModel.add(n + 1, query);
                jList.setSelectedValue(query, true);
                OQLQueryCustomizer.updateButtons(jButtonArray, query, defaultListModel);
            }
        };
        jButtonArray[1].setToolTipText(DOWN_BUTTON_TOOLTIP);
        jButtonArray[1].getAccessibleContext().setAccessibleName(DOWN_BUTTON_ACCESS_NAME);
        CustomizerPanel customizerPanel = new CustomizerPanel(jButton, query.getName(), query.getDescription());
        customizerPanel.getInputMap(2).put(KeyStroke.getKeyStroke(38, 8), "MOVE_UP");
        customizerPanel.getActionMap().put("MOVE_UP", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jButtonArray[0].isEnabled()) {
                    jButtonArray[0].doClick();
                }
            }
        });
        customizerPanel.getInputMap(2).put(KeyStroke.getKeyStroke(40, 8), "MOVE_DOWN");
        customizerPanel.getActionMap().put("MOVE_DOWN", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jButtonArray[1].isEnabled()) {
                    jButtonArray[1].doClick();
                }
            }
        });
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)customizerPanel, QUERY_PROPERTIES_CAPTION, true, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton, 0, null, null);
        dialogDescriptor.setAdditionalOptions(new Object[]{jButtonArray[0], jButtonArray[1]});
        OQLQueryCustomizer.updateButtons(jButtonArray, query, defaultListModel);
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == jButton) {
            query.setName(customizerPanel.getQueryName());
            query.setDescription(customizerPanel.getQueryDescription());
            defaultListModel.setElementAt(query, defaultListModel.indexOf(query));
            return true;
        }
        int n2 = defaultListModel.indexOf(query);
        if (n2 != n) {
            defaultListModel.remove(n2);
            defaultListModel.add(n, query);
            jList.setSelectedValue(query, true);
        }
        return false;
    }

    private static void updateButtons(JButton[] jButtonArray, Object object, DefaultListModel defaultListModel) {
        int n = defaultListModel.indexOf(object);
        jButtonArray[0].setEnabled(n > 0);
        jButtonArray[1].setEnabled(n < defaultListModel.size() - 1);
    }

    private static class CustomizerPanel
    extends JPanel {
        private JComponent submitComponent;
        private Object lastSelectedValue;
        private JRadioButton newRadio;
        private JSeparator newSeparator;
        private JLabel nameLabel;
        private JTextField nameField;
        private JLabel descriptionLabel;
        private JTextArea descriptionArea;
        private JRadioButton existingRadio;
        private JSeparator existingSeparator;
        private JLabel existingLabel;
        private JList existingList;

        public CustomizerPanel(JComponent jComponent, ListModel listModel) {
            this.submitComponent = jComponent;
            this.initComponents(listModel);
            this.updateComponents();
        }

        public CustomizerPanel(JComponent jComponent, String string, String string2) {
            this.submitComponent = jComponent;
            this.initComponents(null);
            this.nameField.setText(string);
            this.descriptionArea.setText(string2 == null ? "" : string2);
            this.updateComponents();
        }

        public boolean isNewQuery() {
            return this.newRadio == null || this.newRadio.isSelected();
        }

        public String getQueryName() {
            return this.nameField.getText().trim();
        }

        public String getQueryDescription() {
            String string = this.descriptionArea.getText().trim();
            return string.length() > 0 ? string : null;
        }

        public Object getSelectedValue() {
            return this.existingList.getSelectedValue();
        }

        private void updateComponents() {
            if (this.newRadio != null) {
                boolean bl = this.newRadio.isSelected();
                this.nameLabel.setEnabled(bl);
                this.nameField.setEnabled(bl);
                this.descriptionLabel.setEnabled(bl);
                this.descriptionArea.setEnabled(bl);
                this.existingLabel.setEnabled(!bl);
                if (bl && this.existingList.isEnabled()) {
                    this.lastSelectedValue = this.existingList.getSelectedValue();
                    this.existingList.setEnabled(false);
                    this.existingList.clearSelection();
                } else if (!bl && !this.existingList.isEnabled()) {
                    this.existingList.setEnabled(true);
                    if (this.lastSelectedValue == null) {
                        this.lastSelectedValue = this.existingList.getModel().getElementAt(0);
                    }
                    this.existingList.setSelectedValue(this.lastSelectedValue, false);
                }
            }
            if (this.existingRadio != null && this.existingRadio.isSelected()) {
                this.submitComponent.setEnabled(this.existingList.getSelectedValue() != null);
            } else {
                this.submitComponent.setEnabled(this.nameField.getText().trim().length() > 0);
            }
        }

        private void initComponents(ListModel listModel) {
            GridBagConstraints gridBagConstraints;
            JComponent jComponent;
            final boolean bl = listModel != null && listModel.getSize() != 0;
            this.setLayout(new GridBagLayout());
            if (bl) {
                jComponent = new JPanel(new GridBagLayout());
                this.newRadio = new JRadioButton(){

                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        CustomizerPanel.this.updateComponents();
                    }
                };
                Mnemonics.setLocalizedText((AbstractButton)this.newRadio, (String)NEW_QUERY_RADIO_TEXT);
                this.newRadio.setSelected(true);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                jComponent.add((Component)this.newRadio, gridBagConstraints);
                this.newSeparator = new JSeparator(0){

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }
                };
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                jComponent.add((Component)this.newSeparator, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(8, 8, 0, 8);
                this.add((Component)jComponent, gridBagConstraints);
            }
            this.nameLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NAME_LABEL_TEXT);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(bl ? 8 : 16, bl ? 40 : 16, 8, 8);
            this.add((Component)this.nameLabel, gridBagConstraints);
            this.nameField = new JTextField();
            this.nameLabel.setLabelFor(this.nameField);
            this.nameField.setText(DEFAULT_QUERY_NAME);
            this.nameField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    CustomizerPanel.this.updateComponents();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    CustomizerPanel.this.updateComponents();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    CustomizerPanel.this.updateComponents();
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(bl ? 8 : 16, 0, 8, 16);
            this.add((Component)this.nameField, gridBagConstraints);
            this.descriptionLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)DESCRIPTION_LABEL_TEXT);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(8, bl ? 40 : 16, 8, 8);
            this.add((Component)this.descriptionLabel, gridBagConstraints);
            this.descriptionArea = new JTextArea();
            this.descriptionLabel.setLabelFor(this.descriptionArea);
            this.descriptionArea.setLineWrap(true);
            this.descriptionArea.setWrapStyleWord(true);
            this.descriptionArea.setFont(this.descriptionLabel.getFont());
            this.descriptionArea.setRows(3);
            jComponent = new JScrollPane(this.descriptionArea, 20, 30){

                public Dimension getPreferredSize() {
                    return new Dimension(250, super.getPreferredSize().height);
                }

                public Dimension getMinimumSize() {
                    return bl ? this.getPreferredSize() : super.getMinimumSize();
                }
            };
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            if (!bl) {
                gridBagConstraints.weighty = 1.0;
            }
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 0, bl ? 8 : 16, 16);
            this.add((Component)jComponent, gridBagConstraints);
            if (bl) {
                JPanel jPanel = new JPanel(new GridBagLayout());
                this.existingRadio = new JRadioButton(){

                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        CustomizerPanel.this.updateComponents();
                    }
                };
                Mnemonics.setLocalizedText((AbstractButton)this.existingRadio, (String)EXISTING_QUERY_RADIO_TEXT);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                jPanel.add((Component)this.existingRadio, gridBagConstraints);
                this.existingSeparator = new JSeparator(0){

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }
                };
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                jPanel.add((Component)this.existingSeparator, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(8, 8, 0, 8);
                this.add((Component)jPanel, gridBagConstraints);
                this.existingLabel = new JLabel();
                Mnemonics.setLocalizedText((JLabel)this.existingLabel, (String)UPDATE_QUERY_LABEL_TEXT);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(8, 40, 8, 8);
                this.add((Component)this.existingLabel, gridBagConstraints);
                this.existingList = new JList(listModel);
                this.existingLabel.setLabelFor(this.existingList);
                this.existingList.setVisibleRowCount(3);
                this.existingList.setSelectionMode(0);
                this.existingList.addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        CustomizerPanel.this.updateComponents();
                    }
                });
                JScrollPane jScrollPane = new JScrollPane(this.existingList, 20, 30);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 6;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(0, 0, 16, 16);
                this.add((Component)jScrollPane, gridBagConstraints);
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(this.newRadio);
                buttonGroup.add(this.existingRadio);
            }
            this.addHierarchyListener(new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && CustomizerPanel.this.isShowing()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                CustomizerPanel.this.nameField.requestFocus();
                                CustomizerPanel.this.nameField.selectAll();
                            }
                        });
                    }
                }
            });
        }
    }
}

