/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.ppoints.TriggeredGlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TriggerCustomizer
extends ValidityAwarePanel
implements ActionListener {
    private static final String HEAP_USG_REL_KEY = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_HeapUsgRelKey");
    private static final String HEAP_USG_REL_UNIT = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_HeapUsgRelUnit");
    private static final String HEAP_SIZE_ABS_KEY = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_HeapSizeAbsKey");
    private static final String HEAP_SIZE_ABS_UNIT = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_HeapSizeAbsUnit");
    private static final String SURVGEN_COUNT_KEY = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_SurvgenCountKey");
    private static final String SURVGEN_COUNT_UNIT = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_SurvgenCountUnit");
    private static final String LDCLASS_COUNT_KEY = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_LdClassCountKey");
    private static final String LDCLASS_COUNT_UNIT = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_LdClassCountUnit");
    private static final String TAKE_WHEN_LABEL_TEXT = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_TakeWhenLabelText");
    private static final String EXCEEDS_LABEL_TEXT = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_ExceedsLabelText");
    private static final String TAKE_ONCE_RADIO_TEXT = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_TakeOnceRadioText");
    private static final String TAKE_ALWAYS_RADIO_TEXT = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_TakeAlwaysRadioText");
    private static int defaultTextComponentHeight = -1;
    private final SpinnerModel percentsModel = new SpinnerNumberModel(1, 1, 99, 1);
    private final SpinnerModel unitsModel = new SpinnerNumberModel(1, 1, 9999, 1);
    private JComboBox triggerWhenCombo;
    private JLabel triggerExceedsLabel;
    private JLabel triggerGenerationsLabel;
    private JLabel triggerWhenLabel;
    private JRadioButton triggerAlwaysRadio;
    private JRadioButton triggerOnceRadio;
    private JSpinner triggerValueSpinner;

    public TriggerCustomizer() {
        this.initComponents();
    }

    public int getPreferredCaptionAreaWidth() {
        return -1;
    }

    public void setTriggerCondition(TriggeredGlobalProfilingPoint.TriggerCondition triggerCondition) {
        switch (triggerCondition.getMetric()) {
            case 1: {
                this.triggerWhenCombo.setSelectedItem(HEAP_USG_REL_KEY);
                this.triggerValueSpinner.setValue((int)triggerCondition.getValue());
                break;
            }
            case 2: {
                this.triggerWhenCombo.setSelectedItem(HEAP_SIZE_ABS_KEY);
                this.triggerValueSpinner.setValue((int)(triggerCondition.getValue() / 0x100000L));
                break;
            }
            case 3: {
                this.triggerWhenCombo.setSelectedItem(SURVGEN_COUNT_KEY);
                this.triggerValueSpinner.setValue((int)triggerCondition.getValue());
                break;
            }
            case 4: {
                this.triggerWhenCombo.setSelectedItem(LDCLASS_COUNT_KEY);
                this.triggerValueSpinner.setValue((int)triggerCondition.getValue());
                break;
            }
        }
        this.triggerOnceRadio.setSelected(triggerCondition.isOnetime());
        this.triggerAlwaysRadio.setSelected(!triggerCondition.isOnetime());
    }

    public TriggeredGlobalProfilingPoint.TriggerCondition getTriggerCondition() {
        TriggeredGlobalProfilingPoint.TriggerCondition triggerCondition = new TriggeredGlobalProfilingPoint.TriggerCondition();
        Object object = this.triggerWhenCombo.getSelectedItem();
        if (object == HEAP_USG_REL_KEY) {
            triggerCondition.setMetric(1);
            triggerCondition.setValue(((Integer)this.triggerValueSpinner.getValue()).intValue());
        } else if (object == HEAP_SIZE_ABS_KEY) {
            triggerCondition.setMetric(2);
            triggerCondition.setValue((Integer)this.triggerValueSpinner.getValue() * 0x100000);
        } else if (object == SURVGEN_COUNT_KEY) {
            triggerCondition.setMetric(3);
            triggerCondition.setValue(((Integer)this.triggerValueSpinner.getValue()).intValue());
        } else if (object == LDCLASS_COUNT_KEY) {
            triggerCondition.setMetric(4);
            triggerCondition.setValue(((Integer)this.triggerValueSpinner.getValue()).intValue());
        }
        triggerCondition.setOnetime(this.triggerOnceRadio.isSelected());
        return triggerCondition;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.triggerWhenCombo) {
            Object object = this.triggerWhenCombo.getSelectedItem();
            if (object == HEAP_USG_REL_KEY) {
                this.triggerGenerationsLabel.setText(HEAP_USG_REL_UNIT);
                this.triggerValueSpinner.setModel(this.percentsModel);
            } else if (object == HEAP_SIZE_ABS_KEY) {
                this.triggerGenerationsLabel.setText(HEAP_SIZE_ABS_UNIT);
                this.triggerValueSpinner.setModel(this.unitsModel);
            } else if (object == SURVGEN_COUNT_KEY) {
                this.triggerGenerationsLabel.setText(SURVGEN_COUNT_UNIT);
                this.triggerValueSpinner.setModel(this.unitsModel);
            } else if (object == LDCLASS_COUNT_KEY) {
                this.triggerGenerationsLabel.setText(LDCLASS_COUNT_UNIT);
                this.triggerValueSpinner.setModel(this.unitsModel);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TriggerCustomizer triggerCustomizer = new TriggerCustomizer();
        JFrame jFrame = new JFrame("Customize Profiling Point");
        jFrame.getContentPane().add(triggerCustomizer);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void normalizeCaptionAreaWidth() {
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.triggerWhenLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.triggerWhenLabel, (String)TAKE_WHEN_LABEL_TEXT);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.triggerWhenLabel, gridBagConstraints);
        this.triggerWhenCombo = new JComboBox(new Object[]{HEAP_USG_REL_KEY, HEAP_SIZE_ABS_KEY, SURVGEN_COUNT_KEY, LDCLASS_COUNT_KEY}){

            public Dimension getPreferredSize() {
                return new Dimension(Math.min(super.getPreferredSize().width, 200), super.getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.triggerWhenLabel.setLabelFor(this.triggerWhenCombo);
        this.triggerWhenCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.triggerWhenCombo, gridBagConstraints);
        this.triggerExceedsLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.triggerExceedsLabel, (String)EXCEEDS_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.triggerExceedsLabel, gridBagConstraints);
        this.triggerValueSpinner = new JExtendedSpinner(this.percentsModel){

            public Dimension getPreferredSize() {
                return new Dimension(Math.max(super.getPreferredSize().width, 55), Utils.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.triggerExceedsLabel.setLabelFor(this.triggerValueSpinner);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.triggerValueSpinner, gridBagConstraints);
        this.triggerGenerationsLabel = new JLabel(HEAP_USG_REL_UNIT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.triggerGenerationsLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)jPanel, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.triggerOnceRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.triggerOnceRadio, (String)TAKE_ONCE_RADIO_TEXT);
        buttonGroup.add(this.triggerOnceRadio);
        this.triggerOnceRadio.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel3.add((Component)this.triggerOnceRadio, gridBagConstraints);
        this.triggerAlwaysRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.triggerAlwaysRadio, (String)TAKE_ALWAYS_RADIO_TEXT);
        buttonGroup.add(this.triggerAlwaysRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add((Component)this.triggerAlwaysRadio, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new FlowLayout(3, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel5 = new JPanel(new FlowLayout(3, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jPanel5, gridBagConstraints);
    }

    private void updateValidity() {
        boolean bl = true;
        if (bl != this.areSettingsValid()) {
            this.fireValidityChanged(bl);
        }
    }
}

