/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.modules.profiler.ProfilerIDESettings;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.ProfilingSettingsManager;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.netbeans.modules.profiler.utilities.queries.SettingsFolderQuery;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class IDEUtils {
    private static final String CREATE_NEW_CONFIGURATION_HINT = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_CreateNewConfigurationHint");
    private static final String SELECT_SETTINGS_CONFIGURATION_LABEL_TEXT = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_SelectSettingsConfigurationLabelText");
    private static final String SELECT_SETTINGS_CONFIGURATION_DIALOG_CAPTION = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_SelectSettingsConfigurationDialogCaption");
    private static final String INVALID_PLATFORM_PROJECT_MSG = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_InvalidPlatformProjectMsg");
    private static final String INVALID_PLATFORM_PROFILER_MSG = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_InvalidPlatformProfilerMsg");
    private static final String INVALID_TARGET_JVM_EXEFILE_ERROR = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_InvalidTargetJVMExeFileError");
    private static final String ERROR_CONVERTING_PROFILING_SETTINGS_MESSAGE = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_ErrorConvertingProfilingSettingsMessage");
    private static final String LIST_ACCESS_NAME = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_ListAccessName");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_OkButtonText");
    public static final String SETTINGS_DIR = "org-netbeans-modules-profiler";
    private static final RequestProcessor profilerRequestProcessor = new RequestProcessor("Profiler Request Processor", 1);
    private static final ErrorManager profilerErrorManager = ErrorManager.getDefault().getInstance("org.netbeans.modules.profiler");

    public static String getAntProfilerStartArgument15(int n, int n2) {
        return IDEUtils.getAntProfilerStartArgument(n, n2, "jdk15");
    }

    public static String getAntProfilerStartArgument16(int n, int n2) {
        return IDEUtils.getAntProfilerStartArgument(n, n2, "jdk16");
    }

    public static String getAntProfilerStartArgument17(int n, int n2) {
        return IDEUtils.getAntProfilerStartArgument(n, n2, "jdk17");
    }

    public static String getHelpDir() {
        Iterator iterator = NbBundle.getLocalizingSuffixes();
        File file = null;
        while (iterator.hasNext() && file == null) {
            file = InstalledFileLocator.getDefault().locate("docs/profiler" + iterator.next(), "org.netbeans.modules.profiler", false);
        }
        if (file == null) {
            return null;
        }
        return file.getPath();
    }

    public static JavaPlatform getJavaPlatformByName(String string) {
        if (string != null) {
            JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(string, null);
            for (int i = 0; i < javaPlatformArray.length; ++i) {
                JavaPlatform javaPlatform = javaPlatformArray[i];
                if (string == null || !javaPlatform.getDisplayName().equals(string)) continue;
                return javaPlatform;
            }
        }
        return null;
    }

    public static String getLibsDir() {
        File file = InstalledFileLocator.getDefault().locate("lib/jfluid-server.jar", "org.netbeans.lib.profiler", false);
        if (file == null) {
            return null;
        }
        return file.getParentFile().getPath();
    }

    public static Component getMainWindow() {
        return WindowManager.getDefault().getMainWindow();
    }

    public static int getPlatformArchitecture(JavaPlatform javaPlatform) {
        assert (javaPlatform != null) : "Platform may not be NULL";
        Map map = javaPlatform.getSystemProperties();
        String string = (String)map.get("sun.arch.data.model");
        if (string == null) {
            return 32;
        }
        return Integer.parseInt(string);
    }

    public static int getPlatformJDKMinor(JavaPlatform javaPlatform) {
        assert (javaPlatform != null) : "Platform may not be NULL";
        Map map = javaPlatform.getSystemProperties();
        String string = (String)map.get("java.version");
        return Platform.getJDKMinorNumber((String)string);
    }

    public static String getPlatformJDKVersion(JavaPlatform javaPlatform) {
        assert (javaPlatform != null) : "Platform may not be NULL";
        Map map = javaPlatform.getSystemProperties();
        String string = (String)map.get("java.version");
        if (string == null) {
            return null;
        }
        if (string.startsWith("1.5")) {
            return "jdk15";
        }
        if (string.startsWith("1.6")) {
            return "jdk16";
        }
        if (string.startsWith("1.7")) {
            return "jdk17";
        }
        return null;
    }

    public static String getPlatformJavaFile(JavaPlatform javaPlatform) {
        assert (javaPlatform != null) : "Platform may not be NULL";
        FileObject fileObject = javaPlatform.findTool("java");
        if (fileObject == null) {
            if (ProfilerIDESettings.getInstance().getJavaPlatformForProfiling() == null) {
                Profiler.getDefault().displayError(MessageFormat.format(INVALID_PLATFORM_PROJECT_MSG, javaPlatform.getDisplayName()));
            } else {
                Profiler.getDefault().displayError(MessageFormat.format(INVALID_PLATFORM_PROFILER_MSG, javaPlatform.getDisplayName()));
            }
            return null;
        }
        String string = null;
        try {
            File file = FileUtil.toFile((FileObject)fileObject);
            string = file.getAbsolutePath();
            MiscUtils.checkFileForName((String)string);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().annotate((Throwable)exception, MessageFormat.format(INVALID_TARGET_JVM_EXEFILE_ERROR, string, exception.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)exception);
        }
        return string;
    }

    public static RequestProcessor getProfilerRequestProcessor() {
        return profilerRequestProcessor;
    }

    public static Project getProjectFromSettingsFolder(FileObject fileObject) {
        if (fileObject == null || !fileObject.getName().equals("profiler")) {
            return null;
        }
        FileObject fileObject2 = fileObject.getParent();
        if (fileObject2 == null || !fileObject2.getName().equals("private")) {
            return null;
        }
        FileObject fileObject3 = fileObject2.getParent();
        if (fileObject3 == null || !fileObject3.getName().equals("nbproject")) {
            return null;
        }
        FileObject fileObject4 = fileObject3.getParent();
        if (fileObject4 == null) {
            return null;
        }
        try {
            return ProjectManager.getDefault().findProject(fileObject4);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static FileObject getProjectSettingsFolder(Project project, boolean bl) throws IOException {
        if (project == null) {
            return IDEUtils.getSettingsFolder(true);
        }
        FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject");
        if (fileObject == null && bl) {
            fileObject = project.getProjectDirectory().createFolder("nbproject");
        }
        if (fileObject == null) {
            return null;
        }
        FileObject fileObject2 = fileObject.getFileObject("private");
        if (fileObject2 == null && bl) {
            fileObject2 = fileObject.createFolder("private");
        }
        if (fileObject2 == null) {
            return null;
        }
        FileObject fileObject3 = fileObject2.getFileObject("profiler");
        if (fileObject3 == null && bl) {
            fileObject3 = fileObject2.createFolder("profiler");
        }
        return fileObject3;
    }

    public static FileObject getSettingsFolder(boolean bl) throws IOException {
        return SettingsFolderQuery.getDefault().getSettingsFolder(bl);
    }

    public static TopComponent getTopComponent(Component component) {
        while (!(component instanceof TopComponent)) {
            if ((component = component.getParent()) != null) continue;
            return null;
        }
        return (TopComponent)component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertPropertiesToXML(FileObject fileObject, FileObject fileObject2) {
        FileLock fileLock = null;
        FileLock fileLock2 = null;
        try {
            fileLock = fileObject.lock();
            InputStream inputStream = fileObject.getInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            Properties properties = new Properties();
            properties.load(bufferedInputStream);
            bufferedInputStream.close();
            inputStream.close();
            fileLock2 = fileObject2.lock();
            OutputStream outputStream = fileObject2.getOutputStream(fileLock2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            properties.storeToXML(bufferedOutputStream, "");
            bufferedOutputStream.close();
            outputStream.close();
            fileObject.delete(fileLock);
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(ERROR_CONVERTING_PROFILING_SETTINGS_MESSAGE, FileUtil.toFile((FileObject)fileObject).getPath(), FileUtil.toFile((FileObject)fileObject2).getPath(), exception.getMessage()), 2));
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
            if (fileLock2 != null) {
                fileLock2.releaseLock();
            }
        }
    }

    public static Properties duplicateProperties(Properties properties) {
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties2.setProperty(string, properties.getProperty(string));
        }
        return properties2;
    }

    public static ProgressHandle indeterminateProgress(String string, final int n) {
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string);
        IDEUtils.runInEventDispatchThreadAndWait(new Runnable(){

            public void run() {
                progressHandle.setInitialDelay(n);
                progressHandle.start();
            }
        });
        return progressHandle;
    }

    public static void runInEventDispatchThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void runInEventDispatchThreadAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                profilerErrorManager.notify((Throwable)invocationTargetException);
            }
            catch (InterruptedException interruptedException) {
                profilerErrorManager.notify((Throwable)interruptedException);
            }
        }
    }

    public static void runInProfilerRequestProcessor(Runnable runnable) {
        profilerRequestProcessor.post(runnable);
    }

    public static ProfilingSettings selectSettings(Project project, int n, ProfilingSettings[] profilingSettingsArray, ProfilingSettings profilingSettings) {
        int n2;
        Object[] objectArray = new Object[profilingSettingsArray.length + 1];
        for (int i = 0; i < profilingSettingsArray.length; ++i) {
            objectArray[i] = profilingSettingsArray[i];
        }
        objectArray[profilingSettingsArray.length] = CREATE_NEW_CONFIGURATION_HINT;
        JLabel jLabel = new JLabel(SELECT_SETTINGS_CONFIGURATION_LABEL_TEXT);
        final JButton jButton = new JButton(OK_BUTTON_TEXT);
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(450, 250));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        jPanel.setLayout(new BorderLayout(0, 5));
        jPanel.add((Component)jLabel, "North");
        final JList<Object> jList = new JList<Object>(objectArray);
        jLabel.setLabelFor(jList);
        jList.getAccessibleContext().setAccessibleName(LIST_ACCESS_NAME);
        jList.setSelectionMode(0);
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                jButton.setEnabled(jList.getSelectedIndex() != -1);
            }
        });
        if (profilingSettings != null) {
            jList.setSelectedValue(profilingSettings, true);
        } else {
            jList.setSelectedIndex(0);
        }
        jPanel.add((Component)new JScrollPane(jList), "Center");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, SELECT_SETTINGS_CONFIGURATION_DIALOG_CAPTION, true, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton, 0, null, null);
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == jButton && (n2 = jList.getSelectedIndex()) != -1) {
            if (n2 < objectArray.length - 1) {
                ProfilingSettings profilingSettings2 = (ProfilingSettings)objectArray[n2];
                profilingSettings2.setProfilingType(n);
                return profilingSettings2;
            }
            ProfilingSettings profilingSettings3 = ProfilingSettingsManager.getDefault().createNewSettings(n, profilingSettingsArray);
            if (profilingSettings3 == null) {
                return null;
            }
            profilingSettings3.setProfilingType(n);
            return profilingSettings3;
        }
        return null;
    }

    private static String getAntProfilerStartArgument(int n, int n2, String string) {
        String string2 = IDEUtils.getLibsDir();
        return "-agentpath:" + Platform.getAgentNativeLibFullName((String)string2, (boolean)false, (String)string, (int)n2) + "=" + string2 + "," + n + "," + System.getProperty("profiler.agent.connect.timeout", "10");
    }

    private static ArrayList getSettings(Project project, int n) {
        ProfilingSettings[] profilingSettingsArray;
        ArrayList<ProfilingSettings> arrayList = new ArrayList<ProfilingSettings>();
        for (ProfilingSettings profilingSettings : profilingSettingsArray = ProfilingSettingsManager.getDefault().getProfilingSettings(project).getProfilingSettings()) {
            if (!IDEUtils.matchesMask(profilingSettings, n)) continue;
            arrayList.add(profilingSettings);
        }
        return arrayList;
    }

    private static String forwardSlashes(String string) {
        return string.replaceAll("\\\\", "/");
    }

    private static boolean matchesMask(ProfilingSettings profilingSettings, int n) {
        return Utils.isCPUSettings(profilingSettings);
    }
}

