/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.io.File;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.WLDeployer;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentFactory;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.WLTargetModuleID;
import org.netbeans.modules.j2ee.weblogic9.util.WLOutputManager;
import org.openide.util.NbBundle;

public class WLDeploymentManager
implements DeploymentManager {
    private static final Logger LOGGER = Logger.getLogger(WLDeploymentManager.class.getName());
    private final WLDeploymentFactory factory;
    private DeploymentManager vendorDeploymentManager;
    private InstanceProperties instanceProperties;
    private String uri;
    private String username;
    private String password;
    private boolean isConnected;
    private String host;
    private String port;
    private Process process;
    private WLOutputManager outputManager;

    public WLDeploymentManager(WLDeploymentFactory wLDeploymentFactory, String string, String string2, String string3, String string4, String string5) {
        this(wLDeploymentFactory, string, string2, string3, string4, string5, true);
    }

    public WLDeploymentManager(WLDeploymentFactory wLDeploymentFactory, String string, String string2, String string3) {
        this(wLDeploymentFactory, string, null, null, string2, string3, false);
    }

    protected WLDeploymentManager(WLDeploymentFactory wLDeploymentFactory, String string, String string2, String string3, String string4, String string5, boolean bl) {
        this.factory = wLDeploymentFactory;
        this.uri = string;
        this.username = string2;
        this.password = string3;
        this.host = string4;
        this.port = string5;
        this.isConnected = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentManager getDeploymentManager() throws DeploymentManagerCreationException {
        WLDeploymentFactory wLDeploymentFactory = this.factory;
        synchronized (wLDeploymentFactory) {
            if (this.vendorDeploymentManager == null) {
                this.vendorDeploymentManager = this.isConnected ? new SafeDeploymentManager(this.factory.getVendorDeploymentManager(this.uri, this.username, this.password, this.host, this.port)) : new SafeDeploymentManager(this.factory.getVendorDisconnectedDeploymentManager(this.uri));
            }
            return this.vendorDeploymentManager;
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public String getURI() {
        return this.uri;
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.getInstanceProperties().getProperty("username");
    }

    public String getPassword() {
        return this.getInstanceProperties().getProperty("password");
    }

    public String getPort() {
        return this.port;
    }

    public boolean isLocal() {
        return Boolean.valueOf(this.getInstanceProperties().getProperty("isLocal"));
    }

    public InstanceProperties getInstanceProperties() {
        if (this.instanceProperties == null) {
            this.instanceProperties = InstanceProperties.getInstanceProperties((String)this.uri);
        }
        return this.instanceProperties;
    }

    public synchronized void setServerProcess(Process process) {
        this.process = process;
    }

    public synchronized Process getServerProcess() {
        return this.process;
    }

    public WLOutputManager getOutputManager() {
        return this.outputManager;
    }

    public void setOutputManager(WLOutputManager wLOutputManager) {
        this.outputManager = wLOutputManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject distribute(Target[] targetArray, File file, File file2) throws IllegalStateException {
        if (this.isLocal()) {
            return new WLDeployer(this.uri).deploy(targetArray, file, file2, this.getHost(), this.getPort());
        }
        ClassLoader classLoader = this.modifyLoader();
        try {
            DelegatingProgressObject delegatingProgressObject = new DelegatingProgressObject(this.getDeploymentManager().distribute(targetArray, file, null));
            return delegatingProgressObject;
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            FinishedProgressObject finishedProgressObject = new FinishedProgressObject(ActionType.EXECUTE, CommandType.DISTRIBUTE, NbBundle.getMessage(WLDeploymentManager.class, (String)"MSG_Deployment_Failed"), null, true);
            return finishedProgressObject;
        }
        finally {
            this.originalLoader(classLoader);
        }
    }

    public ProgressObject distribute(Target[] targetArray, ModuleType moduleType, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        return this.distribute(targetArray, inputStream, inputStream2);
    }

    private ClassLoader modifyLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String string = this.getInstanceProperties().getProperty("serverRoot");
        if (string == null) {
            string = WLPluginProperties.getInstance().getInstallLocation();
        }
        Thread.currentThread().setContextClassLoader(WLDeploymentFactory.getWLClassLoader(string));
        return classLoader;
    }

    private void originalLoader(ClassLoader classLoader) {
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, InputStream inputStream, InputStream inputStream2) throws UnsupportedOperationException, IllegalStateException {
        ClassLoader classLoader = this.modifyLoader();
        try {
            DelegatingProgressObject delegatingProgressObject = new DelegatingProgressObject(this.getDeploymentManager().redeploy(targetModuleIDArray, inputStream, inputStream2));
            return delegatingProgressObject;
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            FinishedProgressObject finishedProgressObject = new FinishedProgressObject(ActionType.EXECUTE, CommandType.REDEPLOY, NbBundle.getMessage(WLDeploymentManager.class, (String)"MSG_Redeployment_Failed"), null, true);
            return finishedProgressObject;
        }
        finally {
            this.originalLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject distribute(Target[] targetArray, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        ClassLoader classLoader = this.modifyLoader();
        try {
            DelegatingProgressObject delegatingProgressObject = new DelegatingProgressObject(this.getDeploymentManager().distribute(targetArray, inputStream, inputStream2));
            return delegatingProgressObject;
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            FinishedProgressObject finishedProgressObject = new FinishedProgressObject(ActionType.EXECUTE, CommandType.DISTRIBUTE, NbBundle.getMessage(WLDeploymentManager.class, (String)"MSG_Deployment_Failed"), null, true);
            return finishedProgressObject;
        }
        finally {
            this.originalLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject undeploy(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        ClassLoader classLoader = this.modifyLoader();
        try {
            DelegatingProgressObject delegatingProgressObject = new DelegatingProgressObject(this.getDeploymentManager().undeploy(targetModuleIDArray));
            return delegatingProgressObject;
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            FinishedProgressObject finishedProgressObject = new FinishedProgressObject(ActionType.EXECUTE, CommandType.UNDEPLOY, NbBundle.getMessage(WLDeploymentManager.class, (String)"MSG_Undeployment_Failed"), null, true);
            return finishedProgressObject;
        }
        finally {
            this.originalLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject stop(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        ClassLoader classLoader = this.modifyLoader();
        try {
            DelegatingProgressObject delegatingProgressObject = new DelegatingProgressObject(this.getDeploymentManager().stop(targetModuleIDArray));
            return delegatingProgressObject;
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            FinishedProgressObject finishedProgressObject = new FinishedProgressObject(ActionType.EXECUTE, CommandType.STOP, NbBundle.getMessage(WLDeploymentManager.class, (String)"MSG_Application_Stop_Failed"), null, true);
            return finishedProgressObject;
        }
        finally {
            this.originalLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject start(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        TargetModuleID[] targetModuleIDArray2 = this.getServerTargetModuleIds(targetModuleIDArray);
        if (targetModuleIDArray2.length == 0) {
            return new FinishedProgressObject(ActionType.EXECUTE, CommandType.START, NbBundle.getMessage(WLDeploymentManager.class, (String)"MSG_Application_Started_Already"), targetModuleIDArray, false);
        }
        ClassLoader classLoader = this.modifyLoader();
        try {
            DelegatingProgressObject delegatingProgressObject = new DelegatingProgressObject(this.getDeploymentManager().start(targetModuleIDArray2));
            return delegatingProgressObject;
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            FinishedProgressObject finishedProgressObject = new FinishedProgressObject(ActionType.EXECUTE, CommandType.START, NbBundle.getMessage(WLDeploymentManager.class, (String)"MSG_Application_Start_Failed"), null, true);
            return finishedProgressObject;
        }
        finally {
            this.originalLoader(classLoader);
        }
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        ClassLoader classLoader = this.modifyLoader();
        try {
            TargetModuleID[] targetModuleIDArray;
            TargetModuleID[] targetModuleIDArray2 = targetModuleIDArray = this.getDeploymentManager().getAvailableModules(moduleType, targetArray);
            return targetModuleIDArray2;
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            throw new IllegalStateException(deploymentManagerCreationException);
        }
        finally {
            this.originalLoader(classLoader);
        }
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        ClassLoader classLoader = this.modifyLoader();
        try {
            TargetModuleID[] targetModuleIDArray;
            TargetModuleID[] targetModuleIDArray2 = targetModuleIDArray = this.getDeploymentManager().getNonRunningModules(moduleType, targetArray);
            return targetModuleIDArray2;
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            throw new IllegalStateException(deploymentManagerCreationException);
        }
        finally {
            this.originalLoader(classLoader);
        }
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        ClassLoader classLoader = this.modifyLoader();
        try {
            TargetModuleID[] targetModuleIDArray;
            TargetModuleID[] targetModuleIDArray2 = targetModuleIDArray = this.getDeploymentManager().getRunningModules(moduleType, targetArray);
            return targetModuleIDArray2;
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            throw new IllegalStateException(deploymentManagerCreationException);
        }
        finally {
            this.originalLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, File file, File file2) throws UnsupportedOperationException, IllegalStateException {
        ClassLoader classLoader = this.modifyLoader();
        try {
            DelegatingProgressObject delegatingProgressObject = new DelegatingProgressObject(this.getDeploymentManager().redeploy(targetModuleIDArray, file, file2));
            return delegatingProgressObject;
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            FinishedProgressObject finishedProgressObject = new FinishedProgressObject(ActionType.EXECUTE, CommandType.REDEPLOY, NbBundle.getMessage(WLDeploymentManager.class, (String)"MSG_Redeployment_Failed"), null, true);
            return finishedProgressObject;
        }
        finally {
            this.originalLoader(classLoader);
        }
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public boolean isLocaleSupported(Locale locale) {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        ClassLoader classLoader = this.modifyLoader();
        try {
            WLDeploymentFactory wLDeploymentFactory = this.factory;
            synchronized (wLDeploymentFactory) {
                if (this.vendorDeploymentManager != null) {
                    try {
                        this.vendorDeploymentManager.release();
                    }
                    catch (Exception exception) {
                        Logger.getLogger("global").log(Level.INFO, null, exception);
                    }
                    finally {
                        this.vendorDeploymentManager = null;
                    }
                }
            }
        }
        finally {
            this.originalLoader(classLoader);
        }
    }

    public boolean isRedeploySupported() {
        return false;
    }

    public Locale getCurrentLocale() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Locale getDefaultLocale() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Locale[] getSupportedLocales() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Target[] getTargets() throws IllegalStateException {
        ClassLoader classLoader = this.modifyLoader();
        try {
            Target[] targetArray = this.getDeploymentManager().getTargets();
            return targetArray;
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            throw new IllegalStateException(deploymentManagerCreationException);
        }
        finally {
            this.originalLoader(classLoader);
        }
    }

    private TargetModuleID[] getServerTargetModuleIds(TargetModuleID[] targetModuleIDArray) {
        LinkedList<TargetModuleID> linkedList = new LinkedList<TargetModuleID>();
        for (TargetModuleID targetModuleID : targetModuleIDArray) {
            if (targetModuleID instanceof WLTargetModuleID) continue;
            linkedList.add(targetModuleID);
        }
        return linkedList.toArray(new TargetModuleID[linkedList.size()]);
    }

    private static final class SafeDeploymentManager
    implements DeploymentManager {
        private final DeploymentManager delegate;

        public SafeDeploymentManager(DeploymentManager deploymentManager) {
            this.delegate = deploymentManager;
        }

        public synchronized ProgressObject undeploy(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
            return this.delegate.undeploy(targetModuleIDArray);
        }

        public synchronized ProgressObject stop(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
            return this.delegate.stop(targetModuleIDArray);
        }

        public synchronized ProgressObject start(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
            return this.delegate.start(targetModuleIDArray);
        }

        public synchronized void setLocale(Locale locale) throws UnsupportedOperationException {
            this.delegate.setLocale(locale);
        }

        public synchronized void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
            this.delegate.setDConfigBeanVersion(dConfigBeanVersionType);
        }

        public synchronized void release() {
            this.delegate.release();
        }

        public synchronized ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, InputStream inputStream, InputStream inputStream2) throws UnsupportedOperationException, IllegalStateException {
            return this.delegate.redeploy(targetModuleIDArray, inputStream, inputStream2);
        }

        public synchronized ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, File file, File file2) throws UnsupportedOperationException, IllegalStateException {
            return this.delegate.redeploy(targetModuleIDArray, file, file2);
        }

        public synchronized boolean isRedeploySupported() {
            return this.delegate.isRedeploySupported();
        }

        public synchronized boolean isLocaleSupported(Locale locale) {
            return this.delegate.isLocaleSupported(locale);
        }

        public synchronized boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
            return this.delegate.isDConfigBeanVersionSupported(dConfigBeanVersionType);
        }

        public synchronized Target[] getTargets() throws IllegalStateException {
            return this.delegate.getTargets();
        }

        public synchronized Locale[] getSupportedLocales() {
            return this.delegate.getSupportedLocales();
        }

        public synchronized TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
            return this.delegate.getRunningModules(moduleType, targetArray);
        }

        public synchronized TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
            return this.delegate.getNonRunningModules(moduleType, targetArray);
        }

        public synchronized Locale getDefaultLocale() {
            return this.delegate.getDefaultLocale();
        }

        public synchronized DConfigBeanVersionType getDConfigBeanVersion() {
            return this.delegate.getDConfigBeanVersion();
        }

        public synchronized Locale getCurrentLocale() {
            return this.delegate.getCurrentLocale();
        }

        public synchronized TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
            return this.delegate.getAvailableModules(moduleType, targetArray);
        }

        public synchronized ProgressObject distribute(Target[] targetArray, ModuleType moduleType, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
            return this.delegate.distribute(targetArray, moduleType, inputStream, inputStream2);
        }

        public synchronized ProgressObject distribute(Target[] targetArray, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
            return this.delegate.distribute(targetArray, inputStream, inputStream2);
        }

        public synchronized ProgressObject distribute(Target[] targetArray, File file, File file2) throws IllegalStateException {
            return this.delegate.distribute(targetArray, file, file2);
        }

        public synchronized DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
            return this.delegate.createConfiguration(deployableObject);
        }
    }

    private static class DelegatingProgressObject
    implements ProgressObject,
    ProgressListener {
        private final ProgressObject original;
        private List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();

        public DelegatingProgressObject(ProgressObject progressObject) {
            this.original = progressObject;
            progressObject.addProgressListener((ProgressListener)this);
        }

        public DeploymentStatus getDeploymentStatus() {
            return this.original.getDeploymentStatus();
        }

        public TargetModuleID[] getResultTargetModuleIDs() {
            return this.original.getResultTargetModuleIDs();
        }

        public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
            return this.original.getClientConfiguration(targetModuleID);
        }

        public boolean isCancelSupported() {
            return this.original.isCancelSupported();
        }

        public void cancel() throws OperationUnsupportedException {
            this.original.cancel();
        }

        public boolean isStopSupported() {
            return this.original.isStopSupported();
        }

        public void stop() throws OperationUnsupportedException {
            this.original.stop();
        }

        public void addProgressListener(ProgressListener progressListener) {
            this.listeners.add(progressListener);
        }

        public void removeProgressListener(ProgressListener progressListener) {
            this.listeners.remove(progressListener);
        }

        public void handleProgressEvent(ProgressEvent progressEvent) {
            for (ProgressListener progressListener : this.listeners) {
                progressListener.handleProgressEvent(progressEvent);
            }
        }
    }

    private static final class FinishedProgressObject
    implements ProgressObject {
        private final TargetModuleID[] moduleIds;
        private final DeploymentStatus status;

        public FinishedProgressObject(final ActionType actionType, final CommandType commandType, final String string, TargetModuleID[] targetModuleIDArray, final boolean bl) {
            this.moduleIds = targetModuleIDArray == null ? new TargetModuleID[]{} : targetModuleIDArray;
            this.status = new DeploymentStatus(){

                public ActionType getAction() {
                    return actionType;
                }

                public CommandType getCommand() {
                    return commandType;
                }

                public String getMessage() {
                    return string;
                }

                public StateType getState() {
                    return bl ? StateType.FAILED : StateType.COMPLETED;
                }

                public boolean isCompleted() {
                    return false;
                }

                public boolean isFailed() {
                    return true;
                }

                public boolean isRunning() {
                    return false;
                }
            };
        }

        public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public DeploymentStatus getDeploymentStatus() {
            return this.status;
        }

        public TargetModuleID[] getResultTargetModuleIDs() {
            return this.moduleIds;
        }

        public boolean isCancelSupported() {
            return false;
        }

        public boolean isStopSupported() {
            return false;
        }

        public void cancel() throws OperationUnsupportedException {
            throw new UnsupportedOperationException("Not supported.");
        }

        public void stop() throws OperationUnsupportedException {
            throw new UnsupportedOperationException("Not supported.");
        }

        public void addProgressListener(ProgressListener progressListener) {
        }

        public void removeProgressListener(ProgressListener progressListener) {
        }
    }
}

