/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.structure;

import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamRecognitionException;
import java.util.Stack;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.structure.APTBaseNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTConditionsBlockNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTDefineNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTElifNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTElseNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTEndifNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTErrorNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTFileNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIfNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIfdefNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIfndefNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIncludeNextNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIncludeNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTStreamNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTTokenBasedNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTUndefineNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTUnknownNode;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public final class APTBuilderImpl {
    private Stack<APTBaseNode> nodeStack = new Stack();

    public APTFile buildAPT(CharSequence charSequence, TokenStream tokenStream) {
        if (tokenStream == null) {
            return null;
        }
        APTFileNode aPTFileNode = new APTFileNode(charSequence);
        try {
            this.buildFileAPT(aPTFileNode, tokenStream);
        }
        catch (TokenStreamRecognitionException tokenStreamRecognitionException) {
            APTUtils.LOG.log(Level.SEVERE, "error on building APT\n {0}", new Object[]{tokenStreamRecognitionException});
        }
        catch (TokenStreamException tokenStreamException) {
            APTUtils.LOG.log(Level.SEVERE, "error on converting token stream to text while building APT\n{0}", new Object[]{tokenStreamException});
            APTUtils.LOG.log(Level.SEVERE, "problem file is {0}", new Object[]{charSequence});
        }
        return aPTFileNode;
    }

    public static APT buildAPTLight(APT aPT) {
        assert (aPT != null);
        assert (APTBuilderImpl.isRootNode(aPT));
        APT aPT2 = APTBuilderImpl.createLightCopy(aPT);
        APT aPT3 = APTBuilderImpl.nextRoot(aPT);
        APT aPT4 = aPT2;
        do {
            APT aPT5;
            APT aPT6;
            if ((aPT6 = APTBuilderImpl.nextRoot(aPT3.getFirstChild())) != null) {
                aPT5 = APTBuilderImpl.buildAPTLight(aPT6);
                assert (aPT5 != null);
                assert (APTBuilderImpl.isRootNode(aPT5));
                aPT4.setFirstChild(aPT5);
            }
            aPT3 = aPT5 = APTBuilderImpl.nextRoot(aPT3.getNextSibling());
            if (aPT5 == null) continue;
            APT aPT7 = APTBuilderImpl.createLightCopy(aPT5);
            assert (aPT7 != null);
            assert (APTBuilderImpl.isRootNode(aPT7));
            aPT4.setNextSibling(aPT7);
            aPT4 = aPT7;
        } while (aPT3 != null);
        assert (aPT2 != null);
        assert (APTBuilderImpl.isRootNode(aPT2));
        return aPT2;
    }

    private void buildFileAPT(APTFileNode aPTFileNode, TokenStream tokenStream) throws TokenStreamException {
        APTToken aPTToken = APTTraceFlags.APT_RECURSIVE_BUILD ? this.addChildren(aPTFileNode, (APTToken)tokenStream.nextToken(), tokenStream, false) : this.build(aPTFileNode, tokenStream);
        assert (APTUtils.isEOF(aPTToken));
    }

    private APTToken build(APTBaseNode aPT, TokenStream tokenStream) throws TokenStreamException {
        assert (tokenStream != null);
        APT aPT2 = null;
        APTToken aPTToken = (APTToken)tokenStream.nextToken();
        while (!APTUtils.isEOF(aPTToken)) {
            if (aPT2 == null) {
                aPT2 = aPT.getType() != 7 ? this.createNode(aPTToken) : this.createConditionChildNode(aPTToken);
                if (APTUtils.isEndCondition(aPTToken)) {
                    assert (!this.nodeStack.empty()) : aPTToken.getText() + " found without corresponding if: " + aPTToken;
                    aPT = this.nodeStack.pop();
                    ((APTBaseNode)aPT).addChild(aPT2);
                    aPTToken = (APTToken)tokenStream.nextToken();
                    continue;
                }
                ((APTBaseNode)aPT).addChild(aPT2);
                if (aPT2.getType() == 7) {
                    assert (aPT.getType() != 7);
                    this.nodeStack.push((APTBaseNode)aPT);
                    aPT = aPT2;
                    aPT2 = this.createConditionChildNode(aPTToken);
                    ((APTBaseNode)aPT).addChild(aPT2);
                }
                aPTToken = (APTToken)tokenStream.nextToken();
                continue;
            }
            if (!aPT2.accept(aPTToken)) {
                if (APTUtils.isEndDirectiveToken(aPTToken.getType())) {
                    aPTToken = (APTToken)tokenStream.nextToken();
                }
                if (aPT2.getType() == 13) {
                    assert (!this.nodeStack.empty()) : "endif found without corresponding if: " + aPTToken;
                    aPT = this.nodeStack.pop();
                } else if (aPT.getType() == 7) {
                    this.nodeStack.push((APTBaseNode)aPT);
                    aPT = aPT2;
                }
                aPT2 = null;
                continue;
            }
            aPTToken = (APTToken)tokenStream.nextToken();
        }
        return aPTToken;
    }

    private APTToken addChildren(APTBaseNode aPTBaseNode, APTToken aPTToken, TokenStream tokenStream, boolean bl) throws TokenStreamException {
        assert (tokenStream != null);
        APTBaseNode aPTBaseNode2 = null;
        while (!APTUtils.isEOF(aPTToken)) {
            if (bl && APTUtils.isEndCondition(aPTToken)) {
                return aPTToken;
            }
            APTBaseNode aPTBaseNode3 = this.createNode(aPTToken);
            if (aPTBaseNode2 == null) {
                aPTBaseNode.setFirstChild(aPTBaseNode3);
            } else {
                aPTBaseNode2.setNextSibling(aPTBaseNode3);
            }
            aPTBaseNode2 = aPTBaseNode3;
            if (aPTBaseNode3.getType() == 7) {
                assert (aPTBaseNode.getType() != 7);
                aPTToken = this.initPreprocBranch((APTConditionsBlockNode)aPTBaseNode3, aPTToken, tokenStream);
                continue;
            }
            aPTToken = this.initNode(aPTBaseNode3, (APTToken)tokenStream.nextToken(), tokenStream);
        }
        return aPTToken;
    }

    private APTToken initPreprocBranch(APTConditionsBlockNode aPTConditionsBlockNode, APTToken aPTToken, TokenStream tokenStream) throws TokenStreamException {
        assert (tokenStream != null);
        APTBaseNode aPTBaseNode = null;
        while (!APTUtils.isEOF(aPTToken)) {
            APTBaseNode aPTBaseNode2 = this.createConditionChildNode(aPTToken);
            if (aPTBaseNode == null) {
                aPTConditionsBlockNode.setFirstChild(aPTBaseNode2);
            } else {
                aPTBaseNode.setNextSibling(aPTBaseNode2);
            }
            aPTBaseNode = aPTBaseNode2;
            aPTToken = this.initNode(aPTBaseNode2, (APTToken)tokenStream.nextToken(), tokenStream);
            if (aPTBaseNode2.getType() == 13) {
                return aPTToken;
            }
            aPTToken = this.addChildren(aPTBaseNode2, aPTToken, tokenStream, true);
        }
        return aPTToken;
    }

    private APTToken initNode(APT aPT, APTToken aPTToken, TokenStream tokenStream) throws TokenStreamException {
        while (!APTUtils.isEOF(aPTToken) && aPT.accept(aPTToken)) {
            aPTToken = (APTToken)tokenStream.nextToken();
        }
        if (APTUtils.isEndDirectiveToken(aPTToken.getType())) {
            aPTToken = (APTToken)tokenStream.nextToken();
        }
        return aPTToken;
    }

    private APTBaseNode createNode(APTToken aPTToken) {
        APTBaseNode aPTBaseNode;
        assert (!APTUtils.isEOF(aPTToken));
        int n = aPTToken.getType();
        switch (n) {
            case 15: 
            case 16: 
            case 17: {
                aPTBaseNode = new APTConditionsBlockNode();
                break;
            }
            case 11: {
                aPTBaseNode = new APTIncludeNode(aPTToken);
                break;
            }
            case 12: {
                aPTBaseNode = new APTIncludeNextNode(aPTToken);
                break;
            }
            case 18: {
                aPTBaseNode = new APTElifNode(aPTToken);
                break;
            }
            case 19: {
                aPTBaseNode = new APTElseNode(aPTToken);
                break;
            }
            case 20: {
                aPTBaseNode = new APTEndifNode(aPTToken);
                break;
            }
            case 13: {
                aPTBaseNode = new APTDefineNode(aPTToken);
                break;
            }
            case 14: {
                aPTBaseNode = new APTUndefineNode(aPTToken);
                break;
            }
            case 23: {
                aPTBaseNode = new APTErrorNode(aPTToken);
                break;
            }
            case 21: 
            case 22: 
            case 24: {
                aPTBaseNode = new APTUnknownNode(aPTToken);
                break;
            }
            default: {
                assert (!APTUtils.isPreprocessorToken(n)) : "all preprocessor tokens should be handled above";
                aPTBaseNode = new APTStreamNode(aPTToken);
            }
        }
        assert (aPTBaseNode != null);
        return aPTBaseNode;
    }

    private APTBaseNode createConditionChildNode(APTToken aPTToken) {
        assert (!APTUtils.isEOF(aPTToken));
        assert (APTUtils.isConditionsBlockToken(aPTToken)) : "Not conditional token found:" + aPTToken;
        int n = aPTToken.getType();
        APTTokenBasedNode aPTTokenBasedNode = null;
        switch (n) {
            case 17: {
                aPTTokenBasedNode = new APTIfNode(aPTToken);
                break;
            }
            case 15: {
                aPTTokenBasedNode = new APTIfdefNode(aPTToken);
                break;
            }
            case 16: {
                aPTTokenBasedNode = new APTIfndefNode(aPTToken);
                break;
            }
            case 18: {
                aPTTokenBasedNode = new APTElifNode(aPTToken);
                break;
            }
            case 19: {
                aPTTokenBasedNode = new APTElseNode(aPTToken);
                break;
            }
            case 20: {
                aPTTokenBasedNode = new APTEndifNode(aPTToken);
                break;
            }
            default: {
                assert (false) : "unexpected " + n;
                break;
            }
        }
        assert (aPTTokenBasedNode != null);
        return aPTTokenBasedNode;
    }

    private static APT createLightCopy(APT aPT) {
        assert (aPT != null);
        assert (APTBuilderImpl.isRootNode(aPT));
        APTBaseNode aPTBaseNode = null;
        switch (aPT.getType()) {
            case 2: {
                break;
            }
            case 5: {
                aPTBaseNode = new APTDefineNode((APTDefineNode)aPT);
                break;
            }
            case 6: {
                aPTBaseNode = new APTUndefineNode((APTUndefineNode)aPT);
                break;
            }
            case 7: {
                aPTBaseNode = new APTConditionsBlockNode((APTConditionsBlockNode)aPT);
                break;
            }
            case 8: {
                aPTBaseNode = new APTIfdefNode((APTIfdefNode)aPT);
                break;
            }
            case 9: {
                aPTBaseNode = new APTIfndefNode((APTIfndefNode)aPT);
                break;
            }
            case 10: {
                aPTBaseNode = new APTIfNode((APTIfNode)aPT);
                break;
            }
            case 11: {
                aPTBaseNode = new APTElifNode((APTElifNode)aPT);
                break;
            }
            case 12: {
                aPTBaseNode = new APTElseNode((APTElseNode)aPT);
                break;
            }
            case 13: {
                aPTBaseNode = new APTEndifNode((APTEndifNode)aPT);
                break;
            }
            case 3: {
                aPTBaseNode = new APTIncludeNode((APTIncludeNode)aPT);
                break;
            }
            case 4: {
                aPTBaseNode = new APTIncludeNextNode((APTIncludeNextNode)aPT);
                break;
            }
            case 16: {
                aPTBaseNode = new APTErrorNode((APTErrorNode)aPT);
                break;
            }
            case 1: {
                aPTBaseNode = new APTFileNode((APTFileNode)aPT);
                break;
            }
        }
        return aPTBaseNode;
    }

    private static boolean isRootNode(APT aPT) {
        switch (aPT.getType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private static APT nextRoot(APT aPT) {
        for (APT aPT2 = aPT; aPT2 != null; aPT2 = aPT2.getNextSibling()) {
            if (!APTBuilderImpl.isRootNode(aPT2)) continue;
            return aPT2;
        }
        return null;
    }
}

