/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.debug.DebugUtils;
import org.netbeans.modules.cnd.apt.impl.structure.APTMacroBaseNode;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.apt.utils.ListBasedTokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APTDefineNode
extends APTMacroBaseNode
implements APTDefine,
Serializable {
    private static final long serialVersionUID = -99267816578145490L;
    private List<APTToken> params = null;
    private List<APTToken> bodyTokens = null;
    private byte state = 0;
    private static final byte BEFORE_MACRO_NAME = 0;
    private static final byte AFTER_MACRO_NAME = 1;
    private static final byte IN_PARAMS = 2;
    private static final byte IN_BODY = 3;
    private static final byte IN_BODY_AFTER_SHARP = 4;
    private static final byte ERROR = 5;

    APTDefineNode(APTDefineNode aPTDefineNode) {
        super(aPTDefineNode);
        this.params = aPTDefineNode.params;
        this.bodyTokens = aPTDefineNode.bodyTokens;
        this.state = aPTDefineNode.state;
    }

    protected APTDefineNode() {
    }

    public APTDefineNode(APTToken aPTToken) {
        super(aPTToken);
    }

    @Override
    public final int getType() {
        return 5;
    }

    @Override
    public Collection<APTToken> getParams() {
        if (this.params == null) {
            return null;
        }
        return Collections.unmodifiableList(this.params);
    }

    @Override
    public boolean isFunctionLike() {
        return this.params != null;
    }

    @Override
    public List<APTToken> getBody() {
        return this.bodyTokens != null ? this.bodyTokens : Collections.emptyList();
    }

    @Override
    public boolean isValid() {
        return this.state != 5;
    }

    @Override
    public boolean accept(APTToken aPTToken) {
        int n = aPTToken.getType();
        if (APTUtils.isEndDirectiveToken(n)) {
            if (this.bodyTokens != null) {
                ((ArrayList)this.bodyTokens).trimToSize();
            }
            if (this.params != null) {
                ((ArrayList)this.params).trimToSize();
            }
            if (this.state == 0) {
                this.state = (byte)5;
            }
            return false;
        }
        block0 : switch (this.state) {
            case 0: {
                boolean bl = super.accept(aPTToken);
                assert (bl);
                this.state = 1;
                break;
            }
            case 1: {
                if (aPTToken.getType() == 209) {
                    this.params = new ArrayList<APTToken>();
                    this.state = (byte)2;
                    break;
                }
                if (this.bodyTokens == null) {
                    this.bodyTokens = new ArrayList<APTToken>();
                }
                this.bodyTokens.add(aPTToken);
                this.state = (byte)3;
                break;
            }
            case 2: {
                switch (aPTToken.getType()) {
                    case 205: {
                        this.params.add(aPTToken);
                        break block0;
                    }
                    case 139: {
                        this.state = (byte)3;
                        break block0;
                    }
                    case 6: {
                        this.params.add(APTUtils.VA_ARGS_TOKEN);
                        break block0;
                    }
                }
                if (aPTToken.getType() == 134 || APTUtils.isCommentToken(aPTToken.getType())) break;
                if (DebugUtils.STANDALONE) {
                    System.err.printf("line %d: \"%s\" may not appear in macro parameter list\n", this.getToken().getLine(), aPTToken.getText());
                } else {
                    APTUtils.LOG.log(Level.SEVERE, "line {0}: {1} may not appear in macro parameter list", new Object[]{this.getToken().getLine(), aPTToken.getText()});
                }
                this.state = (byte)5;
                break;
            }
            case 3: {
                if (this.bodyTokens == null) {
                    this.bodyTokens = new ArrayList<APTToken>();
                }
                if (aPTToken.getType() == 183) {
                    this.state = (byte)4;
                }
                this.bodyTokens.add(aPTToken);
                break;
            }
            case 4: {
                this.bodyTokens.add(aPTToken);
                if (!APTUtils.isCommentToken(aPTToken.getType())) {
                    this.state = aPTToken.getType() == 205 ? (byte)(this.isInParamList(aPTToken) ? 3 : 5) : (byte)5;
                }
                if (this.state != 5) break;
                if (DebugUtils.STANDALONE) {
                    System.err.printf("line %d: '#' is not followed by a macro parameter\n", this.getToken().getLine());
                    break;
                }
                APTUtils.LOG.log(Level.SEVERE, "line {0}: '#' is not followed by a macro parameter", new Object[]{this.getToken().getLine()});
                break;
            }
            case 5: {
                break;
            }
            default: {
                assert (false) : "unexpected state";
                break;
            }
        }
        return true;
    }

    private boolean isInParamList(APTToken aPTToken) {
        assert (aPTToken != null);
        if (this.params == null) {
            return false;
        }
        for (APTToken aPTToken2 : this.params) {
            if (!aPTToken2.getTextID().equals(aPTToken.getTextID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getText() {
        String string = super.getText();
        String string2 = "";
        if (this.params != null) {
            string2 = "PARAMS{" + APTUtils.toString(new ListBasedTokenStream(this.params)) + "}";
        }
        String string3 = this.bodyTokens != null ? "BODY{" + APTUtils.toString(new ListBasedTokenStream(this.getBody())) + "}" : "{NO BODY}";
        return string + string2 + string3;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        APTDefineNode aPTDefineNode = (APTDefineNode)object;
        if (!(this.params == aPTDefineNode.params || this.params != null && ((Object)this.params).equals(aPTDefineNode.params))) {
            return false;
        }
        return this.bodyTokens == aPTDefineNode.bodyTokens || this.bodyTokens != null && ((Object)this.bodyTokens).equals(aPTDefineNode.bodyTokens);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 37 * n + (this.params != null ? ((Object)this.params).hashCode() : 0);
        n = 37 * n + (this.bodyTokens != null ? ((Object)this.bodyTokens).hashCode() : 0);
        return n;
    }
}

