/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.debug.DebugUtils;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroParamExpansion;
import org.netbeans.modules.cnd.apt.impl.support.APTSystemMacroMap;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenStream;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.apt.utils.ListBasedTokenStream;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTExpandedStream
implements TokenStream,
APTTokenStream {
    private final TokenStreamSelector selector = new TokenStreamSelector();
    private final APTMacroCallback callback;
    private boolean extractingMacroParams = false;
    private final boolean expandPPExpression;
    private APTToken paramsRParen = null;
    private static final int BODY_STREAM = 0;
    private static final int STRINGIZE_PARAM = 1;
    private static final int CONCATENATE = 2;
    private static final long MACRO_EXPANDING_THREASHOLD = 16384L;

    public APTExpandedStream(TokenStream tokenStream, APTMacroCallback aPTMacroCallback, boolean bl) {
        this.selector.select(tokenStream);
        this.callback = aPTMacroCallback;
        this.expandPPExpression = bl;
        assert (!(aPTMacroCallback instanceof APTSystemMacroMap)) : "system macro map can't be used as callback";
    }

    public APTExpandedStream(TokenStream tokenStream, APTMacroCallback aPTMacroCallback) {
        this(tokenStream, aPTMacroCallback, false);
    }

    @Override
    public APTToken nextToken() {
        APTToken aPTToken;
        boolean bl;
        do {
            try {
                aPTToken = (APTToken)this.selector.nextToken();
            }
            catch (TokenStreamException tokenStreamException) {
                APTUtils.LOG.log(Level.SEVERE, tokenStreamException.getMessage());
                return APTUtils.EOF_TOKEN;
            }
            if (this.extractingMacroParams) {
                return aPTToken;
            }
            bl = false;
            if (APTUtils.isID(aPTToken)) {
                APTMacro aPTMacro = this.callback.getMacro(aPTToken);
                if (aPTMacro == null || this.callback.isExpanding(aPTToken)) continue;
                try {
                    bl = this.pushMacroExpanding(aPTToken, aPTMacro);
                }
                catch (TokenStreamException tokenStreamException) {
                    APTUtils.LOG.log(Level.SEVERE, tokenStreamException.getMessage());
                    bl = false;
                }
                continue;
            }
            if (!APTUtils.isEOF(aPTToken)) continue;
            bl = this.continueOnEOF();
        } while (bl);
        return aPTToken;
    }

    private boolean isExpandingPPExpression() {
        return this.expandPPExpression;
    }

    private boolean pushMacroExpanding(APTToken aPTToken, APTMacro aPTMacro) throws TokenStreamException {
        boolean bl = true;
        try {
            APTTokenStream aPTTokenStream = this.createMacroBodyWrapper(aPTToken, aPTMacro);
            bl = this.callback.pushExpanding(aPTToken);
            if (bl) {
                this.selector.push((TokenStream)aPTTokenStream);
            }
        }
        catch (RecognitionException recognitionException) {
            APTUtils.LOG.log(Level.SEVERE, "error on expanding {0}\n{1}", new Object[]{aPTToken, recognitionException.getMessage()});
            bl = false;
        }
        return bl;
    }

    private boolean popMacroExpanding() {
        boolean bl = true;
        this.callback.popExpanding();
        this.selector.pop();
        return bl;
    }

    protected APTTokenStream createMacroBodyWrapper(APTToken aPTToken, APTMacro aPTMacro) throws TokenStreamException, RecognitionException {
        TokenStream tokenStream;
        assert (aPTMacro != null) : "must be valid macro object";
        assert (aPTMacro.getName() != null) : "macro object must have valid name token";
        assert (!this.callback.isExpanding(aPTMacro.getName())) : "macro must not be under recursive expanding";
        this.paramsRParen = null;
        if (!aPTMacro.isFunctionLike()) {
            tokenStream = new APTCommentsFilter(aPTMacro.getBody());
            if (this.isExpandingPPExpression()) {
                tokenStream = APTUtils.isEOF(tokenStream.nextToken()) ? new ListBasedTokenStream(APTUtils.DEF_MACRO_BODY) : new APTCommentsFilter(aPTMacro.getBody());
            }
        } else {
            APTToken aPTToken2;
            boolean bl;
            do {
                bl = false;
                while (APTUtils.isCommentToken(aPTToken2 = (APTToken)this.selector.nextToken())) {
                }
            } while (bl = APTUtils.isEOF(aPTToken2) && this.continueOnEOF());
            if (aPTToken2.getType() == 138) {
                List<List<APTToken>> list = this.extractParams(aPTMacro, aPTToken, aPTToken2);
                List<APTToken> list2 = APTExpandedStream.subsituteParams(aPTMacro, list, this.callback, this.isExpandingPPExpression());
                tokenStream = new ListBasedTokenStream(list2);
            } else {
                ArrayList<APTToken> arrayList = new ArrayList<APTToken>(2);
                arrayList.add(aPTToken);
                arrayList.add(aPTToken2);
                tokenStream = new ListBasedTokenStream(arrayList);
            }
        }
        APTUtils.LOG.log(Level.INFO, "token {0} \n was expanded by macro substitution to \n {1}", new Object[]{aPTToken, tokenStream});
        return tokenStream;
    }

    private boolean continueOnEOF() {
        boolean bl = false;
        if (!this.selector.isEmpty()) {
            bl = this.popMacroExpanding();
        }
        return bl;
    }

    protected final APTToken getLastExtractedParamRPAREN() {
        return this.paramsRParen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<APTToken>> extractParams(APTMacro aPTMacro, APTToken aPTToken, APTToken aPTToken2) throws TokenStreamException, RecognitionException {
        assert (!this.extractingMacroParams) : "already extracting params";
        this.extractingMacroParams = true;
        ArrayList<List<APTToken>> arrayList = new ArrayList<List<APTToken>>();
        try {
            if (aPTToken2.getType() != 138) {
                throw new RecognitionException("Error on expanding " + aPTToken + "\n by macro " + aPTMacro + "\n Expecting LPAREN, found " + aPTToken2);
            }
            int n = 0;
            ArrayList<APTToken> arrayList2 = new ArrayList<APTToken>();
            aPTToken2 = this.nextToken();
            while (!APTUtils.isEOF(aPTToken2) || this.continueOnEOF()) {
                int n2 = aPTToken2.getType();
                if (n2 == 138) {
                    this.add2Param(arrayList2, aPTToken2);
                    ++n;
                } else if (n2 == 139) {
                    if (n == 0) {
                        arrayList.add(arrayList2);
                        arrayList2 = null;
                        this.paramsRParen = aPTToken2;
                        break;
                    }
                    this.add2Param(arrayList2, aPTToken2);
                    if (--n < 0) {
                        throw new RecognitionException("Error on expanding " + aPTToken + "\n by macro " + aPTMacro + "\n Unbalanced RPAREN " + aPTToken2);
                    }
                } else if (n2 == 134 && n == 0) {
                    arrayList.add(arrayList2);
                    arrayList2 = new ArrayList();
                } else {
                    this.add2Param(arrayList2, aPTToken2);
                }
                aPTToken2 = this.nextToken();
            }
            if (APTUtils.isEOF(aPTToken2)) {
                APTUtils.LOG.log(Level.SEVERE, "error expanding macro " + aPTToken + " : unterminated arguments list");
            }
        }
        finally {
            this.extractingMacroParams = false;
        }
        return arrayList;
    }

    private void add2Param(List<APTToken> list, APTToken aPTToken) {
        if (!APTUtils.isCommentToken(aPTToken)) {
            list.add(aPTToken);
        }
    }

    private static List<APTToken> subsituteParams(APTMacro aPTMacro, List<List<APTToken>> list, APTMacroCallback aPTMacroCallback, boolean bl) throws TokenStreamException {
        Map<CharSequence, List<APTToken>> map = APTExpandedStream.createParamsMap(aPTMacro, list);
        LinkedList<APTToken> linkedList = new LinkedList<APTToken>();
        APTCommentsFilter aPTCommentsFilter = new APTCommentsFilter(aPTMacro.getBody());
        int n = 0;
        Object object = null;
        APTToken aPTToken = aPTCommentsFilter.nextToken();
        Object object2 = null;
        do {
            block0 : switch (n) {
                case 0: {
                    List<APTToken> list2;
                    Object object3;
                    object = aPTToken;
                    aPTToken = aPTCommentsFilter.nextToken();
                    switch (aPTToken.getType()) {
                        case 182: {
                            object2 = object;
                            n = 2;
                            object = null;
                            break block0;
                        }
                    }
                    switch (object.getType()) {
                        case 183: {
                            n = 1;
                            object = null;
                            break;
                        }
                        case 205: {
                            object3 = map.get(object.getTextID());
                            if (object3 == null) break;
                            list2 = APTExpandedStream.expandParamValue((List<APTToken>)object3, aPTMacroCallback, bl);
                            ArrayList<APTToken> arrayList = new ArrayList<APTToken>();
                            for (APTToken aPTToken2 : list2) {
                                arrayList.add(new APTMacroParamExpansion(aPTToken2, (APTToken)object));
                            }
                            list2 = arrayList;
                            if ((long)list2.size() > 16384L) {
                                if (DebugUtils.STANDALONE) {
                                    System.err.printf("parameter '%s' was empty substituted due to very long output value when expanding macros:\n %s\n", object.getText(), aPTMacro.getName());
                                } else {
                                    APTUtils.LOG.log(Level.WARNING, "parameter '{0}' was empty substituted due to very long output value when expanding macros:\n {1}\n", new Object[]{object.getText(), aPTMacro.getName()});
                                }
                                return Collections.emptyList();
                            }
                            object = null;
                            linkedList.addAll(list2);
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    object = null;
                    assert (aPTToken.getType() == 182);
                    assert (object2 != null);
                    Object object3 = new ArrayList<APTToken>();
                    object3.add(aPTCommentsFilter.nextToken());
                    aPTToken = aPTCommentsFilter.nextToken();
                    if (APTExpandedStream.isImplicitConcat((APTToken)object3.get(0), aPTToken)) {
                        object3.add(aPTToken);
                        aPTToken = aPTCommentsFilter.nextToken();
                    }
                    List<APTToken> list2 = APTExpandedStream.createConcatenation((APTToken)object2, (List<APTToken>)object3, map);
                    switch (aPTToken.getType()) {
                        case 182: {
                            int n2 = list2.size() - 1;
                            Object object4 = object2 = n2 < 0 ? APTUtils.EMPTY_ID_TOKEN : list2.remove(n2);
                            if (list2.size() > 0) {
                                linkedList.addAll(list2);
                            }
                            n = 2;
                            break block0;
                        }
                    }
                    object2 = null;
                    linkedList.addAll(list2);
                    n = 0;
                    break;
                }
                case 1: {
                    Object object3;
                    object = null;
                    if (aPTToken != null && aPTToken.getType() == 205) {
                        object3 = APTExpandedStream.stringizeParam(map.get(aPTToken.getTextID()));
                        aPTToken = aPTCommentsFilter.nextToken();
                        switch (aPTToken.getType()) {
                            case 182: {
                                object2 = object3;
                                n = 2;
                                break block0;
                            }
                        }
                        object = object3;
                        n = 0;
                        break;
                    }
                    n = 0;
                }
            }
            if (object == null) continue;
            if (APTUtils.isEOF((Token)object)) break;
            linkedList.add((APTToken)object);
            object = null;
        } while (object == null);
        return linkedList;
    }

    private static boolean isImplicitConcat(APTToken aPTToken, APTToken aPTToken2) {
        return APTUtils.isInt(aPTToken) && APTUtils.isID(aPTToken2) && APTUtils.areAdjacent(aPTToken, aPTToken2);
    }

    private static Map<CharSequence, List<APTToken>> createParamsMap(APTMacro aPTMacro, List<List<APTToken>> list) {
        HashMap<CharSequence, List<APTToken>> hashMap = new HashMap<CharSequence, List<APTToken>>();
        Collection<APTToken> collection = aPTMacro.getParams();
        int n = list.size();
        int n2 = 0;
        APTToken aPTToken = null;
        for (APTToken aPTToken2 : collection) {
            hashMap.put(aPTToken2.getTextID(), n2 < n ? list.get(n2) : Collections.emptyList());
            ++n2;
            aPTToken = aPTToken2;
        }
        if (n2 < n && APTUtils.isVaArgsToken(aPTToken)) {
            List list2 = (List)hashMap.get(aPTToken.getTextID());
            while (n2 < n) {
                list2.add(APTUtils.COMMA_TOKEN);
                list2.addAll((Collection)list.get(n2));
                ++n2;
            }
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    private static List<APTToken> createConcatenation(APTToken aPTToken, List<APTToken> list, Map<CharSequence, List<APTToken>> map) {
        void var7_10;
        List<APTToken> list2 = map.get(aPTToken.getTextID());
        String string = list2 != null ? APTExpandedStream.toText(list2, false) : aPTToken.getText();
        StringBuilder stringBuilder = new StringBuilder();
        for (APTToken object2 : list) {
            if (APTUtils.isEOF(object2)) {
                if (DebugUtils.STANDALONE) {
                    System.err.printf("no token after ##", new Object[0]);
                    continue;
                }
                APTUtils.LOG.log(Level.SEVERE, "no token after ##");
                continue;
            }
            stringBuilder.append(object2.getTextID());
        }
        List<APTToken> list3 = map.get(CharSequenceKey.create((CharSequence)stringBuilder));
        if (list3 != null) {
            String string2 = APTExpandedStream.toText(list3, false);
        } else {
            String string3 = stringBuilder.toString();
        }
        if (aPTToken.getType() == 134 && var7_10.length() == 0 && APTUtils.isVaArgsToken(list.get(0))) {
            return new ArrayList<APTToken>();
        }
        String string4 = string + (String)var7_10;
        TokenStream tokenStream = APTTokenStreamBuilder.buildTokenStream(string4);
        List<APTToken> list4 = APTUtils.toList(tokenStream);
        return list4;
    }

    private static APTToken stringizeParam(List<APTToken> list) {
        assert (list != null);
        APTToken aPTToken = APTUtils.createAPTToken();
        aPTToken.setType(193);
        aPTToken.setText(APTExpandedStream.toText(list, true));
        return aPTToken;
    }

    private static String toText(List<APTToken> list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append('\"');
        }
        for (int i = 0; i < list.size(); ++i) {
            APTToken aPTToken = list.get(i);
            if (bl) {
                stringBuilder.append(APTExpandedStream.escape(aPTToken.getTextID()));
                continue;
            }
            stringBuilder.append(aPTToken.getTextID());
            if (i + 1 >= list.size() || APTUtils.areAdjacent(aPTToken, list.get(i + 1))) continue;
            stringBuilder.append(' ');
        }
        if (bl) {
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }

    private static CharSequence escape(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == '\"' || c == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder;
    }

    private static List<APTToken> expandParamValue(List<APTToken> list, APTMacroCallback aPTMacroCallback, boolean bl) {
        ListBasedTokenStream listBasedTokenStream = new ListBasedTokenStream(list);
        APTExpandedStream aPTExpandedStream = new APTExpandedStream(listBasedTokenStream, aPTMacroCallback, bl);
        List<APTToken> list2 = APTUtils.toList(aPTExpandedStream);
        return list2;
    }
}

