/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.InternalResourceView;
import org.springframework.web.servlet.view.JstlView;
import org.springframework.web.servlet.view.UrlBasedViewResolver;

public class InternalResourceViewResolver
extends UrlBasedViewResolver {
    private static final boolean jstlPresent = ClassUtils.isPresent((String)"javax.servlet.jsp.jstl.fmt.LocalizationContext");
    private Boolean alwaysInclude;
    private Boolean exposeContextBeansAsAttributes;

    public InternalResourceViewResolver() {
        Class viewClass = this.requiredViewClass();
        if (viewClass.equals(InternalResourceView.class) && jstlPresent) {
            viewClass = JstlView.class;
        }
        this.setViewClass(viewClass);
    }

    protected Class requiredViewClass() {
        return InternalResourceView.class;
    }

    public void setAlwaysInclude(boolean alwaysInclude) {
        this.alwaysInclude = alwaysInclude;
    }

    public void setExposeContextBeansAsAttributes(boolean exposeContextBeansAsAttributes) {
        this.exposeContextBeansAsAttributes = exposeContextBeansAsAttributes;
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        InternalResourceView view = (InternalResourceView)super.buildView(viewName);
        if (this.alwaysInclude != null) {
            view.setAlwaysInclude(this.alwaysInclude);
        }
        if (this.exposeContextBeansAsAttributes != null) {
            view.setExposeContextBeansAsAttributes(this.exposeContextBeansAsAttributes);
        }
        return view;
    }
}

