/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.spi.jaxws.client;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.websvc.api.jaxws.project.CatalogUtils;
import org.netbeans.modules.websvc.api.jaxws.project.JAXWSVersionProvider;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.ClientAlreadyExistsExeption;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOption;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.spi.jaxws.client.JAXWSClientSupportImpl;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class ProjectJAXWSClientSupport
implements JAXWSClientSupportImpl {
    private static final String[] DEFAULT_WSIMPORT_OPTIONS = new String[]{"extension", "verbose"};
    private static final String XNOCOMPILE_OPTION = "xnocompile";
    private static final String WSDL_LOCATION = "wsdlLocation";
    Project project;
    private FileObject clientArtifactsFolder;

    public ProjectJAXWSClientSupport(Project project) {
        this.project = project;
    }

    public void removeServiceClient(String string) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && jaxWsModel.removeClient(string)) {
            this.writeJaxWsModel(jaxWsModel);
        }
    }

    public String getWsdlUrl(String string) {
        Client client;
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && (client = jaxWsModel.findClientByName(string)) != null) {
            return client.getWsdlUrl();
        }
        return null;
    }

    public String addServiceClient(String string, String string2, String string3, boolean bl) {
        FileObject fileObject = WSUtils.findJaxWsFileObject((Project)this.project);
        if (fileObject == null) {
            try {
                WSUtils.createJaxWsFileObject((Project)this.project);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        final JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        String string4 = string;
        boolean bl2 = false;
        if (jaxWsModel != null) {
            NotifyDescriptor.Message message;
            String string5;
            if (!bl) {
                try {
                    this.addJaxWs20Library();
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
            Client client = null;
            string4 = this.findProperClientName(string, jaxWsModel);
            FileObject fileObject2 = this.getLocalWsdlFolderForClient(string4, true);
            FileObject fileObject3 = null;
            try {
                fileObject3 = WSUtils.retrieveResource((FileObject)fileObject2, (URI)new URI(string2));
            }
            catch (URISyntaxException uRISyntaxException) {
                ErrorManager.getDefault().notify(1, (Throwable)uRISyntaxException);
                string5 = NbBundle.getMessage(ProjectJAXWSClientSupport.class, (String)"ERR_IncorrectURI", (Object)string2);
                message = new NotifyDescriptor.Message((Object)string5, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            catch (UnknownHostException unknownHostException) {
                ErrorManager.getDefault().notify(1, (Throwable)unknownHostException);
                string5 = NbBundle.getMessage(ProjectJAXWSClientSupport.class, (String)"ERR_UnknownHost", (Object)unknownHostException.getMessage());
                message = new NotifyDescriptor.Message((Object)string5, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                string5 = NbBundle.getMessage(ProjectJAXWSClientSupport.class, (String)"ERR_WsdlRetrieverFailure", (Object)string2);
                message = new NotifyDescriptor.Message((Object)string5, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            if (fileObject3 != null) {
                FileObject fileObject4;
                Boolean bl3 = jaxWsModel.getJsr109();
                if ((bl3 == null || Boolean.TRUE.equals(bl3)) && !bl) {
                    jaxWsModel.setJsr109(Boolean.FALSE);
                } else if (Boolean.FALSE.equals(bl3) && bl) {
                    jaxWsModel.setJsr109(Boolean.TRUE);
                }
                try {
                    string5 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject3);
                    client = jaxWsModel.addClient(string4, string2, string3);
                    client.setLocalWsdlFile(string5);
                    if (string3 == null) {
                        client.setPackageName(WSUtils.getPackageNameForWsdl((File)FileUtil.toFile((FileObject)fileObject3)));
                    }
                }
                catch (ClientAlreadyExistsExeption clientAlreadyExistsExeption) {
                    // empty catch block
                }
                string5 = this.getCatalogFileObject();
                if (string5 != null) {
                    client.setCatalogFile("catalog.xml");
                }
                message = client.getWsImportOptions();
                WsimportOption wsimportOption = null;
                if (message != null) {
                    for (String string6 : DEFAULT_WSIMPORT_OPTIONS) {
                        wsimportOption = message.newWsimportOption();
                        wsimportOption.setWsimportOptionName(string6);
                        wsimportOption.setWsimportOptionValue("true");
                        message.addWsimportOption(wsimportOption);
                    }
                    wsimportOption = message.newWsimportOption();
                    wsimportOption.setWsimportOptionName(WSDL_LOCATION);
                    wsimportOption.setWsimportOptionValue(string2);
                    message.addWsimportOption(wsimportOption);
                    if (ProjectJAXWSClientSupport.isXnocompile(this.project)) {
                        wsimportOption = message.newWsimportOption();
                        wsimportOption.setWsimportOptionName(XNOCOMPILE_OPTION);
                        wsimportOption.setWsimportOptionValue("true");
                        message.addWsimportOption(wsimportOption);
                    }
                }
                this.writeJaxWsModel(jaxWsModel);
                bl2 = true;
                if (string5 != null) {
                    try {
                        fileObject4 = this.getWsdlFolder(true);
                        if (fileObject4 != null) {
                            FileObject fileObject5 = fileObject4.getParent().getFileObject("jax-ws-catalog.xml");
                            if (fileObject5 == null) {
                                fileObject5 = FileUtil.copyFile((FileObject)string5, (FileObject)fileObject4.getParent(), (String)"jax-ws-catalog");
                                CatalogUtils.updateCatalogEntriesForClient((FileObject)fileObject5, (String)string);
                            } else {
                                CatalogUtils.copyCatalogEntriesForClient((FileObject)string5, (FileObject)fileObject5, (String)string);
                            }
                            WSUtils.copyFiles((FileObject)fileObject2, (FileObject)fileObject4);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                fileObject4 = string4;
                try {
                    final WsdlModeler wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(fileObject3.getURL());
                    if (wsdlModeler != null) {
                        wsdlModeler.setPackageName(string3);
                        wsdlModeler.setCatalog(string5.getURL());
                        wsdlModeler.generateWsdlModel(new WsdlModelListener((String)fileObject4){
                            final /* synthetic */ String val$clientName2;
                            {
                                this.val$clientName2 = string;
                            }

                            public void modelCreated(WsdlModel wsdlModel) {
                                if (wsdlModel == null) {
                                    RequestProcessor.getDefault().post(new Runnable(){

                                        public void run() {
                                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new WsImportFailedMessage(wsdlModeler.getCreationException()));
                                        }
                                    });
                                } else {
                                    Client client = jaxWsModel.findClientByName(this.val$clientName2);
                                    String string = client.getPackageName();
                                    if (string == null && wsdlModel.getServices().size() > 0) {
                                        WsdlService wsdlService = (WsdlService)wsdlModel.getServices().get(0);
                                        String string2 = wsdlService.getJavaName();
                                        int n = string2.lastIndexOf(".");
                                        string = n != -1 ? string2.substring(0, n) : string2;
                                        client.setPackageName(string);
                                        ProjectJAXWSClientSupport.this.writeJaxWsModel(jaxWsModel);
                                    }
                                    ProjectJAXWSClientSupport.this.runWsimport(this.val$clientName2);
                                }
                            }
                        });
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().log(iOException.getLocalizedMessage());
                }
            }
            return string4;
        }
        return null;
    }

    private void runWsimport(String string) {
        final FileObject fileObject = this.project.getProjectDirectory().getFileObject("build.xml");
        final String string2 = string;
        if (SwingUtilities.isEventDispatchThread()) {
            this.openOutputWindow();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProjectJAXWSClientSupport.this.openOutputWindow();
                }
            });
        }
        try {
            ((Boolean)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    ExecutorTask executorTask = ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{"wsimport-client-" + string2}, null);
                    return Boolean.TRUE;
                }
            })).booleanValue();
        }
        catch (MutexException mutexException) {
            ErrorManager.getDefault().notify((Throwable)mutexException);
        }
    }

    private void openOutputWindow() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent("output");
        if (topComponent != null) {
            topComponent.open();
        }
    }

    private String findProperClientName(String string, JaxWsModel jaxWsModel) {
        String string2;
        String string3 = string2 = string.length() == 0 ? NbBundle.getMessage(ProjectJAXWSClientSupport.class, (String)"LBL_defaultClientName") : string;
        if (jaxWsModel.findClientByName(string2) == null) {
            return string2;
        }
        int n = 1;
        String string4;
        while (jaxWsModel.findClientByName(string4 = string2 + "_" + n) != null) {
            ++n;
        }
        return string4;
    }

    private void writeJaxWsModel(JaxWsModel jaxWsModel) {
        try {
            jaxWsModel.write();
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "failed to save jax-ws.xml", iOException);
        }
    }

    public List getServiceClients() {
        ArrayList<Client> arrayList = new ArrayList<Client>();
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            Client[] clientArray = jaxWsModel.getClients();
            for (int i = 0; i < clientArray.length; ++i) {
                arrayList.add(clientArray[i]);
            }
        }
        return arrayList;
    }

    public FileObject getLocalWsdlFolderForClient(String string, boolean bl) {
        return this.getArtifactsFolder(string, bl, true);
    }

    public FileObject getBindingsFolderForClient(String string, boolean bl) {
        return this.getArtifactsFolder(string, bl, false);
    }

    private FileObject getArtifactsFolder(String string, boolean bl, boolean bl2) {
        String string2 = bl2 ? "wsdl" : "bindings";
        FileObject fileObject = this.getXmlArtifactsRoot();
        assert (fileObject != null);
        FileObject fileObject2 = fileObject.getFileObject("xml-resources/web-service-references/" + string + "/" + string2);
        if (fileObject2 == null && bl) {
            try {
                FileObject fileObject3;
                FileObject fileObject4;
                FileObject fileObject5 = fileObject.getFileObject("xml-resources");
                if (fileObject5 == null) {
                    fileObject5 = fileObject.createFolder("xml-resources");
                }
                if ((fileObject4 = fileObject5.getFileObject("web-service-references")) == null) {
                    fileObject4 = fileObject5.createFolder("web-service-references");
                }
                if ((fileObject3 = fileObject4.getFileObject(string)) == null) {
                    fileObject3 = fileObject4.createFolder(string);
                }
                if ((fileObject2 = fileObject3.getFileObject(string2)) == null) {
                    fileObject2 = fileObject3.createFolder(string2);
                }
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return fileObject2;
    }

    protected FileObject getXmlArtifactsRoot() {
        return this.project.getProjectDirectory();
    }

    private FileObject getCatalogFileObject() {
        return this.project.getProjectDirectory().getFileObject("catalog.xml");
    }

    public URL getCatalog() {
        try {
            FileObject fileObject = this.getCatalogFileObject();
            return fileObject == null ? null : fileObject.getURL();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return null;
        }
    }

    protected abstract void addJaxWs20Library() throws Exception;

    public abstract FileObject getWsdlFolder(boolean var1) throws IOException;

    public String getServiceRefName(Node node) {
        WsdlService wsdlService = (WsdlService)node.getLookup().lookup(WsdlService.class);
        String string = wsdlService.getName();
        return "service/" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject getWsdlFolderForClient(String string) throws IOException {
        FileLock fileLock;
        FileObject fileObject = this.getWsdlFolder(true);
        FileObject fileObject2 = fileObject.getFileObject("client/" + string);
        if (fileObject2 != null) {
            fileLock = fileObject2.lock();
            try {
                fileObject2.delete(fileLock);
            }
            finally {
                fileLock.releaseLock();
            }
        }
        if ((fileLock = fileObject.getFileObject("client")) == null) {
            fileLock = fileObject.createFolder("client");
        }
        return fileLock.createFolder(string);
    }

    private static boolean isXnocompile(Project project) {
        String string;
        JAXWSVersionProvider jAXWSVersionProvider = (JAXWSVersionProvider)project.getLookup().lookup(JAXWSVersionProvider.class);
        if (jAXWSVersionProvider != null && (string = jAXWSVersionProvider.getJAXWSVersion()) != null) {
            return ProjectJAXWSClientSupport.isVersionSatisfied(string, "2.1.3");
        }
        return true;
    }

    private static boolean isVersionSatisfied(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        for (int i = 0; i < Math.min(n, n2); ++i) {
            if (string.charAt(i) < string2.charAt(i)) {
                return false;
            }
            if (string.charAt(i) <= string2.charAt(i)) continue;
            return true;
        }
        if (n > n2) {
            return true;
        }
        return n >= n2;
    }

    private class WsImportFailedMessage
    extends NotifyDescriptor.Message {
        public WsImportFailedMessage(Throwable throwable) {
            super((Object)NbBundle.getMessage(ProjectJAXWSClientSupport.class, (String)"TXT_CannotGenerateClient", (Object)throwable.getLocalizedMessage()), 0);
        }
    }
}

