/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.xml.api.XmlFileEncodingQueryImpl;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.netbeans.modules.xml.multiview.EncodingHelper;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.io.ReaderInputStream;
import org.openide.windows.CloneableTopComponent;
import org.xml.sax.SAXException;

public abstract class XmlMultiViewDataObject
extends MultiDataObject
implements CookieSet.Factory {
    public static final String PROP_DOCUMENT_VALID = "document_valid";
    public static final String PROP_SAX_ERROR = "sax_error";
    public static final String PROPERTY_DATA_MODIFIED = "data modified";
    public static final String PROPERTY_DATA_UPDATED = "data changed";
    protected XmlMultiViewEditorSupport editorSupport;
    private SAXException saxError;
    private final DataCache dataCache = new DataCache();
    private EncodingHelper encodingHelper = new EncodingHelper();
    private transient long timeStamp = 0L;
    private transient WeakReference lockReference;
    private MultiViewElement activeMVElement;
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            XmlMultiViewDataObject.this.getEditorSupport().saveDocument();
        }
    };

    public XmlMultiViewDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.getCookieSet().add(XmlMultiViewEditorSupport.class, (CookieSet.Factory)this);
        this.getCookieSet().assign(FileEncodingQueryImplementation.class, new Object[]{XmlFileEncodingQueryImpl.singleton()});
    }

    protected EditorCookie createEditorCookie() {
        return this.getEditorSupport();
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(XmlMultiViewEditorSupport.class)) {
            return this.getEditorSupport();
        }
        return null;
    }

    protected synchronized XmlMultiViewEditorSupport getEditorSupport() {
        if (this.editorSupport == null) {
            this.editorSupport = new XmlMultiViewEditorSupport(this);
            this.editorSupport.getMultiViewDescriptions();
        }
        return this.editorSupport;
    }

    public void goToXmlView() {
        this.getEditorSupport().goToXmlPerspective();
    }

    protected void setSaxError(SAXException sAXException) {
        SAXException sAXException2 = this.saxError;
        this.saxError = sAXException;
        if (sAXException2 == null) {
            if (sAXException != null) {
                this.firePropertyChange(PROP_DOCUMENT_VALID, Boolean.TRUE, Boolean.FALSE);
            }
        } else if (sAXException == null) {
            this.firePropertyChange(PROP_DOCUMENT_VALID, Boolean.FALSE, Boolean.TRUE);
        }
        String string = XmlMultiViewDataObject.getErrorMessage(sAXException2);
        String string2 = XmlMultiViewDataObject.getErrorMessage(sAXException);
        if (string == null) {
            if (string2 != null) {
                this.firePropertyChange(PROP_SAX_ERROR, null, string2);
            }
        } else if (!string.equals(string2)) {
            this.firePropertyChange(PROP_SAX_ERROR, string, string2);
        }
    }

    private static String getErrorMessage(Exception exception) {
        return exception == null ? null : exception.getMessage();
    }

    public SAXException getSaxError() {
        return this.saxError;
    }

    protected Image getXmlViewIcon() {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/xml/multiview/resources/xmlObject.gif");
    }

    protected abstract DesignMultiViewDesc[] getMultiViewDesc();

    public void setLastOpenView(int n) {
        this.getEditorSupport().setLastOpenView(n);
    }

    protected FileObject handleRename(String string) throws IOException {
        FileObject fileObject = super.handleRename(string);
        this.getEditorSupport().updateDisplayName();
        return fileObject;
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        if (bl) {
            if (this.getCookie(SaveCookie.class) == null) {
                this.getCookieSet().add((Node.Cookie)this.saveCookie);
            }
        } else if (this.saveCookie.equals(this.getCookie(SaveCookie.class))) {
            this.getCookieSet().remove((Node.Cookie)this.saveCookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canClose() {
        Enumeration enumeration;
        CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)this.getEditorSupport().getMVTC();
        if (cloneableTopComponent != null && (enumeration = cloneableTopComponent.getReference().getComponents()).hasMoreElements()) {
            enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                return true;
            }
        }
        try {
            enumeration = this.waitForLock();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return !this.isModified();
        }
        try {
            boolean bl = !this.isModified();
            return bl;
        }
        finally {
            enumeration.releaseLock();
        }
    }

    public FileLock waitForLock() throws IOException {
        return this.waitForLock(10000L);
    }

    public FileLock waitForLock(long l) throws IOException {
        long l2 = System.currentTimeMillis() + l;
        long l3 = 50L;
        while (true) {
            try {
                return this.dataCache.lock();
            }
            catch (IOException iOException) {
                if (System.currentTimeMillis() > l2) {
                    throw (IOException)new IOException("Cannot wait for data lock for more than " + l + " ms").initCause(iOException);
                }
                try {
                    Thread.sleep(l3);
                    l3 = 3L * l3 / 2L;
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public MultiViewPerspective getSelectedPerspective() {
        return this.getEditorSupport().getSelectedPerspective();
    }

    public void showElement(Object object) {
        this.getEditorSupport().edit();
    }

    protected MultiViewElement getActiveMultiViewElement() {
        return this.activeMVElement;
    }

    void setActiveMultiViewElement(MultiViewElement multiViewElement) {
        this.activeMVElement = multiViewElement;
    }

    public void openView(int n) {
        this.getEditorSupport().openView(n);
    }

    protected abstract String getPrefixMark();

    boolean acceptEncoding() throws IOException {
        this.encodingHelper.resetEncoding();
        DataCache dataCache = this.getDataCache();
        String string = dataCache.getStringData();
        String string2 = this.encodingHelper.detectEncoding(string.getBytes());
        if (!this.encodingHelper.getEncoding().equals(string2)) {
            Object object = this.showChangeEncodingDialog(string2);
            if (NotifyDescriptor.YES_OPTION.equals(object)) {
                dataCache.setData(this.encodingHelper.setDefaultEncoding(string));
            } else if (NotifyDescriptor.NO_OPTION.equals(object)) {
                this.showUsingDifferentEncodingMessage(string2);
            } else {
                return false;
            }
        }
        return true;
    }

    private void showUsingDifferentEncodingMessage(String string) {
        String string2 = NbBundle.getMessage((Class)XmlMultiViewDataObject.class, (String)"TEXT_TREAT_USING_DIFFERENT_ENCODING", (Object)string, (Object)this.encodingHelper.getEncoding());
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2);
        message.setTitle(this.getPrimaryFile().getPath());
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    private Object showChangeEncodingDialog(String string) {
        String string2 = NbBundle.getMessage((Class)Utils.class, (String)"TEXT_CHANGE_DECLARED_ENCODING", (Object)string, (Object)this.encodingHelper.getEncoding());
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, this.getPrimaryFile().getPath(), 1);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
    }

    public EncodingHelper getEncodingHelper() {
        return this.encodingHelper;
    }

    public DataCache getDataCache() {
        return this.dataCache;
    }

    protected boolean verifyDocumentBeforeClose() {
        return true;
    }

    public class DataCache {
        private transient String buffer = null;
        private long fileTime = 0L;

        public void loadData() {
            block3: {
                FileObject fileObject = XmlMultiViewDataObject.this.getPrimaryFile();
                if (this.fileTime == fileObject.lastModified().getTime()) {
                    return;
                }
                try {
                    FileLock fileLock = this.lock();
                    this.loadData(fileObject, fileLock);
                }
                catch (IOException iOException) {
                    if (this.buffer != null) break block3;
                    this.buffer = "";
                }
            }
        }

        public void reloadData() throws IOException {
            FileObject fileObject = XmlMultiViewDataObject.this.getPrimaryFile();
            if (this.fileTime == fileObject.lastModified().getTime()) {
                return;
            }
            FileLock fileLock = this.getLock();
            if (fileLock == null) {
                fileLock = this.lock();
            }
            this.loadData(fileObject, fileLock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadData(FileObject fileObject, FileLock fileLock) throws IOException {
            try {
                long l;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileObject.getInputStream());
                String string = XmlMultiViewDataObject.this.encodingHelper.detectEncoding(bufferedInputStream);
                if (!XmlMultiViewDataObject.this.encodingHelper.getEncoding().equals(string)) {
                    XmlMultiViewDataObject.this.showUsingDifferentEncodingMessage(string);
                }
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, XmlMultiViewDataObject.this.encodingHelper.getEncoding());
                StringBuffer stringBuffer = new StringBuffer(2048);
                try {
                    int n;
                    char[] cArray = new char[1024];
                    l = fileObject.lastModified().getTime();
                    while ((n = ((Reader)inputStreamReader).read(cArray, 0, 1024)) != -1) {
                        stringBuffer.append(cArray, 0, n);
                    }
                }
                finally {
                    ((Reader)inputStreamReader).close();
                }
                this.buffer = null;
                this.fileTime = l;
                this.setData(fileLock, stringBuffer.toString(), true);
            }
            finally {
                fileLock.releaseLock();
            }
        }

        public void setData(FileLock fileLock, String string, boolean bl) throws IOException {
            this.testLock(fileLock);
            boolean bl2 = XmlMultiViewDataObject.this.isModified() || bl;
            long l = XmlMultiViewDataObject.this.timeStamp;
            if (this.setData(string)) {
                if (!bl2) {
                    this.saveData(fileLock);
                    XmlMultiViewDataObject.this.firePropertyChange(XmlMultiViewDataObject.PROPERTY_DATA_UPDATED, new Long(l), new Long(XmlMultiViewDataObject.this.timeStamp));
                } else {
                    XmlMultiViewDataObject.this.firePropertyChange(XmlMultiViewDataObject.PROPERTY_DATA_MODIFIED, new Long(l), new Long(XmlMultiViewDataObject.this.timeStamp));
                }
            }
        }

        private boolean setData(String string) {
            if (string.equals(this.buffer)) {
                return false;
            }
            this.buffer = string;
            long l = new Date().getTime();
            if (l <= XmlMultiViewDataObject.this.timeStamp) {
                l = XmlMultiViewDataObject.this.timeStamp + 1L;
            }
            XmlMultiViewDataObject.this.timeStamp = l;
            this.fileTime = 0L;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void saveData(FileLock fileLock) {
            block11: {
                if (this.buffer == null || this.fileTime == XmlMultiViewDataObject.this.getPrimaryFile().lastModified().getTime()) {
                    return;
                }
                try {
                    XmlMultiViewEditorSupport xmlMultiViewEditorSupport = XmlMultiViewDataObject.this.getEditorSupport();
                    if (xmlMultiViewEditorSupport.getDocument() == null) {
                        XmlMultiViewEditorSupport.XmlEnv xmlEnv = xmlMultiViewEditorSupport.getXmlEnv();
                        FileLock fileLock2 = null;
                        try {
                            fileLock2 = xmlEnv.takeLock();
                            OutputStream outputStream = XmlMultiViewDataObject.this.getPrimaryFile().getOutputStream(fileLock2);
                            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, XmlMultiViewDataObject.this.encodingHelper.getEncoding());
                            try {
                                outputStreamWriter.write(this.buffer);
                                break block11;
                            }
                            finally {
                                ((Writer)outputStreamWriter).close();
                                xmlEnv.unmarkModified();
                                this.resetFileTime();
                            }
                        }
                        finally {
                            if (fileLock2 != null) {
                                fileLock2.releaseLock();
                            }
                        }
                    }
                    xmlMultiViewEditorSupport.saveDocument(fileLock);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }

        public FileLock lock() throws IOException {
            FileLock fileLock = this.getLock();
            if (fileLock != null) {
                throw new FileAlreadyLockedException("File is already locked by [" + fileLock + "].");
            }
            FileLock fileLock2 = new FileLock();
            XmlMultiViewDataObject.this.lockReference = new WeakReference<FileLock>(fileLock2);
            return fileLock2;
        }

        private FileLock getLock() {
            FileLock fileLock;
            FileLock fileLock2 = fileLock = XmlMultiViewDataObject.this.lockReference == null ? null : (FileLock)XmlMultiViewDataObject.this.lockReference.get();
            if (fileLock != null && !fileLock.isValid()) {
                fileLock = null;
            }
            return fileLock;
        }

        public String getStringData() {
            if (this.buffer == null) {
                this.loadData();
            }
            return this.buffer;
        }

        public byte[] getData() {
            try {
                return this.getStringData().getBytes(XmlMultiViewDataObject.this.encodingHelper.getEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ErrorManager.getDefault().notify((Throwable)unsupportedEncodingException);
                return null;
            }
        }

        public void setData(FileLock fileLock, byte[] byArray, boolean bl) throws IOException {
            XmlMultiViewDataObject.this.encodingHelper.detectEncoding(byArray);
            this.setData(fileLock, new String(byArray, XmlMultiViewDataObject.this.encodingHelper.getEncoding()), bl);
        }

        public long getTimeStamp() {
            return XmlMultiViewDataObject.this.timeStamp;
        }

        public InputStream createInputStream() {
            try {
                XmlMultiViewDataObject.this.encodingHelper.detectEncoding(this.getStringData().getBytes());
                return new ReaderInputStream((Reader)new StringReader(this.getStringData()), XmlMultiViewDataObject.this.encodingHelper.getEncoding());
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return null;
            }
        }

        public Reader createReader() throws IOException {
            return new StringReader(this.getStringData());
        }

        public OutputStream createOutputStream() throws IOException {
            final FileLock fileLock = this.lock();
            return new ByteArrayOutputStream(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    try {
                        super.close();
                        DataCache.this.setData(fileLock, this.toByteArray(), true);
                    }
                    finally {
                        fileLock.releaseLock();
                    }
                }
            };
        }

        public OutputStream createOutputStream(final FileLock fileLock, final boolean bl) throws IOException {
            this.testLock(fileLock);
            return new ByteArrayOutputStream(){

                public void close() throws IOException {
                    super.close();
                    DataCache.this.setData(fileLock, this.toByteArray(), bl);
                    if (!bl) {
                        XmlMultiViewDataObject.this.dataCache.saveData(fileLock);
                    }
                }
            };
        }

        public Writer createWriter() throws IOException {
            final FileLock fileLock = this.lock();
            return new StringWriter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    try {
                        super.close();
                        DataCache.this.setData(fileLock, this.toString(), true);
                    }
                    finally {
                        fileLock.releaseLock();
                    }
                }
            };
        }

        public Writer createWriter(final FileLock fileLock, final boolean bl) throws IOException {
            this.testLock(fileLock);
            return new StringWriter(){

                public void close() throws IOException {
                    super.close();
                    DataCache.this.setData(fileLock, this.toString(), bl);
                    if (!bl) {
                        XmlMultiViewDataObject.this.dataCache.saveData(fileLock);
                    }
                }
            };
        }

        public void testLock(FileLock fileLock) throws IOException {
            if (fileLock == null) {
                throw new IOException("Lock is null.");
            }
            if (fileLock != this.getLock()) {
                throw new IOException("Invalid lock [" + fileLock + "]. Expected [" + this.getLock() + "].");
            }
        }

        public void resetFileTime() {
            this.fileTime = XmlMultiViewDataObject.this.getPrimaryFile().lastModified().getTime();
        }
    }
}

