/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.XmlMultiViewElement;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class XmlMultiViewEditorSupport
extends DataEditorSupport
implements Serializable,
EditCookie,
OpenCookie,
EditorCookie.Observable,
PrintCookie {
    private XmlMultiViewDataObject dObj;
    private DocumentListener docListener;
    private int xmlMultiViewIndex;
    private TopComponent mvtc;
    private int lastOpenView = 0;
    private TopComponentsListener topComponentsListener;
    private MultiViewDescription[] multiViewDescriptions;
    private DocumentSynchronizer documentSynchronizer;
    private int loading = 0;
    private FileLock saveLock;
    private static final String PROPERTY_MODIFICATION_LISTENER = "modificationListener";
    private boolean suppressXmlView = false;
    static /* synthetic */ Class class$org$openide$text$CloneableEditorSupport;

    public XmlMultiViewEditorSupport() {
        super(null, null);
    }

    public XmlMultiViewEditorSupport(XmlMultiViewDataObject xmlMultiViewDataObject) {
        super((DataObject)xmlMultiViewDataObject, (CloneableEditorSupport.Env)new XmlEnv(xmlMultiViewDataObject));
        this.dObj = xmlMultiViewDataObject;
        this.documentSynchronizer = new DocumentSynchronizer(xmlMultiViewDataObject);
        this.setMIMEType("text/xml");
        this.docListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.doUpdate();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.doUpdate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.doUpdate();
            }

            private void doUpdate() {
                if (XmlMultiViewEditorSupport.this.saveLock == null) {
                    XmlMultiViewEditorSupport.this.documentSynchronizer.requestUpdateData();
                }
            }
        };
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                StyledDocument styledDocument;
                if ("document".equals(propertyChangeEvent.getPropertyName()) && (styledDocument = XmlMultiViewEditorSupport.this.getDocument()) != null) {
                    styledDocument.addDocumentListener(XmlMultiViewEditorSupport.this.docListener);
                }
            }
        });
    }

    UndoRedo getUndoRedo0() {
        return super.getUndoRedo();
    }

    public XmlEnv getXmlEnv() {
        return (XmlEnv)this.env;
    }

    protected CloneableEditor createCloneableEditor() {
        return super.createCloneableEditor();
    }

    public InputStream getInputStream() throws IOException {
        return super.getInputStream();
    }

    protected Task reloadDocument() {
        FileLock fileLock;
        ++this.loading;
        this.documentSynchronizer.reloadingStarted();
        try {
            fileLock = this.dObj.waitForLock();
            this.dObj.getDataCache().loadData(this.dObj.getPrimaryFile(), fileLock);
        }
        catch (IOException iOException) {
            fileLock = null;
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        final Task task = XmlMultiViewEditorSupport.super.reloadDocument();
        final FileLock fileLock2 = fileLock;
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (!task.isFinished()) {
                        task.waitFinished(5000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    ErrorManager.getDefault().annotate((Throwable)interruptedException, NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$multiview$XmlMultiViewEditorSupport == null ? (class$org$netbeans$modules$xml$multiview$XmlMultiViewEditorSupport = XmlMultiViewEditorSupport.class$("org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport")) : class$org$netbeans$modules$xml$multiview$XmlMultiViewEditorSupport), (String)"CANNOT_UPDATE_LOCKED_DATA_OBJECT"));
                }
                finally {
                    if (fileLock2 != null) {
                        fileLock2.releaseLock();
                    }
                    XmlMultiViewEditorSupport.this.documentSynchronizer.reloadingFinished();
                    XmlMultiViewEditorSupport.this.loading--;
                }
            }
        });
        return task;
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        editorKit.read(new InputStreamReader(inputStream, this.dObj.getEncodingHelper().getEncoding()), (Document)styledDocument, 0);
    }

    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        editorKit.write(new OutputStreamWriter(outputStream, this.dObj.getEncodingHelper().getEncoding()), (Document)styledDocument, 0, styledDocument.getLength());
    }

    public StyledDocument openDocument() throws IOException {
        this.dObj.getDataCache().getStringData();
        return super.openDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocument() throws IOException {
        if (this.loading > 0) {
            return;
        }
        FileLock fileLock = ((XmlMultiViewDataObject)this.getDataObject()).waitForLock();
        try {
            ((XmlMultiViewDataObject)this.getDataObject()).getDataCache().saveData(fileLock);
        }
        finally {
            fileLock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveDocument(FileLock fileLock) throws IOException {
        if (this.saveLock != fileLock) {
            this.saveLock = fileLock;
            this.documentSynchronizer.reloadModel();
            try {
                this.doSaveDocument();
                this.dObj.getDataCache().resetFileTime();
            }
            finally {
                this.saveLock = null;
            }
        }
    }

    private void doSaveDocument() throws IOException {
        final StyledDocument styledDocument = this.getDocument();
        String string = EncodingUtil.detectEncoding((Document)styledDocument);
        if (string == null) {
            string = "UTF8";
        }
        try {
            new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(1), string);
            if (!this.checkCharsetConversion(string)) {
                return;
            }
            super.saveDocument();
            this.getDataObject().setModified(false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = NbBundle.getMessage((Class)XmlMultiViewEditorSupport.class, (String)"TEXT_SAVE_AS_UTF", (Object)string);
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (object.equals(NotifyDescriptor.YES_OPTION)) {
                try {
                    int n;
                    int n2 = Math.min(1000, styledDocument.getLength());
                    final char[] cArray = styledDocument.getText(0, n2).toCharArray();
                    int n3 = 0;
                    if (cArray[0] == '<' && cArray[1] == '?' && cArray[2] == 'x') {
                        for (n = 3; n < n2; ++n) {
                            if (cArray[n] != '?' || cArray[n + 1] != '>') continue;
                            n3 = n + 1;
                            break;
                        }
                    }
                    n = n3;
                    Runnable runnable = new Runnable(){

                        public void run() {
                            block2: {
                                try {
                                    styledDocument.remove(0, n + 1);
                                    styledDocument.insertString(0, "<?xml version='1.0' encoding='UTF-8' ?> \n<!-- was: " + new String(cArray, 0, n + 1) + " -->", null);
                                }
                                catch (BadLocationException badLocationException) {
                                    if (System.getProperty("netbeans.debug.exceptions") == null) break block2;
                                    badLocationException.printStackTrace();
                                }
                            }
                        }
                    };
                    NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
                    super.saveDocument();
                    this.getDataObject().setModified(false);
                    ((XmlMultiViewDataObject)this.getDataObject()).getDataCache().reloadData();
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
            }
            return;
        }
    }

    private boolean checkCharsetConversion(String string) {
        boolean bl = true;
        try {
            CharsetEncoder charsetEncoder = Charset.forName(string).newEncoder();
            if (!charsetEncoder.canEncode(this.getDocument().getText(0, this.getDocument().getLength()))) {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)XmlMultiViewEditorSupport.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), string}), 0, 2);
                confirmation.setValue(NotifyDescriptor.NO_OPTION);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                    bl = false;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
        }
        return bl;
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        MultiViewDescription[] multiViewDescriptionArray = this.getMultiViewDescriptions();
        CloneableTopComponent cloneableTopComponent = MultiViewFactory.createCloneableMultiView((MultiViewDescription[])multiViewDescriptionArray, (MultiViewDescription)multiViewDescriptionArray[0], (CloseOperationHandler)new MyCloseHandler(this.dObj));
        Mode mode = WindowManager.getDefault().findMode("editor");
        if (mode != null) {
            mode.dockInto((TopComponent)cloneableTopComponent);
        }
        this.mvtc = cloneableTopComponent;
        return cloneableTopComponent;
    }

    public MultiViewDescription[] getMultiViewDescriptions() {
        if (this.multiViewDescriptions == null) {
            if (this.suppressXmlView) {
                this.multiViewDescriptions = this.dObj.getMultiViewDesc();
                this.xmlMultiViewIndex = 0;
            } else {
                DesignMultiViewDesc[] designMultiViewDescArray = this.dObj.getMultiViewDesc();
                XmlViewDesc xmlViewDesc = new XmlViewDesc(this.dObj);
                this.multiViewDescriptions = new MultiViewDescription[designMultiViewDescArray.length + 1];
                System.arraycopy(designMultiViewDescArray, 0, this.multiViewDescriptions, 0, designMultiViewDescArray.length);
                this.multiViewDescriptions[designMultiViewDescArray.length] = xmlViewDesc;
                this.xmlMultiViewIndex = designMultiViewDescArray.length;
            }
        }
        return this.multiViewDescriptions;
    }

    public void setSuppressXmlView(boolean bl) {
        this.suppressXmlView = bl;
        this.multiViewDescriptions = null;
    }

    public void edit() {
        this.openView(-1);
    }

    void openView(final int n) {
        Utils.runInAwtDispatchThread(new Runnable(){

            public void run() {
                CloneableTopComponent cloneableTopComponent = XmlMultiViewEditorSupport.this.openCloneableTopComponent();
                MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)cloneableTopComponent);
                multiViewHandler.requestVisible(multiViewHandler.getPerspectives()[n < 0 ? XmlMultiViewEditorSupport.this.xmlMultiViewIndex : n]);
                cloneableTopComponent.requestActive();
            }
        });
        try {
            this.openDocument();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public void open() {
        this.openView(this.lastOpenView);
    }

    void goToXmlPerspective() {
        Utils.runInAwtDispatchThread(new Runnable(){

            public void run() {
                MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)XmlMultiViewEditorSupport.this.mvtc);
                multiViewHandler.requestVisible(multiViewHandler.getPerspectives()[XmlMultiViewEditorSupport.this.xmlMultiViewIndex]);
            }
        });
    }

    protected void notifyClosed() {
        StyledDocument styledDocument;
        this.mvtc = null;
        if (this.topComponentsListener != null) {
            TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this.topComponentsListener);
            this.topComponentsListener = null;
        }
        if ((styledDocument = this.getDocument()) != null) {
            styledDocument.removeDocumentListener(this.docListener);
        }
        super.notifyClosed();
    }

    MultiViewPerspective getSelectedPerspective() {
        if (this.mvtc != null) {
            return MultiViews.findMultiViewHandler((TopComponent)this.mvtc).getSelectedPerspective();
        }
        return null;
    }

    public void updateDisplayName() {
        if (this.mvtc != null) {
            Utils.runInAwtDispatchThread(new Runnable(){

                public void run() {
                    String string = XmlMultiViewEditorSupport.this.messageName();
                    if (!string.equals(XmlMultiViewEditorSupport.this.mvtc.getDisplayName())) {
                        XmlMultiViewEditorSupport.this.mvtc.setDisplayName(string);
                    }
                    XmlMultiViewEditorSupport.this.mvtc.setToolTipText(FileUtil.getFileDisplayName((FileObject)XmlMultiViewEditorSupport.this.dObj.getPrimaryFile()));
                }
            });
        }
    }

    public TopComponent getMVTC() {
        return this.mvtc;
    }

    void setMVTC(TopComponent topComponent) {
        this.mvtc = topComponent;
        if (this.topComponentsListener == null) {
            this.topComponentsListener = new TopComponentsListener();
            TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this.topComponentsListener);
        }
    }

    void setLastOpenView(int n) {
        this.lastOpenView = n;
    }

    protected String messageName() {
        return super.messageName();
    }

    private class TopComponentsListener
    implements PropertyChangeListener {
        private TopComponentsListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("opened".equals(propertyChangeEvent.getPropertyName())) {
                Set set = (Set)propertyChangeEvent.getOldValue();
                set.removeAll((Set)propertyChangeEvent.getNewValue());
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof CloneableTopComponent)) continue;
                    CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)e;
                    Enumeration enumeration = cloneableTopComponent.getReference().getComponents();
                    if (XmlMultiViewEditorSupport.this.mvtc != cloneableTopComponent) continue;
                    if (enumeration.hasMoreElements()) {
                        XmlMultiViewEditorSupport.this.mvtc = (TopComponent)((CloneableTopComponent)enumeration.nextElement());
                        continue;
                    }
                    XmlMultiViewEditorSupport.this.notifyClosed();
                }
            }
        }
    }

    static class MyCloseHandler
    implements CloseOperationHandler,
    Serializable {
        static final long serialVersionUID = -6512103928294991474L;
        private XmlMultiViewDataObject dObj;

        MyCloseHandler() {
        }

        MyCloseHandler(XmlMultiViewDataObject xmlMultiViewDataObject) {
            this.dObj = xmlMultiViewDataObject;
        }

        public boolean resolveCloseOperation(CloseOperationState[] closeOperationStateArray) {
            Object object;
            for (int i = 0; i < closeOperationStateArray.length; ++i) {
                object = closeOperationStateArray[i];
                if (!"Flush Data".equals(object.getCloseWarningID())) continue;
                return false;
            }
            if (this.dObj.isModified()) {
                XmlMultiViewEditorSupport xmlMultiViewEditorSupport = this.dObj.getEditorSupport();
                object = xmlMultiViewEditorSupport.messageSave();
                ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = XmlMultiViewEditorSupport.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport));
                JButton jButton = new JButton(resourceBundle.getString("CTL_Save"));
                jButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Save"));
                jButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CTL_Save"));
                JButton jButton2 = new JButton(resourceBundle.getString("CTL_Discard"));
                jButton2.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Discard"));
                jButton2.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CTL_Discard"));
                jButton2.setMnemonic(resourceBundle.getString("CTL_Discard_Mnemonic").charAt(0));
                NotifyDescriptor notifyDescriptor = new NotifyDescriptor(object, resourceBundle.getString("LBL_SaveFile_Title"), 1, 3, new Object[]{jButton, jButton2, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton);
                Object object2 = DialogDisplayer.getDefault().notify(notifyDescriptor);
                if (NotifyDescriptor.CANCEL_OPTION.equals(object2) || NotifyDescriptor.CLOSED_OPTION.equals(object2)) {
                    return false;
                }
                if (jButton.equals(object2)) {
                    try {
                        if (!this.dObj.acceptEncoding() || !this.dObj.verifyDocumentBeforeClose()) {
                            return false;
                        }
                        xmlMultiViewEditorSupport.saveDocument();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                        return false;
                    }
                } else if (jButton2.equals(object2)) {
                    this.dObj.getEditorSupport().reloadDocument().waitFinished();
                    xmlMultiViewEditorSupport.notifyClosed();
                }
            }
            return true;
        }
    }

    private class DocumentSynchronizer
    extends XmlMultiViewDataSynchronizer {
        private final RequestProcessor.Task reloadUpdatedTask;

        public DocumentSynchronizer(XmlMultiViewDataObject xmlMultiViewDataObject) {
            super(xmlMultiViewDataObject, 100);
            this.reloadUpdatedTask = this.requestProcessor.create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    DocumentListener documentListener;
                    StyledDocument styledDocument = XmlMultiViewEditorSupport.this.getDocument();
                    DocumentListener documentListener2 = documentListener = styledDocument == null ? null : (DocumentListener)styledDocument.getProperty(XmlMultiViewEditorSupport.PROPERTY_MODIFICATION_LISTENER);
                    if (documentListener != null) {
                        styledDocument.removeDocumentListener(documentListener);
                    }
                    try {
                        DocumentSynchronizer.this.reloadModel();
                    }
                    finally {
                        if (documentListener != null) {
                            styledDocument.addDocumentListener(documentListener);
                        }
                    }
                }
            });
            XmlMultiViewEditorSupport.this.getXmlEnv().addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    if ("time".equals(string) && XmlMultiViewEditorSupport.this.getDocument() == null) {
                        XmlMultiViewEditorSupport.this.dObj.getDataCache().loadData();
                    }
                }
            });
        }

        protected boolean mayUpdateData(boolean bl) {
            return true;
        }

        protected void dataUpdated(long l) {
            if (XmlMultiViewEditorSupport.this.loading == 0) {
                this.reloadUpdatedTask.schedule(0);
            }
        }

        protected Object getModel() {
            return XmlMultiViewEditorSupport.this.getDocument();
        }

        protected void updateDataFromModel(Object object, final FileLock fileLock, final boolean bl) {
            final Document document = (Document)object;
            if (document == null) {
                try {
                    XmlMultiViewEditorSupport.this.dObj.getDataCache().setData(fileLock, "", bl);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            } else {
                document.render(new Runnable(){

                    public void run() {
                        try {
                            XmlMultiViewEditorSupport.this.dObj.getDataCache().setData(fileLock, document.getText(0, document.getLength()), bl);
                        }
                        catch (BadLocationException badLocationException) {
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify((Throwable)iOException);
                        }
                    }
                });
            }
        }

        protected void reloadModelFromData() {
            if (XmlMultiViewEditorSupport.this.loading == 0) {
                Utils.replaceDocument(XmlMultiViewEditorSupport.this.getDocument(), XmlMultiViewEditorSupport.this.dObj.getDataCache().getStringData());
            }
        }
    }

    private static class XmlViewDesc
    implements MultiViewDescription,
    Serializable {
        private static final long serialVersionUID = 8085725367398466167L;
        XmlMultiViewDataObject dObj;

        XmlViewDesc() {
        }

        XmlViewDesc(XmlMultiViewDataObject xmlMultiViewDataObject) {
            this.dObj = xmlMultiViewDataObject;
        }

        public MultiViewElement createElement() {
            return new XmlMultiViewElement(this.dObj);
        }

        public String getDisplayName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$multiview$XmlMultiViewEditorSupport == null ? (class$org$netbeans$modules$xml$multiview$XmlMultiViewEditorSupport = XmlMultiViewEditorSupport.class$("org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport")) : class$org$netbeans$modules$xml$multiview$XmlMultiViewEditorSupport), (String)"LBL_XML_TAB");
        }

        public HelpCtx getHelpCtx() {
            return this.dObj.getHelpCtx();
        }

        public Image getIcon() {
            return this.dObj.getXmlViewIcon();
        }

        public int getPersistenceType() {
            return 1;
        }

        public String preferredID() {
            return "multiview_xml";
        }
    }

    public static class XmlEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 2882981960507292985L;
        private final XmlMultiViewDataObject xmlMultiViewDataObject;

        public XmlEnv(XmlMultiViewDataObject xmlMultiViewDataObject) {
            super((DataObject)xmlMultiViewDataObject);
            this.xmlMultiViewDataObject = xmlMultiViewDataObject;
            this.changeFile();
        }

        protected FileObject getFile() {
            return this.xmlMultiViewDataObject.getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return this.xmlMultiViewDataObject.getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return this.xmlMultiViewDataObject.getEditorSupport();
        }

        public InputStream inputStream() throws IOException {
            return this.xmlMultiViewDataObject.getDataCache().createInputStream();
        }

        protected OutputStream getFileOutputStream() throws IOException {
            return super.outputStream();
        }

        public OutputStream outputStream() throws IOException {
            if (this.xmlMultiViewDataObject.getEditorSupport().saveLock != null) {
                return super.outputStream();
            }
            return this.xmlMultiViewDataObject.getDataCache().createOutputStream();
        }

        public boolean isModified() {
            return super.isModified();
        }
    }
}

