/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.analyzer.ui;

import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.InputMap;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.hints.analyzer.ui.CheckRenderer;
import org.netbeans.modules.java.hints.analyzer.ui.FixDescription;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

public class CheckTreeView
extends BeanTreeView {
    private NodeTreeModel nodeTreeModel;

    public CheckTreeView() {
        this.setFocusable(false);
        CheckListener checkListener = new CheckListener();
        this.tree.addMouseListener(checkListener);
        this.tree.addKeyListener(checkListener);
        CheckRenderer checkRenderer = new CheckRenderer();
        this.tree.setCellRenderer(checkRenderer);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(false);
        InputMap inputMap = this.tree.getInputMap(0);
        if (null != inputMap) {
            inputMap.remove(KeyStroke.getKeyStroke(10, 0));
        }
        this.setBorder(UIManager.getBorder("ScrollPane.border"));
    }

    protected NodeTreeModel createModel() {
        this.nodeTreeModel = super.createModel();
        return this.nodeTreeModel;
    }

    public void expandRow(int n) {
        this.tree.expandRow(n);
    }

    public boolean getScrollsOnExpand() {
        return this.tree.getScrollsOnExpand();
    }

    public void setScrollsOnExpand(boolean bl) {
        this.tree.setScrollsOnExpand(bl);
    }

    protected void showPath(TreePath treePath) {
        this.tree.expandPath(treePath);
        this.showPathWithoutExpansion(treePath);
    }

    protected void showSelection(TreePath[] treePathArray) {
        this.tree.getSelectionModel().setSelectionPaths(treePathArray);
        if (treePathArray.length == 1) {
            this.showPathWithoutExpansion(treePathArray[0]);
        }
    }

    private void showPathWithoutExpansion(TreePath treePath) {
        Rectangle rectangle = this.tree.getPathBounds(treePath);
        if (rectangle != null && this.getWidth() > 0 && this.getHeight() > 0) {
            this.tree.scrollRectToVisible(rectangle);
        }
    }

    class CheckListener
    implements MouseListener,
    KeyListener {
        CheckListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                TreePath treePath = CheckTreeView.this.tree.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                Rectangle rectangle = CheckTreeView.this.tree.getPathBounds(treePath);
                if (rectangle != null) {
                    rectangle.width = rectangle.height;
                    if (rectangle.contains(mouseEvent.getPoint()) && this.toggle(treePath)) {
                        mouseEvent.consume();
                        CheckTreeView.this.repaint();
                    }
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            JTree jTree;
            TreePath treePath;
            if (keyEvent.getKeyCode() == 32 && keyEvent.getSource() instanceof JTree && this.toggle(treePath = (jTree = (JTree)keyEvent.getSource()).getSelectionPath())) {
                keyEvent.consume();
                CheckTreeView.this.repaint();
            }
        }

        private boolean toggle(TreePath treePath) {
            if (treePath == null) {
                return false;
            }
            Node node = Visualizer.findNode((Object)treePath.getLastPathComponent());
            if (node == null) {
                return false;
            }
            Collection collection = node.getLookup().lookupAll(FixDescription.class);
            if (!collection.isEmpty()) {
                CheckRenderer.State state = CheckRenderer.getCheckState(collection);
                boolean bl = state != CheckRenderer.State.SELECTED;
                for (FixDescription fixDescription : collection) {
                    fixDescription.setSelected(bl);
                }
                return true;
            }
            return false;
        }
    }
}

