/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax;

import java.util.Map;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.xml.text.syntax.AbstractBaseOptions;
import org.openide.util.Lookup;

public class XMLOptions
extends AbstractBaseOptions {
    private static final long serialVersionUID = 2347735706857337892L;
    public static final String COMPLETION_AUTO_POPUP_PROP = "completionAutoPopup";
    public static final String COMPLETION_AUTO_POPUP_DELAY_PROP = "completionAutoPopupDelay";
    public static final String COMPLETION_INSTANT_SUBSTITUTION_PROP = "completionInstantSubstitution";
    static final String[] XML_PROP_NAMES = new String[]{"completionAutoPopup", "completionAutoPopupDelay", "completionInstantSubstitution"};
    private static final String[][] TRANSLATE_COLORS = new String[][]{{"xml-string", "xml-value"}, {"xml-symbol", "xml-operator"}, {"xml-keyword", "xml-doctype"}, {"xml-plain", "xml-text"}};

    public XMLOptions() {
        super(XMLOptions.gimeClass("org.netbeans.modules.xml.text.syntax.XMLKit", BaseKit.class), "xml");
    }

    protected Class getDefaultIndentEngineClass() {
        return XMLOptions.gimeClass("org.netbeans.modules.xml.text.indent.XMLIndentEngine", super.getDefaultIndentEngineClass());
    }

    public boolean getCompletionAutoPopup() {
        return this.getSettingBoolean("completion-auto-popup");
    }

    public void setCompletionAutoPopup(boolean bl) {
        this.setSettingBoolean("completion-auto-popup", bl, COMPLETION_AUTO_POPUP_PROP);
    }

    public int getCompletionAutoPopupDelay() {
        return this.getSettingInteger("completion-auto-popup-delay");
    }

    public void setCompletionAutoPopupDelay(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument((String)"MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("completion-auto-popup-delay", n, COMPLETION_AUTO_POPUP_DELAY_PROP);
    }

    public boolean getCompletionInstantSubstitution() {
        return this.getSettingBoolean("completion-instant-substitution");
    }

    public void setCompletionInstantSubstitution(boolean bl) {
        this.setSettingBoolean("completion-instant-substitution", bl, COMPLETION_INSTANT_SUBSTITUTION_PROP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getColoringMap() {
        Map<String, Coloring> map = super.getColoringMap();
        XMLOptions xMLOptions = this;
        synchronized (xMLOptions) {
            for (int i = 0; i < TRANSLATE_COLORS.length; ++i) {
                String string = TRANSLATE_COLORS[i][0];
                Coloring coloring = map.get(string);
                if (coloring == null) continue;
                map.remove(string);
                String string2 = TRANSLATE_COLORS[i][1];
                map.put(string2, coloring);
            }
            return map;
        }
    }

    protected String getContentType() {
        return "text/xml";
    }

    static Class gimeClass(String string, Class clazz) {
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            return classLoader == null ? clazz : classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return clazz;
        }
    }
}

