/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.hints.pom.spi.SelectionPOMFixProvider;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.spi.editor.errorstripe.UpToDateStatus;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProvider;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProviderFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class StatusProvider
implements UpToDateStatusProviderFactory {
    private static final String LAYER_POM = "pom";
    private static final String LAYER_POM_SELECTION = "pom-selection";

    public UpToDateStatusProvider createUpToDateStatusProvider(Document document) {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        if (fileObject != null && "text/x-maven-pom+xml".equals(fileObject.getMIMEType())) {
            return new StatusProviderImpl(document);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StatusProviderImpl
    extends UpToDateStatusProvider {
        private Document document;
        private POMModel model;
        private Project project;
        private FileChangeListener listener;

        StatusProviderImpl(Document document) {
            this.document = document;
            this.listener = new FileChangeAdapter(){

                public void fileChanged(FileEvent fileEvent) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            StatusProviderImpl.this.checkHints();
                        }
                    });
                }
            };
            this.initializeModel();
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    StatusProviderImpl.this.checkHints();
                }
            });
        }

        private void checkHints() {
            HintsController.setErrors((Document)this.document, (String)StatusProvider.LAYER_POM, StatusProviderImpl.findHints(this.model, this.project));
        }

        static List<ErrorDescription> findHints(POMModel pOMModel, Project project) {
            if (!pOMModel.getModelSource().isEditable()) {
                return new ArrayList<ErrorDescription>();
            }
            assert (pOMModel != null);
            try {
                pOMModel.sync();
                pOMModel.refresh();
            }
            catch (IOException iOException) {
                Logger.getLogger(StatusProvider.class.getName()).log(Level.INFO, "Errror while syncing pom model.", iOException);
            }
            ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
            if (!pOMModel.getState().equals((Object)Model.State.VALID)) {
                Logger.getLogger(StatusProvider.class.getName()).log(Level.INFO, "Pom model document is not valid, is " + pOMModel.getState());
                return arrayList;
            }
            if (pOMModel.getProject() == null) {
                Logger.getLogger(StatusProvider.class.getName()).log(Level.INFO, "Pom model root element missing");
                return arrayList;
            }
            Lookup lookup = Lookups.forPath((String)"org-netbeans-modules-maven-hints");
            Lookup.Result result = lookup.lookupResult(POMErrorFixProvider.class);
            for (POMErrorFixProvider pOMErrorFixProvider : result.allInstances()) {
                List<ErrorDescription> list;
                if (!pOMErrorFixProvider.getConfiguration().isEnabled(pOMErrorFixProvider.getConfiguration().getPreferences()) || (list = pOMErrorFixProvider.getErrorsForDocument(pOMModel, project)) == null) continue;
                arrayList.addAll(list);
            }
            return arrayList;
        }

        private void initializeModel() {
            FileObject fileObject = NbEditorUtilities.getFileObject((Document)this.document);
            if (fileObject != null) {
                ModelSource modelSource = Utilities.createModelSource((FileObject)fileObject);
                this.model = POMModelFactory.getDefault().getModel(modelSource);
                this.model.setAutoSyncActive(false);
                this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
                fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.listener, (Object)fileObject));
            }
        }

        static List<ErrorDescription> findHints(POMModel pOMModel, Project project, int n, int n2) {
            if (!pOMModel.getModelSource().isEditable()) {
                return new ArrayList<ErrorDescription>();
            }
            try {
                pOMModel.sync();
                pOMModel.refresh();
            }
            catch (IOException iOException) {
                Logger.getLogger(StatusProvider.class.getName()).log(Level.INFO, "Errror while syncing pom model.", iOException);
            }
            ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
            if (!pOMModel.getState().equals((Object)Model.State.VALID)) {
                Logger.getLogger(StatusProvider.class.getName()).log(Level.INFO, "Pom model document is not valid, is " + pOMModel.getState());
                return arrayList;
            }
            if (pOMModel.getProject() == null) {
                Logger.getLogger(StatusProvider.class.getName()).log(Level.INFO, "Pom model root element missing");
                return arrayList;
            }
            Lookup lookup = Lookups.forPath((String)"org-netbeans-modules-maven-hints");
            Lookup.Result result = lookup.lookupResult(SelectionPOMFixProvider.class);
            for (SelectionPOMFixProvider selectionPOMFixProvider : result.allInstances()) {
                List<ErrorDescription> list;
                if (!selectionPOMFixProvider.getConfiguration().isEnabled(selectionPOMFixProvider.getConfiguration().getPreferences()) || (list = selectionPOMFixProvider.getErrorsForDocument(pOMModel, project, n, n2)) == null) continue;
                arrayList.addAll(list);
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UpToDateStatus getUpToDate() {
            if (!this.model.isIntransaction()) {
                FileObject fileObject = NbEditorUtilities.getFileObject((Document)this.document);
                boolean bl = false;
                try {
                    JEditorPane[] jEditorPaneArray;
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                    if (editorCookie != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && jEditorPaneArray.length > 0 && jEditorPaneArray[0].getSelectionStart() != jEditorPaneArray[0].getSelectionEnd()) {
                        HintsController.setErrors((Document)this.document, (String)StatusProvider.LAYER_POM_SELECTION, StatusProviderImpl.findHints(this.model, this.project, jEditorPaneArray[0].getSelectionStart(), jEditorPaneArray[0].getSelectionEnd()));
                        bl = true;
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
                finally {
                    if (!bl) {
                        HintsController.setErrors((Document)this.document, (String)StatusProvider.LAYER_POM_SELECTION, Collections.emptyList());
                    }
                }
            }
            return UpToDateStatus.UP_TO_DATE_OK;
        }
    }
}

