/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.netbeans.junit.Manager;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.junit.internal.NbModuleLogHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NbModuleSuite {
    private NbModuleSuite() {
    }

    public static Test create(Class<? extends TestCase> clazz, String string, String string2) {
        return new S(Configuration.create(clazz).clusters(string).enableModules(string2));
    }

    public static Test create(Class<? extends TestCase> clazz, String string, String string2, String ... stringArray) {
        Configuration configuration = Configuration.create(clazz).clusters(string).enableModules(string2);
        if (stringArray.length > 0) {
            configuration = configuration.addTest(stringArray);
        }
        return new S(configuration);
    }

    public static Test allModules(Class<? extends TestCase> clazz, String ... stringArray) {
        return NbModuleSuite.create(clazz, ".*", ".*", stringArray);
    }

    public static Configuration createConfiguration(Class<? extends TestCase> clazz) {
        return Configuration.create(clazz);
    }

    public static Configuration emptyConfiguration() {
        return Configuration.create(null);
    }

    public static Test create(Configuration configuration) {
        return new S(configuration);
    }

    static {
        System.setProperty("org.netbeans.MainImpl.154417", "true");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class S
    extends NbTestSuite {
        final Configuration config;
        private static int invocations;
        private static File lastUserDir;
        private int testCount = 0;
        private static Pattern CODENAME;
        private static Pattern VERSION;
        private static Pattern MANIFEST;
        private static Pattern ENABLED;
        private static Pattern AUTO;
        private static Pattern EAGER;

        public S(Configuration configuration) {
            this.config = configuration.getReady();
        }

        public int countTestCases() {
            return this.testCount;
        }

        public void run(TestResult testResult) {
            try {
                this.runInRuntimeContainer(testResult);
            }
            catch (Exception exception) {
                testResult.addError((Test)this, (Throwable)exception);
            }
        }

        private static String[] tokenizePath(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":;", true);
            char c = '\u0000';
            int n = 0;
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                char c2;
                String string2 = stringTokenizer.nextToken();
                if (string2.length() == 0) continue;
                if (string2.length() == 1 && ((c2 = string2.charAt(0)) == ':' || c2 == ';')) {
                    n = c2;
                    ++n2;
                    continue;
                }
                if (c != '\u0000') {
                    if (n == 58 && n2 == 1 && (string2.charAt(0) == '\\' || string2.charAt(0) == '/')) {
                        string2 = "" + c + ':' + string2;
                    } else {
                        arrayList.add(Character.toString(c));
                    }
                    c = '\u0000';
                }
                n2 = 0;
                if (string2.length() == 1 && ((c2 = string2.charAt(0)) >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                    c = c2;
                    continue;
                }
                arrayList.add(string2);
            }
            if (c != '\u0000') {
                arrayList.add(Character.toString(c));
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }

        static void findClusters(Collection<File> collection, List<String> list) throws IOException {
            File file = S.findPlatform().getCanonicalFile();
            String string = System.getProperty("cluster.path.final");
            HashSet<File> hashSet = null;
            if (string != null) {
                hashSet = new HashSet<File>();
                for (String string2 : S.tokenizePath(string)) {
                    File file2 = new File(string2);
                    hashSet.add(file2.getCanonicalFile());
                }
            }
            for (String string3 : list) {
                for (File file3 : file.getParentFile().listFiles()) {
                    File file4;
                    if (file3.equals(file) || !file3.getName().matches(string3) || hashSet != null && !hashSet.contains(file3) || !(file4 = new File(new File(file3, "config"), "Modules")).exists()) continue;
                    collection.add(file3);
                }
            }
        }

        private void runInRuntimeContainer(TestResult testResult) throws Exception {
            Class<TestCase> clazz;
            Object object;
            Serializable serializable;
            System.getProperties().remove("netbeans.dirs");
            File file = S.findPlatform();
            File[] fileArray = new File(file, "lib").listFiles();
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (int i = 0; i < fileArray.length; ++i) {
                serializable = fileArray[i].toURI().toURL();
                if (!((URL)serializable).toExternalForm().endsWith(".jar")) continue;
                arrayList.add((URL)serializable);
            }
            File file2 = new File(System.getProperty("java.home"));
            if (!"Mac OS X".equals(System.getProperty("os.name"))) {
                file2 = file2.getParentFile();
            }
            if (((File)(serializable = new File(file2, "lib"))).isDirectory()) {
                for (File file3 : ((File)serializable).listFiles()) {
                    if (!file3.getName().endsWith(".jar")) continue;
                    arrayList.add(file3.toURI().toURL());
                }
            }
            JUnitLoader jUnitLoader = new JUnitLoader(this.config.parentClassLoader, NbModuleSuite.class.getClassLoader());
            URLClassLoader uRLClassLoader = new URLClassLoader(arrayList.toArray(new URL[0]), (ClassLoader)jUnitLoader);
            Class<?> clazz2 = uRLClassLoader.loadClass("org.netbeans.Main");
            Assert.assertEquals((String)"Loaded by our classloader", (Object)uRLClassLoader, (Object)clazz2.getClassLoader());
            Method method = clazz2.getDeclaredMethod("main", String[].class);
            System.setProperty("java.util.logging.config", "-");
            System.setProperty("netbeans.logger.console", "true");
            System.setProperty("netbeans.home", file.getPath());
            System.setProperty("netbeans.full.hack", "true");
            File file4 = new File(new File(Manager.getWorkDirPath()), "userdir" + invocations++);
            if (this.config.reuseUserDir) {
                file4 = lastUserDir != null ? lastUserDir : file4;
            } else {
                NbTestCase.deleteSubFiles(file4);
            }
            lastUserDir = file4;
            file4.mkdirs();
            System.setProperty("netbeans.user", file4.getPath());
            TreeSet<String> treeSet = new TreeSet<String>();
            if (this.config.enableClasspathModules) {
                treeSet.addAll(S.findEnabledModules(NbTestSuite.class.getClassLoader()));
            }
            treeSet.add("org.openide.filesystems");
            treeSet.add("org.openide.modules");
            treeSet.add("org.openide.util");
            treeSet.remove("org.netbeans.insane");
            treeSet.add("org.netbeans.core.startup");
            treeSet.add("org.netbeans.bootstrap");
            S.turnModules(file4, !this.config.honorAutoEager, treeSet, this.config.moduleRegExp, file);
            if (this.config.enableClasspathModules) {
                S.turnClassPathModules(file4, NbTestSuite.class.getClassLoader());
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            for (File file5 : this.findClusters()) {
                S.turnModules(file4, !this.config.honorAutoEager, treeSet, this.config.moduleRegExp, file5);
                stringBuilder.append(string);
                stringBuilder.append(file5.getPath());
                string = File.pathSeparator;
            }
            System.setProperty("netbeans.dirs", stringBuilder.toString());
            System.setProperty("netbeans.security.nocheck", "true");
            ArrayList arrayList2 = new ArrayList(this.config.tests.size());
            for (Item item : this.config.tests) {
                arrayList2.add(item.clazz);
            }
            S.preparePatches(System.getProperty("java.class.path"), System.getProperties(), arrayList2.toArray(new Class[0]));
            ArrayList arrayList3 = new ArrayList();
            arrayList3.add("--nosplash");
            if (!this.config.gui) {
                arrayList3.add("--nogui");
            }
            Test test = NbModuleLogHandler.registerBuffer(this.config.failOnMessage, this.config.failOnException);
            method.invoke(null, new Object[]{arrayList3.toArray(new String[0])});
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Assert.assertNotNull((String)"Global classloader is initialized", (Object)classLoader);
            ClassLoader classLoader2 = classLoader;
            try {
                classLoader2.loadClass("junit.framework.Test");
                classLoader2.loadClass("org.netbeans.junit.NbTestSuite");
                object = new NbTestSuite();
                for (Item item : this.config.tests) {
                    if (item.isTestCase) {
                        clazz = classLoader2.loadClass(item.clazz.getName()).asSubclass(TestCase.class);
                        if (item.fileNames == null) {
                            ((NbTestSuite)object).addTest(new NbTestSuite(clazz));
                            continue;
                        }
                        NbTestSuite nbTestSuite = new NbTestSuite();
                        nbTestSuite.addTests(clazz, item.fileNames);
                        ((NbTestSuite)object).addTest(nbTestSuite);
                        continue;
                    }
                    clazz = classLoader2.loadClass(item.clazz.getName()).asSubclass(Test.class);
                    ((NbTestSuite)object).addTest((Test)clazz.newInstance());
                }
                if (test != null) {
                    ((NbTestSuite)object).addTest(test);
                }
                this.testCount = object.countTestCases();
                object.run(testResult);
            }
            catch (ClassNotFoundException classNotFoundException) {
                testResult.addError((Test)this, (Throwable)classNotFoundException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                testResult.addError((Test)this, (Throwable)noClassDefFoundError);
            }
            if (test != null) {
                NbModuleLogHandler.finish();
            }
            object = classLoader.loadClass("org.openide.LifecycleManager");
            Method method2 = ((Class)object).getMethod("getDefault", new Class[0]);
            Method method3 = ((Class)object).getMethod("exit", new Class[0]);
            clazz = method2.invoke(null, new Object[0]);
            if (!clazz.getClass().getName().startsWith("org.openide.LifecycleManager")) {
                System.setProperty("netbeans.close.no.exit", "true");
                method3.invoke(clazz, new Object[0]);
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                    }
                });
            }
        }

        static File findPlatform() {
            try {
                Class<?> clazz = Class.forName("org.openide.util.Lookup");
                File file = new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI());
                Assert.assertTrue((String)("Util exists: " + file), (boolean)file.exists());
                return file.getParentFile().getParentFile();
            }
            catch (Exception exception) {
                try {
                    File file = new File(NbModuleSuite.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    File file2 = file.getParentFile().getParentFile();
                    Assert.assertEquals((String)"NbJUnit is in harness", (String)"harness", (String)file2.getName());
                    TreeSet<File> treeSet = new TreeSet<File>();
                    for (File file3 : file2.getParentFile().listFiles()) {
                        if (!file3.getName().startsWith("platform")) continue;
                        treeSet.add(file3);
                    }
                    Assert.assertFalse((String)("Platform shall be found in " + file2.getParent()), (boolean)treeSet.isEmpty());
                    return (File)treeSet.last();
                }
                catch (Exception exception2) {
                    Assert.fail((String)("Cannot find utilities JAR: " + exception + " and: " + exception2));
                    return null;
                }
            }
        }

        private File[] findClusters() throws IOException {
            LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
            if (this.config.clusterRegExp != null) {
                S.findClusters(linkedHashSet, this.config.clusterRegExp);
            }
            if (this.config.enableClasspathModules) {
                for (String string : S.tokenizePath(System.getProperty("java.class.path"))) {
                    File file = new File(string);
                    File file2 = file.getParentFile().getParentFile();
                    File file3 = new File(new File(file2, "config"), "Modules");
                    if (!file3.exists() && !file2.getName().equals("cluster")) continue;
                    linkedHashSet.add(file2);
                }
            }
            return linkedHashSet.toArray(new File[0]);
        }

        static Set<String> findEnabledModules(ClassLoader classLoader) throws IOException {
            TreeSet<String> treeSet = new TreeSet<String>();
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                String string = S.asString(uRL.openStream(), true);
                Matcher matcher = CODENAME.matcher(string);
                if (!matcher.find()) continue;
                treeSet.add(matcher.group(1));
            }
            return treeSet;
        }

        private static void turnClassPathModules(File file, ClassLoader classLoader) throws IOException {
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                String string = S.asString(uRL.openStream(), true);
                Matcher matcher = CODENAME.matcher(string);
                if (!matcher.find()) continue;
                String string2 = matcher.group(1);
                Matcher matcher2 = VERSION.matcher(string);
                if (!matcher2.find()) {
                    throw new IllegalStateException("Cannot find version:\n" + string);
                }
                File file2 = S.jarFromURL(uRL);
                if (file2 == null || file2.getParentFile().getName().equals("lib") || file2.getParentFile().getName().equals("core")) continue;
                String string3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"\n                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">\n<module name=\"" + string2 + "\">\n" + "    <param name=\"autoload\">false</param>\n" + "    <param name=\"eager\">false</param>\n" + "    <param name=\"enabled\">true</param>\n" + "    <param name=\"jar\">" + file2 + "</param>\n" + "    <param name=\"reloadable\">false</param>\n" + "    <param name=\"specversion\">" + matcher2.group(1) + "</param>\n" + "</module>\n";
                File file3 = new File(new File(file, "config"), "Modules");
                file3.mkdirs();
                File file4 = new File(file3, string2.replace('.', '-') + ".xml");
                S.writeModule(file4, string3);
            }
        }

        private static File jarFromURL(URL uRL) {
            Matcher matcher = MANIFEST.matcher(uRL.toExternalForm());
            if (matcher.matches()) {
                return new File(URI.create(matcher.group(1)));
            }
            if (!uRL.getProtocol().equals("file")) {
                throw new IllegalStateException(uRL.toExternalForm());
            }
            return null;
        }

        static void preparePatches(String string, Properties properties, Class ... classArray) throws URISyntaxException {
            Object object;
            Pattern pattern = Pattern.compile(".*\\" + File.separator + "([^\\" + File.separator + "]+)\\" + File.separator + "tests\\.jar");
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = "";
            for (String object2 : S.tokenizePath(string)) {
                object = pattern.matcher(object2);
                if (!((Matcher)object).matches()) continue;
                stringBuilder.append(string2).append(object2);
                string2 = File.pathSeparator;
            }
            for (Class clazz : classArray) {
                object = clazz.getProtectionDomain().getCodeSource().getLocation();
                Assert.assertNotNull((String)("URL found for " + clazz), (Object)object);
                stringBuilder.append(string2).append(new File(((URL)object).toURI()).getPath());
                string2 = File.pathSeparator;
            }
            properties.setProperty("netbeans.systemclassloader.patches", stringBuilder.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String asString(InputStream inputStream, boolean bl) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            byte[] byArray = new byte[4096];
            try {
                int n;
                while ((n = inputStream.read(byArray)) != -1) {
                    stringBuilder.append(new String(byArray, 0, n, "UTF-8"));
                }
            }
            finally {
                if (bl) {
                    inputStream.close();
                }
            }
            return stringBuilder.toString();
        }

        private static void turnModules(File file, boolean bl, TreeSet<String> treeSet, List<String> list, File ... fileArray) throws IOException {
            if (list == null) {
                return;
            }
            File file2 = new File(new File(file, "config"), "Modules");
            file2.mkdirs();
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                String string2 = iterator.next();
                Pattern pattern = Pattern.compile(string2);
                for (File file3 : fileArray) {
                    File file4;
                    File[] fileArray2;
                    if (!file3.getName().matches(string) || (fileArray2 = (file4 = new File(new File(file3, "config"), "Modules")).listFiles()) == null) continue;
                    for (File file5 : fileArray2) {
                        String string3 = file5.getName();
                        if (string3.endsWith(".xml")) {
                            string3 = string3.substring(0, string3.length() - 4);
                        }
                        string3 = string3.replace('-', '.');
                        String string4 = S.asString(new FileInputStream(file5), true);
                        boolean bl2 = treeSet.contains(string3);
                        if (!bl2 && pattern != null) {
                            bl2 = pattern.matcher(string3).matches();
                        }
                        if (!bl2) continue;
                        S.enableModule(string4, bl, bl2, new File(file2, file5.getName()));
                    }
                }
            }
        }

        private static void enableModule(String string, boolean bl, boolean bl2, File file) throws IOException {
            Object object;
            Matcher matcher;
            boolean bl3 = false;
            Matcher matcher2 = ENABLED.matcher(string);
            if (matcher2.find()) {
                bl3 = "false".equals(matcher2.group(1));
            }
            if ((matcher = EAGER.matcher(string)).find() && "true".equals(matcher.group(1))) {
                return;
            }
            if (!bl && ((Matcher)(object = AUTO.matcher(string))).find() && "true".equals(((Matcher)object).group(1))) {
                return;
            }
            if (bl3) {
                assert (matcher2.groupCount() == 1) : "Groups: " + matcher2.groupCount() + " for:\n" + string;
                try {
                    object = string.substring(0, matcher2.start(1)) + (bl2 ? "true" : "false") + string.substring(matcher2.end(1));
                    S.writeModule(file, (String)object);
                }
                catch (IllegalStateException illegalStateException) {
                    throw (IOException)new IOException("Unparsable:\n" + string).initCause(illegalStateException);
                }
            }
            if ((matcher2 = AUTO.matcher(string)).find()) {
                int n = string.indexOf("<param name=\"autoload");
                int n2 = string.indexOf("<param name=\"jar");
                String string2 = "<param name=\"autoload\">false</param>\n    <param name=\"eager\">false</param>\n    <param name=\"enabled\">true</param>\n    ";
                String string3 = string.substring(0, n) + string2 + string.substring(n2);
                try {
                    S.writeModule(file, string3);
                }
                catch (IllegalStateException illegalStateException) {
                    throw (IOException)new IOException("Unparsable:\n" + string).initCause(illegalStateException);
                }
            }
        }

        private static void writeModule(File file, String string) throws IOException {
            Object object;
            if (file.exists() && ((String)(object = S.asString(new FileInputStream(file), true))).equals(string)) {
                return;
            }
            object = new FileOutputStream(file);
            ((FileOutputStream)object).write(string.getBytes("UTF-8"));
            ((FileOutputStream)object).close();
        }

        static {
            CODENAME = Pattern.compile("OpenIDE-Module: *([^/$ \n\r]*)[/]?[0-9]*", 8);
            VERSION = Pattern.compile("OpenIDE-Module-Specification-Version: *([0-9\\.]*)", 8);
            MANIFEST = Pattern.compile("jar:(file:.*)!/META-INF/MANIFEST.MF", 8);
            ENABLED = Pattern.compile("<param name=[\"']enabled[\"']>([^<]*)</param>", 8);
            AUTO = Pattern.compile("<param name=[\"']autoload[\"']>([^<]*)</param>", 8);
            EAGER = Pattern.compile("<param name=[\"']eager[\"']>([^<]*)</param>", 8);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class JUnitLoader
        extends ClassLoader {
            private final ClassLoader junit;

            public JUnitLoader(ClassLoader classLoader, ClassLoader classLoader2) {
                super(classLoader);
                this.junit = classLoader2;
            }

            @Override
            protected Class<?> findClass(String string) throws ClassNotFoundException {
                if (this.isUnit(string)) {
                    return this.junit.loadClass(string);
                }
                return super.findClass(string);
            }

            @Override
            public URL findResource(String string) {
                if (this.isUnit(string)) {
                    return this.junit.getResource(string);
                }
                if (string.equals("META-INF/services/java.util.logging.Handler")) {
                    return this.junit.getResource("org/netbeans/junit/internal/FakeMetaInf.txt");
                }
                return super.findResource(string);
            }

            @Override
            public Enumeration<URL> findResources(String string) throws IOException {
                if (this.isUnit(string)) {
                    return this.junit.getResources(string);
                }
                if (string.equals("META-INF/services/java.util.logging.Handler")) {
                    return this.junit.getResources("org/netbeans/junit/internal/FakeMetaInf.txt");
                }
                return super.findResources(string);
            }

            private final boolean isUnit(String string) {
                if (string.startsWith("junit")) {
                    return true;
                }
                if (string.startsWith("org.junit") || string.startsWith("org/junit")) {
                    return true;
                }
                if (string.startsWith("org.netbeans.junit") || string.startsWith("org/netbeans/junit")) {
                    return !string.startsWith("org.netbeans.junit.ide") && !string.startsWith("org/netbeans/junit/ide");
                }
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Item {
        boolean isTestCase;
        Class<?> clazz;
        String[] fileNames;

        public Item(boolean bl, Class<?> clazz, String[] stringArray) {
            this.isTestCase = bl;
            this.clazz = clazz;
            this.fileNames = stringArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Configuration {
        final List<Item> tests;
        final Class<? extends TestCase> latestTestCaseClass;
        final List<String> clusterRegExp;
        final List<String> moduleRegExp;
        final ClassLoader parentClassLoader;
        final boolean reuseUserDir;
        final boolean gui;
        final boolean enableClasspathModules;
        final boolean honorAutoEager;
        final Level failOnMessage;
        final Level failOnException;

        private Configuration(List<String> list, List<String> list2, ClassLoader classLoader, List<Item> list3, Class<? extends TestCase> clazz, boolean bl, boolean bl2, boolean bl3, boolean bl4, Level level, Level level2) {
            this.clusterRegExp = list;
            this.moduleRegExp = list2;
            this.parentClassLoader = classLoader;
            this.tests = list3;
            this.reuseUserDir = bl;
            this.latestTestCaseClass = clazz;
            this.gui = bl2;
            this.enableClasspathModules = bl3;
            this.honorAutoEager = bl4;
            this.failOnException = level2;
            this.failOnMessage = level;
        }

        static Configuration create(Class<? extends TestCase> clazz) {
            return new Configuration(null, null, ClassLoader.getSystemClassLoader().getParent(), Collections.<Item>emptyList(), clazz, false, true, true, false, null, null);
        }

        public Configuration clusters(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.clusterRegExp != null) {
                arrayList.addAll(this.clusterRegExp);
            }
            if (string != null) {
                arrayList.add(string);
            }
            if (arrayList.isEmpty()) {
                arrayList = null;
            }
            return new Configuration(arrayList, this.moduleRegExp, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Configuration enableModules(String string) {
            if (string == null) {
                return this;
            }
            return this.enableModules(".*", string);
        }

        public Configuration enableModules(String string, String string2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.moduleRegExp != null) {
                arrayList.addAll(this.moduleRegExp);
            }
            arrayList.add(string);
            arrayList.add(string2);
            return new Configuration(this.clusterRegExp, arrayList, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        Configuration classLoader(ClassLoader classLoader) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, classLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Configuration addTest(String ... stringArray) {
            if (this.latestTestCaseClass == null) {
                throw new IllegalStateException();
            }
            ArrayList<Item> arrayList = new ArrayList<Item>(this.tests);
            arrayList.add(new Item(true, this.latestTestCaseClass, stringArray));
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.parentClassLoader, arrayList, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Configuration addTest(Class<? extends TestCase> clazz, String ... stringArray) {
            if (clazz.equals(this.latestTestCaseClass)) {
                return this.addTest(stringArray);
            }
            ArrayList<Item> arrayList = new ArrayList<Item>(this.tests);
            this.addLatest(arrayList);
            if (stringArray != null && stringArray.length != 0) {
                arrayList.add(new Item(true, clazz, stringArray));
            }
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.parentClassLoader, arrayList, clazz, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Configuration addTest(Class<? extends Test> clazz) {
            if (TestCase.class.isAssignableFrom(clazz)) {
                Class<TestCase> clazz2 = clazz.asSubclass(TestCase.class);
                return this.addTest(clazz2, new String[0]);
            }
            ArrayList<Item> arrayList = new ArrayList<Item>(this.tests);
            arrayList.add(new Item(false, clazz, null));
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.parentClassLoader, arrayList, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Configuration enableClasspathModules(boolean bl) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, bl, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Configuration honorAutoloadEager(boolean bl) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, bl, this.failOnMessage, this.failOnException);
        }

        public Configuration failOnMessage(Level level) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, level, this.failOnException);
        }

        public Configuration failOnException(Level level) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, level);
        }

        private void addLatest(List<Item> list) {
            if (this.latestTestCaseClass == null) {
                return;
            }
            for (Item item : list) {
                if (!item.clazz.equals(this.latestTestCaseClass)) continue;
                return;
            }
            list.add(new Item(true, this.latestTestCaseClass, null));
        }

        private Configuration getReady() {
            ArrayList<Item> arrayList = new ArrayList<Item>(this.tests);
            this.addLatest(arrayList);
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.parentClassLoader, arrayList, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Configuration gui(boolean bl) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, bl, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Configuration reuseUserDir(boolean bl) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.parentClassLoader, this.tests, this.latestTestCaseClass, bl, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }
    }
}

