/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.startup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.mobility.cldcplatform.startup.LibraryConverter;
import org.netbeans.modules.mobility.cldcplatform.startup.PostInstallJ2meAction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInstall;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DefaultEmulatorInstall
extends ModuleInstall {
    private static final String EMU_MARKER = "emu_installed.mark";
    private static final String DSC_MARKER = "dsc_installed.mark";

    public void restored() {
        new LibraryConverter();
        this.installEmulators();
        this.installDescriptors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installDescriptors() {
        FileObject fileObject;
        FileObject fileObject2 = FileUtil.getConfigFile((String)"emulator-descriptor-inst");
        try {
            fileObject = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)"Services/Platforms/org-netbeans-api-java-Platform");
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return;
        }
        byte[] byArray = new byte[256];
        if (fileObject2 != null) {
            for (FileObject fileObject3 : fileObject2.getChildren()) {
                InputStream inputStream = null;
                OutputStreamWriter outputStreamWriter = null;
                FileLock fileLock = null;
                File file = FileUtil.toFile((FileObject)fileObject3);
                if (!file.isFile() || (file = file.getParentFile()) == null || (file = file.getParentFile()) == null || (file = file.getParentFile()) == null || !fileObject3.getExt().equals("xml")) continue;
                if (fileObject.getFileObject(fileObject3.getNameExt()) != null) {
                    ErrorManager.getDefault().log("Emulator description file already installed: " + file.getAbsolutePath());
                    continue;
                }
                try {
                    int n;
                    inputStream = fileObject3.getInputStream();
                    StringBuffer stringBuffer = new StringBuffer(1024);
                    while ((n = inputStream.read(byArray)) != -1) {
                        stringBuffer.append(new String(byArray, 0, n, "UTF-8"));
                    }
                    inputStream.close();
                    inputStream = null;
                    FileObject fileObject4 = fileObject.createData(fileObject3.getNameExt());
                    fileLock = fileObject4.lock();
                    outputStreamWriter = new OutputStreamWriter(fileObject4.getOutputStream(fileLock), "UTF8");
                    outputStreamWriter.write(MessageFormat.format(stringBuffer.toString(), XMLUtil.toAttributeValue((String)file.getAbsolutePath())));
                    outputStreamWriter.close();
                    outputStreamWriter = null;
                    fileObject3.delete();
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (outputStreamWriter != null) {
                        try {
                            outputStreamWriter.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fileLock != null && fileLock.isValid()) {
                        fileLock.releaseLock();
                    }
                }
            }
        }
    }

    public void installEmulators() {
        File[] fileArray = this.getAvailableEmulators();
        if (fileArray == null || fileArray.length <= 0) {
            ErrorManager.getDefault().log(1, "No emulator available");
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            File file2 = this.getTargetFolder(file);
            String string = this.getEmulatorRootInPack(file);
            if (string == null || file2 == null) continue;
            File file3 = new File(file2, string);
            if (new File(file3, EMU_MARKER).exists()) {
                String string2;
                this.checkJavaPath(file3);
                ErrorManager.getDefault().log(1, "Emulator already installed: " + file.getAbsolutePath());
                if (new File(file3, DSC_MARKER).exists()) continue;
                try {
                    string2 = file3.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string2 = file3.getAbsolutePath();
                }
                if (this.installDescriptionFile(file, string2)) continue;
                ErrorManager.getDefault().log("Emulator description file already installed: " + file.getAbsolutePath());
                continue;
            }
            this.installEmulator(file, file2, string);
        }
    }

    private File[] getAvailableEmulators() {
        ArrayList<File> arrayList = new ArrayList<File>();
        InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
        File file = installedFileLocator.locate("emulators-inst", "org.netbeans.modules.kjava.emulators", false);
        if (file == null || !file.exists() || !file.isDirectory()) {
            return new File[0];
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string;
                File file2 = fileArray[i];
                if (!file2.exists() || !file2.isFile() || this.isAlreadyInstalled(file2) || !(string = file2.getName().toLowerCase()).endsWith(".zip") && !string.endsWith(".jar")) continue;
                arrayList.add(file2);
            }
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private boolean isAlreadyInstalled(File file) {
        String[] stringArray = this.getDescriptionFile(file);
        if (stringArray == null || stringArray.length != 2) {
            return false;
        }
        FileObject fileObject = FileUtil.getConfigFile((String)"Services/Platforms/org-netbeans-api-java-Platform");
        FileObject fileObject2 = fileObject.getFileObject(stringArray[0]);
        if (fileObject2 != null) {
            JavaPlatform[] javaPlatformArray;
            File file2 = this.getTargetFolder(file);
            String string = this.getEmulatorRootInPack(file);
            File file3 = new File(file2, string);
            Document document = null;
            try {
                document = XMLUtil.parse((InputSource)new InputSource(fileObject2.getInputStream()), (boolean)false, (boolean)false, null, (EntityResolver)new EntityResolver(){

                    public InputSource resolveEntity(String string, String string2) {
                        return new InputSource(new ByteArrayInputStream(new byte[0]));
                    }
                });
            }
            catch (Exception exception) {
                return false;
            }
            Attr attr = document.getDocumentElement().getAttributeNode("displayname");
            if (attr == null) {
                return false;
            }
            String string2 = attr.getValue();
            for (JavaPlatform javaPlatform : javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms()) {
                String string3 = javaPlatform.getDisplayName();
                if (!string3.equals(string2)) continue;
                for (FileObject fileObject3 : javaPlatform.getInstallFolders()) {
                    if (file3.getAbsolutePath().equals(FileUtil.toFile((FileObject)fileObject3).getAbsolutePath())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private String archiveName2FolderName(File file) {
        if (file != null) {
            String string = file.getName().toLowerCase();
            if (string.endsWith(".zip")) {
                string = string.substring(0, string.length() - ".zip".length());
            } else if (string.endsWith(".jar")) {
                string = string.substring(0, string.length() - ".jar".length());
            }
            return string;
        }
        return "unknown";
    }

    private File getTargetFolder(File file) {
        if (file == null) {
            return null;
        }
        FileObject fileObject = FileUtil.getConfigRoot();
        if (fileObject == null) {
            return null;
        }
        File file2 = FileUtil.toFile((FileObject)fileObject);
        if (file2 == null) {
            return null;
        }
        if ((file2 = file2.getParentFile()) == null) {
            return null;
        }
        return new File(file2, "emulators" + File.separator + this.archiveName2FolderName(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEmulatorRootInPack(File file) {
        if (file == null) {
            return null;
        }
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
            while (true) {
                ZipEntry zipEntry;
                if ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    int n;
                    String string = zipEntry.getName();
                    if (!zipEntry.isDirectory() && (n = (string = string.replace('\\', '/')).toLowerCase().indexOf("bin/emulator")) >= 0) {
                        String string2 = string.substring(0, n).replace('/', File.separatorChar);
                        return string2;
                    }
                    zipInputStream.closeEntry();
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().log(1, "IOException while detecting emulator pack: " + file.getAbsolutePath());
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.closeEntry();
                }
                catch (IOException iOException) {}
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private void installEmulator(final File file, final File file2, String string) {
        String string2;
        final File file3 = new File(file2, string);
        try {
            string2 = file3.getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = file3.getAbsolutePath();
        }
        file3.mkdirs();
        if (!this.installDescriptionFile(file, string2)) {
            ErrorManager.getDefault().log("Emulator description file already installed: " + file.getAbsolutePath());
        }
        final RequestProcessor requestProcessor = new RequestProcessor();
        requestProcessor.post(new Runnable(){

            public void run() {
                if (!DefaultEmulatorInstall.this.unpackEmulator(file, file2)) {
                    ErrorManager.getDefault().log("Failed to unpack emulator: " + file.getAbsolutePath());
                    return;
                }
                ErrorManager.getDefault().log("Emulator unpacked: " + file.getAbsolutePath());
                try {
                    new File(file3, DefaultEmulatorInstall.EMU_MARKER).createNewFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                DefaultEmulatorInstall.this.checkJavaPath(file3);
                requestProcessor.stop();
            }
        }, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean installDescriptionFile(File file, String string) {
        String[] stringArray = this.getDescriptionFile(file);
        if (stringArray == null || stringArray.length != 2) {
            return false;
        }
        FileObject fileObject = FileUtil.getConfigFile((String)"Services/Platforms/org-netbeans-api-java-Platform");
        if (fileObject.getFileObject(stringArray[0]) != null) {
            ErrorManager.getDefault().log("Emulator description file already installed: " + file.getAbsolutePath());
            return false;
        }
        try {
            string = XMLUtil.toAttributeValue((String)string);
        }
        catch (CharConversionException charConversionException) {
            ErrorManager.getDefault().notify((Throwable)charConversionException);
        }
        String string2 = MessageFormat.format(stringArray[1], string);
        OutputStreamWriter outputStreamWriter = null;
        FileLock fileLock = null;
        try {
            FileObject fileObject2 = fileObject.createData(stringArray[0]);
            fileLock = fileObject2.lock();
            outputStreamWriter = new OutputStreamWriter(fileObject2.getOutputStream(fileLock), "UTF8");
            outputStreamWriter.write(string2);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        finally {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException) {}
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        try {
            new File(string, DSC_MARKER).createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getDescriptionFile(File file) {
        if (file == null) {
            return null;
        }
        ZipInputStream zipInputStream = null;
        byte[] byArray = new byte[256];
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string = zipEntry.getName();
                if (!zipEntry.isDirectory() && string.indexOf(47) == -1 && string.indexOf(92) == -1 && string.toLowerCase().endsWith(".xml")) {
                    int n;
                    StringBuffer stringBuffer = new StringBuffer(1024);
                    while ((n = zipInputStream.read(byArray)) != -1) {
                        stringBuffer.append(new String(byArray, 0, n));
                    }
                    String[] stringArray = new String[]{string, stringBuffer.toString()};
                    return stringArray;
                }
                zipInputStream.closeEntry();
            }
            zipInputStream.close();
        }
        catch (IOException iOException) {
        }
        finally {
            byArray = null;
            if (zipInputStream != null) {
                try {
                    zipInputStream.closeEntry();
                }
                catch (IOException iOException) {}
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unpackEmulator(File file, File file2) {
        if (file == null) {
            return false;
        }
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File file3;
                String string = zipEntry.getName();
                if (zipEntry.isDirectory()) {
                    file3 = new File(file2, string);
                    file3.mkdirs();
                } else {
                    if (string.indexOf(47) == -1 && string.indexOf(92) == -1 && string.toLowerCase().endsWith(".xml")) {
                        zipInputStream.closeEntry();
                        continue;
                    }
                    file3 = new File(file2, string);
                    if (file3.createNewFile()) {
                        BufferedOutputStream bufferedOutputStream = null;
                        byte[] byArray = new byte[256];
                        try {
                            int n;
                            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
                            while ((n = zipInputStream.read(byArray)) != -1) {
                                bufferedOutputStream.write(byArray, 0, n);
                            }
                        }
                        finally {
                            byArray = null;
                            if (bufferedOutputStream != null) {
                                try {
                                    bufferedOutputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                }
                zipInputStream.closeEntry();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.closeEntry();
                }
                catch (IOException iOException) {}
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkJavaPath(File file) {
        String string;
        Object object;
        final String string2 = System.getProperty("java.home");
        final File file2 = new File(file, "java.mark");
        if (file2 != null && file2.exists()) {
            object = null;
            try {
                object = new BufferedReader(new FileReader(file2));
                string = ((BufferedReader)object).readLine();
                if (string != null && string.equals(string2)) {
                    return;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (object != null) {
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        try {
            object = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            object = file.getAbsolutePath();
        }
        string = object;
        final RequestProcessor requestProcessor = new RequestProcessor();
        requestProcessor.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block14: {
                    try {
                        PostInstallJ2meAction.installAction(string);
                        if (file2 == null) break block14;
                        BufferedWriter bufferedWriter = null;
                        try {
                            bufferedWriter = new BufferedWriter(new FileWriter(file2));
                            bufferedWriter.write(string2);
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            if (bufferedWriter != null) {
                                try {
                                    bufferedWriter.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                }
                requestProcessor.stop();
            }
        }, 1000);
    }
}

