/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreateElementUtilities {
    private static final Set<Tree.Kind> STOP_LOOKING_FOR_METHOD = EnumSet.of(Tree.Kind.METHOD, Tree.Kind.CLASS, Tree.Kind.COMPILATION_UNIT);

    private CreateElementUtilities() {
    }

    public static List<? extends TypeMirror> resolveType(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n, TypeMirror[] typeMirrorArray, int[] nArray) {
        switch (treePath.getLeaf().getKind()) {
            case METHOD: {
                return CreateElementUtilities.computeMethod(set, compilationInfo, treePath, typeMirrorArray, tree, n);
            }
            case MEMBER_SELECT: {
                return CreateElementUtilities.computeMemberSelect(set, compilationInfo, treePath, tree, n);
            }
            case ASSIGNMENT: {
                return CreateElementUtilities.computeAssignment(set, compilationInfo, treePath, tree, n);
            }
            case ENHANCED_FOR_LOOP: {
                return CreateElementUtilities.computeEnhancedForLoop(set, compilationInfo, treePath, tree, n);
            }
            case ARRAY_ACCESS: {
                return CreateElementUtilities.computeArrayAccess(set, compilationInfo, treePath, tree, n);
            }
            case VARIABLE: {
                return CreateElementUtilities.computeVariableDeclaration(set, compilationInfo, treePath, tree, n);
            }
            case ASSERT: {
                return CreateElementUtilities.computeAssert(set, compilationInfo, treePath, tree, n);
            }
            case PARENTHESIZED: {
                return CreateElementUtilities.computeParenthesis(set, compilationInfo, treePath, tree, n);
            }
            case DO_WHILE_LOOP: {
                return CreateElementUtilities.computePrimitiveType(set, compilationInfo, ((DoWhileLoopTree)treePath.getLeaf()).getCondition(), tree, TypeKind.BOOLEAN);
            }
            case FOR_LOOP: {
                return CreateElementUtilities.computePrimitiveType(set, compilationInfo, ((ForLoopTree)treePath.getLeaf()).getCondition(), tree, TypeKind.BOOLEAN);
            }
            case IF: {
                return CreateElementUtilities.computePrimitiveType(set, compilationInfo, ((IfTree)treePath.getLeaf()).getCondition(), tree, TypeKind.BOOLEAN);
            }
            case WHILE_LOOP: {
                return CreateElementUtilities.computePrimitiveType(set, compilationInfo, ((WhileLoopTree)treePath.getLeaf()).getCondition(), tree, TypeKind.BOOLEAN);
            }
            case SYNCHRONIZED: {
                return CreateElementUtilities.computeReferenceType(set, compilationInfo, ((SynchronizedTree)treePath.getLeaf()).getExpression(), tree, "java.lang.Object");
            }
            case THROW: {
                return CreateElementUtilities.computeReferenceType(set, compilationInfo, ((ThrowTree)treePath.getLeaf()).getExpression(), tree, "java.lang.Exception");
            }
            case INSTANCE_OF: {
                return CreateElementUtilities.computeReferenceType(set, compilationInfo, ((InstanceOfTree)treePath.getLeaf()).getExpression(), tree, "java.lang.Object");
            }
            case SWITCH: {
                return CreateElementUtilities.computePrimitiveType(set, compilationInfo, ((SwitchTree)treePath.getLeaf()).getExpression(), tree, TypeKind.INT);
            }
            case EXPRESSION_STATEMENT: {
                return Collections.singletonList(compilationInfo.getTypes().getNoType(TypeKind.VOID));
            }
            case RETURN: {
                return CreateElementUtilities.computeReturn(set, compilationInfo, treePath, tree, n);
            }
            case TYPE_PARAMETER: {
                return CreateElementUtilities.computeTypeParameter(set, compilationInfo, treePath, tree, n);
            }
            case PARAMETERIZED_TYPE: {
                return CreateElementUtilities.computeParametrizedType(set, compilationInfo, treePath, tree, n, typeMirrorArray, nArray);
            }
            case CLASS: {
                return CreateElementUtilities.computeClass(set, compilationInfo, treePath, tree, n);
            }
            case CONDITIONAL_EXPRESSION: {
                return CreateElementUtilities.computeConditionalExpression(set, compilationInfo, treePath, tree, n);
            }
            case NEW_ARRAY: {
                return CreateElementUtilities.computeNewArray(set, compilationInfo, treePath, tree, n);
            }
            case METHOD_INVOCATION: {
                return CreateElementUtilities.computeMethodInvocation(set, compilationInfo, treePath, tree, n);
            }
            case NEW_CLASS: {
                return CreateElementUtilities.computeNewClass(set, compilationInfo, treePath, tree, n);
            }
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case UNARY_PLUS: 
            case UNARY_MINUS: 
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: {
                return CreateElementUtilities.computeUnary(set, compilationInfo, treePath, tree, n);
            }
            case MULTIPLY: 
            case DIVIDE: 
            case REMAINDER: 
            case PLUS: 
            case MINUS: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN_EQUAL: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: 
            case AND: 
            case XOR: 
            case OR: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: {
                return CreateElementUtilities.computeBinaryOperator(set, compilationInfo, treePath, tree, n);
            }
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case OR_ASSIGNMENT: {
                return null;
            }
            case ARRAY_TYPE: 
            case BLOCK: 
            case BREAK: 
            case CATCH: 
            case COMPILATION_UNIT: 
            case CONTINUE: 
            case IMPORT: 
            case IDENTIFIER: 
            case TYPE_CAST: 
            case TRY: 
            case EMPTY_STATEMENT: 
            case PRIMITIVE_TYPE: 
            case LABELED_STATEMENT: 
            case MODIFIERS: 
            case ERRONEOUS: 
            case OTHER: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case FLOAT_LITERAL: 
            case DOUBLE_LITERAL: 
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case STRING_LITERAL: 
            case NULL_LITERAL: {
                return null;
            }
            case CASE: 
            case ANNOTATION: 
            case UNBOUNDED_WILDCARD: 
            case EXTENDS_WILDCARD: 
            case SUPER_WILDCARD: {
                return null;
            }
        }
        return null;
    }

    private static List<? extends TypeMirror> computeBinaryOperator(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        BinaryTree binaryTree = (BinaryTree)treePath.getLeaf();
        TreePath treePath2 = null;
        if (binaryTree.getLeftOperand() == tree) {
            treePath2 = new TreePath(treePath, binaryTree.getRightOperand());
        }
        if (binaryTree.getRightOperand() == tree) {
            treePath2 = new TreePath(treePath, binaryTree.getLeftOperand());
        }
        set.add(ElementKind.PARAMETER);
        set.add(ElementKind.LOCAL_VARIABLE);
        set.add(ElementKind.FIELD);
        return treePath2 != null ? Collections.singletonList(compilationInfo.getTrees().getTypeMirror(treePath2)) : null;
    }

    private static List<? extends TypeMirror> computeMethod(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, TypeMirror[] typeMirrorArray, Tree tree, int n) {
        List<? extends ExpressionTree> list;
        MethodTree methodTree = (MethodTree)treePath.getLeaf();
        if (methodTree.getReturnType() == tree) {
            set.add(ElementKind.CLASS);
            set.add(ElementKind.INTERFACE);
            set.add(ElementKind.ENUM);
        }
        if ((list = methodTree.getThrows()) != null && !list.isEmpty()) {
            for (ExpressionTree expressionTree : list) {
                if (expressionTree != tree) continue;
                set.add(ElementKind.CLASS);
                typeMirrorArray[0] = compilationInfo.getElements().getTypeElement("java.lang.Exception").asType();
                break;
            }
        }
        if (methodTree.getBody() == null) {
            return null;
        }
        try {
            Document document = compilationInfo.getDocument();
            if (document != null) {
                int n2 = org.netbeans.modules.java.editor.semantic.Utilities.findBodyStart((Tree)treePath.getLeaf(), (CompilationUnitTree)compilationInfo.getCompilationUnit(), (SourcePositions)compilationInfo.getTrees().getSourcePositions(), (Document)document);
                int n3 = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), treePath.getLeaf());
                set.add(ElementKind.PARAMETER);
                set.add(ElementKind.LOCAL_VARIABLE);
                set.add(ElementKind.FIELD);
                if (n2 <= n && n <= n3) {
                    return Collections.singletonList(compilationInfo.getElements().getTypeElement("java.lang.Object").asType());
                }
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, iOException.getMessage(), iOException);
        }
        return null;
    }

    private static List<? extends TypeMirror> computeMemberSelect(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        MemberSelectTree memberSelectTree = (MemberSelectTree)treePath.getLeaf();
        TypeElement typeElement = compilationInfo.getElements().getTypeElement("java.lang.Object");
        if (typeElement != null && !"class".equals(memberSelectTree.getIdentifier().toString())) {
            set.add(ElementKind.FIELD);
            set.add(ElementKind.CLASS);
            return Collections.singletonList(typeElement.asType());
        }
        return null;
    }

    private static List<? extends TypeMirror> computeAssignment(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        AssignmentTree assignmentTree = (AssignmentTree)treePath.getLeaf();
        TypeMirror typeMirror = null;
        if (assignmentTree.getVariable() == tree) {
            typeMirror = compilationInfo.getTrees().getTypeMirror(new TreePath(treePath, assignmentTree.getExpression()));
            if ((typeMirror = Utilities.convertIfAnonymous(typeMirror)).getKind() == TypeKind.EXECUTABLE) {
                typeMirror = ((ExecutableType)typeMirror).getReturnType();
            }
        }
        if (assignmentTree.getExpression() == tree) {
            typeMirror = compilationInfo.getTrees().getTypeMirror(new TreePath(treePath, assignmentTree.getVariable()));
        }
        if (typeMirror == null) {
            if (ErrorHintsProvider.ERR.isLoggable(1)) {
                ErrorHintsProvider.ERR.log(1, "offset=" + n);
                ErrorHintsProvider.ERR.log(1, "errorTree=" + tree);
                ErrorHintsProvider.ERR.log(1, "type=null");
            }
            return null;
        }
        set.add(ElementKind.PARAMETER);
        set.add(ElementKind.LOCAL_VARIABLE);
        set.add(ElementKind.FIELD);
        return Collections.singletonList(typeMirror);
    }

    private static List<? extends TypeMirror> computeEnhancedForLoop(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        EnhancedForLoopTree enhancedForLoopTree = (EnhancedForLoopTree)treePath.getLeaf();
        if (enhancedForLoopTree.getExpression() != tree) {
            return null;
        }
        TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(new TreePath(new TreePath(treePath, enhancedForLoopTree.getVariable()), enhancedForLoopTree.getVariable().getType()));
        if (typeMirror == null) {
            return null;
        }
        if (typeMirror.getKind().isPrimitive()) {
            set.add(ElementKind.PARAMETER);
            set.add(ElementKind.LOCAL_VARIABLE);
            set.add(ElementKind.FIELD);
            return Collections.singletonList(compilationInfo.getTypes().getArrayType(typeMirror));
        }
        TypeElement typeElement = compilationInfo.getElements().getTypeElement("java.lang.Iterable");
        if (typeElement == null) {
            return null;
        }
        set.add(ElementKind.PARAMETER);
        set.add(ElementKind.LOCAL_VARIABLE);
        set.add(ElementKind.FIELD);
        return Collections.singletonList(compilationInfo.getTypes().getDeclaredType(typeElement, typeMirror));
    }

    private static List<? extends TypeMirror> computeArrayAccess(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        ArrayAccessTree arrayAccessTree = (ArrayAccessTree)treePath.getLeaf();
        if (arrayAccessTree.getExpression() == tree) {
            TreePath treePath2 = treePath.getParentPath();
            List<? extends TypeMirror> list = CreateElementUtilities.resolveType(set, compilationInfo, treePath2, arrayAccessTree, n, null, null);
            if (list == null) {
                return null;
            }
            ArrayList<ArrayType> arrayList = new ArrayList<ArrayType>();
            block3: for (TypeMirror typeMirror : list) {
                if (typeMirror == null) continue;
                switch (typeMirror.getKind()) {
                    case VOID: 
                    case EXECUTABLE: 
                    case WILDCARD: 
                    case PACKAGE: {
                        continue block3;
                    }
                }
                arrayList.add(compilationInfo.getTypes().getArrayType(typeMirror));
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            return arrayList;
        }
        if (arrayAccessTree.getIndex() == tree) {
            set.add(ElementKind.PARAMETER);
            set.add(ElementKind.LOCAL_VARIABLE);
            set.add(ElementKind.FIELD);
            return Collections.singletonList(compilationInfo.getTypes().getPrimitiveType(TypeKind.INT));
        }
        return null;
    }

    private static List<? extends TypeMirror> computeVariableDeclaration(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        VariableTree variableTree = (VariableTree)treePath.getLeaf();
        if (variableTree.getInitializer() == tree) {
            set.add(ElementKind.PARAMETER);
            set.add(ElementKind.LOCAL_VARIABLE);
            set.add(ElementKind.FIELD);
            return Collections.singletonList(compilationInfo.getTrees().getTypeMirror(new TreePath(treePath, variableTree.getType())));
        }
        TreePath treePath2 = treePath.getParentPath();
        if (variableTree.getType() != tree || treePath2 == null) {
            return null;
        }
        switch (treePath2.getLeaf().getKind()) {
            case ENHANCED_FOR_LOOP: {
                ExpressionTree expressionTree = ((EnhancedForLoopTree)treePath2.getLeaf()).getExpression();
                TreePath treePath3 = new TreePath(treePath2, expressionTree);
                TypeMirror typeMirror = Utilities.getIterableGenericType(compilationInfo, treePath3);
                set.add(ElementKind.LOCAL_VARIABLE);
                return Collections.singletonList(typeMirror);
            }
        }
        set.add(ElementKind.CLASS);
        return Collections.emptyList();
    }

    private static List<? extends TypeMirror> computeAssert(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        AssertTree assertTree = (AssertTree)treePath.getLeaf();
        set.add(ElementKind.PARAMETER);
        set.add(ElementKind.LOCAL_VARIABLE);
        set.add(ElementKind.FIELD);
        if (assertTree.getCondition() == tree) {
            return Collections.singletonList(compilationInfo.getTypes().getPrimitiveType(TypeKind.BOOLEAN));
        }
        if (assertTree.getDetail() == tree) {
            return Collections.singletonList(compilationInfo.getElements().getTypeElement("java.lang.Object").asType());
        }
        return null;
    }

    private static List<? extends TypeMirror> computeParenthesis(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        ParenthesizedTree parenthesizedTree = (ParenthesizedTree)treePath.getLeaf();
        if (parenthesizedTree.getExpression() != tree) {
            return null;
        }
        TreePath treePath2 = treePath.getParentPath();
        List<? extends TypeMirror> list = CreateElementUtilities.resolveType(set, compilationInfo, treePath2, parenthesizedTree, n, null, null);
        if (list == null) {
            return null;
        }
        return list;
    }

    private static List<? extends TypeMirror> computeConditionalExpression(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        ConditionalExpressionTree conditionalExpressionTree = (ConditionalExpressionTree)treePath.getLeaf();
        if (conditionalExpressionTree.getCondition() == tree) {
            set.add(ElementKind.PARAMETER);
            set.add(ElementKind.LOCAL_VARIABLE);
            set.add(ElementKind.FIELD);
            return Collections.singletonList(compilationInfo.getTypes().getPrimitiveType(TypeKind.BOOLEAN));
        }
        if (conditionalExpressionTree.getTrueExpression() == tree || conditionalExpressionTree.getFalseExpression() == tree) {
            set.add(ElementKind.PARAMETER);
            set.add(ElementKind.LOCAL_VARIABLE);
            set.add(ElementKind.FIELD);
            return CreateElementUtilities.resolveType(set, compilationInfo, treePath.getParentPath(), conditionalExpressionTree, n, null, null);
        }
        return null;
    }

    private static List<? extends TypeMirror> computePrimitiveType(Set<ElementKind> set, CompilationInfo compilationInfo, Tree tree, Tree tree2, TypeKind typeKind) {
        if (tree == tree2) {
            set.add(ElementKind.PARAMETER);
            set.add(ElementKind.LOCAL_VARIABLE);
            set.add(ElementKind.FIELD);
            return Collections.singletonList(compilationInfo.getTypes().getPrimitiveType(typeKind));
        }
        return null;
    }

    private static List<? extends TypeMirror> computeReferenceType(Set<ElementKind> set, CompilationInfo compilationInfo, Tree tree, Tree tree2, String string) {
        if (tree == tree2) {
            set.add(ElementKind.PARAMETER);
            set.add(ElementKind.LOCAL_VARIABLE);
            set.add(ElementKind.FIELD);
            return Collections.singletonList(compilationInfo.getElements().getTypeElement(string).asType());
        }
        return null;
    }

    private static List<? extends TypeMirror> computeUnary(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        UnaryTree unaryTree = (UnaryTree)treePath.getLeaf();
        if (unaryTree.getExpression() == tree) {
            List<? extends TypeMirror> list = CreateElementUtilities.resolveType(set, compilationInfo, treePath.getParentPath(), unaryTree, n, null, null);
            if (list != null) {
                if (list.size() != 1) {
                    return list;
                }
                if (list.get(0).getKind() != TypeKind.VOID) {
                    return list;
                }
            }
            set.add(ElementKind.PARAMETER);
            set.add(ElementKind.LOCAL_VARIABLE);
            set.add(ElementKind.FIELD);
            return Collections.singletonList(compilationInfo.getTypes().getPrimitiveType(TypeKind.INT));
        }
        return null;
    }

    private static List<? extends TypeMirror> computeReturn(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        ReturnTree returnTree = (ReturnTree)treePath.getLeaf();
        if (returnTree.getExpression() == tree) {
            TreePath treePath2 = CreateElementUtilities.findMethod(treePath);
            if (treePath2 == null) {
                return null;
            }
            Element element = compilationInfo.getTrees().getElement(treePath2);
            if (element == null || element.getKind() != ElementKind.METHOD) {
                return null;
            }
            set.add(ElementKind.PARAMETER);
            set.add(ElementKind.LOCAL_VARIABLE);
            set.add(ElementKind.FIELD);
            return Collections.singletonList(((ExecutableElement)element).getReturnType());
        }
        return null;
    }

    private static List<? extends TypeMirror> computeTypeParameter(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        TypeParameterTree typeParameterTree = (TypeParameterTree)treePath.getLeaf();
        for (Tree tree2 : typeParameterTree.getBounds()) {
            if (tree2 != tree) continue;
            set.add(ElementKind.CLASS);
            return null;
        }
        return null;
    }

    private static List<? extends TypeMirror> computeParametrizedType(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n, TypeMirror[] typeMirrorArray, int[] nArray) {
        ParameterizedTypeTree parameterizedTypeTree = (ParameterizedTypeTree)treePath.getLeaf();
        if (parameterizedTypeTree.getType() == tree) {
            set.add(ElementKind.CLASS);
            set.add(ElementKind.INTERFACE);
            if (nArray != null) {
                nArray[0] = parameterizedTypeTree.getTypeArguments().size();
            }
            return null;
        }
        TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(treePath);
        DeclaredType declaredType = null;
        if (typeMirror != null && typeMirror.getKind() == TypeKind.DECLARED) {
            declaredType = (DeclaredType)typeMirror;
        }
        int n2 = 0;
        for (Tree tree2 : parameterizedTypeTree.getTypeArguments()) {
            if (tree2 == tree) {
                List<? extends TypeMirror> list;
                if (declaredType != null && typeMirrorArray != null && (list = ((DeclaredType)declaredType.asElement().asType()).getTypeArguments()).size() > n2) {
                    typeMirrorArray[0] = ((TypeVariable)list.get(n2)).getUpperBound();
                }
                set.add(ElementKind.CLASS);
                return null;
            }
            ++n2;
        }
        return null;
    }

    private static List<? extends TypeMirror> computeClass(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        ClassTree classTree = (ClassTree)treePath.getLeaf();
        if (classTree.getExtendsClause() == tree) {
            set.add(ElementKind.CLASS);
            return null;
        }
        for (Tree tree2 : classTree.getImplementsClause()) {
            if (tree2 != tree) continue;
            set.add(ElementKind.INTERFACE);
            return null;
        }
        return null;
    }

    private static List<? extends TypeMirror> computeNewArray(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        NewArrayTree newArrayTree = (NewArrayTree)treePath.getLeaf();
        if (newArrayTree.getType() == tree) {
            set.add(ElementKind.CLASS);
            set.add(ElementKind.ENUM);
            set.add(ElementKind.INTERFACE);
            return null;
        }
        for (ExpressionTree expressionTree : newArrayTree.getDimensions()) {
            if (expressionTree != tree) continue;
            set.add(ElementKind.PARAMETER);
            set.add(ElementKind.LOCAL_VARIABLE);
            set.add(ElementKind.FIELD);
            return Collections.singletonList(compilationInfo.getTypes().getPrimitiveType(TypeKind.INT));
        }
        for (ExpressionTree expressionTree : newArrayTree.getInitializers()) {
            if (expressionTree != tree) continue;
            TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(treePath);
            if (typeMirror == null || typeMirror.getKind() != TypeKind.ARRAY) {
                return null;
            }
            set.add(ElementKind.PARAMETER);
            set.add(ElementKind.LOCAL_VARIABLE);
            set.add(ElementKind.FIELD);
            return Collections.singletonList(((ArrayType)typeMirror).getComponentType());
        }
        return null;
    }

    private static List<? extends TypeMirror> computeMethodInvocation(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)treePath.getLeaf();
        boolean bl = false;
        for (ExpressionTree object : methodInvocationTree.getArguments()) {
            bl |= object == tree;
        }
        if (bl) {
            TypeMirror[] typeMirrorArray = new TypeMirror[1];
            int[] nArray = new int[1];
            ExecutableElement executableElement = org.netbeans.modules.editor.java.Utilities.fuzzyResolveMethodInvocation((CompilationInfo)compilationInfo, (TreePath)treePath, (TypeMirror[])typeMirrorArray, (int[])nArray);
            if (executableElement == null) {
                return null;
            }
            set.add(ElementKind.PARAMETER);
            set.add(ElementKind.LOCAL_VARIABLE);
            set.add(ElementKind.FIELD);
            return Collections.singletonList(typeMirrorArray[0]);
        }
        return null;
    }

    private static List<? extends TypeMirror> computeNewClass(Set<ElementKind> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        NewClassTree newClassTree = (NewClassTree)treePath.getLeaf();
        boolean bl = false;
        for (ExpressionTree object : newClassTree.getArguments()) {
            bl |= object == tree;
        }
        if (bl) {
            TypeMirror[] typeMirrorArray = new TypeMirror[1];
            int[] nArray = new int[1];
            ExecutableElement executableElement = org.netbeans.modules.editor.java.Utilities.fuzzyResolveMethodInvocation((CompilationInfo)compilationInfo, (TreePath)treePath, (TypeMirror[])typeMirrorArray, (int[])nArray);
            if (executableElement == null) {
                return null;
            }
            set.add(ElementKind.PARAMETER);
            set.add(ElementKind.LOCAL_VARIABLE);
            set.add(ElementKind.FIELD);
            return Collections.singletonList(typeMirrorArray[0]);
        }
        return null;
    }

    private static TreePath findMethod(TreePath treePath) {
        while (!STOP_LOOKING_FOR_METHOD.contains((Object)treePath.getLeaf().getKind())) {
            treePath = treePath.getParentPath();
        }
        if (treePath.getLeaf().getKind() == Tree.Kind.METHOD) {
            return treePath;
        }
        return null;
    }
}

