/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spi;

import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.modules.java.hints.spi.TreeRule;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbPreferences;

public abstract class AbstractHint
implements TreeRule {
    private boolean enableDefault;
    private boolean showInTaskListDefault;
    private HintSeverity severityDefault;
    private String[] suppressBy;

    public AbstractHint(boolean bl, boolean bl2, HintSeverity hintSeverity, String ... stringArray) {
        this.enableDefault = bl;
        this.showInTaskListDefault = bl2;
        this.severityDefault = hintSeverity;
        this.suppressBy = stringArray;
    }

    public Preferences getPreferences(String string) {
        Preferences preferences;
        Map<String, Preferences> map = HintsSettings.getPreferencesOverride();
        if (map != null && (preferences = map.get(this.getId())) != null) {
            return preferences;
        }
        string = string == null ? HintsSettings.getCurrentProfileId() : string;
        return NbPreferences.forModule(this.getClass()).node(string).node(this.getId());
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    public abstract String getDescription();

    public final boolean isEnabled() {
        return HintsSettings.isEnabled(this, this.getPreferences(HintsSettings.getCurrentProfileId()));
    }

    public final HintSeverity getSeverity() {
        return HintsSettings.getSeverity(this, this.getPreferences(HintsSettings.getCurrentProfileId()));
    }

    static {
        HintsSettings.HINTS_ACCESSOR = new HintAccessorImpl();
    }

    private static class HintAccessorImpl
    implements HintsSettings.HintsAccessor {
        private HintAccessorImpl() {
        }

        public boolean isEnabledDefault(AbstractHint abstractHint) {
            return abstractHint.enableDefault;
        }

        public boolean isShowInTaskListDefault(AbstractHint abstractHint) {
            return abstractHint.showInTaskListDefault;
        }

        public HintSeverity severiryDefault(AbstractHint abstractHint) {
            return abstractHint.severityDefault;
        }

        public String[] getSuppressBy(AbstractHint abstractHint) {
            return abstractHint.suppressBy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HintSeverity {
        ERROR,
        WARNING,
        CURRENT_LINE_WARNING;


        public Severity toEditorSeverity() {
            switch (this) {
                case ERROR: {
                    return Severity.ERROR;
                }
                case WARNING: {
                    return Severity.VERIFIER;
                }
                case CURRENT_LINE_WARNING: {
                    return Severity.HINT;
                }
            }
            return null;
        }
    }
}

