/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmDisplayUtilities {
    private static final boolean SKIP_COLORING = Boolean.getBoolean("cnd.test.skip.coloring");

    private CsmDisplayUtilities() {
    }

    public static String getContextLineHtml(CsmFile csmFile, int n, int n2, boolean bl) {
        CloneableEditorSupport cloneableEditorSupport = CsmUtilities.findCloneableEditorSupport(csmFile);
        StyledDocument styledDocument = null;
        try {
            styledDocument = cloneableEditorSupport.openDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = null;
        if (styledDocument instanceof BaseDocument) {
            BaseDocument baseDocument = (BaseDocument)styledDocument;
            try {
                int n3 = n;
                int n4 = n2;
                int n5 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n3);
                int n6 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n4) + 1;
                if (!bl) {
                    n3 = -1;
                    n4 = -1;
                }
                string = CsmDisplayUtilities.getLineHtml(n5, n6, n3, n4, baseDocument);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return string;
    }

    public static String getContextLine(CsmFile csmFile, int n, int n2) {
        CloneableEditorSupport cloneableEditorSupport = CsmUtilities.findCloneableEditorSupport(csmFile);
        StyledDocument styledDocument = null;
        try {
            styledDocument = cloneableEditorSupport.openDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = null;
        if (styledDocument instanceof BaseDocument) {
            BaseDocument baseDocument = (BaseDocument)styledDocument;
            try {
                int n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                int n4 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n2) + 1;
                string = baseDocument.getText(n3, n4 - n3);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return string;
    }

    public static String getLineHtml(int n, int n2, int n3, int n4, BaseDocument baseDocument) throws BadLocationException {
        int n5 = n3 - n;
        int n6 = n4 - n;
        String string = baseDocument.getText(n, n2 - n);
        String string2 = (String)baseDocument.getProperty((Object)"mimeType");
        if (n5 >= 0 && n6 >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(CsmDisplayUtilities.getHtml(string2, CsmDisplayUtilities.trimStart(string.substring(0, n5))));
            stringBuilder.append("<b>");
            stringBuilder.append(CsmDisplayUtilities.getHtml(string2, string.substring(n5, n6)));
            stringBuilder.append("</b>");
            stringBuilder.append(CsmDisplayUtilities.getHtml(string2, CsmDisplayUtilities.trimEnd(string.substring(n6))));
            return stringBuilder.toString();
        }
        return CsmDisplayUtilities.getHtml(string2, string);
    }

    public static String getHtml(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        Language language = CndLexerUtilities.getLanguage((String)string);
        if (language == null) {
            return string2;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)string2, (Language)language);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        CsmDisplayUtilities.appendHtml(stringBuilder, tokenSequence);
        return stringBuilder.toString();
    }

    public static CharSequence getTooltipText(CsmObject csmObject) {
        CharSequence charSequence = null;
        if (CsmKindUtilities.isMethod((CsmObject)csmObject)) {
            CharSequence charSequence2 = CsmDisplayUtilities.getFunctionText((CsmFunction)csmObject);
            CsmClass csmClass = ((CsmMember)csmObject).getContainingClass();
            CharSequence charSequence3 = csmClass.getQualifiedName();
            String string = "DSC_MethodTooltip";
            if (CsmKindUtilities.isConstructor((CsmObject)csmObject)) {
                string = "DSC_ConstructorTooltip";
            } else if (CsmKindUtilities.isDestructor((CsmObject)csmObject)) {
                string = "DSC_DestructorTooltip";
            }
            charSequence = CsmDisplayUtilities.getHtmlizedString(string, charSequence2, charSequence3);
        } else if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
            CharSequence charSequence4 = CsmDisplayUtilities.getFunctionText((CsmFunction)csmObject);
            charSequence = CsmDisplayUtilities.getHtmlizedString("DSC_FunctionTooltip", charSequence4);
        } else if (CsmKindUtilities.isClass((CsmObject)csmObject)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)csmObject).getKind();
            String string = kind == CsmDeclaration.Kind.STRUCT ? "DSC_StructTooltip" : (kind == CsmDeclaration.Kind.UNION ? "DSC_UnionTooltip" : "DSC_ClassTooltip");
            charSequence = CsmDisplayUtilities.getHtmlizedString(string, ((CsmClassifier)csmObject).getQualifiedName());
        } else if (CsmKindUtilities.isTypedef((CsmObject)csmObject)) {
            CharSequence charSequence5 = ((CsmTypedef)csmObject).getQualifiedName();
            charSequence = CsmDisplayUtilities.getHtmlizedString("DSC_TypedefTooltip", charSequence5, ((CsmTypedef)csmObject).getText());
        } else if (CsmKindUtilities.isEnum((CsmObject)csmObject)) {
            charSequence = CsmDisplayUtilities.getHtmlizedString("DSC_EnumTooltip", ((CsmEnum)csmObject).getQualifiedName());
        } else if (CsmKindUtilities.isEnumerator((Object)csmObject)) {
            CsmEnumerator csmEnumerator = (CsmEnumerator)csmObject;
            charSequence = CsmDisplayUtilities.getHtmlizedString("DSC_EnumeratorTooltip", csmEnumerator.getName(), csmEnumerator.getEnumeration().getQualifiedName());
        } else if (CsmKindUtilities.isField((CsmObject)csmObject)) {
            CharSequence charSequence6 = ((CsmField)csmObject).getName();
            CsmClass csmClass = ((CsmField)csmObject).getContainingClass();
            CharSequence charSequence7 = csmClass.getQualifiedName();
            String string = "class";
            if (csmClass.getKind() == CsmDeclaration.Kind.STRUCT) {
                string = "struct";
            } else if (csmClass.getKind() == CsmDeclaration.Kind.UNION) {
                string = "union";
            }
            charSequence = CsmDisplayUtilities.getHtmlizedString("DSC_FieldTooltip", charSequence6, string, charSequence7, ((CsmField)csmObject).getText());
        } else if (CsmKindUtilities.isParamVariable((CsmObject)csmObject)) {
            CharSequence charSequence8 = ((CsmParameter)csmObject).getName();
            charSequence = CsmDisplayUtilities.getHtmlizedString("DSC_ParameterTooltip", charSequence8, ((CsmParameter)csmObject).getText());
        } else if (CsmKindUtilities.isVariable((CsmObject)csmObject)) {
            CharSequence charSequence9 = ((CsmVariable)csmObject).getName();
            charSequence = CsmDisplayUtilities.getHtmlizedString("DSC_VariableTooltip", charSequence9, ((CsmVariable)csmObject).getText());
        } else if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            CharSequence charSequence10 = ((CsmFile)csmObject).getName();
            charSequence = CsmDisplayUtilities.getHtmlizedString("DSC_FileTooltip", charSequence10);
        } else if (CsmKindUtilities.isNamespace((Object)csmObject)) {
            CharSequence charSequence11 = ((CsmNamespace)csmObject).getQualifiedName();
            charSequence = CsmDisplayUtilities.getHtmlizedString("DSC_NamespaceTooltip", charSequence11);
        } else if (CsmKindUtilities.isMacro((CsmObject)csmObject)) {
            CsmMacro csmMacro = (CsmMacro)csmObject;
            switch (csmMacro.getKind()) {
                case DEFINED: {
                    charSequence = CsmDisplayUtilities.getHtmlizedString("DSC_MacroTooltip", csmMacro.getName(), csmMacro.getText());
                    break;
                }
                case COMPILER_PREDEFINED: {
                    charSequence = CsmDisplayUtilities.getHtmlizedString("DSC_SysMacroTooltip", csmMacro.getName(), csmMacro.getText());
                    break;
                }
                case POSITION_PREDEFINED: {
                    charSequence = CsmDisplayUtilities.getHtmlizedString("DSC_PosMacroTooltip", csmMacro.getName(), csmMacro.getText());
                    break;
                }
                case USER_SPECIFIED: {
                    charSequence = CsmDisplayUtilities.getHtmlizedString("DSC_ProjectMacroTooltip", csmMacro.getName(), csmMacro.getText());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected macro kind:" + csmMacro.getKind() + " in macro:" + csmMacro);
                }
            }
        } else {
            CsmInclude csmInclude;
            CsmFile csmFile;
            charSequence = CsmKindUtilities.isInclude((CsmObject)csmObject) ? ((csmFile = (csmInclude = (CsmInclude)csmObject).getIncludeFile()) == null ? CsmDisplayUtilities.getHtmlizedString("DSC_IncludeErrorTooltip", csmInclude.getText()) : (csmFile.getProject().isArtificial() ? CsmDisplayUtilities.getHtmlizedString("DSC_IncludeLibraryTooltip", csmFile.getAbsolutePath()) : CsmDisplayUtilities.getHtmlizedString("DSC_IncludeTooltip", csmFile.getAbsolutePath(), csmFile.getProject().getName()))) : (CsmKindUtilities.isQualified((CsmObject)csmObject) ? ((CsmQualifiedNamedElement)csmObject).getQualifiedName() : (CsmKindUtilities.isLabel((CsmObject)csmObject) ? CsmDisplayUtilities.getHtmlizedString("DSC_LabelTooltip", ((CsmLabel)csmObject).getLabel()) : (CsmKindUtilities.isNamedElement((CsmObject)csmObject) ? ((CsmNamedElement)csmObject).getName() : "unhandled object " + csmObject)));
        }
        return charSequence;
    }

    private static CharSequence getFunctionText(CsmFunction csmFunction) {
        CsmParameter csmParameter;
        StringBuilder stringBuilder = new StringBuilder();
        if (CsmKindUtilities.isMethod((CsmObject)csmFunction) && ((CsmMethod)csmFunction).isVirtual()) {
            stringBuilder.append("virtual ");
        }
        stringBuilder.append(csmFunction.getReturnType().getText()).append(' ');
        stringBuilder.append(csmFunction.getName());
        stringBuilder.append('(');
        Iterator iterator = csmFunction.getParameters().iterator();
        while (iterator.hasNext()) {
            csmParameter = (CsmParameter)iterator.next();
            stringBuilder.append(csmParameter.getText());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(')');
        if (CsmKindUtilities.isMethod((CsmObject)csmFunction)) {
            csmParameter = (CsmMethod)csmFunction;
            if (csmParameter.isConst()) {
                stringBuilder.append(" const");
            }
            if (csmParameter.isAbstract()) {
                stringBuilder.append(" = 0");
            }
        }
        return stringBuilder.toString();
    }

    private static String getHtmlizedString(String string, CharSequence charSequence) {
        return CsmDisplayUtilities.getString(string, CsmDisplayUtilities.htmlize(charSequence));
    }

    private static String getHtmlizedString(String string, CharSequence charSequence, CharSequence charSequence2) {
        return CsmDisplayUtilities.getString(string, CsmDisplayUtilities.htmlize(charSequence), CsmDisplayUtilities.htmlize(charSequence2));
    }

    private static String getHtmlizedString(String string, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, CharSequence charSequence4) {
        return CsmDisplayUtilities.getString(string, CsmDisplayUtilities.htmlize(charSequence), CsmDisplayUtilities.htmlize(charSequence2), CsmDisplayUtilities.htmlize(charSequence3), CsmDisplayUtilities.htmlize(charSequence4));
    }

    private static String getString(String string, CharSequence charSequence) {
        return NbBundle.getMessage(CsmDisplayUtilities.class, (String)string, (Object)charSequence);
    }

    private static String getString(String string, CharSequence charSequence, CharSequence charSequence2) {
        return NbBundle.getMessage(CsmDisplayUtilities.class, (String)string, (Object)charSequence, (Object)charSequence2);
    }

    private static String getString(String string, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, CharSequence charSequence4) {
        return NbBundle.getMessage(CsmDisplayUtilities.class, (String)string, (Object[])new Object[]{charSequence, charSequence2, charSequence3, charSequence4});
    }

    private static void appendHtml(StringBuilder stringBuilder, TokenSequence<?> tokenSequence) {
        TokenSequence tokenSequence2;
        Object object;
        FontColorSettings fontColorSettings = null;
        LanguagePath languagePath = tokenSequence.languagePath();
        while (!SKIP_COLORING && languagePath != null && fontColorSettings == null) {
            object = languagePath.mimePath();
            tokenSequence2 = MimeLookup.getLookup((String)object);
            fontColorSettings = (FontColorSettings)tokenSequence2.lookup(FontColorSettings.class);
        }
        while (tokenSequence.moveNext()) {
            object = tokenSequence.token();
            tokenSequence2 = tokenSequence.embedded();
            if (tokenSequence2 != null && tokenSequence2.language() == CppTokenId.languagePreproc()) {
                CsmDisplayUtilities.appendHtml(stringBuilder, tokenSequence2);
                continue;
            }
            String string = object.id().primaryCategory();
            if (string == null) {
                string = "whitespace";
            }
            String string2 = "whitespace".equals(string) ? " " : ((Object)object.text()).toString();
            if (fontColorSettings != null) {
                AttributeSet attributeSet = fontColorSettings.getTokenFontColors(string);
                stringBuilder.append(CsmDisplayUtilities.addHTMLColor(CsmDisplayUtilities.htmlize(string2), attributeSet));
                continue;
            }
            stringBuilder.append(CsmDisplayUtilities.htmlize(string2));
        }
    }

    public static String htmlize(CharSequence charSequence) {
        if (charSequence == null) {
            System.err.println("null string");
            return "";
        }
        String string = org.openide.util.Utilities.replaceString((String)((Object)charSequence).toString(), (String)"&", (String)"&amp;");
        string = org.openide.util.Utilities.replaceString((String)string, (String)"<", (String)"&lt;");
        string = org.openide.util.Utilities.replaceString((String)string, (String)">", (String)"&gt;");
        return string;
    }

    public static String addHTMLColor(String string, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return org.openide.util.Utilities.replaceString((String)org.openide.util.Utilities.replaceString((String)string, (String)" ", (String)"&nbsp;"), (String)"\n", (String)"<br>");
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        if (StyleConstants.isBold(attributeSet)) {
            stringBuilder.insert(0, "<b>");
            stringBuilder.append("</b>");
        }
        if (StyleConstants.isItalic(attributeSet)) {
            stringBuilder.insert(0, "<i>");
            stringBuilder.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(attributeSet)) {
            stringBuilder.insert(0, "<s>");
            stringBuilder.append("</s>");
        }
        stringBuilder.insert(0, "<font color=" + CsmDisplayUtilities.getHTMLColor(StyleConstants.getForeground(attributeSet)) + ">");
        stringBuilder.append("</font>");
        return stringBuilder.toString();
    }

    private static String getHTMLColor(Color color) {
        String string = "0" + Integer.toHexString(color.getRed());
        string = string.substring(string.length() - 2);
        String string2 = "0" + Integer.toHexString(color.getGreen());
        string2 = string2.substring(string2.length() - 2);
        String string3 = "0" + Integer.toHexString(color.getBlue());
        string3 = string3.substring(string3.length() - 2);
        String string4 = "#" + string + string2 + string3;
        return string4;
    }

    private static String trimStart(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return string.substring(i, string.length());
        }
        return "";
    }

    private static String trimEnd(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return string.substring(0, i + 1);
        }
        return "";
    }

    public static String shrinkPath(CharSequence charSequence, int n, int n2, int n3) {
        return CsmDisplayUtilities.shrinkPath(charSequence, true, File.separator, n, n2, n3);
    }

    public static String shrinkPath(CharSequence charSequence, boolean bl, String string, int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(charSequence);
        String string2 = null;
        if ("/".equals(string)) {
            if (stringBuilder.indexOf("\\") >= 0) {
                string2 = "\\";
            }
        } else if (stringBuilder.indexOf("/") >= 0) {
            string2 = "/";
        }
        if (string2 != null) {
            stringBuilder = new StringBuilder(stringBuilder.toString().replace(string2, string));
        }
        int n4 = stringBuilder.length();
        if (bl && n4 > n) {
            int n5;
            StringBuilder stringBuilder2 = new StringBuilder(stringBuilder).reverse();
            int n6 = stringBuilder.indexOf(string);
            n6 = n6 < 0 ? 0 : ++n6;
            int n7 = 0;
            while (stringBuilder2.charAt(n7) == string.charAt(0)) {
                ++n7;
            }
            int n8 = n2 > 0 ? Integer.MAX_VALUE : -1;
            for (n5 = n2; n5 > 0 && n8 > 0; --n5) {
                n8 = stringBuilder.indexOf(string, n6);
                n6 = n8 + 1;
            }
            n5 = n3 > 0 ? Integer.MAX_VALUE : -1;
            for (int i = n3; i > 0 && n5 > 0; --i) {
                n5 = stringBuilder2.indexOf(string, n7);
                n7 = n5 + 1;
            }
            if (n5 > 0 && n8 > 0 && n8 < (n5 = n4 - n5) - 1) {
                stringBuilder.replace(n8, n5 - 1, "...");
            }
        }
        return stringBuilder.toString();
    }
}

