/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.identity.profile.api.configurator.SecurityMechanism;
import org.netbeans.modules.identity.profile.api.configurator.impl.dynamic.SecurityMechanismRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityMechanismHelper {
    private static final String LIBERTY_PREFIX = "Liberty";
    private Collection<SecurityMechanism> allSecurityMechs;
    private Collection<SecurityMechanism> allMsgLevelSecurityMechs;
    private Collection<SecurityMechanism> allWSPLibertySecurityMechs;
    private Collection<SecurityMechanism> allWSCLibertySecurityMechs;
    private Collection<SecurityMechanism> allWSPSecurityMechs;
    private Collection<SecurityMechanism> allWSCSecurityMechs;
    private SecurityMechanismRetriever retriever;

    public SecurityMechanismHelper(String string) {
        this.retriever = new SecurityMechanismRetriever(string);
    }

    public Collection<SecurityMechanism> getAllSecurityMechanisms() {
        if (this.allSecurityMechs == null) {
            ArrayList<SecurityMechanism> arrayList = new ArrayList<SecurityMechanism>();
            arrayList.addAll(this.getAllMessageLevelSecurityMechanisms());
            arrayList.addAll(this.getAllWSPLibertySecurityMechanisms());
            arrayList.addAll(this.getAllWSCLibertySecurityMechanisms());
            this.allSecurityMechs = Collections.unmodifiableCollection(arrayList);
        }
        return this.allSecurityMechs;
    }

    public Collection<SecurityMechanism> getAllMessageLevelSecurityMechanisms() {
        if (this.allMsgLevelSecurityMechs == null) {
            this.allMsgLevelSecurityMechs = this.retriever.getAllMessageLevelSecurityMechanism();
        }
        return this.allMsgLevelSecurityMechs;
    }

    public Collection<SecurityMechanism> getAllWSPLibertySecurityMechanisms() {
        if (this.allWSPLibertySecurityMechs == null) {
            Collection<SecurityMechanism> collection = this.retriever.getAllWSPLibertySecurityMechanisms();
            this.allWSPLibertySecurityMechs = new ArrayList<SecurityMechanism>();
            for (SecurityMechanism securityMechanism : collection) {
                if (!securityMechanism.getName().startsWith(LIBERTY_PREFIX)) continue;
                this.allWSPLibertySecurityMechs.add(securityMechanism);
            }
            this.allWSPLibertySecurityMechs = Collections.unmodifiableCollection(this.allWSPLibertySecurityMechs);
        }
        return this.allWSPLibertySecurityMechs;
    }

    public Collection<SecurityMechanism> getAllWSCLibertySecurityMechanisms() {
        if (this.allWSCLibertySecurityMechs == null) {
            Collection<SecurityMechanism> collection = this.retriever.getAllWSCLibertySecurityMechanisms();
            this.allWSCLibertySecurityMechs = new ArrayList<SecurityMechanism>();
            for (SecurityMechanism securityMechanism : collection) {
                if (!securityMechanism.getName().startsWith(LIBERTY_PREFIX)) continue;
                this.allWSCLibertySecurityMechs.add(securityMechanism);
            }
            this.allWSCLibertySecurityMechs = Collections.unmodifiableCollection(this.allWSCLibertySecurityMechs);
        }
        return this.allWSCLibertySecurityMechs;
    }

    public Collection<SecurityMechanism> getAllWSPSecurityMechanisms() {
        if (this.allWSPSecurityMechs == null) {
            this.allWSPSecurityMechs = new ArrayList<SecurityMechanism>();
            this.allWSPSecurityMechs.addAll(this.getAllMessageLevelSecurityMechanisms());
            this.allWSPSecurityMechs.addAll(this.getAllWSPLibertySecurityMechanisms());
            this.allWSPSecurityMechs = Collections.unmodifiableCollection(this.allWSPSecurityMechs);
        }
        return this.allWSPSecurityMechs;
    }

    public Collection<SecurityMechanism> getAllWSCSecurityMechanisms() {
        if (this.allWSCSecurityMechs == null) {
            this.allWSCSecurityMechs = new ArrayList<SecurityMechanism>();
            this.allWSCSecurityMechs.addAll(this.getAllMessageLevelSecurityMechanisms());
            this.allWSCSecurityMechs.addAll(this.getAllWSCLibertySecurityMechanisms());
            this.allWSCSecurityMechs = Collections.unmodifiableCollection(this.allWSCSecurityMechs);
        }
        return this.allWSCSecurityMechs;
    }

    public Collection<String> getSecurityMechanismURIs(Collection<SecurityMechanism> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (collection != null) {
            for (SecurityMechanism securityMechanism : collection) {
                arrayList.add(securityMechanism.getURI());
            }
        }
        return arrayList;
    }

    public Collection<SecurityMechanism> getSecurityMechanismsFromURIs(Collection<String> collection) {
        ArrayList<SecurityMechanism> arrayList = new ArrayList<SecurityMechanism>();
        Collection<SecurityMechanism> collection2 = this.getAllSecurityMechanisms();
        if (collection != null) {
            block0: for (String string : collection) {
                for (SecurityMechanism securityMechanism : collection2) {
                    if (!string.equals(securityMechanism.getURI())) continue;
                    arrayList.add(securityMechanism);
                    continue block0;
                }
            }
        }
        return arrayList;
    }

    public Collection<String> getSecurityMechanismURIsFromNames(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection<SecurityMechanism> collection2 = this.getAllSecurityMechanisms();
        for (String string : collection) {
            for (SecurityMechanism securityMechanism : collection2) {
                if (!string.equals(securityMechanism.getName())) continue;
                arrayList.add(securityMechanism.getURI());
            }
        }
        return arrayList;
    }
}

