/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator.impl.dynamic;

import java.lang.reflect.Method;
import org.netbeans.modules.identity.profile.api.configurator.ServerProperties;
import org.netbeans.modules.identity.profile.api.configurator.TrustAuthorityConfigurator;
import org.netbeans.modules.identity.profile.api.configurator.impl.dynamic.ProviderConfigImpl;
import org.netbeans.modules.identity.profile.api.configurator.impl.dynamic.TrustAuthorityConfigImpl;
import org.netbeans.modules.identity.profile.api.configurator.spi.DiscoveryConfig;
import org.netbeans.modules.identity.profile.api.configurator.spi.ProviderConfig;

public class DiscoveryConfigImpl
extends TrustAuthorityConfigImpl
implements DiscoveryConfig {
    private static final String AM_DISCOVERY_CONFIG_CLASS = "com.sun.identity.wss.provider.DiscoveryConfig";
    private static final String AM_REGISTER_PROVIDER_WITH_TA_METHOD = "registerProviderWithTA";
    private static final String AM_UNREGISTER_PROVIDER_WITH_TA_METHOD = "unregisterProviderWithTA";
    private Class discoveryConfigClass;

    public DiscoveryConfigImpl(String string, TrustAuthorityConfigurator.Type type, ServerProperties serverProperties) {
        super(string, type, serverProperties);
    }

    private Class getDiscoveryConfigClass() {
        if (this.discoveryConfigClass == null) {
            try {
                this.discoveryConfigClass = this.getClassLoader().loadClass(AM_DISCOVERY_CONFIG_CLASS);
            }
            catch (Exception exception) {
                throw this.createConfiguratorException(exception);
            }
        }
        return this.discoveryConfigClass;
    }

    public void registerProvider(ProviderConfig providerConfig) {
        try {
            ProviderConfigImpl providerConfigImpl = (ProviderConfigImpl)providerConfig;
            Method method = this.getDiscoveryConfigClass().getMethod(AM_REGISTER_PROVIDER_WITH_TA_METHOD, providerConfigImpl.getProviderConfigClass(), String.class);
            method.invoke(this.getTrustAuthorityConfig(), ((ProviderConfigImpl)providerConfig).getProviderConfig(), providerConfig.getServiceType());
        }
        catch (Exception exception) {
            throw this.createConfiguratorException(exception);
        }
    }

    public void unregisterProvider(ProviderConfig providerConfig) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        try {
            Method method = this.getDiscoveryConfigClass().getMethod(AM_UNREGISTER_PROVIDER_WITH_TA_METHOD, String.class);
            method.invoke(this.getTrustAuthorityConfig(), providerConfig.getServiceType());
        }
        catch (Exception exception) {
            System.out.println("unregister failed " + exception.getMessage());
            throw this.createConfiguratorException(exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }
}

