/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.netbeans.modules.glassfish.common.BasicTask;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.LogViewMgr;
import org.netbeans.modules.glassfish.common.Util;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.Recognizer;
import org.netbeans.modules.glassfish.spi.RegisteredDerbyServer;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.glassfish.spi.TreeParser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartTask
extends BasicTask<GlassfishModule.OperationState> {
    private final CommonServerSupport support;
    private List<Recognizer> recognizers;
    private FileObject jdkHome = null;
    private List<String> jvmArgs = null;

    public StartTask(CommonServerSupport commonServerSupport, List<Recognizer> list, OperationStateListener ... operationStateListenerArray) {
        this(commonServerSupport, list, (FileObject)null, (String[])null, operationStateListenerArray);
    }

    public StartTask(final CommonServerSupport commonServerSupport, List<Recognizer> list, FileObject fileObject, String[] stringArray, OperationStateListener ... operationStateListenerArray) {
        super(commonServerSupport.getInstanceProperties(), operationStateListenerArray);
        ArrayList<OperationStateListener> arrayList = new ArrayList<OperationStateListener>();
        arrayList.addAll(Arrays.asList(operationStateListenerArray));
        arrayList.add(new OperationStateListener(){

            public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
                if (GlassfishModule.OperationState.COMPLETED.equals((Object)operationState)) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            ServerCommand.GetPropertyCommand getPropertyCommand = new ServerCommand.GetPropertyCommand("*.enable-comet-support");
                            Future<GlassfishModule.OperationState> future = commonServerSupport.execute(getPropertyCommand);
                            try {
                                if (future.get(10L, TimeUnit.SECONDS) == GlassfishModule.OperationState.COMPLETED) {
                                    Map<String, String> map = getPropertyCommand.getData();
                                    String string = commonServerSupport.getInstanceProperties().get("v3.grizzly.cometSupport");
                                    if (null == string || string.trim().length() < 1) {
                                        string = "false";
                                    }
                                    for (Map.Entry<String, String> entry : map.entrySet()) {
                                        String string2 = entry.getKey();
                                        if (null == string2 || string2.contains("admin-listener")) continue;
                                        ServerCommand.SetPropertyCommand setPropertyCommand = new ServerCommand.SetPropertyCommand(string2, string);
                                        Future<GlassfishModule.OperationState> future2 = commonServerSupport.execute(setPropertyCommand);
                                        future2.get(10L, TimeUnit.SECONDS);
                                    }
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                Logger.getLogger("glassfish").log(Level.INFO, null, interruptedException);
                            }
                            catch (ExecutionException executionException) {
                                Logger.getLogger("glassfish").log(Level.INFO, null, executionException);
                            }
                            catch (TimeoutException timeoutException) {
                                Logger.getLogger("glassfish").log(Level.INFO, null, timeoutException);
                            }
                        }
                    });
                }
            }
        });
        this.stateListener = arrayList.toArray(new OperationStateListener[arrayList.size()]);
        this.support = commonServerSupport;
        this.recognizers = list;
        this.jdkHome = fileObject;
        this.jvmArgs = stringArray != null ? Arrays.asList(StartTask.removeEscapes(stringArray)) : null;
    }

    private static String[] removeEscapes(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].replace("\\\"", "");
        }
        return stringArray;
    }

    @Override
    public GlassfishModule.OperationState call() {
        Process process;
        Object object;
        Logger.getLogger("glassfish").log(Level.FINEST, "StartTask.call() called on thread \"" + Thread.currentThread().getName() + "\"");
        long l = System.currentTimeMillis();
        int n = 0;
        String string = (String)this.ip.get("host");
        if (string == null || string.length() == 0) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_NOHOST", this.instanceName);
        }
        try {
            n = Integer.valueOf((String)this.ip.get("httpportnumber"));
            if (n < 0 || n > 65535) {
                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
            }
            this.jdkHome = this.getJavaPlatformRoot(this.support);
            object = (RegisteredDerbyServer)Lookup.getDefault().lookup(RegisteredDerbyServer.class);
            if (null != object && "true".equals(this.ip.get("derbyStartOn"))) {
                object.start();
            }
            process = this.createProcess();
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger("glassfish").log(Level.INFO, (String)this.ip.get("httpportnumber"), numberFormatException);
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
        }
        catch (IOException iOException) {
            Logger.getLogger("glassfish").log(Level.INFO, null, iOException);
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_PASS_THROUGH", iOException.getLocalizedMessage());
        }
        catch (ProcessCreationException processCreationException) {
            Logger.getLogger("glassfish").log(Level.INFO, null, processCreationException);
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_PASS_THROUGH", processCreationException.getLocalizedMessage());
        }
        this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, "MSG_START_SERVER_IN_PROGRESS", this.instanceName);
        object = LogViewMgr.getInstance((String)this.ip.get("url"));
        ((LogViewMgr)object).readInputStreams(this.recognizers, process.getInputStream(), process.getErrorStream());
        while (System.currentTimeMillis() - l < 120000L) {
            boolean bl = CommonServerSupport.isRunning(string, n);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (bl) {
                Logger.getLogger("glassfish").log(Level.FINE, "Server HTTP is live.");
                GlassfishModule.OperationState operationState = GlassfishModule.OperationState.COMPLETED;
                String string2 = "MSG_SERVER_STARTED";
                if (!this.support.isReady(true)) {
                    operationState = GlassfishModule.OperationState.FAILED;
                    string2 = "MSG_START_SERVER_FAILED";
                }
                return this.fireOperationStateChanged(operationState, string2, this.instanceName);
            }
            if (null == this.jvmArgs) continue;
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    while (!CommonServerSupport.isRunning(StartTask.this.support.getHostName(), StartTask.this.support.getHttpPortNumber())) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StartTask.this.support.refresh();
                        }
                    });
                }
            });
            return this.fireOperationStateChanged(GlassfishModule.OperationState.COMPLETED, "MSG_SERVER_STARTED", this.instanceName);
        }
        Logger.getLogger("glassfish").log(Level.FINE, "V3 Failed to start, killing process: " + process);
        process.destroy();
        return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED", this.instanceName);
    }

    private String[] createEnvironment() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getJdkHome();
        if (string != null) {
            object = "JAVA_HOME=" + string;
            arrayList.add((String)object);
            Logger.getLogger("glassfish").log(Level.FINE, "V3 Environment: " + (String)object);
        } else {
            Logger.getLogger("glassfish").log(Level.WARNING, "Unable to set JAVA_HOME for GlassFish V3 enviroment.");
        }
        object = Locale.getDefault();
        if (((Locale)object).equals(new Locale("tr", "TR"))) {
            arrayList.add("LANG=en_US");
            arrayList.add("LC_ALL=en_US");
            String string2 = NbBundle.getMessage(StartTask.class, (String)"MSG_LocaleSwitched");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
        }
        this.appendSystemEnvVar(arrayList, "GEM_HOME");
        this.appendSystemEnvVar(arrayList, "GEM_PATH");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void appendSystemEnvVar(List<String> list, String string) {
        String string2 = (String)this.ip.get(string);
        if (string2 != null && string2.length() > 0) {
            list.add(string + "=" + string2);
        }
    }

    private FileObject getJavaPlatformRoot(CommonServerSupport commonServerSupport) throws IOException {
        FileObject fileObject;
        String string = commonServerSupport.getInstanceProperties().get("java.platform");
        if (null == string || string.trim().length() < 1) {
            File file = new File(this.getJdkHome());
            fileObject = FileUtil.createFolder((File)FileUtil.normalizeFile((File)file));
        } else {
            File file = new File(string);
            if (file.exists()) {
                File file2 = file.getParentFile().getParentFile();
                fileObject = FileUtil.createFolder((File)FileUtil.normalizeFile((File)file2));
            } else {
                throw new FileNotFoundException(NbBundle.getMessage(StartTask.class, (String)"MSG_INVALID_JAVA", (Object)this.instanceName, (Object)string));
            }
        }
        return fileObject;
    }

    private String getJdkHome() {
        String string;
        if (null != this.jdkHome) {
            string = FileUtil.toFile((FileObject)this.jdkHome).getAbsolutePath();
        } else {
            string = System.getProperty("java.home");
            if (string.endsWith(File.separatorChar + "jre")) {
                string = string.substring(0, string.length() - 4);
            }
        }
        return string;
    }

    private NbProcessDescriptor createProcessDescriptor() throws ProcessCreationException {
        File file;
        String string = FileUtil.toFile((FileObject)this.jdkHome).getAbsolutePath() + File.separatorChar + "bin" + File.separatorChar + "java";
        if (!File.separator.equals("/")) {
            string = string + ".exe";
        }
        if (!(file = new File(string)).exists()) {
            throw new ProcessCreationException(null, "MSG_INVALID_JAVA", this.instanceName, string);
        }
        if (this.support.getInstanceProvider().requiresJdk6OrHigher() && !Util.appearsToBeJdk6OrBetter(file)) {
            throw new ProcessCreationException(null, "MSG_START_SERVER_FAILED_JDK_ERROR", this.instanceName);
        }
        String string2 = (String)this.ip.get("homefolder");
        File file2 = ServerUtilities.getJarName(string2, "glassfish(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
        if (file2 == null) {
            throw new ProcessCreationException(null, "MSG_START_SERVER_FAILED_FNF", new String[0]);
        }
        String string3 = file2.getAbsolutePath();
        ArrayList<String> arrayList = new ArrayList<String>(10);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.readJvmArgs(this.getDomainFolder(), arrayList, hashMap);
        if (null != this.jvmArgs) {
            arrayList.addAll(this.jvmArgs);
        }
        StringBuilder stringBuilder = new StringBuilder(1024);
        this.appendSystemVars(hashMap, stringBuilder);
        this.appendJavaOpts(arrayList, stringBuilder);
        stringBuilder.append(" -client -jar ");
        stringBuilder.append(StartTask.quote(string3));
        stringBuilder.append(" --domain " + this.getDomainName());
        stringBuilder.append(" --domaindir " + StartTask.quote(this.getDomainFolder().getAbsolutePath()));
        String string4 = stringBuilder.toString();
        Logger.getLogger("glassfish").log(Level.FINE, "V3 JVM Command: " + string + string4);
        return new NbProcessDescriptor(string, string4);
    }

    private static final String quote(String string) {
        return string.indexOf(32) == -1 ? string : "\"" + string + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder appendJavaOpts(List<String> list, StringBuilder stringBuilder) throws ProcessCreationException {
        block14: {
            String string = "";
            try {
                for (String string2 : list) {
                    stringBuilder.append(' ');
                    stringBuilder.append(string2);
                }
                if (!"debugMode".equals(this.ip.get("jvmMode"))) break block14;
                string = (String)this.ip.get("debugPort");
                Object object = "dt_socket";
                if ("true".equals(this.ip.get("use.shared.mem"))) {
                    object = "dt_shmem";
                } else {
                    int n = 0;
                    if (null != string && string.trim().length() > 0 && ((n = Integer.parseInt(string)) < 0 || n > 65535)) {
                        throw new NumberFormatException();
                    }
                }
                if (null == string || "".equals(string)) {
                    if ("true".equals(this.ip.get("use.shared.mem"))) {
                        string = Integer.toString(Math.abs(((String)this.ip.get("homefolder") + (String)this.ip.get("domainsfolder") + (String)this.ip.get("domainname")).hashCode() + 1));
                    } else {
                        int n = 8787;
                        ServerSocket serverSocket = null;
                        try {
                            serverSocket = new ServerSocket(0);
                            n = serverSocket.getLocalPort();
                            string = Integer.toString(n);
                        }
                        finally {
                            if (null != serverSocket) {
                                serverSocket.close();
                            }
                        }
                    }
                }
                this.support.setEnvironmentProperty("debugPort", string, true);
                stringBuilder.append(" -Xdebug -Xrunjdwp:transport=");
                stringBuilder.append((String)object);
                stringBuilder.append(",address=");
                stringBuilder.append(string);
                stringBuilder.append(",server=y,suspend=n");
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProcessCreationException(numberFormatException, "MSG_START_SERVER_FAILED_INVALIDPORT", this.instanceName, string);
            }
            catch (IOException iOException) {
                throw new ProcessCreationException(iOException, "MSG_START_SERVER_FAILED_INVALIDPORT", this.instanceName, string);
            }
        }
        return stringBuilder;
    }

    private StringBuilder appendSystemVars(Map<String, String> map, StringBuilder stringBuilder) {
        this.appendSystemVar(stringBuilder, "jruby.home", (String)this.ip.get("jruby.home"));
        this.appendSystemVar(stringBuilder, "v3.grizzly.cometSupport", (String)this.ip.get("v3.grizzly.cometSupport"));
        if ("true".equals(this.ip.get("useIDEProxyOn"))) {
            String[] stringArray = new String[]{"http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort"};
            boolean bl = Utilities.isWindows();
            for (String string : stringArray) {
                String string2 = System.getProperty(string);
                if (string2 == null || string2.trim().length() <= 0) continue;
                if (bl && "http.nonProxyHosts".equals(string)) {
                    string2 = "\"" + string2 + "\"";
                }
                map.put(string, string2);
            }
        }
        map.remove("jruby.home");
        map.remove("v3.grizzly.cometSupport");
        if (!"false".equals(System.getProperty("glassfish.use.jvm.config"))) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.appendSystemVar(stringBuilder, entry.getKey(), entry.getValue());
            }
        }
        return stringBuilder;
    }

    private StringBuilder appendSystemVar(StringBuilder stringBuilder, String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(" -D");
            stringBuilder.append(string);
            stringBuilder.append("=");
            stringBuilder.append(StartTask.quote(string2));
        }
        return stringBuilder;
    }

    private Process createProcess() throws ProcessCreationException {
        Process process = null;
        NbProcessDescriptor nbProcessDescriptor = this.createProcessDescriptor();
        if (nbProcessDescriptor != null) {
            try {
                process = nbProcessDescriptor.exec(null, this.createEnvironment(), true, new File((String)this.ip.get("homefolder")));
            }
            catch (IOException iOException) {
                throw new ProcessCreationException(iOException, "MSG_START_SERVER_FAILED_PD", this.instanceName);
            }
        }
        return process;
    }

    private File getDomainFolder() {
        return new File((String)this.ip.get("domainsfolder") + File.separatorChar + this.getDomainName());
    }

    private final String getDomainName() {
        return (String)this.ip.get("domainname");
    }

    private void readJvmArgs(File file, List<String> list, Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("com.sun.aas.installRoot", StartTask.fixPath((String)this.ip.get("homefolder")));
        hashMap.put("com.sun.aas.instanceRoot", StartTask.fixPath(file.getAbsolutePath()));
        hashMap.put("com.sun.aas.javaRoot", StartTask.fixPath(this.jdkHome.getPath()));
        File file2 = new File((String)this.ip.get("installfolder") + File.separatorChar + "javadb");
        if (file2.exists()) {
            hashMap.put("com.sun.aas.derbyRoot", StartTask.fixPath((String)this.ip.get("installfolder") + File.separatorChar + "javadb"));
        } else {
            hashMap.put("com.sun.aas.derbyRoot", StartTask.fixPath(this.jdkHome.getPath() + File.separatorChar + "javadb"));
        }
        File file3 = new File(file, "config/domain.xml");
        JvmConfigReader jvmConfigReader = new JvmConfigReader(list, map, hashMap);
        ArrayList<TreeParser.Path> arrayList = new ArrayList<TreeParser.Path>();
        arrayList.add(new TreeParser.Path("/domain/servers/server", jvmConfigReader.getServerFinder()));
        arrayList.add(new TreeParser.Path("/domain/configs/config", jvmConfigReader.getConfigFinder()));
        arrayList.add(new TreeParser.Path("/domain/configs/config/java-config", jvmConfigReader));
        try {
            TreeParser.readXml(file3, arrayList);
        }
        catch (IllegalStateException illegalStateException) {
            Logger.getLogger("glassfish").log(Level.WARNING, illegalStateException.getLocalizedMessage(), illegalStateException);
        }
    }

    private static final String fixPath(String string) {
        return string.replace("\\", "\\\\").replace("$", "\\$");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JvmConfigReader
    extends TreeParser.NodeReader {
        private final Map<String, String> argMap;
        private final Map<String, String> varMap;
        private final List<String> optList;
        private static final String SERVER_NAME = "server";
        private String serverConfigName;
        private boolean readJvmConfig = false;
        private Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");

        public JvmConfigReader(List<String> list, Map<String, String> map, Map<String, String> map2) {
            this.optList = list;
            this.argMap = map;
            this.varMap = map2;
        }

        public TreeParser.NodeReader getServerFinder() {
            return new TreeParser.NodeReader(){

                public void readAttributes(String string, Attributes attributes) throws SAXException {
                    if ((JvmConfigReader.this.serverConfigName == null || JvmConfigReader.this.serverConfigName.length() == 0) && JvmConfigReader.SERVER_NAME.equals(attributes.getValue("name"))) {
                        JvmConfigReader.this.serverConfigName = attributes.getValue("config-ref");
                        Logger.getLogger("glassfish").finer("DOMAIN.XML: Server profile defined by " + JvmConfigReader.this.serverConfigName);
                    }
                }
            };
        }

        public TreeParser.NodeReader getConfigFinder() {
            return new TreeParser.NodeReader(){

                public void readAttributes(String string, Attributes attributes) throws SAXException {
                    if (JvmConfigReader.this.serverConfigName != null && JvmConfigReader.this.serverConfigName.equals(attributes.getValue("name"))) {
                        JvmConfigReader.this.readJvmConfig = true;
                        Logger.getLogger("glassfish").finer("DOMAIN.XML: Reading JVM options from server profile " + JvmConfigReader.this.serverConfigName);
                    }
                }

                public void endNode(String string) throws SAXException {
                    JvmConfigReader.this.readJvmConfig = false;
                }
            };
        }

        @Override
        public void readCData(String string, char[] cArray, int n, int n2) throws SAXException {
            if (this.readJvmConfig) {
                String string2 = new String(cArray, n, n2);
                if (string2.startsWith("-D")) {
                    int n3 = string2.indexOf(61);
                    if (n3 != -1) {
                        String string3 = string2.substring(2, n3);
                        String string4 = this.doSub(string2.substring(n3 + 1));
                        if (string3.length() > 0) {
                            Logger.getLogger("glassfish").finer("DOMAIN.XML: argument name = " + string3 + ", value = " + string4);
                            this.argMap.put(string3, string4);
                        }
                    }
                } else if (string2.startsWith("-X")) {
                    int n4 = (string2 = this.doSub(string2)).indexOf(61);
                    if (n4 != -1) {
                        String string5 = string2.substring(0, n4);
                        String string6 = string2.substring(n4 + 1);
                        Logger.getLogger("glassfish").finer("DOMAIN.XML: jvm option: " + string5 + " = " + string6);
                        this.optList.add(string5 + '=' + StartTask.quote(string6));
                    } else {
                        Logger.getLogger("glassfish").finer("DOMAIN.XML: jvm option: " + string2);
                        this.optList.add(string2);
                    }
                }
            }
        }

        private String doSub(String string) {
            try {
                Matcher matcher = this.pattern.matcher(string);
                boolean bl = matcher.find();
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
                    do {
                        String string2;
                        String string3;
                        if ((string3 = this.varMap.get(string2 = matcher.group(1))) == null) {
                            string3 = System.getProperty(string2);
                            string3 = string3 != null ? StartTask.fixPath(string3) : "\\$\\{" + string2 + "\\}";
                        }
                        matcher.appendReplacement(stringBuffer, string3);
                    } while (bl = matcher.find());
                    matcher.appendTail(stringBuffer);
                    string = stringBuffer.toString();
                }
            }
            catch (Exception exception) {
                Logger.getLogger("glassfish").log(Level.INFO, exception.getLocalizedMessage(), exception);
            }
            return string;
        }
    }

    private static class ProcessCreationException
    extends Exception {
        private final String messageName;
        private final String[] args;

        ProcessCreationException(Exception exception, String string, String ... stringArray) {
            if (null != exception) {
                this.initCause(exception);
            }
            this.messageName = string;
            this.args = stringArray;
        }

        public String getLocalizedMessage() {
            return NbBundle.getMessage(StartTask.class, (String)this.messageName, (Object[])this.args);
        }
    }
}

