/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.nodes;

import java.awt.Component;
import java.awt.Image;
import java.util.Collections;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.actions.DebugAction;
import org.netbeans.modules.glassfish.common.actions.ProfileAction;
import org.netbeans.modules.glassfish.common.actions.PropertiesAction;
import org.netbeans.modules.glassfish.common.actions.RemoveServerAction;
import org.netbeans.modules.glassfish.common.actions.RestartAction;
import org.netbeans.modules.glassfish.common.actions.StartServerAction;
import org.netbeans.modules.glassfish.common.actions.StopServerAction;
import org.netbeans.modules.glassfish.common.actions.ViewAdminConsoleAction;
import org.netbeans.modules.glassfish.common.actions.ViewServerLogAction;
import org.netbeans.modules.glassfish.common.actions.ViewUpdateCenterAction;
import org.netbeans.modules.glassfish.common.nodes.Hk2InstanceChildren;
import org.netbeans.modules.glassfish.common.nodes.Refreshable;
import org.netbeans.modules.glassfish.common.nodes.actions.RefreshModulesAction;
import org.netbeans.modules.glassfish.common.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hk2InstanceNode
extends AbstractNode
implements ChangeListener {
    private static final String ICON_BASE = "org/netbeans/modules/glassfish/common/resources/server.gif";
    private static final String WAITING_ICON = "org/netbeans/modules/glassfish/common/resources/waiting.png";
    private static final String RUNNING_ICON = "org/netbeans/modules/glassfish/common/resources/running.png";
    private static final String DEBUGGING_ICON = "org/netbeans/modules/glassfish/common/resources/debugging.png";
    private static final String SUSPENDED_ICON = "org/netbeans/modules/glassfish/common/resources/suspended.png";
    private static final String PROFILING_ICON = "org/netbeans/modules/glassfish/common/resources/profiling.png";
    private static final String PROFILER_BLOCKING_ICON = "org/netbeans/modules/glassfish/common/resources/profilerblocking.png";
    private final GlassfishInstance serverInstance;
    private final InstanceContent instanceContent;
    private volatile String displayName = null;
    private volatile String shortDesc = null;

    public Hk2InstanceNode(GlassfishInstance glassfishInstance, boolean bl) {
        this(glassfishInstance, new InstanceContent(), bl);
    }

    private Hk2InstanceNode(GlassfishInstance glassfishInstance, InstanceContent instanceContent, boolean bl) {
        super((Children)(bl ? new Hk2InstanceChildren(glassfishInstance) : Children.LEAF), (Lookup)new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)instanceContent), glassfishInstance.getLookup()}));
        this.serverInstance = glassfishInstance;
        this.instanceContent = instanceContent;
        this.setIconBaseWithExtension(ICON_BASE);
        if (bl) {
            this.serverInstance.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.serverInstance));
            this.instanceContent.add((Object)new RefreshModulesCookie(){

                public void refresh() {
                    Children children = Hk2InstanceNode.this.getChildren();
                    if (children instanceof Refreshable) {
                        ((Refreshable)children).updateKeys();
                    }
                }
            });
        }
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this.buildDisplayName();
        }
        return this.displayName;
    }

    public String getShortDescription() {
        if (this.shortDesc == null) {
            this.shortDesc = NbBundle.getMessage(Hk2InstanceNode.class, (String)"LBL_ServerInstanceNodeDesc", (Object)this.serverInstance.getServerDisplayName(), (Object)this.getAdminUrl());
        }
        return this.shortDesc;
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{SystemAction.get(StartServerAction.class), SystemAction.get(DebugAction.class), SystemAction.get(ProfileAction.class), SystemAction.get(RestartAction.class), SystemAction.get(StopServerAction.class), SystemAction.get(RefreshModulesAction.class), null, SystemAction.get(RemoveServerAction.class), null, SystemAction.get(ViewAdminConsoleAction.class), SystemAction.get(ViewServerLogAction.class), SystemAction.get(ViewUpdateCenterAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new JPanel();
    }

    public Image getIcon(int n) {
        return this.badgeIcon(super.getIcon(n));
    }

    public Image getOpenedIcon(int n) {
        return this.badgeIcon(super.getOpenedIcon(n));
    }

    private Image badgeIcon(Image image) {
        Image image2 = null;
        switch (this.serverInstance.getServerState()) {
            case RUNNING: {
                if (this.isDebug()) {
                    image2 = ImageUtilities.loadImage((String)DEBUGGING_ICON);
                    break;
                }
                if (this.isProfile()) {
                    image2 = ImageUtilities.loadImage((String)PROFILING_ICON);
                    break;
                }
                image2 = ImageUtilities.loadImage((String)RUNNING_ICON);
                break;
            }
            case STARTING: {
                image2 = ImageUtilities.loadImage((String)WAITING_ICON);
                break;
            }
            case STOPPED: {
                break;
            }
            case STOPPED_JVM_BP: 
            case STOPPED_JVM_PROFILER: {
                image2 = ImageUtilities.loadImage((String)SUSPENDED_ICON);
                break;
            }
            case STOPPING: {
                image2 = ImageUtilities.loadImage((String)WAITING_ICON);
            }
        }
        return image2 != null ? ImageUtilities.mergeImages((Image)image, (Image)image2, (int)15, (int)8) : image;
    }

    private boolean isDebug() {
        return "debugMode".equals(this.serverInstance.getCommonSupport().getInstanceProperties().get("jvmMode"));
    }

    private boolean isProfile() {
        return "profileMode".equals(this.serverInstance.getCommonSupport().getInstanceProperties().get("jvmMode"));
    }

    private Map<String, String> getInstanceProperties() {
        Map<String, String> map = null;
        GlassfishModule glassfishModule = (GlassfishModule)this.getLookup().lookup(GlassfishModule.class);
        if (glassfishModule != null) {
            map = glassfishModule.getInstanceProperties();
        }
        if (map == null) {
            map = Collections.emptyMap();
        }
        return map;
    }

    private String buildDisplayName() {
        Map<String, String> map = this.getInstanceProperties();
        String string = map.get("displayName");
        return string != null ? string : "Bogus display name";
    }

    public String getAdminUrl() {
        String string;
        String string2 = null;
        Map<String, String> map = this.getInstanceProperties();
        String string3 = map.get("host");
        String string4 = string = !"false".equals(System.getProperty("glassfish.useadminport")) ? map.get("adminPort") : map.get("httpportnumber");
        if (string3 != null && string3.length() > 0) {
            string2 = "http://" + string3 + ":" + string;
        }
        return string2;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                Hk2InstanceNode.this.fireIconChange();
            }
        });
    }
}

