/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.css.formatting.api.LexUtilities;
import org.netbeans.modules.css.formatting.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.css.formatting.api.support.AbstractIndenter;
import org.netbeans.modules.css.formatting.api.support.IndentCommand;
import org.netbeans.modules.css.formatting.api.support.IndenterContextData;
import org.netbeans.modules.css.lexer.api.CssTokenId;
import org.netbeans.modules.editor.indent.spi.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssIndenter
extends AbstractIndenter<CssTokenId> {
    private Stack<CssStackItem> stack = null;
    private int preservedLineIndentation = -1;
    private boolean inComment = false;
    private boolean inMedia = false;

    public CssIndenter(Context context) {
        super(CssTokenId.language(), context);
    }

    private Stack<CssStackItem> getStack() {
        return this.stack;
    }

    @Override
    protected boolean isWhiteSpaceToken(Token<CssTokenId> token) {
        return token.id() == CssTokenId.S;
    }

    private boolean isCommentToken(Token<CssTokenId> token) {
        return token.id() == CssTokenId.COMMENT;
    }

    @Override
    protected void reset() {
        this.stack = new Stack();
        this.inComment = false;
        this.inMedia = false;
    }

    @Override
    protected int getFormatStableStart(JoinedTokenSequence<CssTokenId> joinedTokenSequence, int n, int n2, AbstractIndenter.OffsetRanges offsetRanges) {
        joinedTokenSequence.move(n2, false);
        if (!joinedTokenSequence.moveNext() && !joinedTokenSequence.movePrevious()) {
            return LexUtilities.getTokenSequenceStartOffset(joinedTokenSequence);
        }
        int n3 = 0;
        do {
            Token<CssTokenId> token;
            TokenId tokenId;
            if ((tokenId = (token = joinedTokenSequence.token()).id()) == CssTokenId.IDENT && joinedTokenSequence.offset() < n && n3 == 0) {
                int n4 = joinedTokenSequence.index();
                joinedTokenSequence.moveNext();
                Token<CssTokenId> token2 = LexUtilities.findNext(joinedTokenSequence, Arrays.asList(CssTokenId.S));
                joinedTokenSequence.moveIndex(n4);
                joinedTokenSequence.moveNext();
                if (token2 == null || token2.id() != CssTokenId.LBRACE) continue;
                if (joinedTokenSequence.movePrevious() && (token2 = LexUtilities.findPrevious(joinedTokenSequence, Arrays.asList(CssTokenId.S, CssTokenId.IDENT, CssTokenId.MEDIA_SYM, CssTokenId.COMMA, CssTokenId.GT, CssTokenId.PLUS))) != null) {
                    joinedTokenSequence.moveNext();
                    token2 = LexUtilities.findNext(joinedTokenSequence, Arrays.asList(CssTokenId.S));
                }
                return joinedTokenSequence.offset();
            }
            if (tokenId == CssTokenId.RBRACE) {
                ++n3;
                continue;
            }
            if (tokenId == CssTokenId.LBRACE) {
                --n3;
                continue;
            }
            if (tokenId != CssTokenId.MEDIA_SYM || joinedTokenSequence.offset() >= n || n3 != 0) continue;
            return joinedTokenSequence.offset();
        } while (joinedTokenSequence.movePrevious());
        return LexUtilities.getTokenSequenceStartOffset(joinedTokenSequence);
    }

    private void getIndentFromState(List<IndentCommand> list, boolean bl, int n) {
        Stack<CssStackItem> stack = this.getStack();
        int n2 = stack.size();
        int n3 = stack.size() - 1;
        while (n3 >= 0 && !((CssStackItem)stack.get(n3)).processed.booleanValue()) {
            n2 = n3--;
        }
        for (n3 = n2; n3 < stack.size(); ++n3) {
            IndentCommand indentCommand;
            CssStackItem cssStackItem = (CssStackItem)stack.get(n3);
            assert (!cssStackItem.processed.booleanValue()) : cssStackItem;
            if (cssStackItem.state == StackItemState.IN_MEDIA || cssStackItem.state == StackItemState.IN_RULE) {
                indentCommand = new IndentCommand(IndentCommand.Type.INDENT, n);
                if (cssStackItem.indent != -1) {
                    indentCommand.setFixedIndentSize(cssStackItem.indent);
                }
                list.add(indentCommand);
                if (!bl) continue;
                cssStackItem.processed = Boolean.TRUE;
                continue;
            }
            if (cssStackItem.state == StackItemState.IN_VALUE) {
                indentCommand = new IndentCommand(IndentCommand.Type.CONTINUE, n);
                if (cssStackItem.indent != -1) {
                    indentCommand.setFixedIndentSize(cssStackItem.indent);
                }
                list.add(indentCommand);
                continue;
            }
            if (cssStackItem.state != StackItemState.RULE_FINISHED && cssStackItem.state != StackItemState.MEDIA_FINISHED) continue;
            indentCommand = new IndentCommand(IndentCommand.Type.RETURN, n);
            list.add(indentCommand);
            if (!bl) continue;
            cssStackItem.processed = Boolean.TRUE;
            stack.remove(n3);
            --n3;
        }
    }

    @Override
    protected List<IndentCommand> getLineIndent(IndenterContextData<CssTokenId> indenterContextData, List<IndentCommand> list) throws BadLocationException {
        Object object;
        Stack<CssStackItem> stack = this.getStack();
        ArrayList<IndentCommand> arrayList = new ArrayList<IndentCommand>();
        this.getIndentFromState(arrayList, true, indenterContextData.getLineStartOffset());
        JoinedTokenSequence<CssTokenId> joinedTokenSequence = indenterContextData.getJoinedTokenSequences();
        joinedTokenSequence.move(indenterContextData.getLineStartOffset());
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        while (!indenterContextData.isBlankLine() && joinedTokenSequence.moveNext() && (joinedTokenSequence.isCurrentTokenSequenceVirtual() && joinedTokenSequence.offset() < indenterContextData.getLineEndOffset() || joinedTokenSequence.offset() <= indenterContextData.getLineEndOffset())) {
            CssStackItem cssStackItem;
            object = joinedTokenSequence.token();
            if (object == null || joinedTokenSequence.embedded() != null) continue;
            if (n != -1 && object.id() != CssTokenId.S) {
                cssStackItem = stack.peek();
                assert (cssStackItem.state == StackItemState.IN_RULE || cssStackItem.state == StackItemState.IN_MEDIA);
                cssStackItem.indent = joinedTokenSequence.offset() - indenterContextData.getLineNonWhiteStartOffset();
                n = -1;
            }
            if (object.id() == CssTokenId.LBRACE) {
                if (this.inMedia) {
                    this.inMedia = false;
                    n = joinedTokenSequence.offset();
                    stack.push(new CssStackItem(StackItemState.IN_MEDIA));
                    bl2 = true;
                    continue;
                }
                if (this.isInState(stack, StackItemState.IN_RULE)) continue;
                cssStackItem = new CssStackItem(StackItemState.IN_RULE);
                n = joinedTokenSequence.offset();
                stack.push(cssStackItem);
                bl = true;
                continue;
            }
            if (object.id() == CssTokenId.COLON) {
                if (this.isInState(stack, StackItemState.IN_VALUE) || !this.isInState(stack, StackItemState.IN_RULE)) continue;
                stack.push(new CssStackItem(StackItemState.IN_VALUE));
                continue;
            }
            if (object.id() == CssTokenId.SEMICOLON) {
                if (!this.isInState(stack, StackItemState.IN_VALUE)) continue;
                cssStackItem = stack.pop();
                assert (cssStackItem.state == StackItemState.IN_VALUE);
                continue;
            }
            if (object.id() == CssTokenId.RBRACE) {
                if (this.isInState(stack, StackItemState.IN_RULE)) {
                    cssStackItem = stack.pop();
                    if (cssStackItem.state == StackItemState.IN_VALUE) {
                        cssStackItem = stack.pop();
                    }
                    assert (cssStackItem.state == StackItemState.IN_RULE) : cssStackItem;
                    if (joinedTokenSequence.offset() == indenterContextData.getLineNonWhiteStartOffset()) {
                        arrayList.add(new IndentCommand(IndentCommand.Type.RETURN, indenterContextData.getLineStartOffset()));
                        continue;
                    }
                    if (bl) continue;
                    stack.push(new CssStackItem(StackItemState.RULE_FINISHED));
                    continue;
                }
                if (!this.isInState(stack, StackItemState.IN_MEDIA)) continue;
                cssStackItem = stack.pop();
                if (cssStackItem.state == StackItemState.RULE_FINISHED) {
                    cssStackItem = stack.pop();
                    stack.push(new CssStackItem(StackItemState.RULE_FINISHED));
                }
                assert (cssStackItem.state == StackItemState.IN_MEDIA) : cssStackItem;
                if (joinedTokenSequence.offset() == indenterContextData.getLineNonWhiteStartOffset()) {
                    arrayList.add(new IndentCommand(IndentCommand.Type.RETURN, indenterContextData.getLineStartOffset()));
                    continue;
                }
                if (bl2) continue;
                stack.push(new CssStackItem(StackItemState.MEDIA_FINISHED));
                continue;
            }
            if (this.isCommentToken((Token<CssTokenId>)object)) {
                int n2 = indenterContextData.getLineStartOffset();
                if (n2 < joinedTokenSequence.offset()) {
                    n2 = joinedTokenSequence.offset();
                }
                int n3 = joinedTokenSequence.offset() + ((Object)joinedTokenSequence.token().text()).toString().trim().length() - 1;
                int n4 = indenterContextData.getLineEndOffset();
                if (n4 > n3) {
                    n4 = n3;
                }
                if (n2 > n4) {
                    assert (!this.inComment) : "token=" + object.text() + " start=" + n2 + " end=" + n4;
                    continue;
                }
                if (n2 == joinedTokenSequence.offset()) {
                    if (n4 >= n3) continue;
                    this.inComment = true;
                    int n5 = Utilities.getRowStart((BaseDocument)this.getDocument(), (int)joinedTokenSequence.offset());
                    this.preservedLineIndentation = n2 - n5;
                    continue;
                }
                if (n4 == n3) {
                    String string = this.getDocument().getText(n2, n4 - n2 + 1).trim();
                    if (!string.startsWith("*/")) {
                        IndentCommand indentCommand = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, indenterContextData.getLineStartOffset());
                        indentCommand.setFixedIndentSize(this.preservedLineIndentation);
                        arrayList.add(indentCommand);
                    }
                    assert (this.inComment) : "token=" + object.text() + " start=" + n2 + " end=" + n4;
                    this.inComment = false;
                    this.preservedLineIndentation = -1;
                    continue;
                }
                assert (this.inComment) : "token=" + object.text() + " start=" + n2 + " end=" + n4;
                IndentCommand indentCommand = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, indenterContextData.getLineStartOffset());
                indentCommand.setFixedIndentSize(this.preservedLineIndentation);
                arrayList.add(indentCommand);
                continue;
            }
            if (object.id() != CssTokenId.MEDIA_SYM || stack.size() != 0) continue;
            this.inMedia = true;
        }
        if (indenterContextData.isBlankLine() && this.inComment && arrayList.isEmpty()) {
            object = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, indenterContextData.getLineStartOffset());
            ((IndentCommand)object).setFixedIndentSize(this.preservedLineIndentation);
            arrayList.add((IndentCommand)object);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, indenterContextData.getLineStartOffset()));
        }
        if (indenterContextData.getNextLineStartOffset() != -1) {
            this.getIndentFromState(list, false, indenterContextData.getNextLineStartOffset());
            if (list.size() == 0) {
                list.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, indenterContextData.getNextLineStartOffset()));
            }
        }
        return arrayList;
    }

    private boolean isInState(Stack<CssStackItem> stack, StackItemState stackItemState) {
        for (CssStackItem cssStackItem : stack) {
            if (cssStackItem.state != stackItemState) continue;
            return true;
        }
        return false;
    }

    private static class CssStackItem {
        private StackItemState state;
        private Boolean processed = false;
        private int indent;

        private CssStackItem(StackItemState stackItemState) {
            this.state = stackItemState;
            this.indent = -1;
        }

        public String toString() {
            return "CssStackItem[state=" + (Object)((Object)this.state) + ",indent=" + this.indent + ",processed=" + this.processed + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StackItemState {
        IN_MEDIA,
        IN_RULE,
        IN_VALUE,
        RULE_FINISHED,
        MEDIA_FINISHED;

    }
}

