/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.formatting.api.embedding;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JoinedTokenSequence<T1 extends TokenId> {
    List<TokenSequenceWrapper<T1>> tss;
    private int currentTokenSequence = -1;
    private TokenSequenceWrapper<T1> currentTSW;

    private JoinedTokenSequence(List<TokenSequenceWrapper<T1>> list) {
        this.tss = list;
    }

    public static <T1 extends TokenId> JoinedTokenSequence<T1> createFromTokenSequenceWrappers(List<TokenSequenceWrapper<T1>> list) {
        return new JoinedTokenSequence<T1>(list);
    }

    public static <T1 extends TokenId> JoinedTokenSequence<T1> createFromCodeBlocks(List<CodeBlock<T1>> list) {
        ArrayList<TokenSequenceWrapper<T1>> arrayList = new ArrayList<TokenSequenceWrapper<T1>>();
        for (CodeBlock<T1> codeBlock : list) {
            arrayList.addAll(codeBlock.tss);
        }
        return new JoinedTokenSequence<T1>(arrayList);
    }

    private void checkCurrentTokenSequence() {
        if (this.currentTokenSequence == -1) {
            throw new IllegalStateException("token position was no initialized. call moveStart or something");
        }
    }

    public Token<T1> token() {
        this.checkCurrentTokenSequence();
        return this.currentTokenSequence().token();
    }

    public TokenSequence<?> embedded() {
        this.checkCurrentTokenSequence();
        return this.currentTokenSequence().embedded();
    }

    public int index() {
        this.checkCurrentTokenSequence();
        int n = (this.currentTokenSequence + 1) * 1000000;
        return n + this.currentTokenSequence().index();
    }

    private void setCurrentTokenSequenceIndex(int n) {
        this.currentTokenSequence = n;
        this.currentTSW = null;
    }

    public void moveIndex(int n) {
        this.checkCurrentTokenSequence();
        String string = "" + n;
        assert (string.length() > 6) : string;
        int n2 = Integer.parseInt(string = string.substring(string.length() - 6));
        int n3 = (n - n2) / 1000000 - 1;
        if (n3 < 0 || n3 >= this.tss.size()) {
            throw new IllegalStateException("index " + n + " is out of boundaries " + this.tss);
        }
        this.setCurrentTokenSequenceIndex(n3);
        this.currentTokenSequence().moveIndex(n2);
    }

    public TokenSequence<T1> currentTokenSequence() {
        this.checkCurrentTokenSequence();
        return this.getTokenSequenceWrapper().getTokenSequence();
    }

    public boolean isCurrentTokenSequenceVirtual() {
        this.checkCurrentTokenSequence();
        return this.getTokenSequenceWrapper().isVirtual();
    }

    private TokenSequenceWrapper<T1> getTokenSequenceWrapper() {
        if (this.currentTSW == null) {
            this.currentTSW = this.tss.get(this.currentTokenSequence);
        }
        return this.currentTSW;
    }

    public List<TokenSequenceWrapper<T1>> getContextDataTokenSequences() {
        return this.tss;
    }

    public void moveStart() {
        this.setCurrentTokenSequenceIndex(0);
        this.currentTokenSequence().moveStart();
    }

    public void moveEnd() {
        this.setCurrentTokenSequenceIndex(this.tss.size() - 1);
        this.currentTokenSequence().moveEnd();
    }

    public boolean moveNext() {
        this.checkCurrentTokenSequence();
        boolean bl = this.currentTokenSequence().moveNext();
        if (!bl) {
            if (this.currentTokenSequence < this.tss.size() - 1) {
                this.setCurrentTokenSequenceIndex(this.currentTokenSequence + 1);
                this.currentTokenSequence().moveStart();
                this.moveNext();
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean movePrevious() {
        this.checkCurrentTokenSequence();
        boolean bl = this.currentTokenSequence().movePrevious();
        if (!bl) {
            if (this.currentTokenSequence > 0) {
                this.setCurrentTokenSequenceIndex(this.currentTokenSequence - 1);
                this.currentTokenSequence().moveEnd();
                this.movePrevious();
            } else {
                return false;
            }
        }
        return true;
    }

    public int move(int n) {
        for (int i = 0; i < this.tss.size(); ++i) {
            TokenSequenceWrapper<T1> tokenSequenceWrapper = this.tss.get(i);
            if (tokenSequenceWrapper.isVirtual() || n < tokenSequenceWrapper.getStart() || n > tokenSequenceWrapper.getEnd()) continue;
            this.setCurrentTokenSequenceIndex(i);
            return this.currentTokenSequence().move(n);
        }
        return Integer.MIN_VALUE;
    }

    public boolean move(int n, boolean bl) {
        int n2 = -1;
        for (int i = 0; i < this.tss.size(); ++i) {
            TokenSequenceWrapper<T1> tokenSequenceWrapper = this.tss.get(i);
            if (tokenSequenceWrapper.isVirtual()) continue;
            if (n >= tokenSequenceWrapper.getStart() && n <= tokenSequenceWrapper.getEnd()) {
                this.setCurrentTokenSequenceIndex(i);
                this.currentTokenSequence().move(n);
                return true;
            }
            if (bl && tokenSequenceWrapper.getStart() > n) {
                this.setCurrentTokenSequenceIndex(i);
                this.currentTokenSequence().moveStart();
                return true;
            }
            if (!bl) {
                if (tokenSequenceWrapper.getStart() > n) {
                    if (n2 != -1) {
                        this.setCurrentTokenSequenceIndex(n2);
                        this.currentTokenSequence().moveEnd();
                        return true;
                    }
                    return false;
                }
                if (i == this.tss.size() - 1 && tokenSequenceWrapper.getEnd() < n) {
                    this.setCurrentTokenSequenceIndex(i);
                    this.currentTokenSequence().moveEnd();
                    return true;
                }
            }
            n2 = i;
        }
        return false;
    }

    public int offset() {
        this.checkCurrentTokenSequence();
        if (this.isCurrentTokenSequenceVirtual()) {
            assert (this.currentTokenSequence > 0);
            TokenSequenceWrapper<T1> tokenSequenceWrapper = this.tss.get(this.currentTokenSequence - 1);
            return tokenSequenceWrapper.getEnd();
        }
        return this.currentTokenSequence().offset();
    }

    public Language<T1> language() {
        this.checkCurrentTokenSequence();
        return this.currentTokenSequence().language();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (TokenSequenceWrapper<T1> tokenSequenceWrapper : this.tss) {
            String string = "";
            if (this.currentTokenSequence != -1 && tokenSequenceWrapper == this.getTokenSequenceWrapper()) {
                string = "CURRENT,";
            }
            stringBuffer.append("ContextDataTokenSequence[" + string + "ts=" + tokenSequenceWrapper.getTokenSequence().toString() + ",virtual=" + tokenSequenceWrapper.isVirtual() + "],");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return "JoinedTokenSequence[" + stringBuffer.toString() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CodeBlock<T1 extends TokenId> {
        public List<TokenSequenceWrapper<T1>> tss;

        public CodeBlock(List<TokenSequenceWrapper<T1>> list) {
            this.tss = list;
        }

        public String toString() {
            return "CodeBlock[tss=" + this.tss + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TokenSequenceWrapper<T1 extends TokenId> {
        private TokenSequence<T1> ts;
        private boolean virtual;
        private int start;
        private int end;

        public TokenSequenceWrapper(TokenSequence<T1> tokenSequence, boolean bl) {
            this.ts = tokenSequence;
            this.virtual = bl;
            tokenSequence.moveStart();
            tokenSequence.moveNext();
            this.start = tokenSequence.offset();
            tokenSequence.moveEnd();
            tokenSequence.movePrevious();
            this.end = tokenSequence.offset() + tokenSequence.token().length();
        }

        public TokenSequence<T1> getTokenSequence() {
            return this.ts;
        }

        public int getEnd() {
            return this.end;
        }

        public int getStart() {
            return this.start;
        }

        public boolean isVirtual() {
            return this.virtual;
        }

        public String toString() {
            return "ContextDataTokenSequence[ts=" + this.ts + ",virtual=" + this.virtual + "]";
        }
    }
}

