/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.css.gsf.CssAnalyser;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.parser.ASCII_CharStream;
import org.netbeans.modules.css.parser.CssParser;
import org.netbeans.modules.css.parser.ParseException;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.Token;
import org.netbeans.modules.css.parser.TokenMgrError;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssGSFParser
extends Parser {
    private final CssParser PARSER = new CssParser();
    private CssParserResult lastResult = null;
    private static final String PARSE_ERROR_KEY = "parse_error";
    public static final String GENERATED_CODE = "@@@";
    private static final String ERROR_MESSAGE_PREFIX = NbBundle.getMessage(CssGSFParser.class, (String)"unexpected_symbols");

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent sourceModificationEvent) {
        List<ParseException> list = new ArrayList<ParseException>(1);
        SimpleNode simpleNode = null;
        try {
            this.PARSER.errors().clear();
            this.PARSER.ReInit(new ASCII_CharStream(new StringReader(((Object)snapshot.getText()).toString())));
            simpleNode = this.PARSER.styleSheet();
            list = this.PARSER.errors();
        }
        catch (ParseException parseException) {
            list.add(parseException);
        }
        catch (TokenMgrError tokenMgrError) {
            list.add(new ParseException(tokenMgrError.getMessage()));
        }
        ArrayList<Error> arrayList = new ArrayList<Error>();
        arrayList.addAll(this.errors(list, snapshot));
        arrayList.addAll(CssAnalyser.checkForErrors(snapshot, simpleNode));
        this.lastResult = new CssParserResult(this, snapshot, simpleNode, arrayList);
    }

    public Parser.Result getResult(Task task) {
        return this.lastResult;
    }

    public void cancel() {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public List<Error> errors(List<ParseException> list, Snapshot snapshot) {
        ArrayList<Error> arrayList = new ArrayList<Error>(list.size());
        for (ParseException parseException : list) {
            Error error = this.createError(parseException, snapshot);
            if (error == null) continue;
            arrayList.add(error);
        }
        return arrayList;
    }

    public static boolean containsGeneratedCode(CharSequence charSequence) {
        return CharSequenceUtilities.indexOf((CharSequence)charSequence, (CharSequence)GENERATED_CODE) != -1;
    }

    private Error createError(ParseException parseException, Snapshot snapshot) {
        FileObject fileObject = snapshot.getSource().getFileObject();
        Token token = parseException.currentToken;
        if (token == null) {
            return new DefaultError(PARSE_ERROR_KEY, parseException.getMessage(), parseException.getMessage(), fileObject, 0, 0, Severity.ERROR);
        }
        Token token2 = token.next;
        int n = token2.offset;
        if (!CssGSFParser.containsGeneratedCode(token.image) && !CssGSFParser.containsGeneratedCode(token2.image)) {
            String string = this.buildErrorMessage(parseException);
            int n2 = snapshot.getOriginalOffset(n);
            int n3 = snapshot.getOriginalOffset(n + token2.image.length());
            if (n2 == -1 || n3 == -1) {
                return null;
            }
            assert (n2 <= n3);
            return new DefaultError(PARSE_ERROR_KEY, string, string, fileObject, n2, n3, Severity.ERROR);
        }
        return null;
    }

    private String buildErrorMessage(ParseException parseException) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ERROR_MESSAGE_PREFIX);
        int n = 0;
        for (int i = 0; i < parseException.expectedTokenSequences.length; ++i) {
            if (n >= parseException.expectedTokenSequences[i].length) continue;
            n = parseException.expectedTokenSequences[i].length;
        }
        Token token = parseException.currentToken.next;
        stringBuilder.append('\"');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(token.image);
            if (i < n - 1) {
                stringBuilder.append(',');
                stringBuilder.append(' ');
            }
            token = token.next;
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }
}

