/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Color;
import org.openide.util.Lookup;
import org.openide.windows.InputOutput;

public abstract class IOColors {
    private static IOColors find(InputOutput inputOutput) {
        if (inputOutput instanceof Lookup.Provider) {
            Lookup.Provider provider = (Lookup.Provider)inputOutput;
            return (IOColors)provider.getLookup().lookup(IOColors.class);
        }
        return null;
    }

    public static Color getColor(InputOutput inputOutput, OutputType outputType) {
        IOColors iOColors = IOColors.find(inputOutput);
        return iOColors != null ? iOColors.getColor(outputType) : null;
    }

    public static void setColor(InputOutput inputOutput, OutputType outputType, Color color) {
        IOColors iOColors = IOColors.find(inputOutput);
        if (iOColors != null) {
            iOColors.setColor(outputType, color);
        }
    }

    public static boolean isSupported(InputOutput inputOutput) {
        return IOColors.find(inputOutput) != null;
    }

    protected abstract Color getColor(OutputType var1);

    protected abstract void setColor(OutputType var1, Color var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputType {
        OUTPUT,
        ERROR,
        HYPERLINK,
        HYPERLINK_IMPORTANT;

    }
}

