/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.spi.dom.NodeListImpl;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.NamedNodeMapImpl;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.visitor.PathFromRootVisitor;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeImpl
implements Node,
Cloneable {
    public static final String XMLNS = "xmlns";
    private boolean inTree = false;
    private XDMModel model = null;
    private int id = -1;
    private List<Token> tokens;
    private List<Node> children;
    private List<Attribute> attributes = null;

    NodeImpl() {
    }

    @Override
    public final int getId() {
        return this.id;
    }

    private void setId(int n) {
        this.id = n;
    }

    public int hashCode() {
        return this.getId();
    }

    @Override
    public final boolean isInTree() {
        return this.inTree && this.getModel() != null;
    }

    @Override
    public void addedToTree(XDMModel xDMModel) {
        if (!this.isInTree()) {
            this.inTree = true;
            if (this.getModel() != xDMModel) {
                this.setModel(xDMModel);
                this.setId(xDMModel.getNextNodeId());
            } else if (this.getId() == -1) {
                this.setId(xDMModel.getNextNodeId());
            }
            for (Node node : this.getChildren()) {
                node.addedToTree(xDMModel);
            }
            for (Attribute attribute : this.getAttributesForRead()) {
                attribute.addedToTree(xDMModel);
            }
        }
    }

    private UniqueId createUniqueId() {
        return new UniqueId(){
            private int lastId = -1;

            public int nextId() {
                return ++this.lastId;
            }
        };
    }

    public void assignNodeIdRecursively() {
        this.assignNodeId(this.createUniqueId());
    }

    void assignNodeId(UniqueId uniqueId) {
        assert (!this.isInTree());
        this.setId(uniqueId.nextId());
        for (Node node : this.getChildren()) {
            ((NodeImpl)node).assignNodeId(uniqueId);
        }
        for (Attribute attribute : this.getAttributesForRead()) {
            ((NodeImpl)attribute).assignNodeId(uniqueId);
        }
    }

    public void assignNodeId(int n) {
        assert (!this.isInTree());
        this.setId(n);
        for (Node node : this.getChildren()) {
            ((NodeImpl)node).assignNodeId(n);
        }
        for (Attribute attribute : this.getAttributesForRead()) {
            ((NodeImpl)attribute).assignNodeId(n);
        }
    }

    protected XDMModel getModel() {
        return this.model;
    }

    private void setModel(XDMModel xDMModel) {
        assert (xDMModel != null);
        this.model = xDMModel;
    }

    @Override
    public boolean isEquivalentNode(Node node) {
        return this == node || this.getClass().isInstance(node) && this.getModel() != null && this.getModel() == ((NodeImpl)node).getModel() && this.getId() != -1 && this.getId() == node.getId();
    }

    final void checkNotInTree() {
        if (this.isInTree()) {
            throw new IllegalStateException("mutations cannot occur on nodes already added to a tree");
        }
    }

    @Override
    public boolean isSupported(String string, String string2) {
        return "1.0".equals(string2);
    }

    @Override
    public Node clone(boolean bl, boolean bl2, boolean bl3) {
        try {
            NodeImpl nodeImpl = (NodeImpl)super.clone();
            nodeImpl.inTree = false;
            if (bl) {
                nodeImpl.setTokens(new ArrayList<Token>(this.getTokens()));
            } else {
                nodeImpl.setTokens(this.getTokens());
            }
            if (bl2) {
                nodeImpl.setAttributes(new ArrayList<Attribute>(this.getAttributesForRead()));
            } else {
                nodeImpl.setAttributes(this.getAttributesForRead());
            }
            if (bl3) {
                nodeImpl.setChildren(new ArrayList<Node>(this.getChildren()));
            } else {
                nodeImpl.setChildren(this.getChildren());
            }
            return nodeImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public Node cloneNode(boolean bl) {
        return this.cloneNode(bl, true);
    }

    public Node cloneNode(boolean bl, boolean bl2) {
        Document document = this.isInTree() ? (Document)this.getOwnerDocument() : null;
        Map<Integer, String> map = null;
        if (bl2 && document != null) {
            map = document.getNamespaceMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        return this.cloneNode(bl, map, hashMap);
    }

    public Node cloneNode(boolean bl, Map<Integer, String> map, Map<String, String> map2) {
        try {
            ArrayList<Node> arrayList;
            NodeImpl nodeImpl = (NodeImpl)super.clone();
            nodeImpl.inTree = false;
            nodeImpl.model = null;
            nodeImpl.setTokens(new ArrayList<Token>(this.getTokens()));
            if (bl) {
                arrayList = new ArrayList<Node>(this.getChildren().size());
                for (Node node : this.getChildren()) {
                    NodeImpl nodeImpl2 = (NodeImpl)node;
                    NodeImpl nodeImpl3 = (NodeImpl)nodeImpl2.cloneNode(bl, map, map2);
                    arrayList.add(nodeImpl3);
                }
                nodeImpl.setChildren(arrayList);
            }
            arrayList = new ArrayList(this.getAttributesForRead().size());
            for (Attribute attribute : this.getAttributesForRead()) {
                arrayList.add((Attribute)attribute.cloneNode(bl, map, map2));
            }
            nodeImpl.setAttributes(arrayList);
            this.cloneNamespacePrefixes(map, map2);
            return nodeImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    protected void cloneNamespacePrefixes(Map<Integer, String> map, Map<String, String> map2) {
        if (map == null) {
            return;
        }
        String string = map.get(this.getId());
        if (string != null) {
            String string2 = this.getPrefix();
            if (string2 != null) {
                map2.put(string2, string);
            } else {
                map2.put("", string);
            }
        }
    }

    public Node cloneShallowWithModelContext() {
        try {
            NodeImpl nodeImpl = (NodeImpl)super.clone();
            nodeImpl.inTree = false;
            nodeImpl.setTokens(new ArrayList<Token>(this.getTokens()));
            if (this.hasChildNodes()) {
                nodeImpl.setChildren(new ArrayList<Node>(this.getChildren()));
            }
            if (this.hasAttributes()) {
                nodeImpl.setAttributes(new ArrayList<Attribute>(this.getAttributesForRead()));
            }
            return nodeImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean hasChildNodes() {
        return !this.getChildren().isEmpty();
    }

    @Override
    public NodeList getChildNodes() {
        if (!this.hasChildNodes()) {
            return NodeListImpl.EMPTY;
        }
        return new NodeListImpl(this.getChildren());
    }

    @Override
    public Node getFirstChild() {
        if (!this.hasChildNodes()) {
            return null;
        }
        return this.getChildren().get(0);
    }

    @Override
    public Node getLastChild() {
        if (!this.hasChildNodes()) {
            return null;
        }
        return this.getChildren().get(this.getChildren().size() - 1);
    }

    @Override
    public int getIndexOfChild(Node node) {
        if (node == null) {
            return -1;
        }
        List<Node> list = this.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != node && (list.get(i).getId() != node.getId() || node.getId() == -1)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Node appendChild(org.w3c.dom.Node node) {
        this.checkNotInTree();
        if (node instanceof Node) {
            NodeImpl nodeImpl = (NodeImpl)node;
            nodeImpl.checkNotInTree();
            this.getChildrenForWrite().add(nodeImpl);
            return nodeImpl;
        }
        throw new DOMException(17, node.getClass().getName());
    }

    @Override
    public Node replaceChild(org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        this.checkNotInTree();
        if (node instanceof Node && node2 instanceof Node) {
            NodeImpl nodeImpl = (NodeImpl)node;
            NodeImpl nodeImpl2 = (NodeImpl)node2;
            nodeImpl.checkNotInTree();
            int n = this.getIndexOfChild(nodeImpl2);
            if (n != -1) {
                return this.getChildrenForWrite().set(n, nodeImpl);
            }
            throw new DOMException(8, null);
        }
        throw new DOMException(17, null);
    }

    public Node reorderChild(org.w3c.dom.Node node, int n) {
        this.checkNotInTree();
        if (node instanceof Node) {
            NodeImpl nodeImpl = (NodeImpl)node;
            if (!nodeImpl.isInTree()) {
                throw new IllegalArgumentException("Node is not in tree");
            }
            int n2 = this.getIndexOfChild(nodeImpl);
            if (n == n2) {
                return nodeImpl;
            }
            if (!this.getChildrenForWrite().remove(nodeImpl)) {
                throw new IllegalArgumentException("Node is not in children");
            }
            n = n > n2 ? n - 1 : n;
            this.getChildrenForWrite().add(n, nodeImpl);
            return nodeImpl;
        }
        throw new DOMException(17, null);
    }

    public void reorderChildren(int[] nArray) {
        this.checkNotInTree();
        ArrayList<Node> arrayList = new ArrayList<Node>(this.getChildren());
        if (nArray.length != arrayList.size()) {
            throw new IllegalArgumentException("Permutation length: " + nArray.length + " " + "is different than children size: " + arrayList.size());
        }
        List<Node> list = this.getChildrenForWrite();
        for (int i = 0; i < arrayList.size(); ++i) {
            Node node = (Node)arrayList.get(i);
            list.set(nArray[i], node);
        }
    }

    @Override
    public Node removeChild(org.w3c.dom.Node node) {
        this.checkNotInTree();
        if (node instanceof Attribute ? this.getAttributesForWrite().remove(node) : node instanceof Node && this.getChildrenForWrite().remove(node)) {
            return (Node)node;
        }
        throw new DOMException(17, null);
    }

    @Override
    public Node insertBefore(org.w3c.dom.Node node, org.w3c.dom.Node node2) throws DOMException {
        if (node2 == null) {
            return this.appendChild(node);
        }
        this.checkNotInTree();
        if (node instanceof Node && node2 instanceof Node) {
            NodeImpl nodeImpl = (NodeImpl)node;
            nodeImpl.checkNotInTree();
            int n = this.getIndexOfChild((NodeImpl)node2);
            if (n < 0) {
                throw new DOMException(8, null);
            }
            this.getChildrenForWrite().add(n, nodeImpl);
            return nodeImpl;
        }
        throw new DOMException(17, null);
    }

    @Override
    public boolean hasAttributes() {
        return !this.getAttributesForRead().isEmpty();
    }

    @Override
    public NamedNodeMap getAttributes() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return NamedNodeMapImpl.EMPTY;
        }
        return new NamedNodeMapImpl(this.attributes);
    }

    @Override
    public org.w3c.dom.Document getOwnerDocument() {
        return this.getModel().getDocument();
    }

    @Override
    public Node getParentNode() {
        if (!this.isInTree()) {
            return null;
        }
        PathFromRootVisitor pathFromRootVisitor = new PathFromRootVisitor();
        List<Node> list = pathFromRootVisitor.findPath(this.getModel().getDocument(), this);
        if (list == null || list.size() < 2) {
            return null;
        }
        return list.get(1);
    }

    @Override
    public Node getNextSibling() {
        NodeImpl nodeImpl;
        if (!this.isInTree()) {
            return null;
        }
        PathFromRootVisitor pathFromRootVisitor = new PathFromRootVisitor();
        List<Node> list = pathFromRootVisitor.findPath(this.getModel().getDocument(), this);
        if (list == null || list.size() < 2) {
            return null;
        }
        NodeImpl nodeImpl2 = (NodeImpl)list.get(1);
        int n = nodeImpl2.getIndexOfChild(nodeImpl = (NodeImpl)list.get(0)) + 1;
        if (n >= nodeImpl2.getChildren().size()) {
            return null;
        }
        return nodeImpl2.getChildren().get(n);
    }

    @Override
    public Node getPreviousSibling() {
        NodeImpl nodeImpl;
        if (!this.isInTree()) {
            return null;
        }
        PathFromRootVisitor pathFromRootVisitor = new PathFromRootVisitor();
        List<Node> list = pathFromRootVisitor.findPath(this.getModel().getDocument(), this);
        if (list == null || list.size() < 2) {
            return null;
        }
        NodeImpl nodeImpl2 = (NodeImpl)list.get(1);
        int n = nodeImpl2.getIndexOfChild(nodeImpl = (NodeImpl)list.get(0)) - 1;
        if (n < 0) {
            return null;
        }
        return nodeImpl2.getChildren().get(n);
    }

    @Override
    public abstract short getNodeType();

    @Override
    public abstract String getNodeName();

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String string) throws DOMException {
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public String getNamespaceURI(Document document) {
        assert (document != null);
        return document.getNamespaceURI(this);
    }

    @Override
    public String getNamespaceURI() {
        String string = this.lookupNamespaceLocally(this.getPrefix());
        if (string != null) {
            return string;
        }
        if (this.isInTree()) {
            return this.getModel().getDocument().getNamespaceURI(this);
        }
        return this.lookupNamespaceURI(this.getPrefix());
    }

    @Override
    public String lookupNamespaceURI(String string) {
        String string2;
        if (string == null) {
            string = "";
        }
        if ((string2 = this.lookupNamespaceLocally(string)) == null && this.isInTree()) {
            List<Node> list = new PathFromRootVisitor().findPath(this.getModel().getDocument(), this);
            string2 = NodeImpl.lookupNamespace(string, list);
        }
        return string2;
    }

    public static String lookupNamespace(Node node, List<Node> list) {
        String string = node.getNamespaceURI();
        if (string == null) {
            string = NodeImpl.lookupNamespace(node.getPrefix(), list);
        }
        return string;
    }

    public static String lookupNamespace(String string, List<Node> list) {
        if (list == null) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        for (Node node : list) {
            String string2 = ((NodeImpl)node).lookupNamespaceLocally(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    String lookupNamespaceLocally(String string) {
        if (string == null) {
            string = "";
        }
        if (this.hasAttributes()) {
            for (Attribute attribute : this.getAttributesForRead()) {
                String string2;
                if (!attribute.isXmlnsAttribute() || !(string2 = attribute.getPrefix() == null ? "" : attribute.getLocalName()).equals(string)) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    String lookupPrefixLocally(String string) {
        if (this.hasAttributes()) {
            String string2 = null;
            for (Attribute attribute : this.getAttributesForRead()) {
                String string3 = attribute.getName();
                if (!string3.startsWith(XMLNS)) continue;
                if (string3.length() == 5) {
                    string2 = attribute.getValue();
                    continue;
                }
                if (string3.charAt(5) != ':' || !string.equals(attribute.getValue())) continue;
                return string3.substring(6);
            }
            if (string.equals(string2)) {
                return "";
            }
        }
        return null;
    }

    @Override
    public String lookupPrefix(String string) {
        PathFromRootVisitor pathFromRootVisitor;
        List<Node> list;
        if (string == null) {
            return null;
        }
        if (this.isInTree() && (list = (pathFromRootVisitor = new PathFromRootVisitor()).findPath(this.getModel().getDocument(), this)) != null && !list.isEmpty()) {
            return NodeImpl.lookupPrefix(string, list);
        }
        return this.lookupPrefixLocally(string);
    }

    public static String lookupPrefix(String string, List<Node> list) {
        if (list == null) {
            return null;
        }
        for (Node node : list) {
            NodeImpl nodeImpl = (NodeImpl)node;
            String string2 = nodeImpl.lookupPrefixLocally(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String string) throws DOMException {
    }

    @Override
    public void normalize() {
    }

    @Override
    public short compareDocumentPosition(org.w3c.dom.Node node) {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public String getBaseURI() {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public Object getFeature(String string, String string2) {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public String getTextContent() {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public Object getUserData(String string) {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public boolean isEqualNode(org.w3c.dom.Node node) {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public boolean isSameNode(org.w3c.dom.Node node) {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public void setTextContent(String string) {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    public void copyTokens(Node node) {
        this.checkNotInTree();
        this.setTokens(((NodeImpl)node).getTokens());
    }

    private List<Node> getChildren() {
        return this.createUnmodifiableListIfNeeded(this.children);
    }

    private List<Node> getChildrenForWrite() {
        this.checkNotInTree();
        if (this.children == null) {
            this.children = new ArrayList<Node>(0);
        }
        return this.children;
    }

    private void setChildren(List<Node> list) {
        this.checkNotInTree();
        this.children = list;
    }

    protected List<Attribute> getAttributesForRead() {
        return this.createUnmodifiableListIfNeeded(this.attributes);
    }

    protected List<Attribute> getAttributesForWrite() {
        this.checkNotInTree();
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>(0);
        }
        return this.attributes;
    }

    private void setAttributes(List<Attribute> list) {
        this.checkNotInTree();
        this.attributes = list;
    }

    public List<Token> getTokens() {
        return this.createUnmodifiableListIfNeeded(this.tokens);
    }

    List<Token> getTokensForWrite() {
        this.checkNotInTree();
        if (this.tokens == null) {
            this.tokens = new ArrayList<Token>(0);
        }
        return this.tokens;
    }

    void setTokens(List<Token> list) {
        this.tokens = list;
    }

    public Node copy() {
        NodeImpl nodeImpl = (NodeImpl)this.cloneNode(true);
        nodeImpl.assignNodeId(-1);
        return nodeImpl;
    }

    private <E> List<E> createUnmodifiableListIfNeeded(List<E> list) {
        List<Object> list2 = list;
        if (list == null) {
            list2 = Collections.emptyList();
        } else if (list instanceof ArrayList) {
            list2 = Collections.unmodifiableList(list);
        }
        return list2;
    }

    private static interface UniqueId {
        public int nextId();
    }
}

