/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Rule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class LegalCombinationOfAnnotations
extends JPAClassRule {
    private static Collection<IllegalCombination> illegalClassAnnotationCombinations = Arrays.asList(new IllegalCombination(Collections.singleton("javax.persistence.Entity"), Arrays.asList("javax.persistence.Embeddable", "javax.persistence.MappedSuperclass")), new IllegalCombination(Collections.singleton("javax.persistence.Table"), Collections.singleton("javax.persistence.MappedSuperclass")));
    private static Collection<IllegalCombination> illegalAttrAnnotationCombinations = Arrays.asList(new Object[0]);

    public LegalCombinationOfAnnotations() {
        this.setClassContraints(Arrays.asList(JPAClassRule.ClassConstraints.ENTITY, JPAClassRule.ClassConstraints.EMBEDDABLE, JPAClassRule.ClassConstraints.MAPPED_SUPERCLASS));
    }

    public ErrorDescription[] apply(TypeElement typeElement, ProblemContext problemContext) {
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        Collection<String> collection = ModelUtils.extractAnnotationNames(typeElement);
        for (IllegalCombination object : illegalClassAnnotationCombinations) {
            object.check(problemContext, typeElement, arrayList, collection);
        }
        for (Element element : typeElement.getEnclosedElements()) {
            Collection<String> collection2 = ModelUtils.extractAnnotationNames(element);
            for (IllegalCombination illegalCombination : illegalAttrAnnotationCombinations) {
                illegalCombination.check(problemContext, element, arrayList, collection2);
            }
        }
        return arrayList.toArray(new ErrorDescription[arrayList.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IllegalCombination {
        private Collection<String> set1;
        private Collection<String> set2;

        IllegalCombination(Collection<String> collection, Collection<String> collection2) {
            this.set1 = collection;
            this.set2 = collection2;
        }

        void check(ProblemContext problemContext, Element element, Collection<ErrorDescription> collection, Collection<String> collection2) {
            for (String string : collection2) {
                if (!this.set1.contains(string)) continue;
                for (String string2 : this.set2) {
                    if (!collection2.contains(string2)) continue;
                    ErrorDescription errorDescription = Rule.createProblem(element, problemContext, NbBundle.getMessage(LegalCombinationOfAnnotations.class, (String)"MSG_IllegalAnnotationCombination", (Object)ModelUtils.shortAnnotationName(string), (Object)ModelUtils.shortAnnotationName(string2)));
                    collection.add(errorDescription);
                }
            }
        }
    }
}

