/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.Collections;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.db.api.sql.SQLKeywords;
import org.netbeans.modules.j2ee.jpa.model.JPAHelper;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.rules.entity.IdDefinedInHierarchy;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.dd.JavaPersistenceQLKeywords;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class ValidPrimaryTableName
extends JPAClassRule {
    public ValidPrimaryTableName() {
        this.setClassContraints(Collections.singleton(JPAClassRule.ClassConstraints.ENTITY));
    }

    public ErrorDescription[] apply(TypeElement typeElement, ProblemContext problemContext) {
        String string = JPAHelper.getPrimaryTableName((Entity)problemContext.getModelElement());
        if (string.length() == 0) {
            return new ErrorDescription[]{ValidPrimaryTableName.createProblem(typeElement, problemContext, NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_InvalidPersistenceQLIdentifier"))};
        }
        if (JavaPersistenceQLKeywords.isKeyword((String)string)) {
            return new ErrorDescription[]{ValidPrimaryTableName.createProblem(typeElement, problemContext, NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_ClassNamedWithJavaPersistenceQLKeyword"))};
        }
        if (SQLKeywords.isSQL99ReservedKeyword((String)string)) {
            return new ErrorDescription[]{ValidPrimaryTableName.createProblem((Element)typeElement, problemContext, NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_ClassNamedWithReservedSQLKeyword"), Severity.WARNING)};
        }
        return null;
    }
}

