/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.modules.beans.BeanUtils;
import org.netbeans.modules.beans.PatternGroupNode;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class PropertyPatternPanel
extends JPanel
implements ActionListener {
    private Dialog dialog = null;
    private PatternGroupNode groupNode;
    private boolean forInterface = false;
    private static String[] TYPES = null;
    private static final String[] MODES = new String[]{BeanUtils.getString("LAB_ReadWriteMODE"), BeanUtils.getString("LAB_ReadOnlyMODE"), BeanUtils.getString("LAB_WriteOnlyMODE")};
    static final long serialVersionUID = 4959196907494713555L;
    private JCheckBox boundCheckBox;
    private JCheckBox constrainedCheckBox;
    private JCheckBox fieldCheckBox;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel mainPanel;
    private JComboBox modeComboBox;
    private JLabel modeLabel;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JPanel optionsPanel;
    private JPanel propertyPanel;
    private JCheckBox returnCheckBox;
    private JCheckBox setCheckBox;
    private JCheckBox supportCheckBox;
    private JComboBox typeComboBox;
    private JLabel typeLabel;

    public PropertyPatternPanel() {
        int n;
        this.initComponents();
        this.initAccessibility();
        String[] stringArray = PropertyPatternPanel.getTypes();
        for (n = 0; n < stringArray.length; ++n) {
            this.typeComboBox.addItem(stringArray[n]);
        }
        this.typeComboBox.setSelectedItem(NbBundle.getMessage(PropertyPatternPanel.class, (String)"PropertyPatternPanel_SelectedType"));
        for (n = 0; n < MODES.length; ++n) {
            this.modeComboBox.addItem(MODES[n]);
        }
        this.modeComboBox.setSelectedItem(MODES[0]);
        ((TitledBorder)this.propertyPanel.getBorder()).setTitle(BeanUtils.getString("CTL_PropertyPanel_propertyPanel"));
        ((TitledBorder)this.optionsPanel.getBorder()).setTitle(BeanUtils.getString("CTL_PropertyPanel_optionsPanel"));
        this.nameLabel.setText(BeanUtils.getString("CTL_PropertyPanel_nameLabel"));
        this.nameLabel.setDisplayedMnemonic(BeanUtils.getString("CTL_PropertyPanel_nameLabel_Mnemonic").charAt(0));
        this.nameLabel.setLabelFor(this.nameTextField);
        this.nameTextField.setToolTipText(BeanUtils.getString("ACS_PropertyPanel_nameTextFieldA11yDesc"));
        this.typeLabel.setText(BeanUtils.getString("CTL_PropertyPanel_typeLabel"));
        this.typeLabel.setDisplayedMnemonic(BeanUtils.getString("CTL_PropertyPanel_typeLabel_Mnemonic").charAt(0));
        this.typeLabel.setLabelFor(this.typeComboBox);
        this.typeComboBox.setToolTipText(BeanUtils.getString("ACS_PropertyPanel_typeComboBoxA11yDesc"));
        this.modeLabel.setText(BeanUtils.getString("CTL_PropertyPanel_modeLabel"));
        this.modeLabel.setDisplayedMnemonic(BeanUtils.getString("CTL_PropertyPanel_modeLabel_Mnemonic").charAt(0));
        this.modeLabel.setLabelFor(this.modeComboBox);
        this.modeComboBox.setToolTipText(BeanUtils.getString("ACS_PropertyPanel_modeComboBoxA11yDesc"));
        this.boundCheckBox.setText(BeanUtils.getString("CTL_PropertyPanel_boundCheckBox"));
        this.boundCheckBox.setMnemonic(BeanUtils.getString("CTL_PropertyPanel_boundCheckBox_Mnemonic").charAt(0));
        this.boundCheckBox.setToolTipText(BeanUtils.getString("ACS_PropertyPanel_boundCheckBoxA11yDesc"));
        this.constrainedCheckBox.setText(BeanUtils.getString("CTL_PropertyPanel_constrainedCheckBox"));
        this.constrainedCheckBox.setMnemonic(BeanUtils.getString("CTL_PropertyPanel_constrainedCheckBox_Mnemonic").charAt(0));
        this.constrainedCheckBox.setToolTipText(BeanUtils.getString("ACS_PropertyPanel_constrainedCheckBoxA11yDesc"));
        this.fieldCheckBox.setText(BeanUtils.getString("CTL_PropertyPanel_fieldCheckBox"));
        this.fieldCheckBox.setMnemonic(BeanUtils.getString("CTL_PropertyPanel_fieldCheckBox_Mnemonic").charAt(0));
        this.fieldCheckBox.setToolTipText(BeanUtils.getString("ACS_PropertyPanel_fieldCheckBoxA11yDesc"));
        this.returnCheckBox.setText(BeanUtils.getString("CTL_PropertyPanel_returnCheckBox"));
        this.returnCheckBox.setMnemonic(BeanUtils.getString("CTL_PropertyPanel_returnCheckBox_Mnemonic").charAt(0));
        this.returnCheckBox.setToolTipText(BeanUtils.getString("ACS_PropertyPanel_returnCheckBoxA11yDesc"));
        this.setCheckBox.setText(BeanUtils.getString("CTL_PropertyPanel_setCheckBox"));
        this.setCheckBox.setMnemonic(BeanUtils.getString("CTL_PropertyPanel_setCheckBox_Mnemonic").charAt(0));
        this.setCheckBox.setToolTipText(BeanUtils.getString("ACS_PropertyPanel_setCheckBoxA11yDesc"));
        this.supportCheckBox.setText(BeanUtils.getString("CTL_PropertyPanel_supportCheckBox"));
        this.supportCheckBox.setMnemonic(BeanUtils.getString("CTL_PropertyPanel_supportCheckBox_Mnemonic").charAt(0));
        this.supportCheckBox.setToolTipText(BeanUtils.getString("ACS_PropertyPanel_supportCheckBoxA11yDesc"));
        HelpCtx.setHelpIDString((JComponent)this, (String)"beans.properties");
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(BeanUtils.getString("ACSD_PropertyPanelDialog"));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(BeanUtils.getString("ACS_PropertyPanel_nameLabelA11yDesc"));
        this.nameTextField.getAccessibleContext().setAccessibleName(BeanUtils.getString("ACS_PropertyPanel_nameTextFieldA11yName"));
        this.typeLabel.getAccessibleContext().setAccessibleDescription(BeanUtils.getString("ACS_PropertyPanel_typeLabelA11yDesc"));
        this.typeComboBox.getAccessibleContext().setAccessibleName(BeanUtils.getString("ACS_PropertyPanel_typeComboBoxA11yName"));
        this.modeLabel.getAccessibleContext().setAccessibleDescription(BeanUtils.getString("ACS_PropertyPanel_modeLabelA11yDesc"));
        this.modeComboBox.getAccessibleContext().setAccessibleName(BeanUtils.getString("ACS_PropertyPanel_modeComboBoxA11yName"));
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.propertyPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.modeLabel = new JLabel();
        this.modeComboBox = new JComboBox();
        this.jPanel3 = new JPanel();
        this.boundCheckBox = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.constrainedCheckBox = new JCheckBox();
        this.optionsPanel = new JPanel();
        this.fieldCheckBox = new JCheckBox();
        this.returnCheckBox = new JCheckBox();
        this.setCheckBox = new JCheckBox();
        this.supportCheckBox = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.propertyPanel.setLayout(new GridBagLayout());
        this.propertyPanel.setBorder(new TitledBorder(new EtchedBorder(null, new Color(149, 142, 130)), "propertyPanel"));
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)"nameLabel");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        this.propertyPanel.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.propertyPanel.add((Component)this.nameTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.typeLabel, (String)"typeLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        this.propertyPanel.add((Component)this.typeLabel, gridBagConstraints);
        this.typeComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.propertyPanel.add((Component)this.typeComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.modeLabel, (String)"modeLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        this.propertyPanel.add((Component)this.modeLabel, gridBagConstraints);
        this.modeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyPatternPanel.this.modeComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.propertyPanel.add((Component)this.modeComboBox, gridBagConstraints);
        this.propertyPanel.add((Component)this.jPanel3, new GridBagConstraints());
        Mnemonics.setLocalizedText((AbstractButton)this.boundCheckBox, (String)"boundCheckBox");
        this.boundCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyPatternPanel.this.boundCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.propertyPanel.add((Component)this.boundCheckBox, gridBagConstraints);
        this.propertyPanel.add((Component)this.jPanel4, new GridBagConstraints());
        Mnemonics.setLocalizedText((AbstractButton)this.constrainedCheckBox, (String)"constrainedCheckBox");
        this.constrainedCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyPatternPanel.this.constrainedCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.propertyPanel.add((Component)this.constrainedCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.propertyPanel, gridBagConstraints);
        this.optionsPanel.setLayout(new GridBagLayout());
        this.optionsPanel.setBorder(new TitledBorder(new EtchedBorder(null, new Color(149, 142, 130)), "optionsPanel"));
        this.fieldCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.fieldCheckBox, (String)"fieldCheckBox");
        this.fieldCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyPatternPanel.this.fieldCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.optionsPanel.add((Component)this.fieldCheckBox, gridBagConstraints);
        this.returnCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.returnCheckBox, (String)"returnCheckBox");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.optionsPanel.add((Component)this.returnCheckBox, gridBagConstraints);
        this.setCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.setCheckBox, (String)"setCheckBox");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.optionsPanel.add((Component)this.setCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.supportCheckBox, (String)"supportCheckBox");
        this.supportCheckBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.optionsPanel.add((Component)this.supportCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.optionsPanel, gridBagConstraints);
        this.add((Component)this.mainPanel, "Center");
    }

    private void fieldCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
        this.returnCheckBox.setSelected(this.fieldCheckBox.isSelected());
        this.setCheckBox.setSelected(this.fieldCheckBox.isSelected());
    }

    private void constrainedCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    private void boundCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    private void modeComboBoxActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    Result getResult() {
        Result result = new Result();
        result.name = this.nameTextField.getText();
        result.type = this.typeComboBox.getEditor().getItem().toString();
        result.mode = this.modeComboBox.getSelectedItem().toString().equals(MODES[1]) ? 2 : (this.modeComboBox.getSelectedItem().toString().equals(MODES[2]) ? 4 : 1);
        if (this.boundCheckBox.isSelected()) {
            result.bound = true;
        }
        if (this.constrainedCheckBox.isSelected()) {
            result.constrained = true;
        }
        if (this.fieldCheckBox.isSelected()) {
            result.withField = true;
        }
        if (this.returnCheckBox.isSelected()) {
            result.withReturn = true;
        }
        if (this.setCheckBox.isSelected()) {
            result.withSet = true;
        }
        if (this.supportCheckBox.isSelected()) {
            result.withSupport = true;
        }
        return result;
    }

    private void protectControls() {
        Result result = this.getResult();
        boolean bl = !this.forInterface;
        this.fieldCheckBox.setEnabled(bl);
        this.returnCheckBox.setEnabled((result.mode == 1 || result.mode == 2) && result.withField && bl);
        this.setCheckBox.setEnabled((result.mode == 1 || result.mode == 4) && result.withField && bl);
        this.supportCheckBox.setEnabled((result.bound || result.constrained) && bl);
        this.boundCheckBox.setEnabled(bl);
        this.constrainedCheckBox.setEnabled(bl);
    }

    void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    void setForInterface(boolean bl) {
        this.forInterface = bl;
        this.protectControls();
        this.fieldCheckBox.setSelected(!bl);
        this.returnCheckBox.setSelected(!bl);
        this.setCheckBox.setSelected(!bl);
    }

    void setGroupNode(PatternGroupNode patternGroupNode) {
        this.groupNode = patternGroupNode;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public static String[] getTypes() {
        if (TYPES == null) {
            String string = NbBundle.getMessage(PropertyPatternPanel.class, (String)"IdxPropertyPatternPanel_Types");
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            LinkedList<String> linkedList = new LinkedList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                linkedList.add(string2);
            }
            TYPES = linkedList.toArray(new String[linkedList.size()]);
        }
        return TYPES;
    }

    class Result {
        String name;
        String type;
        int mode = 1;
        boolean bound = false;
        boolean constrained = false;
        boolean withField = false;
        boolean withReturn = false;
        boolean withSet = false;
        boolean withSupport = false;

        Result() {
        }
    }
}

