/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.util.Stack;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.netbeans.modules.maven.graph.ArtifactGraphNode;
import org.netbeans.modules.maven.graph.ArtifactWidget;
import org.netbeans.modules.maven.graph.DependencyGraphScene;

class SearchVisitor
implements DependencyNodeVisitor {
    private DependencyGraphScene scene;
    private DependencyNode root;
    private Stack<DependencyNode> path;
    private String searchTerm;

    SearchVisitor(DependencyGraphScene dependencyGraphScene) {
        this.scene = dependencyGraphScene;
        this.path = new Stack();
    }

    void setSearchString(String string) {
        this.searchTerm = string;
    }

    public boolean visit(DependencyNode dependencyNode) {
        if (this.root == null) {
            this.root = dependencyNode;
        }
        if (dependencyNode.getState() == 0) {
            ArtifactGraphNode artifactGraphNode = this.scene.getGraphNodeRepresentant(dependencyNode);
            ArtifactWidget artifactWidget = (ArtifactWidget)this.scene.findWidget(artifactGraphNode);
            artifactWidget.hightlightText(this.searchTerm);
            this.path.push(dependencyNode);
            return true;
        }
        return false;
    }

    public boolean endVisit(DependencyNode dependencyNode) {
        if (dependencyNode.getState() == 0) {
            this.path.pop();
        }
        return true;
    }
}

