/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.welcome.content.BundleSupport;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.HttpProxySettings;
import org.netbeans.modules.welcome.content.Utils;
import org.netbeans.modules.welcome.content.WebLink;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.WindowManager;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSSFeed
extends JPanel
implements Constants,
PropertyChangeListener {
    private String url;
    private boolean showProxyButton = true;
    private RequestProcessor.Task reloadTimer;
    protected long lastReload = 0L;
    public static final String FEED_CONTENT_PROPERTY = "feedContent";
    private static DateFormat parsingDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    private static DateFormat parsingDateFormatShort = new SimpleDateFormat("EEE, dd MMM yyyy", Locale.ENGLISH);
    private static DateFormat parsingDateFormatLong = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
    private static DateFormat printingDateFormatShort = DateFormat.getDateInstance(3);
    private boolean isCached = false;
    private final Logger LOGGER = Logger.getLogger(RSSFeed.class.getName());
    private int maxDescriptionChars = -1;
    private boolean foregroundColorFlag;
    private static final long serialVersionUID = 1L;

    private static File initCacheStore(String string) throws IOException {
        File file;
        String string2 = System.getProperty("netbeans.user");
        if (string2 != null) {
            file = new File(new File(new File(string2, "var"), "cache"), "welcome");
        } else {
            File file2 = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
            file = new File(file2, "welcome");
        }
        file = new File(file, string);
        file.getParentFile().mkdirs();
        file.createNewFile();
        return file;
    }

    public RSSFeed(String string, boolean bl) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.url = string;
        this.showProxyButton = bl;
        this.setBorder(null);
        this.add((Component)this.buildContentLoadingLabel(), "Center");
        HttpProxySettings.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)HttpProxySettings.getDefault()));
    }

    public RSSFeed(boolean bl) {
        this((String)null, bl);
    }

    public void setContent(Component component) {
        this.removeAll();
        Dimension dimension = new Dimension();
        this.add(component, "Center");
        this.firePropertyChange(FEED_CONTENT_PROPERTY, null, component);
        this.revalidate();
        this.invalidate();
        this.repaint();
    }

    public Component getContent() {
        return this;
    }

    public void reload() {
        new Reload().start();
    }

    protected int getMaxItemCount() {
        return 3;
    }

    protected List<FeedItem> buildItemList() throws SAXException, ParserConfigurationException, IOException {
        XMLReader xMLReader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
        FeedHandler feedHandler = new FeedHandler(this.getMaxItemCount());
        xMLReader.setContentHandler(feedHandler);
        xMLReader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
        xMLReader.setErrorHandler(new ErrorCatcher());
        InputSource inputSource = this.findInputSource(new URL(this.url));
        xMLReader.parse(inputSource);
        return feedHandler.getItemList();
    }

    protected final String url2path(URL uRL) {
        StringBuilder stringBuilder = new StringBuilder(uRL.getHost());
        if (uRL.getPort() != -1) {
            stringBuilder.append(uRL.getPort());
        }
        stringBuilder.append(uRL.getPath());
        if (null != uRL.getQuery()) {
            stringBuilder.append(uRL.getQuery());
        }
        return stringBuilder.toString();
    }

    protected InputSource findInputSource(URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setUseCaches(true);
        httpURLConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
        Preferences preferences = NbPreferences.forModule(RSSFeed.class);
        String string = this.url2path(uRL);
        String string2 = preferences.get(string, null);
        if (string2 != null) {
            httpURLConnection.addRequestProperty("If-Modified-Since", string2);
        }
        httpURLConnection.connect();
        if (httpURLConnection.getResponseCode() == 304) {
            File file = RSSFeed.initCacheStore(string);
            this.LOGGER.log(Level.FINE, "Reading content of {0} from {1}", new Object[]{uRL.toString(), file.getAbsolutePath()});
            this.isCached = true;
            return new InputSource(new BufferedInputStream(new FileInputStream(file)));
        }
        String string3 = httpURLConnection.getContentEncoding();
        this.LOGGER.log(Level.FINER, "Connection encoding: {0}", string3);
        this.LOGGER.log(Level.FINER, "ETag: {0}", httpURLConnection.getHeaderField("ETag"));
        InputStream inputStream = null;
        inputStream = "gzip".equalsIgnoreCase(string3) ? new GZIPInputStream(httpURLConnection.getInputStream()) : ("deflate".equalsIgnoreCase(string3) ? new InflaterInputStream(httpURLConnection.getInputStream(), new Inflater(true)) : httpURLConnection.getInputStream());
        this.LOGGER.log(Level.FINE, "Reading {0} from original source and caching", this.url);
        return new InputSource(new CachingInputStream(inputStream, string, httpURLConnection.getHeaderField("Last-Modified")));
    }

    protected void clearCache() {
        try {
            NbPreferences.forModule(RSSFeed.class).remove(this.url2path(new URL(this.url)));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    protected Component createFeedItemComponent(FeedItem feedItem) {
        JComponent jComponent;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        int n = 0;
        if (feedItem.dateTime != null) {
            jComponent = new JLabel();
            jComponent.setFont(RSS_DESCRIPTION_FONT);
            jComponent.setForeground(Utils.getColor("RssDateTimeColor"));
            ((JLabel)jComponent).setText(this.formatDateTime(feedItem.dateTime));
            jPanel.add((Component)jComponent, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 15, 2, 10), 0, 0));
        }
        jComponent = new WebLink(this.stripHtml(feedItem.title), feedItem.link, true, Utils.getColor(this.foregroundColorFlag ? "HeaderForegroundColor1" : "HeaderForegroundColor2"));
        this.foregroundColorFlag = !this.foregroundColorFlag;
        ((JButton)jComponent).getAccessibleContext().setAccessibleName(BundleSupport.getAccessibilityName("WebLink", feedItem.title));
        ((JButton)jComponent).getAccessibleContext().setAccessibleDescription(BundleSupport.getAccessibilityDescription("WebLink", feedItem.link));
        jComponent.setFont(BUTTON_FONT);
        jPanel.add((Component)jComponent, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 2, 10), 0, 0));
        if (feedItem.description != null) {
            JLabel jLabel = new JLabel("<html>" + this.trimHtml(feedItem.description));
            jLabel.setFont(RSS_DESCRIPTION_FONT);
            jLabel.setForeground(Utils.getColor("RssDetailsColor"));
            jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 30, 0, 10), 0, 0));
        }
        return jPanel;
    }

    protected static String getTextContent(Node node) {
        Node node2 = node.getFirstChild();
        if (null == node2) {
            return null;
        }
        return node2.getNodeValue();
    }

    protected String formatDateTime(String string) {
        try {
            Date date = parsingDateFormat.parse(string);
            return printingDateFormatShort.format(date);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ParseException parseException) {
            try {
                Date date = parsingDateFormatShort.parse(string);
                return printingDateFormatShort.format(date);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (ParseException parseException2) {
                try {
                    Date date = parsingDateFormatLong.parse(string);
                    return printingDateFormatShort.format(date);
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (ParseException parseException3) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    @Override
    public void removeNotify() {
        this.stopReloading();
        this.maxDescriptionChars = -1;
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getMaxDecsriptionLength();
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            public void run() {
                RSSFeed.this.startReloading();
            }
        });
    }

    protected void startReloading() {
        if (null == this.reloadTimer && !Boolean.getBoolean("netbeans.full.hack")) {
            if (System.currentTimeMillis() - this.lastReload >= 3600000L) {
                this.reload();
            } else {
                this.reloadTimer = RequestProcessor.getDefault().post((Runnable)new Reload(), (int)(3600000L - (System.currentTimeMillis() - this.lastReload)));
            }
        }
    }

    protected void stopReloading() {
        if (null != this.reloadTimer) {
            this.reloadTimer.cancel();
            this.reloadTimer = null;
        }
    }

    private String trimHtml(String string) {
        String string2 = this.stripHtml(string);
        int n = this.getMaxDecsriptionLength();
        if (n > 0 && string2.length() > n) {
            string2 = string2.substring(0, n) + "...";
        }
        return string2;
    }

    private String stripHtml(String string) {
        String string2 = string.replaceAll("<[^>]*>", "");
        string2 = string2.replaceAll("&nbsp;", " ");
        return string2.trim();
    }

    protected int getMaxDecsriptionLength() {
        if (this.maxDescriptionChars < 0 && this.getWidth() > 0) {
            if (this.getWidth() <= 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RSSFeed.this.getMaxDecsriptionLength();
                    }
                });
                return 200;
            }
            try {
                Graphics2D graphics2D = (Graphics2D)this.getGraphics();
                FontMetrics fontMetrics = graphics2D.getFontMetrics(RSS_DESCRIPTION_FONT);
                double d = fontMetrics.getStringBounds("Ab c", graphics2D).getWidth() / 4.0;
                double d2 = this.getWidth() - 30;
                this.maxDescriptionChars = (int)(1.8 * d2 / d);
            }
            catch (Throwable throwable) {
                this.maxDescriptionChars = 200;
            }
        }
        return this.maxDescriptionChars;
    }

    protected Component getContentHeader() {
        return null;
    }

    private JComponent buildProxyPanel() {
        Component component = this.getContentHeader();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        int n = 0;
        if (null != component) {
            jPanel.add(component, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        jPanel.add((Component)new JLabel(BundleSupport.getLabel("ErrCannotConnect")), new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
        if (this.showProxyButton) {
            JButton jButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)BundleSupport.getLabel("ProxyConfig"));
            jButton.setOpaque(false);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HttpProxySettings.getDefault().showConfigurationDialog();
                }
            });
            jPanel.add((Component)jButton, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
        }
        return jPanel;
    }

    private JComponent buildContentLoadingLabel() {
        JLabel jLabel = new JLabel(BundleSupport.getLabel("ContentLoading"));
        jLabel.setHorizontalAlignment(0);
        jLabel.setVerticalAlignment(0);
        jLabel.setOpaque(false);
        Component component = this.getContentHeader();
        if (null != component) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            jPanel.add(component, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            jPanel.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(40, 0, 40, 0));
            return jPanel;
        }
        jLabel.setBorder(BorderFactory.createEmptyBorder(40, 0, 40, 0));
        return jLabel;
    }

    private JComponent buildErrorLabel() {
        Component component = this.getContentHeader();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        int n = 0;
        if (null != component) {
            jPanel.add(component, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        jPanel.add((Component)new JLabel(BundleSupport.getLabel("ErrLoadingFeed")), new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)BundleSupport.getLabel("Reload"));
        jButton.setOpaque(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RSSFeed.this.lastReload = 0L;
                RSSFeed.this.reload();
            }
        });
        jPanel.add((Component)jButton, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
        return jPanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("ProxySettings".equals(propertyChangeEvent.getPropertyName())) {
            this.removeAll();
            this.add((Component)this.buildContentLoadingLabel(), "Center");
            this.lastReload = 0L;
            this.reload();
        }
    }

    public boolean isContentCached() {
        return this.isCached;
    }

    static class CachingInputStream
    extends FilterInputStream {
        private OutputStream os;
        private String modTime;
        private String path;

        CachingInputStream(InputStream inputStream, String string, String string2) throws IOException {
            super(inputStream);
            File file = RSSFeed.initCacheStore(string);
            this.os = new BufferedOutputStream(new FileOutputStream(file));
            this.modTime = string2;
            this.path = string;
        }

        public void close() throws IOException {
            super.close();
            NbPreferences.forModule(RSSFeed.class).put(this.path, this.modTime);
            this.os.close();
        }

        public int read() throws IOException {
            int n = super.read();
            this.os.write(n);
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 != -1) {
                this.os.write(byArray, n, n3);
            }
            return n3;
        }
    }

    protected static class FeedItem {
        public String title;
        public String link;
        public String description;
        public String dateTime;
        public String enclosureUrl;

        protected FeedItem() {
        }

        public boolean isValid() {
            return null != this.title && null != this.link;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FeedHandler
    implements ContentHandler {
        private FeedItem currentItem;
        private StringBuffer textBuffer;
        private int maxItemCount;
        private ArrayList<FeedItem> itemList;

        public FeedHandler(int n) {
            this.maxItemCount = n;
            this.itemList = new ArrayList(n);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String string) throws SAXException {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.itemList.size() < this.maxItemCount) {
                if ("item".equals(string2) || "entry".equals(string2)) {
                    this.currentItem = new FeedItem();
                } else if ("link".equals(string2) || "pubDate".equals(string2) || "date".equals(string2) || "published".equals(string2) || "description".equals(string2) || "content".equals(string2) || "title".equals(string2)) {
                    this.textBuffer = new StringBuffer(110);
                    if ("link".equals(string2) && null != this.currentItem && null != attributes.getValue("href")) {
                        this.currentItem.link = attributes.getValue("href");
                    }
                } else if ("enclosure".equals(string2) && null != this.currentItem) {
                    this.currentItem.enclosureUrl = attributes.getValue("url");
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.itemList.size() < this.maxItemCount) {
                if ("item".equals(string2) || "entry".equals(string2)) {
                    if (null != this.currentItem && this.currentItem.isValid()) {
                        this.itemList.add(this.currentItem);
                    }
                    this.currentItem = null;
                } else if (null != this.currentItem && null != this.textBuffer) {
                    String string4 = this.textBuffer.toString().trim();
                    this.textBuffer = null;
                    if (0 == string4.length()) {
                        string4 = null;
                    }
                    if ("link".equals(string2) && null == this.currentItem.link) {
                        this.currentItem.link = string4;
                    } else if ("pubDate".equals(string2) || "published".equals(string2) || "date".equals(string2)) {
                        this.currentItem.dateTime = string4;
                    } else if ("title".equals(string2)) {
                        this.currentItem.title = string4;
                    } else if ("description".equals(string2) || "content".equals(string2)) {
                        this.currentItem.description = string4;
                    }
                }
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (null != this.textBuffer) {
                this.textBuffer.append(cArray, n, n2);
            }
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
        }

        @Override
        public void skippedEntity(String string) throws SAXException {
        }

        public ArrayList<FeedItem> getItemList() {
            return this.itemList;
        }
    }

    private class Reload
    extends Thread {
        private Reload() {
        }

        public void run() {
            try {
                RSSFeed.this.lastReload = System.currentTimeMillis();
                List<FeedItem> list = RSSFeed.this.buildItemList();
                final JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.setOpaque(false);
                int n = 0;
                Component component = RSSFeed.this.getContentHeader();
                if (null != component) {
                    jPanel.add(component, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                RSSFeed.this.foregroundColorFlag = true;
                for (int i = 0; i < Math.min(list.size(), RSSFeed.this.getMaxItemCount()); ++i) {
                    FeedItem feedItem = list.get(i);
                    if (null == feedItem.title || null == feedItem.link) continue;
                    Component component2 = RSSFeed.this.createFeedItemComponent(feedItem);
                    jPanel.add(component2, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 1, new Insets(n == 1 ? 0 : 0, 0, 16, 0), 0, 0));
                }
                jPanel.add((Component)new JLabel(), new GridBagConstraints(0, n++, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RSSFeed.this.setContent(jPanel);
                    }
                });
                RSSFeed.this.reloadTimer = RequestProcessor.getDefault().post((Runnable)this, 3600000);
            }
            catch (UnknownHostException unknownHostException) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RSSFeed.this.setContent(RSSFeed.this.buildProxyPanel());
                    }
                });
            }
            catch (SocketException socketException) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RSSFeed.this.setContent(RSSFeed.this.buildProxyPanel());
                    }
                });
            }
            catch (IOException iOException) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RSSFeed.this.setContent(RSSFeed.this.buildProxyPanel());
                    }
                });
            }
            catch (Exception exception) {
                if (RSSFeed.this.isContentCached()) {
                    RSSFeed.this.isCached = false;
                    RSSFeed.this.clearCache();
                    RSSFeed.this.reload();
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RSSFeed.this.setContent(RSSFeed.this.buildErrorLabel());
                    }
                });
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
    }

    static class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(Level level, SAXParseException sAXParseException) {
            Logger logger = Logger.getLogger(RSSFeed.class.getName());
            logger.log(level, "Line number:" + sAXParseException.getLineNumber());
            logger.log(level, "Column number:" + sAXParseException.getColumnNumber());
            logger.log(level, "Public ID:" + sAXParseException.getPublicId());
            logger.log(level, "System ID:" + sAXParseException.getSystemId());
            logger.log(level, "Error message:" + sAXParseException.getMessage());
        }

        public void error(SAXParseException sAXParseException) {
            this.message(Level.SEVERE, sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) {
            this.message(Level.WARNING, sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) {
            this.message(Level.SEVERE, sAXParseException);
        }
    }
}

