/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.JPanel;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Utils;
import org.openide.util.ImageUtilities;

abstract class AbstractTab
extends JPanel
implements Constants {
    private boolean initialized = false;
    private final Image bottomBar;
    private final Color gradientTop = Color.white;
    private final Color gradientBottom = new Color(223, 233, 242);

    public AbstractTab(boolean bl) {
        super(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(Utils.getColor("ScreenBackgroundColor"));
        this.bottomBar = bl ? ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/bottom_bar.png") : null;
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.buildContent();
            this.initialized = true;
        }
    }

    protected abstract void buildContent();

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getHeight();
        graphics2D.setPaint(new GradientPaint(0.0f, n - 60, this.gradientTop, 0.0f, n, this.gradientBottom));
        graphics2D.fillRect(0, n - 60, this.getWidth(), 60);
        if (null != this.bottomBar) {
            int n2 = this.bottomBar.getWidth(this);
            int n3 = this.bottomBar.getHeight(this);
            graphics.drawImage(this.bottomBar, this.getWidth() - n2, this.getHeight() - n3, this);
        }
    }
}

