/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.util.HashSet;
import java.util.Set;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;

class InstallConfig {
    private boolean ergonomics = false;
    private boolean javaFX = false;
    private boolean somePacksDisabled = false;
    private Set<String> enabledPackNames = new HashSet<String>(10);
    private static final String javaFxPackName = "org.netbeans.modules.javafx.kit";
    private static final String ergonomicsPackName = "org.netbeans.modules.ide.ergonomics";
    private static final String[] packNames = new String[]{"org.netbeans.modules.java.kit", "org.netbeans.modules.j2ee.kit", "org.netbeans.modules.mobility.kit", "org.netbeans.modules.ruby.kit", "org.netbeans.modules.cnd.kit", "org.netbeans.modules.php.kit", "org.netbeans.modules.groovy.kit"};
    private static InstallConfig theInstance;
    private static final String[] preferredPackNames;

    private InstallConfig() {
        for (ModuleInfo moduleInfo : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            this.javaFX = this.javaFX || this.isJavaFxPack(moduleInfo);
            boolean bl = this.ergonomics = this.ergonomics || this.isErgonomicsPack(moduleInfo);
            if (!this.isPack(moduleInfo)) continue;
            if (moduleInfo.isEnabled()) {
                this.enabledPackNames.add(moduleInfo.getCodeNameBase());
                continue;
            }
            this.somePacksDisabled = true;
        }
    }

    public static InstallConfig getDefault() {
        if (null == theInstance) {
            theInstance = new InstallConfig();
        }
        return theInstance;
    }

    public String getPreferredPackName() {
        for (String string : preferredPackNames) {
            if (!this.isPackEnabled(string)) continue;
            return string;
        }
        return preferredPackNames[0];
    }

    public boolean isErgonomicsEnabled() {
        return this.ergonomics;
    }

    public boolean isJavaFXInstalled() {
        return this.javaFX;
    }

    public boolean somePacksDisabled() {
        return this.somePacksDisabled;
    }

    public void setSomePacksDisabled(boolean bl) {
        this.somePacksDisabled = bl;
    }

    private boolean isPack(ModuleInfo moduleInfo) {
        String string = moduleInfo.getCodeNameBase();
        for (String string2 : packNames) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean isJavaFxPack(ModuleInfo moduleInfo) {
        String string = moduleInfo.getCodeNameBase();
        return string.startsWith(javaFxPackName);
    }

    private boolean isErgonomicsPack(ModuleInfo moduleInfo) {
        String string = moduleInfo.getCodeNameBase();
        return string.startsWith(ergonomicsPackName) && moduleInfo.isEnabled();
    }

    private boolean isPackEnabled(String string) {
        for (String string2 : this.enabledPackNames) {
            if (!string2.contains(string)) continue;
            return true;
        }
        return false;
    }

    static {
        preferredPackNames = new String[]{"java", "ruby", "cnd", "php", "groovy"};
    }
}

