/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.freeform.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.web.freeform.WebProjectGenerator;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WebClasspathPanel
extends JPanel
implements HelpCtx.Provider {
    private DefaultListModel listModel;
    private File projectFolder = null;
    private File nbProjectFolder;
    private File lastChosenFile = null;
    private boolean isSeparateClasspath = true;
    private boolean ignoreEvent;
    private static String JAVA_SOURCES_CLASSPATH = NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_JAVA_SOURCE_CLASSPATH");
    private JButton addClasspath;
    private JList classpath;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JButton moveDown;
    private JButton moveUp;
    private JButton removeClasspath;

    public WebClasspathPanel() {
        this(true);
    }

    public WebClasspathPanel(boolean bl) {
        this.initComponents();
        this.jTextArea1.setBackground(this.getBackground());
        this.listModel = new DefaultListModel();
        this.listModel.add(0, JAVA_SOURCES_CLASSPATH);
        this.classpath.setModel(this.listModel);
        if (!bl) {
            this.jTextArea1.setText(NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_ClasspathPanel_Explanation"));
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WebClasspathPanel.class);
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.addClasspath = new JButton();
        this.removeClasspath = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.classpath = new JList();
        this.jPanel1 = new JPanel();
        this.moveUp = new JButton();
        this.moveDown = new JButton();
        this.jTextArea1 = new JTextArea();
        this.jPanel2 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jTextArea2 = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.classpath);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_ClasspathPanel_jLabel3"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebClasspathPanel.class, (String)"ACSD_ClasspathPanel_jLabel3"));
        Mnemonics.setLocalizedText((AbstractButton)this.addClasspath, (String)NbBundle.getMessage(WebClasspathPanel.class, (String)"BTN_ClasspathPanel_addClasspath"));
        this.addClasspath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebClasspathPanel.this.addClasspathActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.addClasspath, gridBagConstraints);
        this.addClasspath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebClasspathPanel.class, (String)"ACSD_ClasspathPanel_addClasspath"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeClasspath, (String)NbBundle.getMessage(WebClasspathPanel.class, (String)"BTN_ClasspathPanel_removeClasspath"));
        this.removeClasspath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebClasspathPanel.this.removeClasspathActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.removeClasspath, gridBagConstraints);
        this.removeClasspath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebClasspathPanel.class, (String)"ACSD_ClasspathPanel_removeClasspath"));
        this.classpath.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                WebClasspathPanel.this.classpathValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.classpath);
        this.classpath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebClasspathPanel.class, (String)"ACSD_ClasspathPanel_classpath"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.moveUp.setMnemonic(NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_MoveUp_MNE").charAt(0));
        this.moveUp.setText(NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_ClasspathPanel_Move_Up"));
        this.moveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebClasspathPanel.this.moveUpActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.moveUp, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/web/freeform/ui/Bundle");
        this.moveUp.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_ClasspathPanel_noveUp"));
        this.moveDown.setMnemonic(NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_MoveDown_MNE").charAt(0));
        this.moveDown.setText(NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_ClasspathPanel_Move_Down"));
        this.moveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebClasspathPanel.this.moveDownActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.moveDown, gridBagConstraints);
        this.moveDown.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_ClasspathPanel_moveDown"));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText(NbBundle.getMessage(WebClasspathPanel.class, (String)"MSG_ClasspathPanel_jTextArea"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setDisabledTextColor(Color.black);
        this.jTextArea1.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.jTextArea1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WebClasspathPanel.class, (String)"ACSN_ClasspathPanel_jTextArea"));
        this.jTextArea1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebClasspathPanel.class, (String)"ACSD_ClasspathPanel_jTextArea"));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Label.disabledForeground")));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/web/freeform/resources/alert_32.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jTextArea2.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setText(NbBundle.getMessage(WebClasspathPanel.class, (String)"Freeform_Warning_Message"));
        this.jTextArea2.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.jPanel2.add((Component)this.jTextArea2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void classpathValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
    }

    private void moveDownActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.classpath.getSelectedIndices();
        if (nArray.length == 0 || nArray[nArray.length - 1] == this.listModel.getSize() - 1) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            Object e = this.listModel.remove(n);
            this.listModel.add(++n, e);
            nArray[i] = n;
        }
        this.classpath.setSelectedIndices(nArray);
        this.updateButtons();
    }

    private void moveUpActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.classpath.getSelectedIndices();
        if (nArray.length == 0 || nArray[0] == 0) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            Object e = this.listModel.remove(n);
            this.listModel.add(--n, e);
            nArray[i] = n;
        }
        this.classpath.setSelectedIndices(nArray);
        this.updateButtons();
    }

    void updateButtons() {
        int[] nArray = this.classpath.getSelectedIndices();
        this.removeClasspath.setEnabled(this.listModel.getSize() > 0 && nArray.length != 0 && nArray[0] != 0);
        this.moveUp.setEnabled(nArray.length > 0 && nArray[0] > 1);
        this.moveDown.setEnabled(nArray.length > 0 && nArray[nArray.length - 1] != this.listModel.getSize() - 1 && nArray[0] != 0);
    }

    private void removeClasspathActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.classpath.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            this.listModel.remove(nArray[i] - i);
        }
        this.updateButtons();
    }

    private void addClasspathActionPerformed(ActionEvent actionEvent) {
        Object object;
        FileChooser fileChooser = new FileChooser(this.projectFolder, null);
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)fileChooser, null);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(true);
        if (this.lastChosenFile != null) {
            fileChooser.setSelectedFile(this.lastChosenFile);
        } else if (this.projectFolder != null) {
            object = this.projectFolder.listFiles();
            if (object != null && ((File[])object).length > 0) {
                fileChooser.setSelectedFile(object[0]);
            } else {
                fileChooser.setSelectedFile(this.projectFolder);
            }
        }
        fileChooser.setDialogTitle(NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_Browse_Classpath"));
        object = new SimpleFileFilter(NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_ZipJarFolderFilter"));
        fileChooser.setFileFilter((FileFilter)object);
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (0 == fileChooser.showOpenDialog((Component)this)) {
            String[] stringArray = null;
            try {
                stringArray = fileChooser.getSelectedPaths();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            for (String string : stringArray) {
                this.listModel.addElement(string);
            }
            this.lastChosenFile = fileChooser.getCurrentDirectory();
            this.updateButtons();
        }
    }

    public void setProjectFolders(File file, File file2) {
        this.projectFolder = file;
        this.nbProjectFolder = file2;
    }

    public String getClasspath() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < this.listModel.getSize(); ++i) {
            String string = (String)this.listModel.get(i);
            stringBuffer.append(string);
            if (i >= this.listModel.getSize() - 1) continue;
            stringBuffer.append(File.pathSeparatorChar);
        }
        return stringBuffer.toString();
    }

    void setClasspath(String string, PropertyEvaluator propertyEvaluator) {
        if (string == null) {
            return;
        }
        this.listModel.clear();
        this.listModel.addElement(JAVA_SOURCES_CLASSPATH);
        String[] stringArray = PropertyUtils.tokenizePath((String)propertyEvaluator.evaluate(string));
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null) continue;
            this.listModel.addElement(string2);
        }
    }

    ActionListener getCustomizerOkListener(final AntProjectHelper antProjectHelper) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AuxiliaryConfiguration auxiliaryConfiguration = Util.getAuxiliaryConfiguration((AntProjectHelper)antProjectHelper);
                List<WebProjectGenerator.WebModule> list = WebProjectGenerator.getWebmodules(antProjectHelper, auxiliaryConfiguration);
                if (list != null) {
                    WebProjectGenerator.WebModule webModule = list.get(0);
                    webModule.classpath = WebClasspathPanel.this.getClasspath();
                    WebProjectGenerator.putWebModules(antProjectHelper, auxiliaryConfiguration, list);
                }
                WebClasspathPanel.this.updateButtons();
            }
        };
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;

        public SimpleFileFilter(String string) {
            this.description = string;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            try {
                return FileUtil.isArchiveFile((URL)file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
                return false;
            }
        }

        public String getDescription() {
            return this.description;
        }
    }
}

