/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MIMEExtensions {
    private static final Preferences preferences = NbPreferences.forModule(MIMEExtensions.class);
    private static final Manager manager = new Manager();
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final String mimeType;
    private final String description;
    private final Set<String> exts;

    public static MIMEExtensions get(String string) {
        return manager.get(string);
    }

    public static List<MIMEExtensions> getCustomizable() {
        return manager.getOrderedExtensions();
    }

    public static boolean isCustomizableExtensions(String string) {
        return MIMEExtensions.get(string) != null;
    }

    public static boolean isRegistered(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        MIMEExtensions mIMEExtensions = MIMEExtensions.get(string);
        if (mIMEExtensions == null) {
            return FileUtil.getMIMETypeExtensions((String)string).contains(string2);
        }
        return mIMEExtensions.contains(string2);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    private MIMEExtensions(String string, String string2) {
        this.mimeType = string;
        this.description = string2;
        this.exts = new TreeSet<String>();
        this.exts.addAll(FileUtil.getMIMETypeExtensions((String)string));
    }

    private MIMEExtensions(String string, MIMEExtensions mIMEExtensions) {
        this.mimeType = string;
        this.description = mIMEExtensions.description;
        this.exts = mIMEExtensions.exts;
    }

    public void setExtensions(List<String> list, String string) {
        if (!list.contains(string)) {
            throw new IllegalArgumentException("input list " + list + " doesn't contain default element:" + string);
        }
        Collection<String> collection = this.getValues();
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        arrayList.removeAll(list);
        ArrayList<String> arrayList2 = new ArrayList<String>(list);
        arrayList2.removeAll(collection);
        for (String string2 : arrayList) {
            FileUtil.setMIMEType((String)string2, null);
        }
        for (String string2 : arrayList2) {
            FileUtil.setMIMEType((String)string2, (String)this.mimeType);
        }
        if (!arrayList.isEmpty() || !arrayList2.isEmpty()) {
            this.exts.clear();
            this.exts.addAll(list);
            this.cs.fireChange();
        }
        preferences.put(this.getMIMEType(), string);
    }

    public String getMIMEType() {
        return this.mimeType;
    }

    public String getDefaultExtension() {
        String string = preferences.get(this.getMIMEType(), "");
        if (string.length() == 0) {
            Collection<String> collection = this.getValues();
            return collection.isEmpty() ? "" : collection.iterator().next();
        }
        return string;
    }

    public String getLocalizedDescription() {
        return this.description;
    }

    public Collection<String> getValues() {
        return Collections.unmodifiableSet(this.exts);
    }

    private boolean contains(String string) {
        return this.exts.contains(string);
    }

    public String toString() {
        return this.description + "[" + this.mimeType + ":" + this.getDefaultExtension() + "]";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MIMEExtensions mIMEExtensions = (MIMEExtensions)object;
        return this.mimeType.equals(mIMEExtensions.mimeType);
    }

    public int hashCode() {
        int n = this.mimeType.hashCode();
        return n;
    }

    public void addExtension(String string) {
        if (!this.getValues().contains(string)) {
            this.exts.add(string);
            FileUtil.setMIMEType((String)string, (String)this.mimeType);
        }
    }

    public void setDefaultExtension(String string) {
        this.addExtension(string);
        preferences.put(this.getMIMEType(), string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Manager {
        private final Map<String, MIMEExtensions> mime2ext = new LinkedHashMap<String, MIMEExtensions>(5);
        private final FileObject configFolder = FileUtil.getConfigFile((String)"CND/Extensions");
        private final FileChangeListener listener;

        private Manager() {
            if (this.configFolder != null) {
                this.listener = new L();
                this.configFolder.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.listener, (Object)this.configFolder));
                this.initialize(this.configFolder);
            } else {
                this.listener = null;
            }
        }

        public MIMEExtensions get(String string) {
            return this.mime2ext.get(string);
        }

        public List<MIMEExtensions> getOrderedExtensions() {
            LinkedHashMap<String, MIMEExtensions> linkedHashMap = new LinkedHashMap<String, MIMEExtensions>(this.mime2ext);
            linkedHashMap.remove("text/sh");
            linkedHashMap.remove("text/x-c/text/x-h");
            return new ArrayList<MIMEExtensions>(linkedHashMap.values());
        }

        private void initialize(FileObject fileObject) {
            this.mime2ext.clear();
            if (fileObject != null) {
                for (FileObject fileObject2 : FileUtil.getOrder(Arrays.asList(fileObject.getChildren()), (boolean)false)) {
                    MIMEExtensions mIMEExtensions = this.create(fileObject2);
                    if (this.mime2ext.containsKey(mIMEExtensions.getMIMEType())) continue;
                    this.mime2ext.put(mIMEExtensions.getMIMEType(), mIMEExtensions);
                    if (!"text/x-h".equals(mIMEExtensions.getMIMEType())) continue;
                    MIMEExtensions mIMEExtensions2 = new MIMEExtensions("text/x-c/text/x-h", mIMEExtensions);
                    String string = preferences.get("text/x-c/text/x-h", "");
                    if (string.length() == 0) {
                        mIMEExtensions2.setDefaultExtension(mIMEExtensions.getDefaultExtension());
                    }
                    this.mime2ext.put("text/x-c/text/x-h", mIMEExtensions2);
                }
                MIMEExtensions mIMEExtensions = new MIMEExtensions("text/sh", "");
                this.mime2ext.put("text/sh", mIMEExtensions);
            }
        }

        private MIMEExtensions create(FileObject fileObject) throws MissingResourceException {
            Object object = fileObject.getAttribute("mimeType");
            if (!(object instanceof String)) {
                throw new MissingResourceException(fileObject.getPath(), fileObject.getClass().getName(), "no stringvalue attribute \"mimeType\"");
            }
            String string = (String)object;
            object = fileObject.getAttribute("SystemFileSystem.localizingBundle");
            if (!(object instanceof String)) {
                throw new MissingResourceException(fileObject.getPath(), fileObject.getClass().getName(), "no stringvalue attribute \"SystemFileSystem.localizingBundle\"");
            }
            ResourceBundle resourceBundle = NbBundle.getBundle((String)((String)object));
            String string2 = resourceBundle.getString(fileObject.getPath());
            object = fileObject.getAttribute("default");
            if (object != null && !(object instanceof String)) {
                throw new MissingResourceException(fileObject.getPath(), fileObject.getClass().getName(), "no stringvalue attribute \"default\"");
            }
            String string3 = (String)(object == null ? "" : object);
            MIMEExtensions mIMEExtensions = new MIMEExtensions(string, string2);
            string3 = preferences.get(string, string3);
            mIMEExtensions.setDefaultExtension(string3);
            return mIMEExtensions;
        }

        private final class L
        implements FileChangeListener {
            private L() {
            }

            public void fileFolderCreated(FileEvent fileEvent) {
                Manager.this.initialize(Manager.this.configFolder);
            }

            public void fileDataCreated(FileEvent fileEvent) {
                Manager.this.initialize(Manager.this.configFolder);
            }

            public void fileChanged(FileEvent fileEvent) {
                Manager.this.initialize(Manager.this.configFolder);
            }

            public void fileDeleted(FileEvent fileEvent) {
                Manager.this.initialize(Manager.this.configFolder);
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
                Manager.this.initialize(Manager.this.configFolder);
            }

            public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
                Manager.this.initialize(Manager.this.configFolder);
            }
        }
    }
}

