/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.utils.cache.WeakSharedSet;

public abstract class APTStringManager {
    private static final Map<String, APTStringManager> instances = Collections.synchronizedMap(new HashMap());
    private static final int STRING_MANAGER_DEFAULT_CAPACITY = 1024;
    private static final int STRING_MANAGER_DEFAULT_SLICED_NUMBER = 29;
    static final String TEXT_MANAGER = "Manager of sharable texts";
    static final int TEXT_MANAGER_INITIAL_CAPACITY = 1024;
    static final String FILE_PATH_MANAGER = "Manager of sharable file paths";
    static final int FILE_PATH_MANAGER_INITIAL_CAPACITY = 1024;

    public abstract CharSequence getString(CharSequence var1);

    public abstract void dispose();

    public static APTStringManager instance(String string, CacheKind cacheKind) {
        switch (cacheKind) {
            case Single: {
                return APTStringManager.instance(string, 1024);
            }
            case Sliced: {
                return APTStringManager.instance(string, 29, 1024);
            }
        }
        throw new IllegalArgumentException();
    }

    private static APTStringManager instance(String string, int n) {
        APTStringManager aPTStringManager = instances.get(string);
        if (aPTStringManager == null) {
            aPTStringManager = new APTSingleStringManager(string, n);
            instances.put(string, aPTStringManager);
        }
        return aPTStringManager;
    }

    private static APTStringManager instance(String string, int n, int n2) {
        APTStringManager aPTStringManager = instances.get(string);
        if (aPTStringManager == null) {
            aPTStringManager = new APTCompoundStringManager(string, n, n2);
            instances.put(string, aPTStringManager);
        }
        return aPTStringManager;
    }

    static final class APTCompoundStringManager
    extends APTStringManager {
        private final APTStringManager[] instances;
        private final int sliceNumber;
        private final String name;

        APTCompoundStringManager(String string, int n) {
            this(string, n, 1024);
        }

        APTCompoundStringManager(String string, int n, int n2) {
            this.sliceNumber = n;
            this.instances = new APTStringManager[n];
            for (int i = 0; i < this.instances.length; ++i) {
                this.instances[i] = new APTSingleStringManager(string, n2);
            }
            this.name = string;
        }

        private APTStringManager getDelegate(CharSequence charSequence) {
            if (charSequence == null) {
                throw new NullPointerException("null string is illegal to share");
            }
            int n = charSequence.hashCode() % this.sliceNumber;
            if (n < 0) {
                n += this.sliceNumber;
            }
            return this.instances[n];
        }

        public final CharSequence getString(CharSequence charSequence) {
            return this.getDelegate(charSequence).getString(charSequence);
        }

        public final void dispose() {
            for (int i = 0; i < this.instances.length; ++i) {
                this.instances[i].dispose();
            }
        }
    }

    static final class APTSingleStringManager
    extends APTStringManager {
        private final WeakSharedSet<CharSequence> storage;
        private final int initialCapacity;
        private final String name;
        private final String lock = new String("lock in APTStringManager");

        private APTSingleStringManager(String string, int n) {
            this.storage = new WeakSharedSet(n);
            this.initialCapacity = n;
            this.name = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final CharSequence getString(CharSequence charSequence) {
            if (charSequence == null) {
                throw new NullPointerException("null string is illegal to share");
            }
            CharSequence charSequence2 = null;
            String string = this.lock;
            synchronized (string) {
                charSequence2 = this.storage.addOrGet(charSequence);
            }
            assert (charSequence2 != null);
            assert (charSequence2.equals(charSequence));
            return charSequence2;
        }

        public final void dispose() {
            if (this.storage.size() > 0) {
                this.storage.clear();
                this.storage.resize(this.initialCapacity);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheKind {
        Single,
        Sliced;

    }
}

