/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.tag;

import java.io.EOFException;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.RepositoryCommand;
import org.netbeans.lib.cvsclient.command.tag.TagBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;

public class RtagCommand
extends RepositoryCommand {
    private EventManager eventManager;
    private boolean clearFromRemoved;
    private boolean deleteTag;
    private boolean makeBranchTag;
    private boolean overrideExistingTag;
    private boolean matchHeadIfRevisionNotFound;
    private boolean noExecTagProgram;
    private String tag;
    private String tagByDate;
    private String tagByRevision;

    public Builder createBuilder(EventManager eventManager) {
        return new TagBuilder(eventManager, this.getLocalDirectory());
    }

    public boolean isClearFromRemoved() {
        return this.clearFromRemoved;
    }

    public void setClearFromRemoved(boolean bl) {
        this.clearFromRemoved = bl;
    }

    public boolean isDeleteTag() {
        return this.deleteTag;
    }

    public void setDeleteTag(boolean bl) {
        this.deleteTag = bl;
    }

    public boolean isMakeBranchTag() {
        return this.makeBranchTag;
    }

    public void setMakeBranchTag(boolean bl) {
        this.makeBranchTag = bl;
    }

    public boolean isOverrideExistingTag() {
        return this.overrideExistingTag;
    }

    public void setOverrideExistingTag(boolean bl) {
        this.overrideExistingTag = bl;
    }

    public boolean isMatchHeadIfRevisionNotFound() {
        return this.matchHeadIfRevisionNotFound;
    }

    public void setMatchHeadIfRevisionNotFound(boolean bl) {
        this.matchHeadIfRevisionNotFound = bl;
    }

    public boolean isNoExecTagProgram() {
        return this.noExecTagProgram;
    }

    public void setNoExecTagProgram(boolean bl) {
        this.noExecTagProgram = bl;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public String getTagByDate() {
        return this.tagByDate;
    }

    public void setTagByDate(String string) {
        this.tagByDate = string;
    }

    public String getTagByRevision() {
        return this.tagByRevision;
    }

    public void setTagByRevision(String string) {
        this.tagByRevision = string;
    }

    protected void postExpansionExecute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        clientServices.ensureConnection();
        this.eventManager = eventManager;
        try {
            if (this.clearFromRemoved) {
                this.requests.add(new ArgumentRequest("-a"));
            }
            if (this.overrideExistingTag) {
                this.requests.add(new ArgumentRequest("-F"));
            }
            if (this.matchHeadIfRevisionNotFound) {
                this.requests.add(new ArgumentRequest("-f"));
            }
            if (this.makeBranchTag) {
                this.requests.add(new ArgumentRequest("-b"));
            }
            if (this.deleteTag) {
                this.requests.add(new ArgumentRequest("-d"));
            }
            if (this.noExecTagProgram) {
                this.requests.add(new ArgumentRequest("-n "));
            }
            if (this.tagByDate != null && this.tagByDate.length() > 0) {
                this.requests.add(new ArgumentRequest("-D"));
                this.requests.add(new ArgumentRequest(this.getTagByDate()));
            }
            if (this.tagByRevision != null && this.tagByRevision.length() > 0) {
                this.requests.add(new ArgumentRequest("-r"));
                this.requests.add(new ArgumentRequest(this.getTagByRevision()));
            }
            this.requests.add(new ArgumentRequest(this.getTag()));
            this.addArgumentRequests();
            this.addRequest(CommandRequest.RTAG);
            clientServices.processRequests(this.requests);
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (EOFException eOFException) {
            throw new CommandException(eOFException, CommandException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
        finally {
            this.requests.clear();
        }
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("rtag ");
        stringBuffer.append(this.getCVSArguments());
        if (this.getTag() != null) {
            stringBuffer.append(this.getTag());
            stringBuffer.append(" ");
        }
        this.appendModuleArguments(stringBuffer);
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else if (c == 'a') {
            this.setClearFromRemoved(true);
        } else if (c == 'd') {
            this.setDeleteTag(true);
        } else if (c == 'F') {
            this.setOverrideExistingTag(true);
        } else if (c == 'f') {
            this.setMatchHeadIfRevisionNotFound(true);
        } else if (c == 'b') {
            this.setMakeBranchTag(true);
        } else if (c == 'n') {
            this.setNoExecTagProgram(true);
        } else if (c == 'D') {
            this.setTagByDate(string.trim());
        } else if (c == 'r') {
            this.setTagByRevision(string.trim());
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "RlaFfbdnD:r:";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setClearFromRemoved(false);
        this.setDeleteTag(false);
        this.setMakeBranchTag(false);
        this.setOverrideExistingTag(false);
        this.setMatchHeadIfRevisionNotFound(false);
        this.setNoExecTagProgram(false);
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        if (this.isClearFromRemoved()) {
            stringBuffer.append("-a ");
        }
        if (this.isOverrideExistingTag()) {
            stringBuffer.append("-F ");
        }
        if (this.isMatchHeadIfRevisionNotFound()) {
            stringBuffer.append("-f ");
        }
        if (this.isMakeBranchTag()) {
            stringBuffer.append("-b ");
        }
        if (this.isDeleteTag()) {
            stringBuffer.append("-d ");
        }
        if (this.isNoExecTagProgram()) {
            stringBuffer.append("-n ");
        }
        if (this.getTagByRevision() != null && this.getTagByRevision().length() > 0) {
            stringBuffer.append("-r ");
            stringBuffer.append(this.getTagByRevision());
            stringBuffer.append(" ");
        }
        if (this.getTagByDate() != null && this.getTagByDate().length() > 0) {
            stringBuffer.append("-D ");
            stringBuffer.append(this.getTagByDate());
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

