/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.connection;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.text.MessageFormat;
import javax.net.SocketFactory;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AbstractConnection;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ConnectionModifier;
import org.netbeans.lib.cvsclient.connection.StandardScrambler;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public class PServerConnection
extends AbstractConnection {
    protected static final String OPEN_PREAMBLE = "BEGIN AUTH REQUEST\n";
    protected static final String OPEN_POSTAMBLE = "END AUTH REQUEST\n";
    protected static final String VERIFY_PREAMBLE = "BEGIN VERIFICATION REQUEST\n";
    protected static final String VERIFY_POSTAMBLE = "END VERIFICATION REQUEST\n";
    protected static final String AUTHENTICATION_SUCCEEDED_RESPONSE = "I LOVE YOU";
    private static final String AUTHENTICATION_SUCCEEDED_RESPONSE_RAW = "I LOVE YOU\n";
    protected static final String AUTHENTICATION_FAILED_RESPONSE = "I HATE YOU";
    private static final String AUTHENTICATION_FAILED_RESPONSE_RAW = "I HATE YOU\n";
    protected String userName;
    protected String encodedPassword;
    public static final int DEFAULT_PORT = 2401;
    protected int port = 2401;
    protected String hostName;
    protected Socket socket;
    protected SocketFactory socketFactory;

    public PServerConnection() {
    }

    public PServerConnection(CVSRoot cVSRoot) {
        this(cVSRoot, null);
    }

    public PServerConnection(CVSRoot cVSRoot, SocketFactory socketFactory) {
        if (!"pserver".equals(cVSRoot.getMethod())) {
            throw new IllegalArgumentException("CVS Root '" + cVSRoot + "' does not represent :pserver: connection type.");
        }
        this.socketFactory = socketFactory;
        String string = cVSRoot.getUserName();
        if (string == null) {
            string = System.getProperty("user.name");
        }
        this.setUserName(string);
        String string2 = cVSRoot.getPassword();
        if (string2 != null) {
            this.setEncodedPassword(StandardScrambler.getInstance().scramble(string2));
        }
        this.setHostName(cVSRoot.getHostName());
        this.setRepository(cVSRoot.getRepository());
        int n = cVSRoot.getPort();
        if (n == 0) {
            n = 2401;
        }
        this.setPort(n);
    }

    private void openConnection(String string, String string2) throws AuthenticationException, CommandAbortedException {
        if (this.hostName == null) {
            String string3 = AuthenticationException.getBundleString("AuthenticationException.HostIsNull");
            throw new AuthenticationException("HostIsNull", string3);
        }
        try {
            SocketFactory socketFactory = this.socketFactory != null ? this.socketFactory : SocketFactory.getDefault();
            this.socket = socketFactory.createSocket(this.hostName, this.port);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.socket.getOutputStream(), 32768);
            LoggedDataOutputStream loggedDataOutputStream = new LoggedDataOutputStream(bufferedOutputStream);
            this.setOutputStream(loggedDataOutputStream);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.socket.getInputStream(), 32768);
            LoggedDataInputStream loggedDataInputStream = new LoggedDataInputStream(bufferedInputStream);
            this.setInputStream(loggedDataInputStream);
            loggedDataOutputStream.writeBytes(string, "US-ASCII");
            loggedDataOutputStream.writeBytes(this.getRepository() + "\n");
            loggedDataOutputStream.writeBytes(this.userName + "\n");
            loggedDataOutputStream.writeBytes(this.getEncodedPasswordNotNull() + "\n", "US-ASCII");
            loggedDataOutputStream.writeBytes(string2, "US-ASCII");
            loggedDataOutputStream.flush();
            if (Thread.interrupted()) {
                this.reset();
                String string4 = CommandException.getLocalMessage("Client.connectionAborted", null);
                throw new CommandAbortedException("Aborted during connecting to the server.", string4);
            }
            byte[] byArray = loggedDataInputStream.readBytes(AUTHENTICATION_SUCCEEDED_RESPONSE_RAW.length());
            String string5 = new String(byArray, "utf8");
            if (Thread.interrupted()) {
                this.reset();
                String string6 = CommandException.getLocalMessage("Client.connectionAborted", null);
                throw new CommandAbortedException("Aborted during connecting to the server.", string6);
            }
            if (AUTHENTICATION_SUCCEEDED_RESPONSE_RAW.equals(string5)) {
                return;
            }
            if (AUTHENTICATION_FAILED_RESPONSE_RAW.equals(string5)) {
                String string7 = this.getLocalMessage("AuthenticationException.badPassword", null);
                throw new AuthenticationException("AuthenticationFailed", string7);
            }
            if (string5 == null) {
                string5 = "";
            }
            String string8 = this.getLocalMessage("AuthenticationException.AuthenticationFailed", new Object[]{string5});
            throw new AuthenticationException("AuthenticationFailed", string8);
        }
        catch (AuthenticationException authenticationException) {
            this.reset();
            throw authenticationException;
        }
        catch (ConnectException connectException) {
            this.reset();
            String string9 = this.getLocalMessage("AuthenticationException.ConnectException", new Object[]{this.hostName, Integer.toString(this.port)});
            throw new AuthenticationException("ConnectException", connectException, string9);
        }
        catch (NoRouteToHostException noRouteToHostException) {
            this.reset();
            String string10 = this.getLocalMessage("AuthenticationException.NoRouteToHostException", new Object[]{this.hostName});
            throw new AuthenticationException("NoRouteToHostException", noRouteToHostException, string10);
        }
        catch (IOException iOException) {
            this.reset();
            String string11 = this.getLocalMessage("AuthenticationException.IOException", new Object[]{this.hostName});
            throw new AuthenticationException("IOException", iOException, string11);
        }
    }

    private void reset() {
        this.socket = null;
        this.setInputStream(null);
        this.setOutputStream(null);
    }

    public void verify() throws AuthenticationException {
        try {
            this.openConnection(VERIFY_PREAMBLE, VERIFY_POSTAMBLE);
        }
        catch (CommandAbortedException commandAbortedException) {
            // empty catch block
        }
        if (this.socket == null) {
            return;
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            String string = AuthenticationException.getBundleString("AuthenticationException.Throwable");
            throw new AuthenticationException("General error", iOException, string);
        }
        finally {
            this.reset();
        }
    }

    public void open() throws AuthenticationException, CommandAbortedException {
        this.openConnection(OPEN_PREAMBLE, OPEN_POSTAMBLE);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getEncodedPassword() {
        return this.encodedPassword;
    }

    private String getEncodedPasswordNotNull() {
        if (this.encodedPassword == null) {
            return StandardScrambler.getInstance().scramble("");
        }
        return this.encodedPassword;
    }

    public void setEncodedPassword(String string) {
        this.encodedPassword = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String string) {
        this.hostName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        try {
            this.socket.close();
        }
        finally {
            this.reset();
        }
    }

    public void modifyInputStream(ConnectionModifier connectionModifier) throws IOException {
        connectionModifier.modifyInputStream(this.getInputStream());
    }

    public void modifyOutputStream(ConnectionModifier connectionModifier) throws IOException {
        connectionModifier.modifyOutputStream(this.getOutputStream());
    }

    private String getLocalMessage(String string, Object[] objectArray) {
        String string2 = AuthenticationException.getBundleString(string);
        if (string2 == null) {
            return null;
        }
        string2 = MessageFormat.format(string2, objectArray);
        return string2;
    }

    public boolean isOpen() {
        return this.socket != null;
    }
}

