/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.apiregistry;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.SmartSteppingCallback;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.debugger.jpda.VariablesFilter;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"org.netbeans.api.debugger.jpda.JPDADebugger.Registration", "org.netbeans.spi.debugger.jpda.SmartSteppingCallback.Registration", "org.netbeans.spi.debugger.jpda.SourcePathProvider.Registration", "org.netbeans.spi.debugger.jpda.EditorContext.Registration", "org.netbeans.spi.debugger.jpda.VariablesFilter.Registration"})
public class DebuggerProcessor
extends LayerGeneratingProcessor {
    public static final String SERVICE_NAME = "serviceName";

    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        String string;
        Annotation annotation;
        if (roundEnvironment.processingOver()) {
            return false;
        }
        int n = 0;
        for (Element element : roundEnvironment.getElementsAnnotatedWith(JPDADebugger.Registration.class)) {
            annotation = element.getAnnotation(JPDADebugger.Registration.class);
            string = annotation.path();
            this.handleProviderRegistration(element, JPDADebugger.class, string);
            ++n;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(SmartSteppingCallback.Registration.class)) {
            annotation = element.getAnnotation(SmartSteppingCallback.Registration.class);
            string = annotation.path();
            this.handleProviderRegistration(element, SmartSteppingCallback.class, string);
            ++n;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(SourcePathProvider.Registration.class)) {
            annotation = element.getAnnotation(SourcePathProvider.Registration.class);
            string = annotation.path();
            this.handleProviderRegistration(element, SourcePathProvider.class, string);
            ++n;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(EditorContext.Registration.class)) {
            annotation = element.getAnnotation(EditorContext.Registration.class);
            string = annotation.path();
            this.handleProviderRegistration(element, EditorContext.class, string);
            ++n;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(VariablesFilter.Registration.class)) {
            annotation = element.getAnnotation(VariablesFilter.Registration.class);
            string = annotation.path();
            this.handleProviderRegistration(element, VariablesFilter.class, string);
            ++n;
        }
        return n == set.size();
    }

    private void handleProviderRegistration(Element element, Class clazz, String string) throws IllegalArgumentException, LayerGenerationException {
        String string2 = this.instantiableClassOrMethod(element);
        if (!this.isClassOf(element, clazz)) {
            throw new IllegalArgumentException("Annotated element " + element + " is not an instance of " + clazz);
        }
        string = string != null && string.length() > 0 ? "Debugger/" + string : "Debugger";
        this.layer(new Element[]{element}).instanceFile(string, null, clazz).stringvalue(SERVICE_NAME, string2).stringvalue("serviceClass", clazz.getName()).methodvalue("instanceCreate", clazz.getName() + "$ContextAware", "createService").write();
    }

    private boolean isClassOf(Element element, Class clazz) {
        switch (element.getKind()) {
            case CLASS: {
                TypeElement typeElement = (TypeElement)element;
                TypeMirror typeMirror = typeElement.getSuperclass();
                if (typeMirror.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                element = ((DeclaredType)typeMirror).asElement();
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                if (string.equals(clazz.getName())) {
                    return true;
                }
                return this.isClassOf(element, clazz);
            }
            case METHOD: {
                TypeMirror typeMirror = ((ExecutableElement)element).getReturnType();
                if (typeMirror.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                element = ((DeclaredType)typeMirror).asElement();
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                if (string.equals(clazz.getName())) {
                    return true;
                }
                return this.isClassOf(element, clazz);
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + element);
    }

    private String instantiableClassOrMethod(Element element) throws IllegalArgumentException, LayerGenerationException {
        switch (element.getKind()) {
            case CLASS: {
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new LayerGenerationException(string + " must not be abstract", element);
                }
                boolean bl = false;
                for (ExecutableElement executableElement : ElementFilter.constructorsIn(element.getEnclosedElements())) {
                    if (!executableElement.getParameters().isEmpty()) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new LayerGenerationException(string + " must have a no-argument constructor", element);
                }
                return string;
            }
            case METHOD: {
                ExecutableElement executableElement = (ExecutableElement)element;
                String string = executableElement.getSimpleName().toString();
                String string2 = this.processingEnv.getElementUtils().getBinaryName((TypeElement)executableElement.getEnclosingElement()).toString();
                if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException(executableElement + " must be static", element);
                }
                if (executableElement.getParameters().size() > 0) {
                    throw new LayerGenerationException(executableElement + " must not have any parameters", element);
                }
                return string2 + "." + string + "()";
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + element);
    }
}

