/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogModelFactoryImpl;
import org.netbeans.modules.xml.retriever.catalog.impl.XAMCatalogWriteModelImpl;
import org.netbeans.modules.xml.retriever.impl.Util;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xam.locator.CatalogModelFactory;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.UserQuestionException;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    public static final String NO_NAME_SPACE = "NO_NAME_SPACE";
    private static final Logger logger = Logger.getLogger(Utilities.class.getName());
    private static boolean firstRoot = true;
    private static Map<String, String> namespaces = new HashMap<String, String>();
    private static Map<String, String> prefixes = new HashMap<String, String>();
    private static CatalogWriteModel testCatalogModel = null;
    public static final String DEFAULT_PRIVATE_CATALOG_URI_STR = "private/cache/retriever/catalog.xml";
    public static final String DEFAULT_PRIVATE_CAHCE_URI_STR = "private/cache/retriever";
    public static final String PRIVATE_CATALOG_URI_STR = "retriever/catalog.xml";
    public static final String PRIVATE_CAHCE_URI_STR = "retriever";

    public static URL appendURL(URL uRL, String string) {
        String string2 = uRL.toString();
        String string3 = null;
        string3 = string2.endsWith("/") ? string2 + string : string2 + "/" + string;
        try {
            return new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static boolean localResourceExists(URL uRL) {
        File file = null;
        try {
            file = new File(uRL.toURI());
            return file.exists();
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static File toFile(URL uRL) {
        URI uRI;
        try {
            uRI = uRL.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        return new File(uRI);
    }

    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                Utilities.deleteRecursively(file2);
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    public static String normalizeURI(String string) {
        byte[] byArray;
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null) {
            return null;
        }
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (n <= 32 || n > 127 || n == 34 || n == 60 || n == 62 || n == 92 || n == 94 || n == 96 || n == 123 || n == 124 || n == 125 || n == 127) {
                stringBuilder.append(Utilities.encodedByte(n));
                continue;
            }
            stringBuilder.append((char)byArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String encodedByte(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() < 2) {
            return "%0" + string;
        }
        return "%" + string;
    }

    public static String relativize(URI uRI, URI uRI2) {
        StringBuilder stringBuilder;
        String string = uRI.toString();
        String string2 = uRI2.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "/");
        String string3 = null;
        String string4 = null;
        int n = -1;
        do {
            ++n;
        } while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens() && (string3 = stringTokenizer.nextToken()).equals(string4 = stringTokenizer2.nextToken()));
        if (n < 2) {
            return uRI2.toString();
        }
        int n2 = stringTokenizer.countTokens();
        String string5 = "";
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append("../");
        }
        string5 = stringBuffer.toString();
        StringBuilder stringBuilder2 = stringBuilder = string3.equals(string4) ? new StringBuilder() : new StringBuilder(string4);
        while (stringTokenizer2.hasMoreTokens()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append('/');
            }
            stringBuilder.append(stringTokenizer2.nextToken());
        }
        return string5 + stringBuilder.toString();
    }

    public static List<FileObject> getFilesOfNSInProj(Project project, DocumentTypesEnum documentTypesEnum, String string, List<String> list) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        Map<FileObject, String> map = Utilities.getFiles2NSMappingInProj(project, documentTypesEnum, list);
        Set<FileObject> set = map.keySet();
        for (FileObject fileObject : set) {
            if (Thread.currentThread().isInterrupted()) break;
            if (!map.get(fileObject).equals(string)) continue;
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    public static List<FileObject> getFilesOfNoNSInProj(Project project, DocumentTypesEnum documentTypesEnum, List<String> list) {
        return Utilities.getFilesOfNSInProj(project, documentTypesEnum, NO_NAME_SPACE, list);
    }

    public static Map<FileObject, String> getFiles2NSMappingInProj(Project project, DocumentTypesEnum documentTypesEnum, List<String> list) {
        HashMap<FileObject, String> hashMap = new HashMap<FileObject, String>();
        List<FileObject> list2 = Utilities.getAllSourceRoots(project, list);
        for (FileObject fileObject : list2) {
            hashMap.putAll(Utilities.getFiles2NSMappingInProj(FileUtil.toFile((FileObject)fileObject), documentTypesEnum));
        }
        return hashMap;
    }

    private static List<FileObject> getAllSourceRoots(Project project, List<String> list) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (String string : list) {
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups(string);
            if (sourceGroupArray == null) continue;
            for (SourceGroup sourceGroup : sourceGroupArray) {
                arrayList.add(sourceGroup.getRootFolder());
            }
        }
        return arrayList;
    }

    public static Map<FileObject, String> getFiles2NSMappingInProj(File file, DocumentTypesEnum documentTypesEnum) {
        List<File> list = Utilities.getFilesWithExtension(file, documentTypesEnum.toString(), new ArrayList<File>());
        HashMap<FileObject, String> hashMap = new HashMap<FileObject, String>();
        String string = null;
        string = documentTypesEnum == DocumentTypesEnum.schema ? "//xsd:schema/@targetNamespace" : "//wsdl:definitions/@targetNamespace";
        for (File file2 : list) {
            if (Thread.currentThread().isInterrupted()) break;
            List<String> list2 = null;
            try {
                list2 = Utilities.runXPathQuery(file2, string);
                String string2 = null;
                FileObject fileObject = FileUtil.toFileObject((File)file2);
                string2 = list2.size() > 0 ? list2.get(0) : NO_NAME_SPACE;
                if (documentTypesEnum == DocumentTypesEnum.wsdl && string2 == NO_NAME_SPACE) continue;
                hashMap.put(fileObject, string2);
            }
            catch (Exception exception) {}
        }
        return hashMap;
    }

    public static List<File> getFilesWithExtension(File file, String string, List<File> list) {
        File[] fileArray;
        Object object;
        int n;
        if (Thread.currentThread().isInterrupted()) {
            firstRoot = true;
            return list;
        }
        if (list == null) {
            list = new ArrayList<File>();
        }
        if (file.isFile() && (n = file.getName().lastIndexOf(".")) != -1 && (object = file.getName().substring(n + 1)) != null && ((String)object).equalsIgnoreCase(string)) {
            list.add(file);
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (firstRoot && file2.getName().endsWith("build")) continue;
                firstRoot = false;
                Utilities.getFilesWithExtension(file2, string, list);
            }
        }
        firstRoot = true;
        return list;
    }

    public static List<String> runXPathQuery(File file, String string) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(Utilities.getNamespaceContext());
        InputSource inputSource = new InputSource(new FileInputStream(file));
        NodeList nodeList = (NodeList)xPath.evaluate(string, inputSource, XPathConstants.NODESET);
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                arrayList.add(node.getNodeValue());
            }
        }
        return arrayList;
    }

    private static NamespaceContext getNamespaceContext() {
        namespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
        prefixes.put("http://www.w3.org/2001/XMLSchema", "xsd");
        namespaces.put("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        prefixes.put("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        return new HashNamespaceResolver(namespaces, prefixes);
    }

    public static int countPushdownFolders(URI uRI, URI uRI2) {
        String string = uRI.toString();
        String string2 = uRI2.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "/");
        String string3 = null;
        String string4 = null;
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens() && (string3 = stringTokenizer.nextToken()).equals(string4 = stringTokenizer2.nextToken())) {
        }
        return stringTokenizer2.countTokens() + 1;
    }

    public static File downloadURLAndSave(URL uRL, File file) throws IOException {
        return Utilities.downloadURLUsingProxyAndSave(uRL, null, file);
    }

    public static File downloadURLUsingProxyAndSave(URL uRL, Proxy proxy, File file) throws IOException {
        IOException iOException = null;
        URLConnection uRLConnection = null;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        uRLConnection = proxy != null ? uRL.openConnection(proxy) : uRL.openConnection();
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        uRLConnection.connect();
        byte[] byArray = new byte[1024];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        file.getParentFile().mkdirs();
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            bufferedInputStream.close();
            throw fileNotFoundException;
        }
        int n = 1024;
        while ((n = bufferedInputStream.read(byArray, 0, 1024)) > 0) {
            try {
                if (Thread.currentThread().isInterrupted()) break;
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                bufferedOutputStream.write(byArray, 0, n);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                break;
            }
        }
        try {
            bufferedInputStream.close();
        }
        catch (IOException iOException3) {
            // empty catch block
        }
        try {
            bufferedOutputStream.close();
        }
        catch (IOException iOException4) {
            // empty catch block
        }
        if (iOException != null) {
            throw iOException;
        }
        return file;
    }

    public static InputStream getInputStreamOfURL(URL uRL, Proxy proxy) throws IOException {
        URLConnection uRLConnection = null;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        uRLConnection = proxy != null ? uRL.openConnection(proxy) : uRL.openConnection();
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        uRLConnection.connect();
        return uRLConnection.getInputStream();
    }

    public static Document getDocument(FileObject fileObject) {
        BaseDocument baseDocument = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            StyledDocument styledDocument = editorCookie.openDocument();
            if (styledDocument instanceof BaseDocument) {
                return styledDocument;
            }
            baseDocument = new BaseDocument(true, fileObject.getMIMEType());
            String string = styledDocument.getText(0, styledDocument.getLength());
            baseDocument.insertString(0, string, null);
        }
        catch (Exception exception) {
            return null;
        }
        return baseDocument;
    }

    private static Document _getDocument(DataObject dataObject) throws IOException {
        StyledDocument styledDocument = null;
        if (dataObject != null && dataObject.isValid()) {
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            assert (editorCookie != null) : "Data object " + dataObject.getPrimaryFile().getPath() + " has no editor cookies.";
            if (editorCookie != null) {
                StyledDocument styledDocument2 = null;
                try {
                    styledDocument2 = editorCookie.openDocument();
                }
                catch (UserQuestionException userQuestionException) {
                    userQuestionException.confirmed();
                    styledDocument2 = editorCookie.openDocument();
                }
                assert (styledDocument2 instanceof BaseDocument);
                styledDocument = styledDocument2;
            }
        }
        return styledDocument;
    }

    protected static Document _getDocument(FileObject fileObject) throws DataObjectNotFoundException, IOException {
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        return Utilities._getDocument(dataObject);
    }

    public static CatalogWriteModel getTestCatalogWriteModel() throws IOException {
        if (testCatalogModel == null) {
            XAMCatalogWriteModelImpl xAMCatalogWriteModelImpl = null;
            try {
                xAMCatalogWriteModelImpl = new XAMCatalogWriteModelImpl(new File(System.getProperty("java.io.tmpdir")));
            }
            catch (CatalogModelException catalogModelException) {
                return null;
            }
            File file = FileUtil.toFile((FileObject)xAMCatalogWriteModelImpl.getCatalogFileObject());
            file.deleteOnExit();
            return xAMCatalogWriteModelImpl;
        }
        return testCatalogModel;
    }

    public static FileObject getProjectCatalogFileObject(Project project) throws IOException {
        return Util.getProjectCatalogFileObject(project, true);
    }

    public static FileObject getFileObject(ModelSource modelSource) {
        return (FileObject)modelSource.getLookup().lookup(FileObject.class);
    }

    public static CatalogModel getCatalogModel(ModelSource modelSource) throws CatalogModelException {
        return CatalogModelFactory.getDefault().getCatalogModel(modelSource);
    }

    public static ModelSource getModelSource(FileObject fileObject, boolean bl) {
        try {
            return Utilities.createModelSource(fileObject, bl);
        }
        catch (CatalogModelException catalogModelException) {
            return null;
        }
    }

    public static ModelSource createModelSource(FileObject fileObject, boolean bl) throws CatalogModelException {
        DataObject dataObject;
        assert (fileObject != null) : "Null file object.";
        final CatalogModel catalogModel = Utilities.createCatalogModel(fileObject);
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            throw new CatalogModelException((Throwable)dataObjectNotFoundException);
        }
        Lookup lookup = Lookups.proxy((Lookup.Provider)new Lookup.Provider(){

            public Lookup getLookup() {
                Document document = null;
                try {
                    document = Utilities._getDocument(dataObject);
                    if (document != null) {
                        return Lookups.fixed((Object[])new Object[]{dataObject.getPrimaryFile(), document, dataObject, DataObjectAdapters.source((DataObject)dataObject), catalogModel});
                    }
                    return Lookups.fixed((Object[])new Object[]{dataObject.getPrimaryFile(), dataObject, catalogModel});
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, iOException.getMessage());
                    return Lookups.fixed((Object[])new Object[]{dataObject, catalogModel});
                }
            }
        });
        return new ModelSource(lookup, bl);
    }

    public static CatalogModel createCatalogModel(FileObject fileObject) throws CatalogModelException {
        return new CatalogModelFactoryImpl().getCatalogModel(fileObject);
    }

    public static boolean retrieveAndCache(URI uRI, FileObject fileObject) {
        return Util.retrieveAndCache(uRI, fileObject, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class HashNamespaceResolver
    implements NamespaceContext {
        private Map<String, String> prefixes;
        private Map<String, String> namespaces;

        public HashNamespaceResolver(Map<String, String> map) {
            this.namespaces = map;
            this.prefixes = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                this.prefixes.put(entry.getValue(), entry.getKey());
            }
        }

        public HashNamespaceResolver(Map<String, String> map, Map<String, String> map2) {
            this.namespaces = map;
            this.prefixes = map2;
        }

        public Iterator getPrefixes(String string) {
            return Collections.singletonList(this.getPrefix(string)).iterator();
        }

        @Override
        public String getPrefix(String string) {
            return this.prefixes.get(string);
        }

        @Override
        public String getNamespaceURI(String string) {
            return this.namespaces.get(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DocumentTypesEnum {
        schema,
        wsdl;


        public String toString() {
            if (this.name().equals("schema")) {
                return "xsd";
            }
            return this.name();
        }
    }
}

