/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.retriever.RetrieveEntry;
import org.netbeans.modules.xml.retriever.Retriever;
import org.netbeans.modules.xml.retriever.XMLCatalogProvider;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.retriever.impl.RetrieverEngineImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetrieverImpl
extends Retriever {
    File seedFile = null;
    RetrieverEngineImpl instance;
    private boolean newThread = false;
    boolean retrieveRecursively = true;
    boolean overwriteFiles = true;

    void setNewThread(boolean bl) {
        this.newThread = bl;
    }

    @Override
    public FileObject retrieveResource(FileObject fileObject, URI uRI, URI uRI2) throws UnknownHostException, URISyntaxException, IOException {
        return this.retrieveResource(fileObject, uRI, uRI2, false);
    }

    @Override
    public FileObject retrieveResource(FileObject fileObject, URI uRI) throws UnknownHostException, URISyntaxException, IOException {
        return this.retrieveResource(fileObject, null, uRI);
    }

    @Override
    public FileObject retrieveResourceClosureIntoSingleDirectory(FileObject fileObject, URI uRI) throws UnknownHostException, URISyntaxException, IOException {
        return this.retrieveResource(fileObject, null, uRI, true);
    }

    public FileObject retrieveResource(FileObject fileObject, URI uRI, URI uRI2, boolean bl) throws UnknownHostException, URISyntaxException, IOException {
        Object object;
        Object object2;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (uRI == null) {
            assert (project != null);
            object2 = (XMLCatalogProvider)project.getLookup().lookup(XMLCatalogProvider.class);
            if (object2 == null) {
                return this.retrieveResourceImpl(fileObject, uRI2, null, bl);
            }
            uRI = object2.getProjectWideCatalog();
            if (uRI == null) {
                return this.retrieveResourceImpl(fileObject, uRI2, null, bl);
            }
        }
        object2 = null;
        if (!uRI.isAbsolute()) {
            object = project.getProjectDirectory();
            object2 = FileUtil.toFile((FileObject)object).toURI().resolve(uRI);
        } else {
            object2 = uRI;
        }
        object = new File((URI)object2);
        if (!((File)object).isFile()) {
            ((File)object).createNewFile();
        }
        FileObject fileObject2 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)object));
        return this.retrieveResourceImpl(fileObject, uRI2, fileObject2, bl);
    }

    private FileObject retrieveResourceImpl(FileObject fileObject, URI uRI, FileObject fileObject2, boolean bl) throws UnknownHostException, URISyntaxException, IOException {
        File file;
        this.instance = new RetrieverEngineImpl(FileUtil.toFile((FileObject)fileObject), this.newThread);
        this.instance.setFileOverwrite(this.overwriteFiles);
        this.instance.setSave2SingleFolder(bl);
        if (fileObject2 != null) {
            this.instance.setCatalogFile(fileObject2);
        }
        this.instance.setShowErrorPopup(false);
        RetrieveEntry retrieveEntry = null;
        retrieveEntry = new RetrieveEntry(null, uRI.toString(), null, null, Utilities.DocumentTypesEnum.schema, this.retrieveRecursively);
        this.instance.addResourceToRetrieve(retrieveEntry);
        this.instance.start();
        this.seedFile = file = this.instance.getSeedFileLocation();
        if (file == null) {
            return null;
        }
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
    }

    private Project getProject(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        return FileOwnerQuery.getOwner((FileObject)fileObject);
    }

    @Override
    public File getProjectCatalog() {
        if (this.seedFile == null) {
            return null;
        }
        FileObject fileObject = this.getProject(this.seedFile).getProjectDirectory();
        File file = FileUtil.toFile((FileObject)fileObject);
        File file2 = new File(file, "catalog.xml");
        return file2;
    }

    @Override
    public Map<RetrieveEntry, Exception> getRetrievedResourceExceptionMap() {
        if (this.instance != null) {
            return this.instance.getRetrievedResourceExceptionMap();
        }
        return null;
    }

    @Override
    public File retrieveResource(File file, URI uRI) throws UnknownHostException, URISyntaxException, IOException {
        FileObject fileObject = this.retrieveResource(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file)), uRI);
        if (fileObject != null) {
            return FileUtil.toFile((FileObject)fileObject);
        }
        return null;
    }

    @Override
    public void setRecursiveRetrieve(boolean bl) {
        this.retrieveRecursively = bl;
    }

    @Override
    public void setOverwriteFilesWithSameName(boolean bl) {
        this.overwriteFiles = bl;
    }
}

