/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;
import org.w3c.dom.Element;

final class ArtifactProvider
implements AntArtifactProvider {
    private final FreeformProject project;

    public ArtifactProvider(FreeformProject freeformProject) {
        this.project = freeformProject;
    }

    public AntArtifact[] getBuildArtifacts() {
        Element element = this.project.getPrimaryConfigurationData();
        ArrayList<FreeformArtifact> arrayList = new ArrayList<FreeformArtifact>();
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, FreeformArtifact> hashMap = new HashMap<String, FreeformArtifact>();
        for (Element element2 : Util.findSubElements(element)) {
            if (!element2.getLocalName().equals("export")) continue;
            FreeformArtifact freeformArtifact = new FreeformArtifact(element2);
            String string = freeformArtifact.getType() + freeformArtifact.getTargetName() + freeformArtifact.getScriptLocation().getAbsolutePath();
            FreeformArtifact freeformArtifact2 = (FreeformArtifact)((Object)hashMap.get(string));
            if (freeformArtifact2 != null) {
                freeformArtifact2.addLocation(ArtifactProvider.readArtifactLocation(element2, this.project.evaluator()));
                continue;
            }
            freeformArtifact.addLocation(ArtifactProvider.readArtifactLocation(element2, this.project.evaluator()));
            hashMap.put(string, freeformArtifact);
            String string2 = freeformArtifact.preferredId();
            if (!hashSet.add(string2)) {
                int n = 2;
                while (true) {
                    String string3;
                    if (hashSet.add(string3 = string2 + n)) {
                        string2 = string3;
                        break;
                    }
                    ++n;
                }
            }
            freeformArtifact.configureId(string2);
            arrayList.add(freeformArtifact);
        }
        return arrayList.toArray(new AntArtifact[arrayList.size()]);
    }

    public static URI readArtifactLocation(Element element, PropertyEvaluator propertyEvaluator) {
        Element element2 = Util.findElement(element, "location", "http://www.netbeans.org/ns/freeform-project/2");
        assert (element2 != null);
        String string = Util.findText(element2);
        assert (string != null);
        String string2 = propertyEvaluator.evaluate(string);
        if (string2 == null) {
            return URI.create("file:/UNDEFINED");
        }
        File file = new File(string2);
        if (file.isAbsolute()) {
            return file.toURI();
        }
        try {
            return new URI(null, null, string2.replace(File.separatorChar, '/'), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            ErrorManager.getDefault().notify(1, (Throwable)uRISyntaxException);
            return URI.create("file:/BROKEN");
        }
    }

    private final class FreeformArtifact
    extends AntArtifact {
        private final Element export;
        private String id = null;
        private final Set<URI> locations = new LinkedHashSet<URI>();

        public FreeformArtifact(Element element) {
            this.export = element;
        }

        public String preferredId() {
            return this.getTargetName();
        }

        public void configureId(String string) {
            assert (this.id == null);
            this.id = string;
        }

        public String getType() {
            Element element = Util.findElement(this.export, "type", "http://www.netbeans.org/ns/freeform-project/2");
            assert (element != null);
            String string = Util.findText(element);
            assert (string != null);
            return string;
        }

        public String getTargetName() {
            Element element = Util.findElement(this.export, "build-target", "http://www.netbeans.org/ns/freeform-project/2");
            assert (element != null);
            String string = Util.findText(element);
            assert (string != null);
            return string;
        }

        public String getCleanTargetName() {
            Element element = Util.findElement(this.export, "clean-target", "http://www.netbeans.org/ns/freeform-project/2");
            if (element != null) {
                String string = Util.findText(element);
                assert (string != null);
                return string;
            }
            String string = null;
            Element element2 = ArtifactProvider.this.project.getPrimaryConfigurationData();
            Element element3 = Util.findElement(element2, "ide-actions", "http://www.netbeans.org/ns/freeform-project/2");
            if (element3 != null) {
                block0: for (Element element4 : Util.findSubElements(element3)) {
                    if (!element4.getAttribute("name").equals("clean")) continue;
                    for (Element element5 : Util.findSubElements(element4)) {
                        if (!element5.getLocalName().equals("target")) continue;
                        String string2 = Util.findText(element5);
                        assert (string2 != null);
                        if (string == null) {
                            string = string2;
                            continue;
                        }
                        string = null;
                        break block0;
                    }
                }
            }
            if (string == null) {
                string = "clean";
            }
            return string;
        }

        public File getScriptLocation() {
            String string = null;
            Element element = Util.findElement(this.export, "script", "http://www.netbeans.org/ns/freeform-project/2");
            if (element != null) {
                String string2 = Util.findText(element);
                assert (string2 != null);
                string = ArtifactProvider.this.project.evaluator().evaluate(string2);
            }
            if (string == null) {
                string = "build.xml";
            }
            return ArtifactProvider.this.project.helper().resolveFile(string);
        }

        public Project getProject() {
            return ArtifactProvider.this.project;
        }

        public String getID() {
            assert (this.id != null);
            return this.id;
        }

        public URI[] getArtifactLocations() {
            return this.locations.toArray(new URI[this.locations.size()]);
        }

        private void addLocation(URI uRI) {
            this.locations.add(uRI);
        }

        public String toString() {
            return "FreeformArtifact[" + ArtifactProvider.this.project + ":" + this.id + "]";
        }
    }
}

