/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BasicProjectInfoPanel
extends JPanel
implements HelpCtx.Provider {
    private DocumentListener documentListener;
    private ChangeListener listener;
    private boolean antScriptTouched = false;
    private boolean projectFolderTouched = false;
    private boolean projectNameTouched = false;
    private boolean antScriptValidityChecked;
    private boolean ignoreEvent = false;
    private JTextField antScript;
    private JButton browseAntScript;
    private JButton browseProjectFolder;
    private JButton browseProjectLocation;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JTextArea jTextArea2;
    private JCheckBox mainProject;
    private JTextField projectFolder;
    private JTextField projectLocation;
    private JTextField projectName;

    public BasicProjectInfoPanel(String string, String string2, String string3, String string4, ChangeListener changeListener) {
        this.initComponents();
        this.projectLocation.setText(string);
        this.antScript.setText(string2);
        this.projectName.setText(string3);
        this.projectFolder.setText(string4);
        this.listener = changeListener;
        this.documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                BasicProjectInfoPanel.this.update(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                BasicProjectInfoPanel.this.update(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                BasicProjectInfoPanel.this.update(documentEvent);
            }
        };
        this.projectLocation.getDocument().addDocumentListener(this.documentListener);
        this.antScript.getDocument().addDocumentListener(this.documentListener);
        this.projectName.getDocument().addDocumentListener(this.documentListener);
        this.projectFolder.getDocument().addDocumentListener(this.documentListener);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(BasicProjectInfoPanel.class);
    }

    public File getProjectLocation() {
        return this.getAsFile(this.projectLocation.getText());
    }

    public File getAntScript() {
        return this.getAsFile(this.antScript.getText());
    }

    public String getProjectName() {
        return this.projectName.getText();
    }

    public File getProjectFolder() {
        return this.getAsFile(this.projectFolder.getText());
    }

    public Boolean getMainProject() {
        return this.mainProject.isSelected();
    }

    public String[] getError() {
        FileObject fileObject;
        if (this.projectLocation.getText().length() == 0) {
            return new String[]{NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_1"), "WizardPanel_infoMessage"};
        }
        if (!this.getProjectLocation().exists()) {
            return new String[]{NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_2"), "WizardPanel_errorMessage"};
        }
        if (this.antScript.getText().length() == 0) {
            return new String[]{NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_3"), "WizardPanel_infoMessage"};
        }
        if (!this.getAntScript().exists()) {
            return new String[]{NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_4"), "WizardPanel_errorMessage"};
        }
        if (!this.antScriptValidityChecked) {
            fileObject = FileUtil.toFileObject((File)this.getAntScript());
            if (fileObject != null) {
                try {
                    AntScriptUtils.getCallableTargetNames((FileObject)fileObject);
                    this.antScriptValidityChecked = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!this.antScriptValidityChecked) {
                return new String[]{NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_5"), "WizardPanel_errorMessage"};
            }
        }
        if (this.getProjectName().length() == 0) {
            return new String[]{NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_6"), "WizardPanel_infoMessage"};
        }
        if (this.projectFolder.getText().length() == 0) {
            return new String[]{NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_7"), "WizardPanel_infoMessage"};
        }
        if (this.getAsFile(this.projectFolder.getText() + File.separatorChar + "nbproject").exists()) {
            return new String[]{NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_8"), "WizardPanel_errorMessage"};
        }
        File file = this.getProjectFolder();
        assert (file != null);
        fileObject = FileOwnerQuery.getOwner((URI)file.toURI());
        if (fileObject != null && file.equals(FileUtil.toFile((FileObject)fileObject.getProjectDirectory()))) {
            ProjectInformation projectInformation = (ProjectInformation)fileObject.getLookup().lookup(ProjectInformation.class);
            String string = projectInformation == null ? "" : projectInformation.getDisplayName();
            return new String[]{MessageFormat.format(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_9"), string), "WizardPanel_errorMessage"};
        }
        File file2 = this.getProjectLocation();
        assert (file2 != null);
        fileObject = FileOwnerQuery.getOwner((URI)file2.toURI());
        if (fileObject != null && file2.equals(FileUtil.toFile((FileObject)fileObject.getProjectDirectory()))) {
            ProjectInformation projectInformation = (ProjectInformation)fileObject.getLookup().lookup(ProjectInformation.class);
            String string = projectInformation == null ? "" : projectInformation.getDisplayName();
            return new String[]{MessageFormat.format(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_10"), string), "WizardPanel_errorMessage"};
        }
        return null;
    }

    private File getAsFile(String string) {
        return FileUtil.normalizeFile((File)new File(string));
    }

    private void update(DocumentEvent documentEvent) {
        if (this.ignoreEvent) {
            return;
        }
        this.ignoreEvent = true;
        if (this.projectLocation.getDocument() == documentEvent.getDocument()) {
            this.antScriptValidityChecked = false;
            this.updateAntScriptLocation();
            this.updateProjectName();
            this.updateProjectFolder();
        }
        if (this.antScript.getDocument() == documentEvent.getDocument()) {
            this.antScriptValidityChecked = false;
            this.updateProjectName();
        }
        this.ignoreEvent = false;
        if (this.projectFolder.getDocument() == documentEvent.getDocument()) {
            boolean bl = this.projectFolderTouched = !"".equals(this.projectFolder.getText());
        }
        if (this.antScript.getDocument() == documentEvent.getDocument()) {
            boolean bl = this.antScriptTouched = !"".equals(this.antScript.getText());
        }
        if (this.projectName.getDocument() == documentEvent.getDocument()) {
            this.projectNameTouched = !"".equals(this.projectName.getText());
        }
        this.listener.stateChanged(null);
    }

    private boolean isValidProjectLocation() {
        return this.getProjectLocation().exists() && this.getProjectLocation().isDirectory() && this.projectLocation.getText().length() > 0 && !this.projectLocation.getText().endsWith(":");
    }

    private void updateAntScriptLocation() {
        File file;
        if (this.antScriptTouched) {
            return;
        }
        if (this.isValidProjectLocation() && (file = new File(this.getProjectLocation().getAbsolutePath() + File.separatorChar + "build.xml")).exists()) {
            this.antScript.setText(file.getAbsolutePath());
            return;
        }
        this.antScript.setText("");
    }

    private void updateProjectName() {
        File file;
        if (this.projectNameTouched) {
            return;
        }
        if (this.getAntScript().exists() && (file = new File(this.getAntScript().getAbsolutePath())).exists()) {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            assert (fileObject != null) : file;
            String string = AntScriptUtils.getAntScriptName((FileObject)fileObject);
            if (string != null) {
                this.projectName.setText(string);
                return;
            }
        }
        this.projectName.setText("");
    }

    private void updateProjectFolder() {
        if (this.projectFolderTouched) {
            return;
        }
        if (this.isValidProjectLocation()) {
            this.projectFolder.setText(this.getProjectLocation().getAbsolutePath());
        } else {
            this.projectFolder.setText("");
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.antScript = new JTextField();
        this.projectName = new JTextField();
        this.projectFolder = new JTextField();
        this.browseAntScript = new JButton();
        this.browseProjectFolder = new JButton();
        this.projectLocation = new JTextField();
        this.jLabel6 = new JLabel();
        this.browseProjectLocation = new JButton();
        this.jSeparator1 = new JSeparator();
        this.mainProject = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jTextArea2 = new JTextArea();
        this.setPreferredSize(new Dimension(400, 360));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel1"));
        this.jLabel2.setLabelFor(this.antScript);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel2"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel3"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(16, 0, 10, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel3"));
        this.jLabel4.setLabelFor(this.projectName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel4"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel4"));
        this.jLabel5.setLabelFor(this.projectFolder);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.antScript, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.projectName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.projectFolder, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseAntScript, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"BTN_BasicProjectInfoPanel_browseAntScript"));
        this.browseAntScript.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicProjectInfoPanel.this.browseAntScriptActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.browseAntScript, gridBagConstraints);
        this.browseAntScript.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_browseAntScript"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseProjectFolder, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"BTN_BasicProjectInfoPanel_browseProjectFolder"));
        this.browseProjectFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicProjectInfoPanel.this.browseProjectFolderActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.browseProjectFolder, gridBagConstraints);
        this.browseProjectFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_browseProjectFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.projectLocation, gridBagConstraints);
        this.jLabel6.setLabelFor(this.projectLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel6"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel6.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel6"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseProjectLocation, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"BTN_BasicProjectInfoPanel_browseProjectLocation"));
        this.browseProjectLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicProjectInfoPanel.this.browseProjectLocationActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.browseProjectLocation, gridBagConstraints);
        this.browseProjectLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_browseProjectLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 10, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.mainProject.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.mainProject, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_mainProject"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.mainProject, gridBagConstraints);
        this.mainProject.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_mainProject"));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Label.disabledForeground")));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel7.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/ant/freeform/resources/alert_32.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        this.jTextArea2.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setText(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"Freeform_Warning_Message"));
        this.jTextArea2.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.jPanel2.add((Component)this.jTextArea2, gridBagConstraints);
        this.jTextArea2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSN_Freeform_Warning_Message"));
        this.jTextArea2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_Freeform_Warning_Message"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void browseProjectLocationActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        if (this.projectLocation.getText().length() > 0 && this.getProjectLocation().exists()) {
            jFileChooser.setSelectedFile(this.getProjectLocation());
        } else {
            jFileChooser.setSelectedFile(ProjectChooser.getProjectsFolder());
        }
        jFileChooser.setDialogTitle(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_Browse_Location"));
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.projectLocation.setText(file.getAbsolutePath());
        }
    }

    private void browseProjectFolderActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        if (this.projectFolder.getText().length() > 0 && this.getProjectFolder().exists()) {
            jFileChooser.setSelectedFile(this.getProjectFolder());
        } else if (this.projectLocation.getText().length() > 0 && this.getProjectLocation().exists()) {
            jFileChooser.setSelectedFile(this.getProjectLocation());
        } else {
            jFileChooser.setSelectedFile(ProjectChooser.getProjectsFolder());
        }
        jFileChooser.setDialogTitle(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_Browse_Project_Folder"));
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.projectFolder.setText(file.getAbsolutePath());
        }
    }

    private void browseAntScriptActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(0);
        if (this.antScript.getText().length() > 0 && this.getAntScript().exists()) {
            jFileChooser.setSelectedFile(this.getAntScript());
        } else if (this.projectLocation.getText().length() > 0 && this.getProjectLocation().exists()) {
            jFileChooser.setSelectedFile(this.getProjectLocation());
        } else {
            jFileChooser.setSelectedFile(ProjectChooser.getProjectsFolder());
        }
        jFileChooser.setDialogTitle(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_Browse_Build_Script"));
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.antScript.setText(file.getAbsolutePath());
        }
    }
}

