/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.netbeans.modules.ant.freeform.FreeformProjectGenerator;
import org.netbeans.modules.ant.freeform.spi.TargetDescriptor;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetMappingPanel
extends JPanel
implements ActionListener,
HelpCtx.Provider {
    public static final String BUILD_ACTION = "build";
    public static final String CLEAN_ACTION = "clean";
    public static final String REBUILD_ACTION = "rebuild";
    public static final String JAVADOC_ACTION = "javadoc";
    public static final String RUN_ACTION = "run";
    public static final String TEST_ACTION = "test";
    private static final List<String> DEFAULT_BUILD_TARGETS = Arrays.asList("build", "compile", "jar", "dist", "all", ".*jar.*");
    private static final List<String> DEFAULT_CLEAN_TARGETS = Arrays.asList("clean", ".*clean.*");
    private static final List<String> DEFAULT_JAVADOC_TARGETS = Arrays.asList("javadoc", "javadocs", "docs", "doc", ".*javadoc.*", ".*doc.*");
    private static final List<String> DEFAULT_RUN_TARGETS = Arrays.asList("run", "start", ".*run.*", ".*start.*");
    private static final List<String> DEFAULT_TEST_TARGETS = Arrays.asList("test", ".*test.*");
    private List<String> targetNames;
    private List<FreeformProjectGenerator.TargetMapping> targetMappings;
    private List<FreeformProjectGenerator.CustomTarget> custTargets;
    private CustomTargetsModel customTargetsModel;
    private String antScript;
    private List<JComboBox> combos = new ArrayList<JComboBox>();
    private List<TargetDescriptor> targetDescs = new ArrayList<TargetDescriptor>();
    private boolean dirtyRegular;
    private boolean dirtyCustom;
    private AntProjectHelper helper;
    private JButton add;
    private JLabel additionalTargetsLabel;
    private JComboBox buildCombo;
    private JLabel buildLabel;
    private JComboBox cleanCombo;
    private JLabel cleanLabel;
    private JTable customTargets;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JComboBox javadocCombo;
    private JLabel javadocLabel;
    private JPanel remainder;
    private JButton remove;
    private JComboBox runCombo;
    private JLabel runLabel;
    private JPanel specialRemainder;
    private JPanel targetsPanel;
    private JComboBox testCombo;
    private JLabel testLabel;

    public TargetMappingPanel(boolean bl) {
        this(new ArrayList<TargetDescriptor>(), bl);
    }

    public TargetMappingPanel(List<TargetDescriptor> list, boolean bl) {
        this.initComponents();
        this.targetMappings = new ArrayList<FreeformProjectGenerator.TargetMapping>();
        this.custTargets = new ArrayList<FreeformProjectGenerator.CustomTarget>();
        this.customTargetsModel = new CustomTargetsModel();
        this.customTargets.setModel(this.customTargetsModel);
        this.customTargets.getTableHeader().setReorderingAllowed(false);
        this.addTargets(list);
        this.showAdvancedPart(bl);
    }

    public TargetMappingPanel(List<TargetDescriptor> list, PropertyEvaluator propertyEvaluator, AntProjectHelper antProjectHelper) {
        this(list, true);
        this.helper = antProjectHelper;
        FileObject fileObject = FreeformProjectGenerator.getAntScript(antProjectHelper, propertyEvaluator);
        List list2 = null;
        if (fileObject != null) {
            try {
                list2 = AntScriptUtils.getCallableTargetNames((FileObject)fileObject);
            }
            catch (IOException iOException) {
                Logger.getLogger(TargetMappingPanel.class.getName()).log(Level.INFO, "Cannot parse: " + fileObject, iOException);
            }
        }
        if (list2 != null) {
            this.setTargetNames(list2, false);
            this.initAntTargetEditor(list2);
        }
        this.antScript = TargetMappingPanel.defaultAntScript(propertyEvaluator);
        this.initMappings(FreeformProjectGenerator.getTargetMappings(antProjectHelper), this.antScript);
        this.custTargets = FreeformProjectGenerator.getCustomContextMenuActions(antProjectHelper);
        this.customTargetsModel.fireTableDataChanged();
        this.updateButtons();
    }

    static String defaultAntScript(PropertyEvaluator propertyEvaluator) {
        String string = propertyEvaluator.getProperty("ant.script");
        if (string == null) {
            return null;
        }
        return "${ant.script}";
    }

    private void addTargets(List<TargetDescriptor> list) {
        this.combos.add(this.buildCombo);
        this.targetDescs.add(new TargetDescriptor(BUILD_ACTION, DEFAULT_BUILD_TARGETS, null, null));
        this.combos.add(this.cleanCombo);
        this.targetDescs.add(new TargetDescriptor(CLEAN_ACTION, DEFAULT_CLEAN_TARGETS, null, null));
        this.combos.add(this.javadocCombo);
        this.targetDescs.add(new TargetDescriptor(JAVADOC_ACTION, DEFAULT_JAVADOC_TARGETS, null, null));
        this.combos.add(this.runCombo);
        this.targetDescs.add(new TargetDescriptor(RUN_ACTION, DEFAULT_RUN_TARGETS, null, null));
        this.combos.add(this.testCombo);
        this.targetDescs.add(new TargetDescriptor(TEST_ACTION, DEFAULT_TEST_TARGETS, null, null));
        int n = 5;
        for (TargetDescriptor targetDescriptor : list) {
            this.targetDescs.add(targetDescriptor);
            JComboBox jComboBox = new JComboBox();
            jComboBox.setEditable(true);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 6, 0);
            this.targetsPanel.add(jComboBox, gridBagConstraints);
            JLabel jLabel = new JLabel();
            jLabel.setLabelFor(jComboBox);
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)targetDescriptor.getIDEActionLabel());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 6, 6);
            this.targetsPanel.add((Component)jLabel, gridBagConstraints);
            jLabel.getAccessibleContext().setAccessibleDescription(targetDescriptor.getAccessibleLabel());
            this.combos.add(jComboBox);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TargetMappingPanel.class);
    }

    private void showAdvancedPart(boolean bl) {
        this.additionalTargetsLabel.setVisible(bl);
        this.jScrollPane1.setVisible(bl);
        this.customTargets.setVisible(bl);
        this.add.setVisible(bl);
        this.remove.setVisible(bl);
        this.remainder.setVisible(bl);
        this.specialRemainder.setVisible(!bl);
    }

    private void initAntTargetEditor(List<String> list) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEditable(true);
        for (String string : list) {
            jComboBox.addItem(string);
        }
        this.customTargets.setDefaultEditor(JComboBox.class, new DefaultCellEditor(jComboBox));
    }

    private FreeformProjectGenerator.CustomTarget getItem(int n) {
        return this.custTargets.get(n);
    }

    public void setTargetNames(List<String> list, boolean bl) {
        this.targetNames = list;
        this.targetNames.add(0, "");
        this.updateCombos(bl);
    }

    public void setScript(String string) {
        this.antScript = string;
        for (FreeformProjectGenerator.TargetMapping targetMapping : this.targetMappings) {
            targetMapping.script = string;
        }
    }

    private void updateCombos(boolean bl) {
        Iterator<TargetDescriptor> iterator = this.targetDescs.iterator();
        for (JComboBox jComboBox : this.combos) {
            TargetDescriptor targetDescriptor = iterator.next();
            jComboBox.removeAllItems();
            for (String string : this.targetNames) {
                jComboBox.addItem(string);
            }
            if (!bl) continue;
            this.selectItem(jComboBox, targetDescriptor.getDefaultTargets(), false);
        }
    }

    private void selectItem(JComboBox jComboBox, List<String> list, boolean bl) {
        ComboBoxModel comboBoxModel = jComboBox.getModel();
        for (String string : list) {
            Pattern pattern = Pattern.compile(string);
            for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                String string2 = (String)comboBoxModel.getElementAt(i);
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.matches()) continue;
                comboBoxModel.setSelectedItem(string2);
                return;
            }
        }
        if (bl) {
            assert (list.size() == 1) : "There should be only one item in this case";
            jComboBox.addItem(list.get(0));
            comboBoxModel.setSelectedItem(list.get(0));
        } else {
            comboBoxModel.setSelectedItem("");
        }
    }

    private void initMappings(List<FreeformProjectGenerator.TargetMapping> list, String string) {
        for (FreeformProjectGenerator.TargetMapping targetMapping : list) {
            Iterator<JComboBox> iterator = this.combos.iterator();
            for (TargetDescriptor targetDescriptor : this.targetDescs) {
                JComboBox jComboBox = iterator.next();
                if (!targetMapping.name.equals(targetDescriptor.getIDEActionName())) continue;
                this.selectItem(jComboBox, Collections.singletonList(TargetMappingPanel.getListAsString(targetMapping.targets)), true);
                this.checkAntScript(jComboBox, string, targetMapping.script);
            }
        }
        this.targetMappings = list;
    }

    private void checkAntScript(JComboBox jComboBox, String string, String string2) {
        if (string == null && string2 == null || string != null && string.equals(string2)) {
            jComboBox.setEnabled(true);
        } else {
            jComboBox.setEnabled(false);
        }
    }

    private static String getListAsString(List<String> list) {
        assert (list != null);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    static List<String> getStringAsList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() == 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private void storeTarget(String string, JComboBox jComboBox) {
        if (jComboBox.getModel().getSelectedItem() == null || ((String)jComboBox.getModel().getSelectedItem()).length() == 0) {
            this.removeTargetMapping(string);
            return;
        }
        FreeformProjectGenerator.TargetMapping targetMapping = this.getTargetMapping(string);
        String string2 = (String)jComboBox.getModel().getSelectedItem();
        List<String> list = TargetMappingPanel.getStringAsList(string2);
        if (!((Object)list).equals(targetMapping.targets)) {
            this.dirtyRegular = true;
        }
        targetMapping.targets = list;
    }

    private FreeformProjectGenerator.TargetMapping getTargetMapping(String string) {
        for (FreeformProjectGenerator.TargetMapping targetMapping : this.targetMappings) {
            if (!targetMapping.name.equals(string)) continue;
            return targetMapping;
        }
        FreeformProjectGenerator.TargetMapping targetMapping = new FreeformProjectGenerator.TargetMapping();
        targetMapping.name = string;
        targetMapping.script = this.antScript;
        this.targetMappings.add(targetMapping);
        this.dirtyRegular = true;
        return targetMapping;
    }

    private void removeTargetMapping(String string) {
        Iterator<FreeformProjectGenerator.TargetMapping> iterator = this.targetMappings.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().name.equals(string)) continue;
            iterator.remove();
            this.dirtyRegular = true;
            return;
        }
    }

    public List<FreeformProjectGenerator.TargetMapping> getMapping() {
        Iterator<JComboBox> iterator = this.combos.iterator();
        for (TargetDescriptor object : this.targetDescs) {
            JComboBox jComboBox = iterator.next();
            this.storeTarget(object.getIDEActionName(), jComboBox);
        }
        if (this.cleanCombo.getModel().getSelectedItem() != null && ((String)this.cleanCombo.getModel().getSelectedItem()).length() > 0 && this.buildCombo.getModel().getSelectedItem() != null && ((String)this.buildCombo.getModel().getSelectedItem()).length() > 0) {
            FreeformProjectGenerator.TargetMapping targetMapping = this.getTargetMapping(REBUILD_ACTION);
            String string = (String)this.cleanCombo.getModel().getSelectedItem() + " " + (String)this.buildCombo.getModel().getSelectedItem();
            targetMapping.targets = TargetMappingPanel.getStringAsList(string);
        } else {
            this.removeTargetMapping(REBUILD_ACTION);
        }
        return this.targetMappings;
    }

    private void initComponents() {
        this.additionalTargetsLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.customTargets = new JTable();
        this.add = new JButton();
        this.remove = new JButton();
        this.jLabel1 = new JLabel();
        this.remainder = new JPanel();
        this.targetsPanel = new JPanel();
        this.buildLabel = new JLabel();
        this.cleanLabel = new JLabel();
        this.runLabel = new JLabel();
        this.javadocLabel = new JLabel();
        this.testLabel = new JLabel();
        this.buildCombo = new JComboBox();
        this.cleanCombo = new JComboBox();
        this.javadocCombo = new JComboBox();
        this.runCombo = new JComboBox();
        this.testCombo = new JComboBox();
        this.specialRemainder = new JPanel();
        this.setPreferredSize(new Dimension(300, 280));
        this.setLayout(new GridBagLayout());
        this.additionalTargetsLabel.setLabelFor(this.customTargets);
        Mnemonics.setLocalizedText((JLabel)this.additionalTargetsLabel, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel10"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.additionalTargetsLabel, gridBagConstraints);
        this.additionalTargetsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel10"));
        this.jScrollPane1.setViewportView(this.customTargets);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.add, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"BTN_TargetMappingPanel_add"));
        this.add.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.add, gridBagConstraints);
        this.add.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_add"));
        Mnemonics.setLocalizedText((AbstractButton)this.remove, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"BTN_TargetMappingPanel_remove"));
        this.remove.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 8, 0, 0);
        this.add((Component)this.remove, gridBagConstraints);
        this.remove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_remove"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_Mapping_Of_General_Actions"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.remainder, gridBagConstraints);
        this.targetsPanel.setLayout(new GridBagLayout());
        this.buildLabel.setLabelFor(this.buildCombo);
        Mnemonics.setLocalizedText((JLabel)this.buildLabel, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.targetsPanel.add((Component)this.buildLabel, gridBagConstraints);
        this.buildLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel2"));
        this.cleanLabel.setLabelFor(this.cleanCombo);
        Mnemonics.setLocalizedText((JLabel)this.cleanLabel, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel4"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.targetsPanel.add((Component)this.cleanLabel, gridBagConstraints);
        this.cleanLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel4"));
        this.runLabel.setLabelFor(this.runCombo);
        Mnemonics.setLocalizedText((JLabel)this.runLabel, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.targetsPanel.add((Component)this.runLabel, gridBagConstraints);
        this.runLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel5"));
        this.javadocLabel.setLabelFor(this.javadocCombo);
        Mnemonics.setLocalizedText((JLabel)this.javadocLabel, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel6"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.targetsPanel.add((Component)this.javadocLabel, gridBagConstraints);
        this.javadocLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel6"));
        this.testLabel.setLabelFor(this.testCombo);
        Mnemonics.setLocalizedText((JLabel)this.testLabel, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel7"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.targetsPanel.add((Component)this.testLabel, gridBagConstraints);
        this.testLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel7"));
        this.buildCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.targetsPanel.add((Component)this.buildCombo, gridBagConstraints);
        this.cleanCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.targetsPanel.add((Component)this.cleanCombo, gridBagConstraints);
        this.javadocCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.targetsPanel.add((Component)this.javadocCombo, gridBagConstraints);
        this.runCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.targetsPanel.add((Component)this.runCombo, gridBagConstraints);
        this.testCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.targetsPanel.add((Component)this.testCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.targetsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.specialRemainder, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.add) {
            this.addActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.remove) {
            this.removeActionPerformed(actionEvent);
        }
    }

    private void removeActionPerformed(ActionEvent actionEvent) {
        int n = this.customTargets.getSelectedRow();
        if (n == -1) {
            return;
        }
        this.custTargets.remove(n);
        this.customTargetsModel.fireTableDataChanged();
        this.dirtyCustom = true;
        this.updateButtons();
    }

    private void addActionPerformed(ActionEvent actionEvent) {
        FreeformProjectGenerator.CustomTarget customTarget = new FreeformProjectGenerator.CustomTarget();
        customTarget.targets = new ArrayList<String>();
        customTarget.script = this.antScript;
        this.custTargets.add(customTarget);
        this.customTargetsModel.fireTableDataChanged();
        this.dirtyCustom = true;
        this.updateButtons();
    }

    private void updateButtons() {
        this.remove.setEnabled(this.custTargets.size() > 0);
    }

    ActionListener getCustomizerOkListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List<FreeformProjectGenerator.TargetMapping> list = TargetMappingPanel.this.getMapping();
                if (TargetMappingPanel.this.dirtyRegular) {
                    FreeformProjectGenerator.putTargetMappings(TargetMappingPanel.this.helper, list);
                    FreeformProjectGenerator.putContextMenuAction(TargetMappingPanel.this.helper, list);
                }
                if (TargetMappingPanel.this.dirtyCustom) {
                    ArrayList<FreeformProjectGenerator.CustomTarget> arrayList = new ArrayList<FreeformProjectGenerator.CustomTarget>(TargetMappingPanel.this.custTargets);
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        FreeformProjectGenerator.CustomTarget customTarget = (FreeformProjectGenerator.CustomTarget)iterator.next();
                        if (customTarget.targets == null || customTarget.targets.size() == 0) {
                            iterator.remove();
                            continue;
                        }
                        if (customTarget.label != null && customTarget.label.length() != 0) continue;
                        customTarget.label = customTarget.targets.get(0);
                    }
                    FreeformProjectGenerator.putCustomContextMenuActions(TargetMappingPanel.this.helper, arrayList);
                }
            }
        };
    }

    public static void main(String[] stringArray) {
        boolean[] blArray = new boolean[]{false, true};
        for (int i = 0; i < blArray.length; ++i) {
            JDialog jDialog = new JDialog((Frame)null, "advancedMode=" + blArray[i], false);
            jDialog.setDefaultCloseOperation(2);
            TargetMappingPanel targetMappingPanel = new TargetMappingPanel(blArray[i]);
            targetMappingPanel.setTargetNames(new ArrayList<String>(Arrays.asList(BUILD_ACTION, CLEAN_ACTION, TEST_ACTION)), true);
            jDialog.getContentPane().add(targetMappingPanel);
            jDialog.pack();
            jDialog.setSize(700, 500);
            jDialog.setVisible(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomTargetsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_Label");
                }
            }
            return NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_Target");
        }

        @Override
        public int getRowCount() {
            return TargetMappingPanel.this.custTargets.size();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 1) {
                FreeformProjectGenerator.CustomTarget customTarget = TargetMappingPanel.this.getItem(n);
                if (customTarget.targets != null && customTarget.targets.size() > 1) {
                    return false;
                }
                return TargetMappingPanel.this.antScript == null && customTarget.script == null || TargetMappingPanel.this.antScript != null && TargetMappingPanel.this.antScript.equals(customTarget.script);
            }
            return true;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
            }
            return JComboBox.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 1) {
                if (TargetMappingPanel.this.getItem(n) == null || ((TargetMappingPanel)TargetMappingPanel.this).getItem((int)n).targets == null) {
                    return "";
                }
                return TargetMappingPanel.getListAsString(((TargetMappingPanel)TargetMappingPanel.this).getItem((int)n).targets);
            }
            return ((TargetMappingPanel)TargetMappingPanel.this).getItem((int)n).label;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n >= TargetMappingPanel.this.custTargets.size()) {
                return;
            }
            FreeformProjectGenerator.CustomTarget customTarget = TargetMappingPanel.this.getItem(n);
            String string = (String)object;
            if (n2 == 1) {
                customTarget.targets = string.length() > 0 ? Collections.singletonList(string) : null;
            } else {
                customTarget.label = string;
            }
            TargetMappingPanel.this.dirtyCustom = true;
        }
    }
}

