/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.openide.util.NbBundle;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class CatalogEntry {
    private final String publicID;
    private final CatalogReader catalog;

    public CatalogEntry(String string, CatalogReader catalogReader) {
        this.publicID = string;
        this.catalog = catalogReader;
    }

    CatalogReader getCatalog() {
        return this.catalog;
    }

    public String getSystemID() {
        Object object;
        String string = this.catalog.getSystemID(this.publicID);
        if (string == null && this.catalog instanceof EntityResolver) {
            try {
                object = ((EntityResolver)((Object)this.catalog)).resolveEntity(this.publicID, null);
                if (object != null) {
                    string = ((InputSource)object).getSystemId();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((object = string) != null) {
            object = ((String)object).replaceAll("\\+", "%20");
            object = ((String)object).replaceAll("\\ ", "%20");
            return object;
        }
        return null;
    }

    public String getPublicID() {
        return this.publicID;
    }

    public String getPublicIDValue() {
        String string = this.getPublicID();
        if (string.startsWith("PUBLIC:")) {
            return string.substring(7);
        }
        if (string.startsWith("URI:")) {
            return string.substring(4);
        }
        if (string.startsWith("SYSTEM:")) {
            return "";
        }
        if (string.startsWith("SCHEMA:")) {
            return "";
        }
        return string;
    }

    public String getSystemIDValue() {
        String string = this.getPublicID();
        if (string.startsWith("SYSTEM:")) {
            return string.substring(7);
        }
        if (string.startsWith("SCHEMA:")) {
            return string.substring(7);
        }
        return "";
    }

    public String getUriValue() {
        return this.getSystemID();
    }

    public String getName() {
        String string = this.getPublicID();
        if (string.startsWith("PUBLIC:")) {
            return NbBundle.getMessage(CatalogEntry.class, (String)"TXT_publicEntry", (Object)string.substring(7));
        }
        if (string.startsWith("SYSTEM:")) {
            return NbBundle.getMessage(CatalogEntry.class, (String)"TXT_systemEntry", (Object)string.substring(7));
        }
        if (string.startsWith("URI:")) {
            return NbBundle.getMessage(CatalogEntry.class, (String)"TXT_publicEntry", (Object)string.substring(4));
        }
        if (string.startsWith("SCHEMA:")) {
            return NbBundle.getMessage(CatalogEntry.class, (String)"TXT_systemEntry", (Object)string.substring(7));
        }
        return NbBundle.getMessage(CatalogEntry.class, (String)"TXT_publicEntry", (Object)string);
    }

    public String toString() {
        return this.publicID + " => " + this.getSystemID();
    }
}

